/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.plugin.model.StencilProperty;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.model.ServiceInfo;
import kd.bos.workflow.engine.impl.util.AutoTaskUtil;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.management.plugin.WfCustomReportRelationUtil;
import kd.bos.workflow.management.plugin.basedatafiltertools.FilterDimemsionParam;

public class WorkflowAutoTaskConfigurePlugin
extends AbstractWorkflowConfigurePlugin
implements TabSelectListener {
    private static final String SERVICEPANELTOOLBAR = "advcontoolbarap1";
    private static final String ADDBTN = "advbtnadd";
    private static final String MODIFYBTN = "advbtnmodify";
    private static final String TAB_NODECONTROL = "tab_nodecontrol";
    private static final String PLUGINENTRY = "extitf";
    private static final String ENTRYBILLNAME = "entityname";
    private static final String ENTRYBILLID = "entityId";
    private static final String EXECUTOR = "serviceexecutor";
    private static final String EXTITF_ENTITYID = "extitf_entityid";
    private static final String EXTITF_ENTITYNAME = "extitf_entityname";
    private static final String EXTITF_ENTITYNUMBER = "extitf_entitynumber";
    private static final String EXTITF_IMPLEMENTATIONTYPE = "extitf_implementationtype";
    private static final String EXTITF_IMPLEMENTATION = "extitf_implementation";
    private static final String EXTITF_IMPLEMENTATION_SHOWVALUE = "sv_extitf_implementation";
    private static final String TAB_MESSAGE = "msgtab";
    private static final String MESSAGE_PANEL = "task_msg_panel";
    private static final String FOCUS_ROWINDEX = "rowIndex";
    private static final String CONTROL_PANEL = "task_control_panel";
    private static final String KEY_MESSAGE_PAGEID = "message_pageId";
    private static final String KEY_CONTROL_PAGEID = "node_control_pageId";
    private static final String KEY_ENTITYID = "entityId";
    private static final String KEY_ENTITYNAME = "entityName";
    private static final String KEY_ENTITYNUMBER = "entityNumber";
    private static final String REFERFILTER = "referfilter";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty("entityId", ENTRYBILLNAME);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADDBTN, MODIFYBTN});
        this.addClickListeners(new String[]{ENTRYBILLNAME, EXECUTOR});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCreateNewData(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getFormShowParameter() != null && "wf_nodeconfigview".equals(parentView.getFormShowParameter().getFormId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
        try {
            this.beginInit();
            super.afterCreateNewData(e);
            this.initControlFieldValue();
            this.initControlVisibility();
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WorkflowAutoTaskConfigurePlugin.class);
        }
    }

    private void initControlVisibility() {
        if (!BizFlowPluginUtil.isBizFlow(this.getModelType())) {
            EntryGrid entry = (EntryGrid)this.getControl(PLUGINENTRY);
            entry.setColumnProperty(EXTITF_ENTITYNAME, "visible", (Object)Boolean.FALSE);
        }
    }

    @Override
    protected Object getDefaultValue(JSONObject properties, StencilProperty property, Map<String, Object> isvPropsConfig) {
        if ("entityId".equals(property.getPropertyName())) {
            try {
                JSONObject processProps = this.getProcessProperties();
                return processProps.getString("entraBillId");
            }
            catch (Exception e) {
                this.log.error(String.format("\u81ea\u52a8\u8282\u70b9\u83b7\u53d6entityId\u51fa\u9519 %s %s", e.getMessage(), e.getStackTrace()));
            }
        }
        return super.getDefaultValue(properties, property, isvPropsConfig);
    }

    @Override
    protected Object getInitPropValue(JSONObject properties, String propName) {
        Object value = null;
        if ("service.extItf".equalsIgnoreCase(propName) && (value = DesignerModelUtil.getProperty((Map<String, Object>)properties, propName)) instanceof String) {
            JSONArray arr = new JSONArray();
            arr.add(value);
            this.setProperty("extItf", arr);
            return arr;
        }
        return super.getInitPropValue(properties, propName);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "entityname": {
                this.showPageForEntryBill();
                break;
            }
            case "serviceexecutor": {
                this.showSelectExecutorWindow();
                break;
            }
            case "advbtnadd": {
                this.addOrUpdateExternalInterface(false);
                break;
            }
            case "advbtnmodify": {
                this.addOrUpdateExternalInterface(true);
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addOrUpdateExternalInterface(boolean update) {
        String value;
        block4: {
            Integer focusRow = null;
            value = null;
            if (update) {
                EntryGrid grid = (EntryGrid)this.getControl(PLUGINENTRY);
                focusRow = grid.getEntryState().getFocusRow();
                if (grid.getSelectRows().length > 0 && focusRow > -1) {
                    DynamicObject row = this.getModel().getEntryRowEntity(PLUGINENTRY, focusRow.intValue());
                    value = this.getServiceInfoString(row);
                    this.getPageCache().put(FOCUS_ROWINDEX, String.valueOf(focusRow));
                    break block4;
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WorkflowAutoTaskConfigurePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
            }
            this.getPageCache().remove(FOCUS_ROWINDEX);
        }
        JSONObject properties = this.getCellProperties();
        String entityId = (String)BpmnModelUtil.getProperty((Map)properties, (String)"service.entityId");
        if (WfUtils.isEmpty((String)entityId)) {
            JSONObject processProps = this.getProcessProperties();
            entityId = (String)processProps.get((Object)"entraBillId");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entityId", entityId);
        params.put("info_value", value);
        params.put("modelJson", this.getModelJsonString());
        params.put("model_type", this.getModelType());
        this.showForm("externalInterface", "wf_autotask_extitf", params);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "externalInterface": {
                this.setPluginEntryValue(returnData);
                break;
            }
            case "entityname": {
                this.setCloseDataForEntryBill(returnData);
                break;
            }
            case "referfilter": {
                this.setCloseDataForExecutor(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setCloseDataForEntryBill(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.getModel().setValue(ENTRYBILLNAME, data.get("name"));
            String entityId = (String)data.get("id");
            this.setProperties("entityId", entityId, ENTRYBILLNAME, data.get("name"));
            this.getModel().setValue("entityId", (Object)entityId);
            int count = this.getModel().getEntryRowCount(PLUGINENTRY);
            if (count > 0) {
                ArrayList<Integer> rows = new ArrayList<Integer>(16);
                String key = this.getEntryFieldKey(PLUGINENTRY, "implementation");
                for (int i = 0; i < count; ++i) {
                    String val = (String)this.getModel().getValue(key, i);
                    String type = ExternalInterfaceUtil.getExtItfType((String)val);
                    if (!"operation".equals(type)) continue;
                    rows.add(i);
                }
                if (!rows.isEmpty()) {
                    int[] indexes = new int[rows.size()];
                    for (int i = 0; i < rows.size(); ++i) {
                        indexes[i] = (Integer)rows.get(i);
                    }
                    this.getModel().deleteEntryRows(PLUGINENTRY, indexes);
                }
            }
        }
    }

    private void setCloseDataForExecutor(Object returnData) {
        String selectInfoStr = (String)returnData;
        if (selectInfoStr != null) {
            JSONObject selectInfoObject = JSONObject.parseObject((String)selectInfoStr);
            String showName = selectInfoObject.getString("showName");
            this.getModel().setValue(EXECUTOR, (Object)showName);
            this.setProperty(EXECUTOR, selectInfoStr);
        }
    }

    @Override
    protected JSONArray getEntryGridValue(EntryGrid grid) {
        String gridKey = grid.getKey();
        if (PLUGINENTRY.equals(gridKey)) {
            return this.getServiceInfoEntryValue(gridKey);
        }
        return super.getEntryGridValue(grid);
    }

    private JSONArray getServiceInfoEntryValue(String gridKey) {
        int rowCount = this.getModel().getEntryRowCount(gridKey);
        DynamicObject[] collection = this.getModel().getEntryEntity(gridKey, 0, rowCount);
        JSONArray arr = new JSONArray();
        for (DynamicObject row : collection) {
            String serviceInfo = this.getServiceInfoString(row);
            if (serviceInfo == null) continue;
            arr.add((Object)serviceInfo);
        }
        return arr;
    }

    private String getServiceInfoString(DynamicObject row) {
        String extItf = row.getString(EXTITF_IMPLEMENTATION);
        if (ExternalInterfaceUtil.isValidValue((String)extItf)) {
            String entityId = row.getString(EXTITF_ENTITYID);
            if (WfUtils.isNotEmpty((String)entityId)) {
                JSONObject val = JSON.parseObject((String)extItf);
                val.put("entityId", (Object)entityId);
                val.put(KEY_ENTITYNAME, (Object)row.getString(EXTITF_ENTITYNAME));
                val.put(KEY_ENTITYNUMBER, (Object)row.getString(EXTITF_ENTITYNUMBER));
                return val.toJSONString();
            }
            return extItf;
        }
        return extItf;
    }

    private void showPageForEntryBill() {
        DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, ENTRYBILLNAME);
    }

    private void setPluginEntryValue(Object returnData) {
        if (returnData instanceof ServiceInfo) {
            ServiceInfo info = (ServiceInfo)returnData;
            IDataModel model = this.getModel();
            String row = this.getPageCache().get(FOCUS_ROWINDEX);
            int rowIndex = WfUtils.isNotEmpty((String)row) ? Integer.parseInt(row) : model.createNewEntryRow(PLUGINENTRY);
            this.setServiceInfoEntryRowValue(model, info, rowIndex);
        } else {
            this.log.error("type error! " + (returnData != null ? returnData.getClass().getName() : "null"));
        }
    }

    private void setServiceInfoEntryRowValue(IDataModel model, ServiceInfo info, int rowIndex) {
        String extItf = info.getExtItf();
        model.setValue(EXTITF_ENTITYID, (Object)info.getEntityId(), rowIndex);
        model.setValue(EXTITF_ENTITYNAME, (Object)info.getEntityName(), rowIndex);
        model.setValue(EXTITF_ENTITYNUMBER, (Object)info.getEntityNumber(), rowIndex);
        model.setValue(EXTITF_IMPLEMENTATIONTYPE, (Object)ExternalInterfaceUtil.getExtItfTypeName((String)extItf), rowIndex);
        model.setValue(EXTITF_IMPLEMENTATION, (Object)extItf, rowIndex);
        model.setValue(EXTITF_IMPLEMENTATION_SHOWVALUE, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)extItf), rowIndex);
    }

    @Override
    protected Object getEntryFieldShowValue(String property, Object value) {
        if ("implementation".equals(property)) {
            return ExternalInterfaceUtil.getFormattedShowValue((String)((String)value));
        }
        return super.getEntryFieldShowValue(property, value);
    }

    @Override
    protected void initEntryGridValue(EntryGrid grid, JSONArray array) {
        if (PLUGINENTRY.equals(grid.getKey())) {
            this.initServiceInfoGridValue(grid, array);
        } else {
            super.initEntryGridValue(grid, array);
        }
    }

    private void initServiceInfoGridValue(EntryGrid grid, JSONArray array) {
        int size = array.size();
        if (size < 1) {
            return;
        }
        IDataModel model = this.getModel();
        String obj = null;
        model.batchCreateNewEntryRow(grid.getKey(), size);
        for (int i = 0; i < size; ++i) {
            if (!(array.get(i) instanceof String)) continue;
            obj = (String)array.get(i);
            ServiceInfo info = AutoTaskUtil.getServiceInfoFromString((String)obj);
            this.setServiceInfoEntryRowValue(model, info, i);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        if (TAB_MESSAGE.equals(key)) {
            this.loadMessagePage();
        } else if (TAB_NODECONTROL.equals(key)) {
            this.loadControlPage();
        }
    }

    protected void loadMessagePage() {
        String pageId = this.getPageCache().get(KEY_MESSAGE_PAGEID);
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_msgnotify_configure", MESSAGE_PANEL);
            this.getPageCache().put(KEY_MESSAGE_PAGEID, pageId);
        }
    }

    protected void loadControlPage() {
        String pageId = this.getPageCache().get(KEY_CONTROL_PAGEID);
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_notifytask_nodecontr", CONTROL_PANEL);
            this.getPageCache().put(KEY_CONTROL_PAGEID, pageId);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(FOCUS_ROWINDEX);
        this.getPageCache().remove(KEY_MESSAGE_PAGEID);
        this.getPageCache().remove(KEY_CONTROL_PAGEID);
    }

    private void showSelectExecutorWindow() {
        String name = ResManager.loadKDString((String)"\u670d\u52a1\u6267\u884c\u4eba", (String)"WorkflowAutoTaskConfigurePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        String modelJson = this.getModelJsonString();
        JSONObject properties = this.getCellProperties();
        String entityId = (String)BpmnModelUtil.getProperty((Map)properties, (String)"service.entityId");
        if (WfUtils.isEmpty((String)entityId)) {
            JSONObject processProps = this.getProcessProperties();
            entityId = (String)processProps.get((Object)"entraBillId");
        }
        String entityNumber = MetadataDao.getEntityNumberById((String)entityId);
        FilterDimemsionParam params = new FilterDimemsionParam();
        params.setFilterDimension("bos_user");
        params.setControlName(name);
        params.setModelJson(modelJson);
        params.setEntityNumber(entityNumber);
        String executorJson = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "serviceExecutor");
        this.putSelectExecutorParams(params, executorJson);
        WfCustomReportRelationUtil.openWindow((IFormPlugin)this, params);
    }

    private void putSelectExecutorParams(FilterDimemsionParam params, String executorJson) {
        if (WfUtils.isEmpty((String)executorJson)) {
            return;
        }
        JSONObject exeObject = JSONObject.parseObject((String)executorJson);
        String radioOption = exeObject.getString("selectType");
        String field = exeObject.getString("showName");
        String info = exeObject.getString("parseInfo");
        if (WfUtils.isNotEmpty((String)field) && WfUtils.isNotEmpty((String)info)) {
            params.setSelectInfo(radioOption, field, info);
        }
    }

    private void initControlFieldValue() {
        JSONObject executor;
        JSONObject properties = this.getCellProperties();
        String executorStr = (String)this.getInitPropValue(properties, EXECUTOR);
        if (WfUtils.isNotEmpty((String)executorStr) && (executor = JSONObject.parseObject((String)executorStr)) != null && !executor.isEmpty()) {
            this.getModel().setValue(EXECUTOR, executor.get((Object)"showName"));
        }
    }
}

