/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.ExtItfPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.model.ServiceInfo;
import kd.bos.workflow.engine.impl.util.AutoTaskUtil;

public class WorkflowAutoTaskExtItfPlugin
extends AbstractWorkflowPlugin {
    private static final String PANEL_EXTITF = "extitfpanel";
    private static final String PANEL_ENTITYINFO = "entityadvcon";
    private static final String FIELD_ENTITYID = "entityid";
    private static final String FIELD_ENTITYNAME = "entityname";
    private static final String FIELD_ENTITYNUMBER = "entitynumber";
    private static final String BTN_CONFIRM = "btnconfirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
        TextEdit entityName = (TextEdit)this.getControl(FIELD_ENTITYNAME);
        entityName.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String value = (String)parameter.getCustomParam("info_value");
        ServiceInfo info = null;
        String extItf = null;
        if (value != null) {
            info = AutoTaskUtil.getServiceInfoFromString((String)value);
            extItf = info.getExtItf();
        }
        String entityId = info != null ? info.getEntityId() : null;
        this.initEntityInfo(parameter, entityId);
        this.loadExtItfPage(parameter, extItf);
    }

    private void initEntityInfo(FormShowParameter parameter, String entityId) {
        String modelType = (String)parameter.getCustomParam("model_type");
        if (!BizFlowPluginUtil.isBizFlow(modelType)) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_ENTITYINFO});
        if (WfUtils.isEmpty((String)entityId)) {
            entityId = (String)parameter.getCustomParam("entityId");
        }
        MainEntityType entity = EntityMetadataCache.getDataEntityTypeById((String)entityId);
        this.getModel().setValue(FIELD_ENTITYID, (Object)entityId);
        this.getModel().setValue(FIELD_ENTITYNAME, (Object)String.valueOf(entity.getDisplayName()));
        this.getModel().setValue(FIELD_ENTITYNUMBER, (Object)entity.getName());
    }

    private void loadExtItfPage(FormShowParameter parameter, String value) {
        String entityId = (String)parameter.getCustomParam("entityId");
        String id = (String)this.getModel().getValue(FIELD_ENTITYID);
        if (WfUtils.isNotEmpty((String)id)) {
            entityId = id;
        }
        String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script", "operation"});
        String pageId = DesignerPluginUtil.openExtItfInContainer(this.getView(), (IFormPlugin)this, types, entityId, value, PANEL_EXTITF);
        this.getPageCache().put("pageId", pageId);
    }

    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "btnconfirm": {
                this.confirm();
                break;
            }
            case "entityname": {
                this.showSelectEntityPage();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void showSelectEntityPage() {
        DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, FIELD_ENTITYNAME);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (FIELD_ENTITYNAME.equals(propName)) {
            this.entityChanged(newValue);
        }
    }

    private void entityChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.getModel().setValue(FIELD_ENTITYID, null);
            this.getModel().setValue(FIELD_ENTITYNUMBER, null);
            ExtItfPluginUtil.invokeResetMethod(this.getView(), this.getPageCache().get("pageId"), null);
        }
    }

    private void confirm() {
        String extItf = ExtItfPluginUtil.invokeConfirmMethod(this.getView(), this.getPageCache().get("pageId"), new Object[]{this.getView()});
        if (WfUtils.isEmpty((String)extItf)) {
            return;
        }
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("model_type");
        String entityName = (String)this.getModel().getValue(FIELD_ENTITYNAME);
        if (BizFlowPluginUtil.isBizFlow(modelType) && WfUtils.isEmpty((String)entityName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"WorkflowAutoTaskExtItfPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ServiceInfo info = new ServiceInfo();
        info.setEntityName(entityName);
        info.setEntityId((String)this.getModel().getValue(FIELD_ENTITYID));
        info.setEntityNumber((String)this.getModel().getValue(FIELD_ENTITYNUMBER));
        info.setExtItf(extItf);
        this.getView().returnDataToParent((Object)info);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (FIELD_ENTITYNAME.equals(evt.getActionId())) {
            this.setEntityInfo(evt.getReturnData());
        }
    }

    private void setEntityInfo(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            Object id = data.get("id");
            Object name = data.get("name");
            Object number = data.get("number");
            this.getModel().setValue(FIELD_ENTITYID, id);
            this.getModel().setValue(FIELD_ENTITYNAME, name);
            this.getModel().setValue(FIELD_ENTITYNUMBER, number);
            this.loadExtItfPage(this.getView().getFormShowParameter(), null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("pageId");
    }
}

