/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.design.util.BillSubjectUtil;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class WorkflowBasicInfoPlugin
extends AbstractWorkflowConfigurePlugin {
    protected static final String NUMBER = "number";
    private static final String ENTITY_NAME = "entityName";
    private static final String ENTITY_NUMBER = "entityNumber";
    protected static final String SOURCEENTITYNUMBER = "sourceEntityNumber";
    private static final String DEFAULT_VALUE_EXPRESSION = "\\$\\{[\\.\\w]+\\}";
    private static final String BILLSUBJECT_BTN = "billsubject";
    private static final String SUBJECT = "subject";
    private static final String TASK_SUBJECT = "task.subject";
    private static final String CUSTOMSUBJECT = "customSubject";
    private static final String PROPERTY_CUSTOMPARAMS = "customParams";
    private static final String FIELD_CUSTOMPARAMS = "nodecustomparams";
    protected static final String PROPERTY_SENSITIVEFIELD = "sensitiveField";
    protected static final String FIELD_SENSITIVEFIELD = "sensitivefield";
    private static final String ENDTYPE = "endtype";
    protected static final String FORMKEY = "formkey";
    protected static final String MOBILFORMKEY = "mobilformkey";
    protected static final String SPLITCHAR = "_combo_";
    protected static final String PROCESSINGPAGE = "processingpage";
    protected static final String PROCESSINGMOBILEPAGE = "processingmobilepage";
    protected static final String PAGEPARAMETERSHOWTEXT = "pageparametershowtext";
    protected static final String CONFIGFIELDCALLBACK = "configfieldcallback";
    protected static final String OPTIONALOPERS = "optionalopers";
    private static final String ENTRYBILL = "entrybill";
    private static final String PANEL_PAGECONTENT = "pagecontentpanel";
    private static final String ENTITYID = "entityId";
    private static final String BIZIDENTIFYKEY = "bizidentifykey";
    private static String[] pageNumberBlackList = new String[]{"wf_pcprocesspagetpl", "wf_approvalpageud_float", "wf_approvalpageud_tile"};
    protected static final String SENSITIVEFIELD = "sensitivefield";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(ENDTYPE, ENTRYBILL, BILLSUBJECT_BTN);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BILLSUBJECT_BTN, ENTRYBILL, PAGEPARAMETERSHOWTEXT, FIELD_CUSTOMPARAMS, "sensitivefield"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initControlState();
        JSONObject properties = this.getCellProperties();
        if (properties == null) {
            return;
        }
        this.initEntryBillInfo(properties);
        this.initBillSubject(properties);
        this.initOptionalOperations(properties);
        this.initPageParameter(properties);
        this.initCustomParamsText();
        this.initSensitiveField(properties);
    }

    private void initCustomParamsText() {
        Object value = DesignerModelUtil.getProperty((Map<String, Object>)this.getCellProperties(), PROPERTY_CUSTOMPARAMS);
        if (value instanceof JSONArray) {
            JSONArray params = (JSONArray)value;
            this.getModel().setValue(FIELD_CUSTOMPARAMS, (Object)DesignerPluginUtil.getNodeParamsShowText(params));
        }
    }

    private void initControlState() {
    }

    private void initBillSubject(JSONObject properties) {
        Object subjectObject = DesignerModelUtil.getProperty((Map<String, Object>)properties, SUBJECT);
        if (subjectObject == null && (subjectObject = DesignerModelUtil.getProperty((Map<String, Object>)properties, TASK_SUBJECT)) != null) {
            this.deleteProperty("task");
        }
        if (subjectObject instanceof Map) {
            this.setProperty(properties, SUBJECT, subjectObject);
            String subject = (String)((Map)subjectObject).get(CUSTOMSUBJECT);
            if (WfUtils.isNotEmpty((String)((String)properties.get((Object)ENTITYID)))) {
                subject = BillSubjectUtil.getShowSubject(subject, (String)properties.get((Object)ENTITYID));
            }
            this.getModel().setValue(BILLSUBJECT_BTN, (Object)subject);
        } else if (subjectObject instanceof List && !((List)subjectObject).isEmpty()) {
            this.setProperties(properties, new Object[]{SUBJECT, subjectObject});
            String subject = ((JSONObject)((JSONArray)subjectObject).get(0)).getString(CUSTOMSUBJECT);
            this.getModel().setValue(BILLSUBJECT_BTN, (Object)subject);
        } else {
            this.getModel().setValue(BILLSUBJECT_BTN, null);
        }
    }

    protected void initEntryBillInfo(JSONObject properties) {
        try {
            String entityName = (String)properties.get((Object)ENTITY_NAME);
            if (entityName != null && !entityName.matches(DEFAULT_VALUE_EXPRESSION)) {
                this.getModel().setValue(ENTRYBILL, (Object)entityName);
            }
            String formKey = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "billSetting.formKey");
            String mobilFormKey = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "billSetting.mobilFormKey");
            this.setBillPageComboAll(properties, formKey, mobilFormKey, (String)properties.get((Object)ENTITYID), (String)properties.get((Object)ENTITY_NUMBER), (String)properties.get((Object)ENTITY_NAME));
            this.showOrHidePCAndMobile(properties.get((Object)"endType"));
            this.addCustomProcessPage(properties);
            this.initBizFlowProperties(properties);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void initBizFlowProperties(JSONObject properties) {
        String entityNumber;
        boolean isBizFlowModel = "BizFlowModel".equals(this.modelType);
        this.getView().setVisible(Boolean.valueOf(isBizFlowModel), new String[]{"floatlayerbillsummary"});
        this.getView().setVisible(Boolean.valueOf(isBizFlowModel), new String[]{"bizflowbillsummary"});
        if (isBizFlowModel && WfUtils.isNotEmpty((String)(entityNumber = (String)properties.get((Object)ENTITY_NUMBER)))) {
            this.initBizFlowProperties(entityNumber, properties);
        }
    }

    protected void initOptionalOperations(JSONObject properties) {
        List<Map<String, Object>> operations = ProcTemplatePluginUtil.getOptionalOperations((Map<String, Object>)properties);
        if (operations != null) {
            this.getModel().setValue(OPTIONALOPERS, (Object)BillPagePluginUtil.getOperationInfosFromReturnValues(operations, (String)"name"));
        }
    }

    protected void addCustomProcessPage(JSONObject properties) {
        String processingPageFromConfCenter;
        String processingPageValue = properties.getString("processingPage");
        if ("wf_approvalbill".equals(processingPageValue) && null != (processingPageFromConfCenter = WfConfigurationUtil.getJsonValueFromConfCenter((String)"approvalbillpage", (String)"approvalbillpage_pc")) && !processingPageFromConfCenter.isEmpty()) {
            processingPageValue = processingPageFromConfCenter;
            this.setProperty(PROCESSINGPAGE, processingPageValue);
        }
        ComboEdit pcProcessPageComboEdit = (ComboEdit)this.getControl(PROCESSINGPAGE);
        QFilter filter1 = new QFilter("inheritpath", "like", (Object)"%0ATY3DYGANC7%");
        QFilter filter2 = new QFilter("type", "!=", (Object)"2");
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObject[] forms = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,number,inheritpath,masterid", (QFilter[])filters);
        HashSet<DynamicObject> formList = new HashSet<DynamicObject>(forms.length);
        for (DynamicObject form : forms) {
            formList.add(form);
        }
        Iterator formListIterator = formList.iterator();
        while (formListIterator.hasNext()) {
            DynamicObject form = (DynamicObject)formListIterator.next();
            String number = form.getString(NUMBER);
            if (!Arrays.asList(pageNumberBlackList).contains(number)) continue;
            formListIterator.remove();
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem comboItem = new ComboItem();
        String caption = ResManager.loadKDString((String)"\u5de6\u53f3\u5e03\u5c40\u5ba1\u6279\u9875\u9762\uff08\u9ed8\u8ba4\uff09", (String)"WorkflowBasicInfoPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        String value = "wf_approvalpage_bac";
        comboItem.setCaption(new LocaleString(caption));
        comboItem.setValue(value);
        comboItems.add(comboItem);
        if (forms.length > 0) {
            for (DynamicObject form : formList) {
                comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(form.getLocaleString("name").getLocaleValue()));
                comboItem.setValue(form.getString(NUMBER));
                comboItems.add(comboItem);
            }
        }
        pcProcessPageComboEdit.setComboItems(comboItems);
        if (WfUtils.isEmpty((String)processingPageValue)) {
            processingPageValue = ((ComboItem)comboItems.get(0)).getValue();
        }
        this.getView().getModel().setValue(PROCESSINGPAGE, (Object)processingPageValue);
        String processingMobilePageValue = properties.getString("processingMobilePage");
        ComboEdit mobileProcessPageComboEdit = (ComboEdit)this.getControl(PROCESSINGMOBILEPAGE);
        QFilter filterMobile = new QFilter("parentid", "=", (Object)"0ATYD18VC/+O");
        filters = new QFilter[]{filterMobile};
        forms = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"number,name", (QFilter[])filters);
        comboItems = new ArrayList();
        comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5ba1\u6279\u9875\u9762", (String)"WorkflowBasicInfoPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        comboItem.setValue("wf_approvalpagemobile_bac");
        comboItems.add(comboItem);
        comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u65b0\u7248\u5ba1\u6279\u9875\u9762", (String)"WorkflowBasicInfoPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        comboItem.setValue("wf_approvalpage_mob");
        comboItems.add(comboItem);
        if (forms.length > 0) {
            for (DynamicObject form : forms) {
                comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(form.getLocaleString("name").getLocaleValue()));
                comboItem.setValue(form.getString(NUMBER));
                comboItems.add(comboItem);
            }
        }
        mobileProcessPageComboEdit.setComboItems(comboItems);
        if (WfUtils.isEmpty((String)processingMobilePageValue)) {
            this.getView().getModel().setValue(PROCESSINGMOBILEPAGE, (Object)((ComboItem)comboItems.get(0)).getValue());
        }
    }

    protected void showOrHidePCAndMobile(Object value) {
        if ("BizFlowModel".equals(this.getModelType()) || "SSCImageUpload".equals(this.stencilType) || "SSCImageUploadNew".equals(this.stencilType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PANEL_PAGECONTENT});
        }
        if ("UserTask".equals(this.stencilType)) {
            this.updateUserTaskSpecCtrlState();
            return;
        }
        Boolean showPC = value == null || "pc".equals(value) || "all".equals(value);
        Boolean showMobile = value == null || "mobile".equals(value) || "all".equals(value);
        this.getView().setVisible(showPC, new String[]{FORMKEY});
        this.getView().setVisible(showMobile, new String[]{MOBILFORMKEY});
        this.getView().setVisible(showPC, new String[]{PROCESSINGPAGE});
        this.getView().setVisible(showMobile, new String[]{PROCESSINGMOBILEPAGE});
    }

    protected void updateUserTaskSpecCtrlState() {
        this.getView().setVisible(Boolean.FALSE, new String[]{PROCESSINGPAGE, PROCESSINGMOBILEPAGE});
        ComboEdit formKey = (ComboEdit)this.getControl(FORMKEY);
        formKey.setCaption(new LocaleString(ResManager.loadKDString((String)"PC\u7aef\u5904\u7406\u9875\u9762", (String)"WorkflowBasicInfoPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        ComboEdit mobileFormKey = (ComboEdit)this.getControl(MOBILFORMKEY);
        mobileFormKey.setCaption(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5904\u7406\u9875\u9762", (String)"WorkflowBasicInfoPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        if ("BizFlowModel".equals(this.modelType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MOBILFORMKEY});
            ComboEdit endType = (ComboEdit)this.getControl(ENDTYPE);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ec5PC\u7aef\u5904\u7406", (String)"WorkflowBasicInfoPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            comboItem.setValue("pc");
            comboItems.add(comboItem);
            endType.setComboItems(comboItems);
            this.getModel().setValue(ENDTYPE, (Object)((ComboItem)comboItems.get(0)).getValue());
        }
    }

    protected void setBillPageComboAll(JSONObject properties, String formKey, String mobileFormKey, String entityId, String entityNumber, String entityName) {
        if (entityId != null && entityId.matches(DEFAULT_VALUE_EXPRESSION) || "wf_billtask_basicinfo".equals(this.getModel().getDataEntityType().getName())) {
            return;
        }
        if (entityId == null) {
            this.log.debug("NodeTemplate,There is't entityId");
            return;
        }
        Map billPages = BillPagePluginUtil.getBillPagesForPC((String)formKey, (String)entityId);
        this.setBillPageComboPart(properties, FORMKEY, billPages);
        this.setBillPageComboPart(properties, MOBILFORMKEY, BillPagePluginUtil.getBillPagesForMob((String)this.stencilType, (String)formKey, (String)mobileFormKey, (String)entityId, (String)entityNumber, (String)entityName, (List)((List)billPages.get("dataitems"))));
    }

    protected void setBillPageComboPart(JSONObject properties, String comboName, Map<String, Object> billPages) {
        List items = (List)billPages.get("dataitems");
        String selectedValue = (String)billPages.get("selectedvalue");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(items.size());
        ComboItem comboItem = null;
        LocaleString localeString = null;
        String name = null;
        String value = null;
        String realValue = null;
        for (Map map : items) {
            comboItem = new ComboItem();
            localeString = new LocaleString();
            name = (String)map.get("name");
            value = (String)map.get("id");
            realValue = value + SPLITCHAR + name;
            localeString.setLocaleValue(name);
            comboItem.setCaption(localeString);
            comboItem.setValue(realValue);
            comboItems.add(comboItem);
            if (!WfUtils.isNotEmpty((String)selectedValue) || !selectedValue.equals(value)) continue;
            selectedValue = realValue;
        }
        ComboEdit operation = (ComboEdit)this.getControl(comboName);
        operation.setComboItems(comboItems);
        this.getView().getModel().setValue(comboName, (Object)selectedValue);
        if (WfUtils.isNotEmptyString((Object)selectedValue)) {
            this.setProperty(properties, comboName, selectedValue.split(SPLITCHAR)[0]);
        } else {
            this.setProperty(properties, comboName, null);
        }
        if (null == selectedValue) {
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"mobilepageattrconfig"});
        if (selectedValue.split(SPLITCHAR)[0].endsWith("&mfm")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mobilepageattrconfig"});
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "entrybill": {
                this.showPageForEntryBill();
                break;
            }
            case "billsubject": {
                this.showBillSubject();
                break;
            }
            case "pageparametershowtext": {
                this.showPageParameter();
                break;
            }
            case "nodecustomparams": {
                this.openCustomParamsPage();
                break;
            }
            case "sensitivefield": {
                this.showConfigFieldPage();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void openCustomParamsPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_CUSTOMPARAMS));
        parameter.setFormId("wf_nodecustomparams");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject props = this.getCellProperties();
        Object customParams = DesignerModelUtil.getProperty((Map<String, Object>)props, PROPERTY_CUSTOMPARAMS);
        String entityId = (String)DesignerModelUtil.getProperty((Map<String, Object>)props, ENTITYID);
        params.put("value", customParams);
        params.put(ENTITYID, entityId);
        params.put("modelJson", this.getModelJsonString());
        parameter.getCustomParams().putAll(params);
        this.getView().showForm(parameter);
    }

    private void showPageForEntryBill() {
        DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, ENTRYBILL);
    }

    private void showBillSubject() {
        JSONObject properties = this.getCellProperties();
        String modelJson = this.getModelJsonString();
        JSONObject processProps = this.getProcessProperties();
        Object subjectObject = DesignerModelUtil.getProperty((Map<String, Object>)properties, SUBJECT);
        String subjectString = "";
        JSONArray subjectList = new JSONArray();
        if (WfUtils.isNullObject((Object)subjectObject)) {
            subjectObject = DesignerModelUtil.getProperty((Map<String, Object>)properties, TASK_SUBJECT);
        } else if (subjectObject instanceof Map) {
            subjectString = (String)((Map)subjectObject).get(CUSTOMSUBJECT);
            if (WfUtils.isNotEmpty((String)((String)properties.get((Object)ENTITYID)))) {
                subjectString = BillSubjectUtil.getShowSubject(subjectString, (String)properties.get((Object)ENTITYID));
            }
        } else if (subjectObject instanceof List) {
            subjectList = (JSONArray)subjectObject;
        }
        String entityNumber = properties.getString(ENTITY_NUMBER);
        String errorInfo = WFMultiLangConstants.getNodeBillNotNull();
        boolean needSourceElement = false;
        if ("BillTask".equals(this.stencilType)) {
            entityNumber = properties.getString(SOURCEENTITYNUMBER);
            errorInfo = WFMultiLangConstants.getBillTaskSourceBillNotNull();
            needSourceElement = true;
        }
        if (WfUtils.isEmpty((String)entityNumber)) {
            this.getView().showTipNotification(errorInfo);
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("openType", "designer");
        params.put("stencilType", this.stencilType);
        params.put("itemId", this.itemId);
        params.put("properties", properties);
        params.put("modelJson", modelJson);
        params.put("processProps", processProps);
        params.put(ENTITY_NUMBER, entityNumber);
        params.put("modelType", this.modelType);
        params.put("needSourceElement", needSourceElement);
        params.put("value", WfUtils.isNotEmpty((String)subjectString) ? subjectString : subjectList);
        params.put("showothersubjecttiming", BpmnModelUtil.instanceofAuditTask((String)this.stencilType));
        this.showForm(BILLSUBJECT_BTN, "wf_tasksubject", params);
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "formkey": {
                this.formKeyChanged(propName, newValue, oldValue);
                break;
            }
            case "mobilformkey": {
                this.formKeyChanged(propName, newValue, oldValue);
                this.getView().setEnable(Boolean.TRUE, new String[]{"mobilepageattrconfig"});
                if (null == newValue) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"mobilepageattrconfig"});
                    break;
                }
                String newValueSplit = newValue.toString().split(SPLITCHAR)[0];
                if (newValueSplit.endsWith("$")) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"mobilepageattrconfig"});
                    break;
                }
                if (!newValueSplit.endsWith("&mfm")) break;
                this.getView().setEnable(Boolean.FALSE, new String[]{"mobilepageattrconfig"});
                break;
            }
            case "endtype": {
                this.endtypeChanged(newValue);
                break;
            }
            case "billsubject": {
                this.billSubjectChanged(newValue);
                break;
            }
            case "entrybill": {
                this.entryBillChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "pageparametershowtext": {
                this.pageParameterChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "nodecustomparams": {
                this.customParamsChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void customParamsChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            boolean hasBuiltInParam = false;
            Object customParams = this.getProperty(PROPERTY_CUSTOMPARAMS);
            if (customParams instanceof List) {
                List params = (List)customParams;
                for (Map param : params) {
                    if (!Boolean.TRUE.equals(param.get("builtIn"))) continue;
                    hasBuiltInParam = true;
                    break;
                }
            }
            if (hasBuiltInParam) {
                this.getModel().beginInit();
                this.getModel().setValue(propName, oldValue);
                this.getModel().endInit();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u4e2d\u5305\u542b\u5185\u7f6e\u53c2\u6570\uff0c\u4e0d\u80fd\u6e05\u7a7a\uff0c\u8bf7\u6253\u5f00\u540e\u5355\u72ec\u5220\u9664\u3002", (String)"WorkflowBasicInfoPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            } else {
                this.setProperty(PROPERTY_CUSTOMPARAMS, null);
            }
        }
    }

    private void entryBillChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperties(ENTITYID, null, ENTITY_NUMBER, null, ENTITY_NAME, null);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    private void updateOperation(String entityNumber) {
        IFormView view = this.getView().getParentView();
        FormViewPluginProxy proxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent(new CustomEventArgs((Object)this.getView(), "updateOperation", "updateOperation", entityNumber));
    }

    private void billSubjectChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty(SUBJECT, null);
        }
    }

    protected void endtypeChanged(Object newValue) {
        this.setProperty(ENDTYPE, newValue);
        this.showOrHidePCAndMobile(newValue);
    }

    protected void formKeyChanged(String propName, Object newValue, Object oldValue) {
        if (WfUtils.isNotEmptyString((Object)newValue)) {
            this.setProperty(propName, newValue.toString().split(SPLITCHAR)[0]);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "entrybill": {
                this.setCloseDataForEntryBill(returnData);
                break;
            }
            case "billsubject": {
                this.setCloseDataForBillSubject(returnData);
                break;
            }
            case "pageparametershowtext": {
                this.setCloseDataForPageParameter(returnData);
                break;
            }
            case "nodecustomparams": {
                this.customParamsCallBack(returnData);
                break;
            }
            case "configfieldcallback": {
                this.configFiledcallback((Map)returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void customParamsCallBack(Object returnData) {
        if (returnData instanceof JSONArray) {
            JSONArray params = (JSONArray)returnData;
            this.getModel().setValue(FIELD_CUSTOMPARAMS, (Object)DesignerPluginUtil.getNodeParamsShowText(params));
            this.setProperty(PROPERTY_CUSTOMPARAMS, params);
        }
    }

    private void configFiledcallback(Object returnData) {
        if (returnData instanceof Map) {
            LocaleString showtext = (LocaleString)((Map)returnData).get("showtext");
            if (WfUtils.isNotEmpty((ILocaleString)showtext)) {
                this.getModel().setValue("sensitivefield", (Object)showtext.getLocaleValue());
                this.setProperty(PROPERTY_SENSITIVEFIELD, returnData);
            } else {
                this.getModel().setValue("sensitivefield", null);
            }
        }
    }

    protected void setCloseDataForEntryBill(Object returnData) {
        if (returnData instanceof Map) {
            JSONObject props = this.getCellProperties();
            String oriEntityNumber = props.getString(ENTITY_NUMBER);
            Map data = (Map)returnData;
            this.getModel().setValue(ENTRYBILL, data.get("name"));
            String entityId = (String)data.get("id");
            String entityName = (String)data.get("name");
            String entityNumber = (String)data.get(NUMBER);
            this.setProperties(props, new Object[]{ENTITYID, entityId, ENTITY_NUMBER, entityNumber, ENTITY_NAME, entityName});
            if ("BizFlowModel".equals(this.modelType)) {
                this.initBizFlowProperties(entityNumber, props);
            }
            this.setBillPageComboAll(null, null, null, (String)data.get("id"), (String)data.get("name"), (String)data.get(NUMBER));
            if ("UserTask".equals(this.stencilType)) {
                this.updateOperation(entityNumber);
            }
            if ("BizFlowModel".equals(this.getModelType()) && BizFlowPluginUtil.isStartItemCorrelationStencil(this.stencilType)) {
                String procEntityNumber = BizFlowPluginUtil.getProcessEntityNumber((Map<String, Object>)this.getProcessProperties());
                BizFlowPluginUtil.updateStartItemWhenEntityNumberChanged(this.getIdeFormView(), props, oriEntityNumber, procEntityNumber);
            }
        }
    }

    private void setCloseDataForBillSubject(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.getModel().setValue(BILLSUBJECT_BTN, data.get("subjectShowtext"));
            this.setProperty(SUBJECT, data.get("taskSubject"));
        }
    }

    private void setCloseDataForPageParameter(Object returnData) {
        if (returnData instanceof List) {
            List pageParameter = (List)returnData;
            this.setProperty("pageparameter", pageParameter);
            this.setPageParameterText(pageParameter);
        }
    }

    private void setPageParameterText(List pageParameter) {
        String text = "";
        if (WfUtils.isNotEmptyForCollection((Collection)pageParameter)) {
            Map mObject = null;
            StringBuilder sb = new StringBuilder();
            for (Object object : pageParameter) {
                if (!(object instanceof Map)) continue;
                mObject = (Map)object;
                sb.append(mObject.get("parameterName")).append(",");
            }
            if (null != sb && sb.length() > 0) {
                text = (String)sb.subSequence(0, sb.length() - 1);
            }
        }
        this.getModel().setValue(PAGEPARAMETERSHOWTEXT, (Object)text);
    }

    private void showPageParameter() {
        String entityNumber = null;
        JSONObject properties = this.getCellProperties();
        if (null != properties) {
            entityNumber = properties.getString(ENTITY_NUMBER);
        }
        if (WfUtils.isNotEmpty(entityNumber)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(ENTITY_NUMBER, entityNumber);
            params.put("parameters", DesignerModelUtil.getProperty((Map<String, Object>)properties, "billSetting.pageParameter"));
            this.showForm(PAGEPARAMETERSHOWTEXT, "wf_pageparameter", params);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u201c\u5355\u636e\u201d\u3002", (String)"WorkflowBasicInfoPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void initPageParameter(JSONObject properties) {
        Object pageParameter = DesignerModelUtil.getProperty((Map<String, Object>)properties, "billSetting.pageParameter");
        if (pageParameter instanceof List) {
            this.setPageParameterText((List)pageParameter);
        }
    }

    private void initSensitiveField(JSONObject properties) {
        Object showTextJson = DesignerModelUtil.getProperty((Map<String, Object>)properties, "billSetting.sensitiveField.showText");
        String showText = WfUtils.isEmptyString((Object)showTextJson) ? "" : ((JSONObject)showTextJson).getString(RequestContext.get().getLang().name());
        this.getModel().setValue("sensitivefield", (Object)showText);
    }

    private void pageParameterChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty("pageparameter", null);
        }
    }

    private void showConfigFieldPage() {
        String entityNumber = this.getCellProperties().getString(ENTITY_NUMBER);
        if (WfUtils.isEmpty((String)entityNumber)) {
            this.log.debug("NodeTemplate,There is't entityId");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u6253\u5f00\uff0centityID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowBasicInfoPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wf_sensitiveconfigfield");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam(ENTITY_NUMBER, (Object)entityNumber);
        JSONObject props = this.getCellProperties();
        Object configFields = DesignerModelUtil.getProperty((Map<String, Object>)props, "billSetting.sensitiveField");
        formShowParameter.setCustomParam("configfields", configFields);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CONFIGFIELDCALLBACK));
        this.getView().showForm(formShowParameter);
    }
}

