/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowBillEntityPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTITYNAME = "entityName";
    private static final String ENTITYNUMBER = "entityNumber";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter params = this.getView().getFormShowParameter();
        String billStr = (String)this.getView().getFormShowParameter().getCustomParam("bills");
        if (WfUtils.isNotEmpty((String)billStr)) {
            String selectedValue = (String)params.getCustomParam("selectedValue");
            Map bills = (Map)SerializationUtils.fromJsonString((String)billStr, Map.class);
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, bills.size());
            int i = 0;
            for (Map.Entry bill : bills.entrySet()) {
                this.getModel().setValue(ENTITYNUMBER, bill.getKey(), i);
                this.getModel().setValue(ENTITYNAME, bill.getValue(), i);
                if (WfUtils.isNotEmpty((String)selectedValue) && selectedValue.equals(bill.getKey())) {
                    this.getPageCache().put("selectedRow", String.valueOf(i));
                }
                ++i;
            }
        }
    }

    public void afterBindData(EventObject e) {
        String selectedRow = this.getPageCache().get("selectedRow");
        if (WfUtils.isNotEmpty((String)selectedRow)) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
            grid.selectRows(Integer.parseInt(selectedRow));
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.btnok();
        }
    }

    private void btnok() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        int[] selectedRows = grid.getEntryState().getSelectedRows();
        if (selectedRows.length > 0) {
            String entityName = (String)this.getModel().getValue(ENTITYNAME, selectedRows[0]);
            String entityNumber = (String)this.getModel().getValue(ENTITYNUMBER, selectedRows[0]);
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put(ENTITYNAME, entityName);
            ret.put(ENTITYNUMBER, entityNumber);
            this.getView().returnDataToParent(ret);
            this.getView().close();
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.btnok();
    }
}

