/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.WorkflowEntitiesListPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowBillListPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CONFIRM = "confirm";
    private static final String PANEL_CONTENT = "flexpanelap";
    private static final String KEY_BILL = "bills";
    private static final String KEY_PAGEID = "pageId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getListShowParameter();
        this.getView().showForm(parameter);
        this.getPageCache().put(KEY_PAGEID, parameter.getPageId());
    }

    private FormShowParameter getListShowParameter() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_BILL));
        parameter.setBillFormId("wf_entity_list");
        parameter.setFormId("wf_list");
        boolean isMultiSelect = this.getView().getFormShowParameter().getCustomParam("isMultiSelect") == null ? false : (Boolean)this.getView().getFormShowParameter().getCustomParam("isMultiSelect");
        parameter.setMultiSelect(isMultiSelect);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(PANEL_CONTENT);
        ListFilterParameter filterParameter = new ListFilterParameter();
        String[] types = new String[]{"BillFormModel", "BaseFormModel"};
        filterParameter.getQFilters().add(new QFilter("modeltype", "in", (Object)types));
        List nodeEntityNumbers = (List)this.getView().getFormShowParameter().getCustomParam("NodeEntityNumbers");
        if (nodeEntityNumbers != null) {
            if (!nodeEntityNumbers.isEmpty()) {
                parameter.setFormId("wf_list");
                String[] entityNums = nodeEntityNumbers.toArray(new String[nodeEntityNumbers.size()]);
                filterParameter.getQFilters().add(new QFilter("number", "in", (Object)entityNums));
            } else {
                filterParameter.getQFilters().add(new QFilter("number", "is null", null));
            }
            parameter.setCaption(ResManager.loadKDString((String)"\u6d41\u7a0b\u5355\u636e\u5217\u8868", (String)"WorkflowBillListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        parameter.setListFilterParameter(filterParameter);
        StyleCss sc = new StyleCss();
        sc.setHeight("505px");
        sc.setWidth("700px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        return parameter;
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_CONFIRM.equals(key)) {
            this.confirm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (KEY_BILL.equals(evt.getActionId())) {
            this.getView().returnDataToParent(evt.getReturnData());
            this.getView().close();
        }
    }

    private void confirm() {
        String pageId = this.getPageCache().get(KEY_PAGEID);
        if (WfUtils.isEmpty((String)pageId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"WorkflowBillListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            Map<String, Object> data;
            IFormView listView = this.getView().getView(pageId);
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)listView.getService(FormViewPluginProxy.class);
            WorkflowEntitiesListPlugin listPlugin = (WorkflowEntitiesListPlugin)pluginProxy.getPlugin("kd.bos.workflow.design.plugin.WorkflowEntitiesListPlugin");
            Object isMultiSelect = this.getView().getFormShowParameter().getCustomParam("isMultiSelect");
            Map<String, Object> map = data = isMultiSelect == null || (Boolean)isMultiSelect == false ? listPlugin.getSelectedData() : listPlugin.getSelectedDatas();
            if (data == null || data instanceof Map && data.isEmpty() || data instanceof List && ((List)((Object)data)).isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5b9e\u4f53\u5355\u636e\u201d\u3002", (String)"WorkflowBillListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().returnDataToParent(data);
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_PAGEID);
    }
}

