/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DynamicTplUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class WorkflowBillSummaryPlugin
extends AbstractWorkflowPlugin {
    private static final int FLEXMAXNUM = 40;
    private static final int FLEXENTRYMAXNUM = 4;
    private static final int COLMAXNUM = 30;
    private static final int ATTACHEMENTNUM = 1;
    private static final String ENTRYENTITY = "entryentity";
    private static final String FLEXENTRY = "flexentry";
    private static final String FIELDPERCENT = "fieldpercent";
    private static final String FONTCOLOR = "fontcolor";
    private static final String FONTSIZE = "fontsize";

    public void afterCreateNewData(EventObject e) {
        try {
            int i;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String bizFlowBillSummary = (String)customParams.get("bizFlowBillSummary");
            String businessKey = (String)customParams.get("businessKey");
            String entityNumber = (String)customParams.get("entityNumber");
            if (WfUtils.isEmpty((String)bizFlowBillSummary)) {
                return;
            }
            this.hideAllFlex();
            DynamicObject billInfo = null;
            try {
                billInfo = BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber);
            }
            catch (Exception exception) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"WorkflowBillSummaryPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            this.setBillInfo(billInfo, formMetadata);
            ArrayList<String> attachmentKeys = new ArrayList<String>();
            Map<String, ControlAp<?>> fieldFormInfos = DynamicTplUtil.getFieldFormInfos(formMetadata, attachmentKeys);
            Map<String, EntityItem<?>> fieldEntityInfos = DynamicTplUtil.getEntityFieldItems(entityMetadata);
            QFilter billTypeFilter = new QFilter("billtype", "=", (Object)entityNumber);
            QFilter enableFilter = new QFilter("number", "=", (Object)bizFlowBillSummary);
            DynamicObject billSummaryInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"wf_mbillsummary_cfg", (QFilter[])new QFilter[]{billTypeFilter, enableFilter});
            ArrayList<String> fieldKeys = new ArrayList<String>();
            HashMap<String, DynamicObject> fieldInfos = new HashMap<String, DynamicObject>();
            ArrayList<String> entryKeys = new ArrayList<String>();
            HashMap<String, List<String>> entryFields = new HashMap<String, List<String>>();
            DynamicObjectCollection entryEntity = (DynamicObjectCollection)billSummaryInfo.get(ENTRYENTITY);
            this.collectFieldInfos(entryEntity, fieldKeys, fieldInfos, entryKeys, entryFields);
            Set<String> canNotReadFields = this.collectCanNotReadFields(entityNumber, businessKey);
            ArrayList<String> showFlexKeys = new ArrayList<String>();
            for (i = 0; i < fieldKeys.size(); ++i) {
                String fieldKey = (String)fieldKeys.get(i);
                DynamicObject fieldInfo = (DynamicObject)fieldInfos.get(fieldKey);
                this.updateFiledAp(i, fieldInfo);
                String fieldName = fieldInfo.getLocaleString("fieldname").getLocaleValue();
                Object fieldValue = billInfo.get(fieldKey);
                Object realValue = null;
                realValue = canNotReadFields != null && canNotReadFields.contains(fieldKey) ? "******" : DynamicTplUtil.formatFieldValue(fieldValue, fieldKey, fieldEntityInfos, fieldFormInfos, entityMetadata, billInfo, null);
                this.getModel().setValue("key" + i, (Object)fieldName);
                this.getModel().setValue("value" + i, realValue);
                if (realValue == null) continue;
                showFlexKeys.add("flex" + i);
            }
            for (i = 0; i < entryKeys.size(); ++i) {
                String entryKey = (String)entryKeys.get(i);
                DynamicObjectCollection datas = (DynamicObjectCollection)billInfo.get(entryKey);
                if (datas == null || datas.isEmpty()) continue;
                EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY + i);
                List fields = (List)entryFields.get(entryKey);
                if (CollectionUtil.isNotEmpty((Collection)fields)) {
                    int j;
                    for (j = 0; j < fields.size(); ++j) {
                        String fieldKey = (String)fields.get(j);
                        DynamicObject fieldInfo = (DynamicObject)fieldInfos.get(fieldKey);
                        this.updateEntryFieldAp(fieldInfo, i, entry, j);
                        if (j == 30) break;
                    }
                    if (fields.size() < 30) {
                        for (j = fields.size(); j < 30; ++j) {
                            entry.setColumnProperty("col" + i + "_" + j, "vi", (Object)Boolean.FALSE);
                        }
                    }
                    this.getModel().batchCreateNewEntryRow(ENTRYENTITY + i, datas.size());
                    for (int k = 0; k < datas.size(); ++k) {
                        for (int l = 0; l < fields.size(); ++l) {
                            String fieldKey = (String)fields.get(l);
                            DynamicObject dynamicObject = (DynamicObject)fieldInfos.get(fieldKey);
                            Object realValue = null;
                            if (canNotReadFields != null && canNotReadFields.contains(fieldKey)) {
                                realValue = "******";
                            } else if ("BasedataPropField".equals(dynamicObject.get("fieldtype"))) {
                                realValue = DynamicTplUtil.getBasedataPropFieldValue((String)fields.get(l), fieldEntityInfos, entityMetadata, billInfo, (DynamicObject)datas.get(k), true);
                            } else {
                                Object fieldValue = ((DynamicObject)datas.get(k)).get(fieldKey);
                                realValue = DynamicTplUtil.formatFieldValue(fieldValue, (String)fields.get(l), fieldEntityInfos, fieldFormInfos, entityMetadata, billInfo, (DynamicObject)datas.get(k));
                            }
                            this.getModel().setValue("col" + i + "_" + l, realValue, k);
                        }
                    }
                }
                showFlexKeys.add(FLEXENTRY + i);
            }
            this.collecAttachementInfo(attachmentKeys, showFlexKeys, entityNumber, businessKey);
            this.showTargetFlexs(showFlexKeys);
        }
        catch (Exception exception) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u6458\u8981\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowBillSummaryPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfUtils.getExceptionStacktrace((Throwable)exception)));
        }
    }

    private Set<String> collectCanNotReadFields(String entityNumber, String businessKey) {
        String appId = this.getAppId(entityNumber);
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        long currUserId = RequestContext.get().getCurrUserId();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(Long.valueOf(businessKey));
        return (Set)BizFlowGraphUtil.getCanNotReadFields((PermissionService)permissionService, (long)currUserId, (String)appId, (String)entityNumber, ids, (boolean)false).get(Long.valueOf(businessKey));
    }

    private void updateEntryFieldAp(DynamicObject fieldInfo, int i, EntryGrid entry, int j) {
        if (j == 0) {
            HashMap<String, Object> signTypeMap = new HashMap<String, Object>();
            signTypeMap.put("text", fieldInfo.get("entrylocationname"));
            this.getView().updateControlMetadata(FLEXENTRY + i, signTypeMap);
        }
        if (WfUtils.isNotEmpty((String)fieldInfo.getString(FIELDPERCENT))) {
            entry.setColumnProperty("col" + i + "_" + j, "w", (Object)new LocaleString(fieldInfo.getString(FIELDPERCENT)));
        }
        if (WfUtils.isNotEmpty((String)fieldInfo.getString(FONTCOLOR))) {
            entry.setColumnProperty("col" + i + "_" + j, "fc", (Object)fieldInfo.getString(FONTCOLOR));
        }
        if (fieldInfo.getInt(FONTSIZE) != 0) {
            entry.setColumnProperty("col" + i + "_" + j, "fs", (Object)fieldInfo.getInt(FONTSIZE));
        }
        entry.setColumnProperty("col" + i + "_" + j, "header", (Object)((OrmLocaleValue)fieldInfo.get("fieldname")));
    }

    private void updateFiledAp(int i, DynamicObject fieldInfo) {
        HashMap<String, Object> signTypeMap = new HashMap<String, Object>(3);
        if (WfUtils.isNotEmpty((String)fieldInfo.getString(FIELDPERCENT))) {
            signTypeMap.put("w", new LocaleString(fieldInfo.getString(FIELDPERCENT)));
        }
        if (WfUtils.isNotEmpty((String)fieldInfo.getString(FONTCOLOR))) {
            signTypeMap.put("fc", fieldInfo.getString(FONTCOLOR));
        }
        if (fieldInfo.getInt(FONTSIZE) != 0) {
            signTypeMap.put("fs", fieldInfo.getInt(FONTSIZE));
        }
        if (!signTypeMap.isEmpty()) {
            this.getView().updateControlMetadata("key" + i, signTypeMap);
        }
    }

    private void collecAttachementInfo(List<String> attachmentKeys, List<String> showFlexKeys, String entityNumber, String businessKey) {
        if (CollectionUtil.isNotEmpty(attachmentKeys)) {
            ArrayList datas = new ArrayList();
            for (String attachmentKey : attachmentKeys) {
                List data = AttachmentServiceHelper.getAttachments((String)entityNumber, (Object)businessKey, (String)attachmentKey);
                datas.addAll(data);
            }
            if (CollectionUtil.isNotEmpty(datas)) {
                this.getPageCache().put("attachments", SerializationUtils.toJsonString(datas));
                showFlexKeys.add("flexattachment");
            }
        }
    }

    private void showTargetFlexs(List<String> showFlexKeys) {
        String[] flexKeys = new String[showFlexKeys.size()];
        for (int i = 0; i < showFlexKeys.size(); ++i) {
            flexKeys[i] = showFlexKeys.get(i);
        }
        this.getView().setVisible(Boolean.TRUE, flexKeys);
    }

    public void afterBindData(EventObject e) {
        String attachmentStr = this.getPageCache().get("attachments");
        if (attachmentStr != null) {
            List datas = (List)SerializationUtils.fromJsonString((String)attachmentStr, List.class);
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentfield");
            attachmentPanel.bindData(datas);
        }
    }

    private void collectFieldInfos(DynamicObjectCollection configFields, List<String> fieldKeys, Map<String, DynamicObject> headFields, List<String> entryKeys, Map<String, List<String>> entryFields) {
        for (int i = 0; i < configFields.size(); ++i) {
            List<String> entryFieldKeys;
            DynamicObject configField = (DynamicObject)configFields.get(i);
            boolean isHeadField = configField.getBoolean("isheadfield");
            String fieldKey = configField.getString("fieldkey");
            headFields.put(fieldKey, configField);
            if (isHeadField) {
                fieldKeys.add(fieldKey);
                continue;
            }
            String entryKey = configField.getString("entrylocation");
            if (!entryKeys.contains(entryKey)) {
                entryKeys.add(entryKey);
            }
            if ((entryFieldKeys = entryFields.get(entryKey)) == null) {
                entryFieldKeys = new ArrayList<String>();
            }
            entryFieldKeys.add(fieldKey);
            entryFields.put(entryKey, entryFieldKeys);
        }
    }

    private void setBillInfo(DynamicObject billInfo, FormMetadata formMetadata) {
        String billName = formMetadata.getName().getLocaleValue();
        DynamicObject user = billInfo.getDynamicObject("creator");
        Label billNameLabel = (Label)this.getView().getControl("billname");
        if (user != null) {
            String creator = user.getLocaleString("name").toString();
            billNameLabel.setText(String.format(ResManager.loadKDString((String)"%1s\u7684%2s", (String)"WorkflowBillSummaryPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), creator, billName));
        } else {
            billNameLabel.setText(billName);
        }
    }

    private void hideAllFlex() {
        int i;
        String[] flexKeys = new String[45];
        for (i = 0; i < 40; ++i) {
            flexKeys[i] = "flex" + i;
        }
        for (i = 0; i < 4; ++i) {
            flexKeys[40 + i] = FLEXENTRY + i;
        }
        flexKeys[44] = "flexattachment";
        this.getView().setVisible(Boolean.FALSE, flexKeys);
    }

    private String getAppId(String entityNumber) {
        String appId = this.getView().getFormShowParameter().getAppId();
        return BizFlowGraphUtil.getAppId((String)entityNumber, (String)appId);
    }
}

