/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.plugin.WorkflowBasicInfoPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowBillTaskBasicInfoPlugin
extends WorkflowBasicInfoPlugin {
    private static final String SOURCEBILL = "sourceBill";
    private static final String PC = "pc";
    private static final String ENDTYPE = "endType";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SOURCEBILL});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject properties = this.getCellProperties();
        this.initSourceBill(properties);
        this.initEndTypeInfo(properties);
    }

    private void initEndTypeInfo(JSONObject properties) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem comboItem = new ComboItem();
        String endTypePc = ResManager.loadKDString((String)"\u4ec5PC\u7aef\u5904\u7406", (String)"WorkflowBillTaskBasicInfoPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        comboItem.setCaption(new LocaleString(endTypePc));
        comboItem.setValue(PC);
        items.add(comboItem);
        ComboEdit pcProcessPageComboEdit = (ComboEdit)this.getControl(ENDTYPE);
        pcProcessPageComboEdit.setComboItems(items);
        this.getModel().setValue(ENDTYPE, (Object)PC);
        this.setProperty(properties, ENDTYPE, PC);
    }

    private void initSourceBill(JSONObject properties) {
        String sourceBill = (String)properties.get((Object)SOURCEBILL);
        this.getModel().setValue(SOURCEBILL, (Object)sourceBill);
    }

    @Override
    protected void addCustomProcessPage(JSONObject properties) {
        String processingPageValue = properties.getString("processingPage");
        if ("wf_approvalbill".equals(processingPageValue)) {
            processingPageValue = "botp_convertop";
            this.setProperty(properties, "processingPage", processingPageValue);
            this.getModel().setValue("processingpage", (Object)processingPageValue);
        }
        ComboEdit pcProcessPageComboEdit = (ComboEdit)this.getControl("processingpage");
        QFilter filter = new QFilter("parentid", "like", (Object)"%5d1c305d000000ac%");
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] forms = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"number,name", (QFilter[])filters);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem comboItem = new ComboItem();
        String caption = ResManager.loadKDString((String)"\u9ed8\u8ba4pc\u7aef\u5355\u636e\u8f6c\u6362\u9875\u9762", (String)"WorkflowBasicInfoPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        String value = "botp_convertop";
        comboItem.setCaption(new LocaleString(caption));
        comboItem.setValue(value);
        comboItems.add(comboItem);
        if (forms.length > 0) {
            for (DynamicObject form : forms) {
                comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(form.getLocaleString("name").getLocaleValue()));
                comboItem.setValue(form.getString("number"));
                comboItems.add(comboItem);
            }
        }
        pcProcessPageComboEdit.setComboItems(comboItems);
    }

    @Override
    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (key.equals("sourcebill")) {
            DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, SOURCEBILL);
        } else {
            super.click(evt);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (SOURCEBILL.equals(actionId)) {
            this.setCloseDataForSourceBill(returnData);
        } else {
            super.closedCallBack(evt);
        }
    }

    private void setCloseDataForSourceBill(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            String entityName = (String)data.get("name");
            String entityNumber = (String)data.get("number");
            this.setProperties("sourceEntityNumber", entityNumber, SOURCEBILL, entityName);
            this.getModel().setValue(SOURCEBILL, (Object)entityName);
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if ("sourcebill".equals(propName)) {
            if (WfUtils.isEmptyString((Object)newValue)) {
                this.setProperties("sourceEntityNumber", "", SOURCEBILL, "");
            }
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }
}

