/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.WorkflowNodeControlPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;

public class WorkflowBilltaskNodeControlPlugin
extends WorkflowNodeControlPlugin {
    private static final String BILLTASK_CALLACTIVITY_MODEL = "billTaskCallActivity";
    private static final String ENABLE_CALLACTIVITY = "enablecallactivity";
    private static final String CALLACT_PANEL = "callact_panel";
    private static final String CALLPROCESSNAME = "callprocessname";
    private static final String CALLEDWAY = "calledway";
    private static final String ADDRESSKEYNAME = "addresskeyname";
    private static final String ADDRESSKEY = "addresskey";
    private static final String ADDRESSPROPSPANEL = "addresspropspanel";
    private static final String BINDPROCESSPANEL = "bindprocesspanel";
    private static final String NUMBER = "number";
    private static final String CALLPROCESSID = "callProcessId";
    private static final String CLOSECONDITION = "closecondition";
    private static final String WAITACTIONS = "waitexecutedactions";
    private static final String PROPERTY_CLOSECONDITION = "billCloseCondition";
    private static final String PROPERTY_WAITACTIONS = "waitActions";
    private static final String PROPERTY_GROUP_BILLCLOSECONFIG = "billCloseConfig";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(ADDRESSKEYNAME, CLOSECONDITION, WAITACTIONS);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADDRESSKEYNAME, CALLPROCESSNAME, CLOSECONDITION, WAITACTIONS});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject properties = this.getCellProperties();
        this.initCallActivityCfg(properties);
        this.initBillCloseConfig(properties);
    }

    private void initCallActivityCfg(JSONObject properties) {
        JSONObject billTaskCallActivity = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, BILLTASK_CALLACTIVITY_MODEL);
        if (billTaskCallActivity == null) {
            return;
        }
        boolean enableCallActivity = billTaskCallActivity.getBooleanValue("enableCallActivity");
        this.getView().setVisible(Boolean.valueOf(enableCallActivity), new String[]{CALLACT_PANEL});
        String calledWay = (String)billTaskCallActivity.get((Object)"calledWay");
        if (WfUtils.isNotEmpty((String)calledWay)) {
            this.getModel().setValue(CALLEDWAY, (Object)calledWay);
        }
        this.visibleCalledWay();
        String callProcessName = (String)billTaskCallActivity.get((Object)"callProcessName");
        if (WfUtils.isNotEmpty((String)callProcessName)) {
            this.getModel().setValue(CALLPROCESSNAME, (Object)callProcessName);
        }
        this.getModel().setValue(ADDRESSKEYNAME, billTaskCallActivity.get((Object)"addressKeyName"));
        this.getPageCache().put(ADDRESSKEY, String.valueOf(billTaskCallActivity.get((Object)"addressKey")));
    }

    private void visibleCalledWay() {
        String value = (String)this.getModel().getValue(CALLEDWAY);
        this.setProperty(CALLEDWAY, value);
        if ("bindByProdefId".equals(value)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BINDPROCESSPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{ADDRESSPROPSPANEL});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BINDPROCESSPANEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{ADDRESSPROPSPANEL});
        }
    }

    private void initBillCloseConfig(JSONObject properties) {
        JSONObject billCloseConfig = properties.getJSONObject(PROPERTY_GROUP_BILLCLOSECONFIG);
        if (billCloseConfig == null) {
            return;
        }
        JSONObject closeCondition = billCloseConfig.getJSONObject(PROPERTY_CLOSECONDITION);
        this.getModel().setValue(CLOSECONDITION, (Object)this.getCloseConditionShowText((Map<String, Object>)closeCondition));
        JSONObject waitActions = billCloseConfig.getJSONObject(PROPERTY_WAITACTIONS);
        this.getModel().setValue(WAITACTIONS, (Object)this.getWaitActionsShowText((Map<String, Object>)waitActions));
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "callprocessname": {
                this.showCallProcess();
                break;
            }
            case "addresskeyname": {
                this.showOperation();
                break;
            }
            case "closecondition": {
                this.showBillCloseCondition();
                break;
            }
            case "waitexecutedactions": {
                this.showWaitActions();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void showBillCloseCondition() {
        String property = String.format("%s.%s", PROPERTY_GROUP_BILLCLOSECONFIG, PROPERTY_CLOSECONDITION);
        DesignerPluginUtil.openConditionalRule(this.getView(), (IFormPlugin)this, this.getCellProperties(), this.getModelJsonString(), this.itemId, ConditionalRuleType.taskCloseRule, property, CLOSECONDITION);
    }

    private void showWaitActions() {
        JSONObject cellProperties = this.getCellProperties();
        String property = String.format("%s.%s", PROPERTY_GROUP_BILLCLOSECONFIG, PROPERTY_WAITACTIONS);
        FormShowParameter showParameter = this.getShowParameter(WAITACTIONS, "bpm_waitactions");
        showParameter.setCustomParam("itemId", (Object)this.itemId);
        showParameter.setCustomParam("modelJson", (Object)this.getModelJsonString());
        showParameter.setCustomParam("value", DesignerModelUtil.getProperty((Map<String, Object>)cellProperties, property));
        showParameter.setCustomParam("entityId", (Object)cellProperties.getString("entityId"));
        showParameter.setCustomParam("entityNumber", (Object)cellProperties.getString("entityNumber"));
        this.getView().showForm(showParameter);
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "enablecallactivity": {
                this.switchCallActivityPanelState(newValue);
                break;
            }
            case "calledway": {
                this.visibleCalledWay();
                break;
            }
            case "callprocessname": {
                this.deleteCallProcess(newValue);
                break;
            }
            case "closecondition": {
                this.closeConditionChanged(newValue);
                break;
            }
            case "waitexecutedactions": {
                this.waitActionsChanged(newValue);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void closeConditionChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty(PROPERTY_CLOSECONDITION, null);
        }
    }

    private void waitActionsChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty(PROPERTY_WAITACTIONS, null);
        }
    }

    private void deleteCallProcess(Object newValue) {
        if (WfUtils.isEmptyString((Object)newValue)) {
            this.deleteProperties("billTaskCallActivity.callProcessId", "billTaskCallActivity.callProcessName", "billTaskCallActivity.callProcessNumber");
        }
    }

    private void switchCallActivityPanelState(Object newValue) {
        this.getView().setVisible((Boolean)newValue, new String[]{CALLACT_PANEL});
        this.setProperty(ENABLE_CALLACTIVITY, newValue);
    }

    private void showCallProcess() {
        try {
            JSONObject processProps = this.getProcessProperties();
            HashMap<String, Object> processProperties = new HashMap<String, Object>();
            processProperties.put("process_id", processProps.getString("process_id"));
            processProperties.put("entraBillId", this.getProperty("entityId"));
            processProperties.put("selected", this.getProperty(CALLPROCESSID));
            HashMap<String, HashMap<String, Object>> context = new HashMap<String, HashMap<String, Object>>();
            context.put("processProperties", processProperties);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("context", context);
            params.put("processType", processProps.getString("processType"));
            FormShowParameter showParameter = this.getShowParameter(CALLPROCESSNAME, "wf_selectsubprocess");
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        }
        catch (Exception e) {
            this.log.error(String.format("\u521d\u59cb\u5316\u5b50\u6d41\u7a0b\u76f8\u5173\u4fe1\u606f\u51fa\u9519--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
        }
    }

    private void showOperation() {
        try {
            JSONObject properties = this.getCellProperties();
            HashMap<String, String> processProperties = new HashMap<String, String>();
            processProperties.put("entraBill", properties.getString("entityNumber"));
            HashMap<String, HashMap<String, String>> context = new HashMap<String, HashMap<String, String>>();
            context.put("processProperties", processProperties);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("context", context);
            params.put("selchexkbox", Boolean.FALSE);
            params.put("selectValues", this.getPageCache().get(ADDRESSKEY));
            FormShowParameter showParameter = this.getShowParameter(ADDRESSKEYNAME, "wf_formoperation");
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        }
        catch (Exception e) {
            this.log.error(String.format("\u521d\u59cb\u5316\u64cd\u4f5c\u76f8\u5173\u4fe1\u606f\u51fa\u9519--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
        }
    }

    private void setCloseDataForSubProcess(Object returnData) {
        Map evtData = (Map)returnData;
        String showName = (String)evtData.get("name") + "(" + (String)evtData.get(NUMBER) + ")";
        this.getModel().setValue(CALLPROCESSNAME, (Object)showName);
        this.setProperty(CALLPROCESSID, evtData.get("id"));
        this.setProperty("callProcessName", showName);
        this.setProperty("callProcessNumber", evtData.get(NUMBER));
    }

    private void setCloseDataForOperation(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            Object name = data.get("name");
            Object number = data.get(NUMBER);
            this.setProperty("addressKeyName", name);
            this.setProperty("addressKey", number);
            this.getModel().setValue(ADDRESSKEYNAME, name);
            this.getPageCache().put(ADDRESSKEY, String.valueOf(number));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "callprocessname": {
                this.setCloseDataForSubProcess(returnData);
                break;
            }
            case "addresskeyname": {
                this.setCloseDataForOperation(returnData);
                break;
            }
            case "closecondition": {
                this.closeConditionCallBack(returnData);
                break;
            }
            case "waitexecutedactions": {
                this.waitActionsCallBack(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void closeConditionCallBack(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.getModel().setValue(CLOSECONDITION, (Object)this.getCloseConditionShowText(data));
            this.setProperty(PROPERTY_CLOSECONDITION, data.size() == 0 ? null : data);
        }
    }

    private void waitActionsCallBack(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.setProperty(PROPERTY_WAITACTIONS, data);
            this.getModel().setValue(WAITACTIONS, (Object)this.getWaitActionsShowText(data));
        }
    }

    private String getCloseConditionShowText(Map<String, Object> data) {
        if (data == null) {
            return "";
        }
        return DesignerPluginUtil.getLocaleValue(data.get("showtext"));
    }

    private String getWaitActionsShowText(Map<String, Object> data) {
        String text;
        Object eventName;
        Map closeEvent;
        if (data == null) {
            return "";
        }
        StringBuilder showText = new StringBuilder();
        List operations = (List)data.get("operations");
        if (operations != null && !operations.isEmpty()) {
            for (Map operation : operations) {
                showText.append((String)operation.get("name")).append(";");
            }
        }
        if ((closeEvent = (Map)data.get("closeEvent")) != null && !closeEvent.isEmpty() && (eventName = closeEvent.get("name")) != null) {
            showText.append(eventName);
        }
        if ((text = showText.toString()).endsWith(";")) {
            text = showText.deleteCharAt(text.length() - 1).toString();
        }
        return text;
    }
}

