/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowCategoryNameChangePlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        if (BTNOK.equals(ctl.getKey())) {
            this.modifyCategory();
        }
    }

    private void modifyCategory() {
        DynamicObject category = (DynamicObject)this.getModel().getValue("datatype");
        Long categoryId = null;
        if (category == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u201c\u6d41\u7a0b\u7c7b\u522b\u201d\u540e\u518d\u64cd\u4f5c\u3002", (String)"WorkflowCategoryNameChangePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            categoryId = (Long)category.get("id");
            List processIds = (List)this.getView().getFormShowParameter().getCustomParam("idList");
            try {
                this.updateDesign(processIds, categoryId);
                IListView listView = (IListView)this.getView().getParentView();
                listView.refresh();
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"WorkflowCategoryNameChangePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                String appType = this.getView().getFormShowParameter().getAppId();
                WfUtils.addOpLogByAppId((String)appType, (String)"wf_model", (String)"procategory", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91cd\u65b0\u8bbe\u7f6e\u6d41\u7a0b\u7c7b\u522b", "WorkflowCategoryNameChangePlugin_4", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u201c%1$s\u201d\u7684\u6d41\u7a0b\u7c7b\u522b\u91cd\u65b0\u8bbe\u7f6e\u4e3a\u201c%2$s\u201d\u3002", "WorkflowCategoryNameChangePlugin_5", "bos-wf-formplugin"), (Object[])new Object[]{processIds, categoryId});
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            }
            catch (Exception e) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowCategoryNameChangePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()), Integer.valueOf(3000));
            }
        }
    }

    private void updateDesign(List<Long> designIds, Long categoryId) {
        int i;
        DynamicObject[] dynModelObjArr = new DynamicObject[designIds.size()];
        QFilter f1 = new QFilter("modelid", "in", designIds);
        QFilter[] qFilters = new QFilter[]{f1};
        DynamicObjectCollection procdefId = QueryServiceHelper.query((String)"wf_processdefinition", (String)"id", (QFilter[])qFilters);
        DynamicObject[] dynprocdefObjArr = new DynamicObject[procdefId.size()];
        for (i = 0; i < designIds.size(); ++i) {
            DynamicObject dynModelObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_model"));
            dynModelObj.set("id", (Object)designIds.get(i));
            dynModelObj.set("categoryid", (Object)categoryId);
            dynModelObjArr[i] = dynModelObj;
        }
        for (i = 0; i < procdefId.size(); ++i) {
            DynamicObject dynprocdefObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_processdefinition"));
            dynprocdefObj.set("id", ((DynamicObject)procdefId.get(i)).get("id"));
            dynprocdefObj.set("categoryid", (Object)categoryId);
            dynprocdefObjArr[i] = dynprocdefObj;
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.update((DynamicObject[])dynModelObjArr);
            SaveServiceHelper.update((DynamicObject[])dynprocdefObjArr);
        }
    }
}

