/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowCommonAuditCommentPlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String AUDITCOMMENTWHENMATCH = "auditcommentwhenmatch";
    private static final String FLEXPANEL_AUDITCOMMENTS = "fp_auditcomments";
    public static final String AUDITCOMMENTS = "auditcomments";
    private static final String AUDITCOMMENTS_ID = "auditcomments_id";
    private static final String AUDITCOMMENTS_NUMBER = "auditcomments_number";
    private static final String AUDITCOMMENTS_CONTENT = "auditcomments_content";
    public static final String AUDITCOMMENTS_DECISION = "auditcomments_decision";
    private static final String AUDITCOMMENTS_ISDEFAULT = "auditcomments_defaudit";
    private static final String AUDITCOMMENTS_BASEDATAID = "auditcomments_basedataid";
    private static final String BTN_AUDITCOMMENTS_CFG = "btn_auditcomments_cfg";
    private static final String DEFAUDIT = "defaudit";

    @Override
    public void initialize() {
        super.initialize();
        this.addHandleProperties("auditComments", "auditCommentWhenMatch");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_AUDITCOMMENTS_CFG});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject properties = this.getCellProperties();
        this.changeAuditCommentsSequence(properties);
        this.initAuditComments(properties);
    }

    private void changeAuditCommentsSequence(JSONObject properties) {
        JSONArray auditComments;
        JSONObject auditCommentModel = (JSONObject)properties.get((Object)"auditCommentModel");
        if (auditCommentModel != null && (auditComments = (JSONArray)auditCommentModel.get((Object)"auditComments")) != null && auditComments.size() > 0) {
            for (int i = 0; i < auditComments.size(); ++i) {
                JSONObject auditComment = (JSONObject)auditComments.get(i);
                if (!auditComment.getBooleanValue(DEFAUDIT) || !WfUtils.isEmpty((String)((String)auditComment.get((Object)"decision")))) continue;
                auditComment.put(DEFAUDIT, (Object)Boolean.FALSE);
                Object decision0 = this.getModel().getValue(AUDITCOMMENTS_DECISION, 0);
                this.setEntryField(auditComment, 0);
                this.getModel().setValue(AUDITCOMMENTS_DECISION, this.getModel().getValue(AUDITCOMMENTS_DECISION, i), 0);
                this.setEntryField((JSONObject)auditComments.get(0), i);
                this.getModel().setValue(AUDITCOMMENTS_DECISION, decision0, i);
                break;
            }
        }
    }

    private void setEntryField(JSONObject auditComment, int rowIndex) {
        this.getModel().setValue(AUDITCOMMENTS_NUMBER, auditComment.get((Object)"number"), rowIndex);
        this.getModel().setValue(AUDITCOMMENTS_CONTENT, auditComment.get((Object)"content"), rowIndex);
        this.getModel().setValue(AUDITCOMMENTS_ISDEFAULT, auditComment.get((Object)DEFAUDIT), rowIndex);
        this.getModel().setValue(AUDITCOMMENTS_BASEDATAID, auditComment.get((Object)"basedataid"), rowIndex);
        this.getModel().setValue(AUDITCOMMENTS_ID, auditComment.get((Object)"id"), rowIndex);
    }

    private void initAuditComments(JSONObject properties) {
        this.initDecisionitems(properties);
        Object auditCommentWhenMatch = this.getProperty(AUDITCOMMENTWHENMATCH);
        Boolean isAuditComments = Boolean.TRUE.equals(auditCommentWhenMatch);
        this.getModel().setValue(AUDITCOMMENTWHENMATCH, (Object)isAuditComments);
        this.getView().setVisible(isAuditComments, new String[]{FLEXPANEL_AUDITCOMMENTS});
    }

    @Override
    protected Object getEntryFieldValue(EntryGrid grid, JSONObject obj, String ctrlKey) {
        Object value = super.getEntryFieldValue(grid, obj, ctrlKey);
        if (AUDITCOMMENTS_DECISION.equals(ctrlKey) && (value == null || WfUtils.isEmpty((String)value.toString()))) {
            JSONObject properties = this.getCellProperties();
            JSONArray decisionOptions = (JSONArray)properties.get((Object)"decisionOptions");
            StringBuilder valueSB = new StringBuilder();
            for (Object decisionOptionObject : decisionOptions) {
                JSONObject decisionOption = (JSONObject)decisionOptionObject;
                String auditType = (String)decisionOption.get((Object)"auditType");
                if (!"approve".equals(auditType)) continue;
                String number = (String)decisionOption.get((Object)"number");
                valueSB.append(number).append(',');
            }
            String newString = valueSB.toString().substring(0, valueSB.length() - 1);
            return newString;
        }
        return value;
    }

    private void initDecisionitems(JSONObject properties) {
        JSONArray decisionOptions = (JSONArray)properties.get((Object)"decisionOptions");
        HashMap<String, Object> items = new HashMap<String, Object>();
        HashSet<String> typeSet = new HashSet<String>();
        ComboEdit operation = (ComboEdit)this.getControl(AUDITCOMMENTS_DECISION);
        if (decisionOptions == null || decisionOptions.isEmpty()) {
            this.log.debug("NodeTemplate,There is't entityId");
            return;
        }
        for (Object decisionOptionObject : decisionOptions) {
            JSONObject decisionOption = (JSONObject)decisionOptionObject;
            Object number = decisionOption.get((Object)"number");
            String name = (String)decisionOption.get((Object)"name");
            typeSet.add(decisionOption.getString("auditType"));
            items.put(name, number);
        }
        this.getPageCache().put("typeSet", SerializationUtils.toJsonString(typeSet));
        PluginUtil.setComboForControl(items, operation);
    }

    @Override
    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_AUDITCOMMENTS_CFG.equals(key)) {
            this.showAuditComments();
        }
    }

    private void showAuditComments() {
        Map auditCommentMap;
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"wf_commonauditcommenttree", (boolean)true, (int)2);
        ArrayList<String> numbers = new ArrayList<String>();
        ArrayList<Long> basedataIds = new ArrayList<Long>();
        int entryRowCount = this.getModel().getEntryRowCount(AUDITCOMMENTS);
        for (int i = 0; i < entryRowCount; ++i) {
            Long basedataId = (Long)this.getModel().getValue(AUDITCOMMENTS_BASEDATAID, i);
            if (basedataId != null && basedataId != 0L) {
                basedataIds.add(basedataId);
                continue;
            }
            String number = (String)this.getModel().getValue(AUDITCOMMENTS_NUMBER, i);
            if (!StringUtils.isNotBlank((CharSequence)number)) continue;
            numbers.add(number);
        }
        if (numbers.size() > 0 && (auditCommentMap = BusinessDataServiceHelper.loadFromCache((String)"wf_commonauditcommenttree", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)numbers.toArray())})) != null) {
            for (Object key : auditCommentMap.keySet()) {
                basedataIds.add((Long)key);
            }
        }
        ListFilterParameter filter = new ListFilterParameter();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
        QFilter flt1 = new QFilter("enable", "=", (Object)"1");
        filterList.add(flt1);
        QFilter flt2 = new QFilter("id", "not in", basedataIds);
        filterList.add(flt2);
        String typeSet = this.getPageCache().get("typeSet");
        if (WfUtils.isEmpty((String)typeSet)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65f6\u4e0d\u652f\u6301\u4fee\u6539\u5e38\u7528\u5ba1\u6279\u610f\u89c1\u3002", (String)"WorkflowCommonAuditCommentPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        Set types = (Set)SerializationUtils.fromJsonString((String)typeSet, Set.class);
        QFilter flt3 = new QFilter("decisiontype", "in", (Object)types);
        filterList.add(flt3);
        filter.setQFilters(filterList);
        showParameter.setListFilterParameter(filter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, AUDITCOMMENTS_CONTENT);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "auditcommentwhenmatch": {
                this.getView().setVisible((Boolean)newValue, new String[]{FLEXPANEL_AUDITCOMMENTS});
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "auditcomments_decision": {
                this.verifyNewValueUsable(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void verifyNewValueUsable(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null || "".equals(newValue)) {
            this.getModel().setValue(propName, oldValue, rowIndex);
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u201c\u51b3\u7b56\u9879\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowCommonAuditCommentPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        Long basedataId = (Long)this.getModel().getValue(AUDITCOMMENTS_BASEDATAID, rowIndex);
        DynamicObject auditComment = QueryServiceHelper.queryOne((String)"wf_commonauditcommenttree", (String)"decisiontype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)basedataId)});
        JSONObject properties = this.getCellProperties();
        JSONArray decisionOptions = (JSONArray)properties.get((Object)"decisionOptions");
        for (int i = 0; i < decisionOptions.size(); ++i) {
            JSONObject decisionOption = (JSONObject)decisionOptions.get(i);
            String number = (String)decisionOption.get((Object)"number");
            String newValueStr = (String)newValue;
            String[] newValueArray = newValueStr.split(",");
            for (int j = 0; j < newValueArray.length; ++j) {
                String auditType;
                if (!number.equals(newValueArray[j]) || (auditType = (String)decisionOption.get((Object)"auditType")) == null || auditComment == null || auditType.equals(auditComment.get("decisiontype"))) continue;
                this.getModel().setValue(propName, oldValue, rowIndex);
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u51b3\u7b56\u9879\u4e0e\u5ba1\u6279\u610f\u89c1\u7684\u51b3\u7b56\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WorkflowCommonAuditCommentPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (AUDITCOMMENTS_CONTENT.equals(actionId)) {
            this.setCloseDataForCommentsContent(returnData);
        }
    }

    private void setCloseDataForCommentsContent(Object returnData) {
        ListSelectedRowCollection datas = (ListSelectedRowCollection)returnData;
        if (datas == null) {
            return;
        }
        if (datas.isEmpty()) {
            this.getModel().deleteEntryData(AUDITCOMMENTS);
            return;
        }
        HashMap<Object, ListSelectedRow> rowMap = new HashMap<Object, ListSelectedRow>(datas.size());
        for (ListSelectedRow row : datas) {
            rowMap.put(row.getPrimaryKeyValue(), row);
        }
        List ids = datas.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection auditComments = QueryServiceHelper.query((String)"wf_commonauditcommenttree", (String)"id,decisiontype", (QFilter[])qFilter.toArray());
        JSONObject properties = this.getCellProperties();
        JSONArray decisionOptions = (JSONArray)properties.get((Object)"decisionOptions");
        HashMap<String, JSONObject> auditTypeMap = new HashMap<String, JSONObject>();
        for (Object item2 : decisionOptions) {
            if (!(item2 instanceof JSONObject)) continue;
            JSONObject jItem = (JSONObject)item2;
            auditTypeMap.put(jItem.getString("auditType"), jItem);
        }
        ORM orm = ORM.create();
        long[] diffIds = orm.genLongIds("wf_billdyninfomodel", auditComments.size());
        this.getModel().beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField(AUDITCOMMENTS_DECISION, new Object[0]);
        setter.addField(AUDITCOMMENTS_CONTENT, new Object[0]);
        setter.addField(AUDITCOMMENTS_NUMBER, new Object[0]);
        setter.addField(AUDITCOMMENTS_BASEDATAID, new Object[0]);
        setter.addField(AUDITCOMMENTS_ID, new Object[0]);
        for (int i = 0; i < auditComments.size(); ++i) {
            String number;
            DynamicObject data = (DynamicObject)auditComments.get(i);
            ListSelectedRow row = (ListSelectedRow)rowMap.get(data.get("id"));
            String decision = data.getString("decisiontype");
            JSONObject jsonObject = (JSONObject)auditTypeMap.get(decision);
            if (jsonObject == null || (number = jsonObject.getString("number")) == null) continue;
            setter.addRow(new Object[]{number, row.getName(), row.getNumber(), row.getPrimaryKeyValue(), diffIds[i]});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(AUDITCOMMENTS, setter);
        model.endInit();
        this.getView().updateView(AUDITCOMMENTS);
        this.setProperty(AUDITCOMMENTS, this.getEntryGridValue((EntryGrid)this.getControl(AUDITCOMMENTS)));
    }
}

