/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.ICommonF7ListPlugin;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowCommonFormListPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CONFIRM = "confirm";
    private static final String PANEL_CONTENT = "container";
    private static final String KEY_ACTIONID = "actionId";
    private static final String KEY_PAGEID = "pageId";
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        FormShowParameter listShowParameter = this.getListShowParameter(parameter);
        this.getView().showForm(listShowParameter);
        this.getPageCache().put(KEY_PAGEID, listShowParameter.getPageId());
    }

    private FormShowParameter getListShowParameter(FormShowParameter parameter) {
        String billFormId = (String)parameter.getCustomParam("billFormId");
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ACTIONID));
        listShowParameter.setBillFormId(billFormId);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setMultiSelect(false);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey(PANEL_CONTENT);
        String filterStr = (String)parameter.getCustomParam("filters");
        if (filterStr != null) {
            List filters = SerializationUtils.fromJsonStringToList((String)filterStr, QFilter.class);
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.getQFilters().addAll(filters);
            listShowParameter.setListFilterParameter(filterParameter);
        }
        StyleCss sc = new StyleCss();
        sc.setHeight("515px");
        sc.setWidth("700px");
        listShowParameter.getOpenStyle().setInlineStyleCss(sc);
        return listShowParameter;
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_CONFIRM.equals(key)) {
            this.confirm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (KEY_ACTIONID.equals(evt.getActionId())) {
            this.getView().returnDataToParent(evt.getReturnData());
            this.getView().close();
        }
    }

    private void confirm() {
        String pageId = this.getPageCache().get(KEY_PAGEID);
        if (WfUtils.isNotEmpty((String)pageId)) {
            IFormView listView = this.getView().getView(pageId);
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)listView.getService(FormViewPluginProxy.class);
            Map<String, Object> data = null;
            for (IFormPlugin plugin : pluginProxy.getPlugIns()) {
                if (!(plugin instanceof ICommonF7ListPlugin)) continue;
                ICommonF7ListPlugin listPlugin = (ICommonF7ListPlugin)plugin;
                data = listPlugin.getSelectedData();
                break;
            }
            if (data == null) {
                this.getView().showTipNotification(WFMultiLangConstants.getPleaseSelectALineTip());
            } else {
                this.getView().returnDataToParent(data);
                this.getView().close();
            }
        } else {
            this.log.debug("pageId is null!");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_PAGEID);
    }
}

