/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.workflow.design.plugin.WorkflowParticipantConfigurePlugin;
import kd.bos.workflow.design.util.ParticipantConfigureHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;

public class WorkflowCoordinateSettingPlugin
extends WorkflowParticipantConfigurePlugin {
    private static final String BTNOK = "btnok";
    private static final String SHOWTEXT = "showtext";
    private static final String CIRCULATESUGGESTION = "circulatesuggestion";
    private static final String MODELJSON = "modelJson";
    private static final String LOGICOTHERCHOOSE = "logicOtherChoose";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CIRCULATESUGGESTION, BTNOK});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.setLogicSignals();
        this.initCirculateSetting();
    }

    private void initCirculateSetting() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject properties = (JSONObject)customParams.get("properties");
        JSONObject autoCoordinateModel = (JSONObject)properties.get((Object)"autoCoordinateModel");
        if (autoCoordinateModel != null && !autoCoordinateModel.isEmpty()) {
            Object autoCoordinateObject = autoCoordinateModel.get((Object)"autoCoordinate");
            if (WfUtils.isNotEmptyString((Object)autoCoordinateObject)) {
                List participants;
                JSONObject autoCoordinate = (JSONObject)autoCoordinateObject;
                JSONObject showtextObject = autoCoordinate.getJSONObject(SHOWTEXT);
                if (showtextObject != null && !showtextObject.isEmpty()) {
                    this.getModel().setValue(SHOWTEXT, (Object)showtextObject);
                }
                if ((participants = (List)autoCoordinate.get((Object)"participant")) != null && !participants.isEmpty()) {
                    this.initParticipantListAndConditionEntry(participants);
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"participant_entryentity"});
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"trigger"});
                this.getModel().setValue(CIRCULATESUGGESTION, autoCoordinate.get((Object)"suggestion"));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"participant_entryentity"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"trigger"});
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String modelJson = (String)customParams.get(MODELJSON);
        String itemId = (String)customParams.get("itemId");
        String isDefaultScheme = (String)customParams.get("isDefaultScheme");
        String paramSchemeId = (String)customParams.get("schemeId");
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_add_all": {
                this.getPageCache().remove(LOGICOTHERCHOOSE);
                ParticipantConfigureHelper.addParticipant(this, "participant_entryentity", itemId, modelJson, "operation_add");
                break;
            }
            case "btn_edit_all": {
                this.getPageCache().remove(LOGICOTHERCHOOSE);
                ParticipantConfigureHelper.modifyParticipant(this, "participant_entryentity", itemId, modelJson, "operation_modify");
                break;
            }
            case "btn_del_all": {
                this.getPageCache().remove(LOGICOTHERCHOOSE);
                this.delete();
                break;
            }
            case "participant_condition": {
                this.showConditionalRule(modelJson, itemId, isDefaultScheme, paramSchemeId);
                break;
            }
            case "circulatesuggestion": {
                this.showContent(customParams, CIRCULATESUGGESTION, String.format(ResManager.loadKDString((String)"%s\u610f\u89c1", (String)"WorkflowCoordinateSettingPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName()));
                break;
            }
            case "btnok": {
                this.returnDataToParent();
                break;
            }
        }
    }

    private void delete() {
        List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.deleteParticipant(this, "participant_entryentity");
        this.updateConditionEntity(returnDataList);
    }

    private void showConditionalRule(String modelJson, String itemId, String isDefaultScheme, String paramSchemeId) {
        int rowIndex = this.getFocusRowIndex("entryentity_condition");
        Object logicValue = this.getModel().getValue("participant_logicsignal", rowIndex);
        if (null != logicValue && !Boolean.parseBoolean(logicValue.toString()) && !logicValue.equals(LOGIC_CLEAR)) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            String type = ConditionalRuleType.participant.toString();
            context.put("type", type);
            context.put("property", "condrule");
            context.put("model", modelJson);
            HashMap<String, String> nodeProperties = new HashMap<String, String>();
            nodeProperties.put("itemId", itemId);
            context.put("nodeProperties", nodeProperties);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("context", context);
            FormShowParameter parameter = this.getShowParameter("participant_condition", "wf_conditionrule_update", ConditionalRuleType.getTypeName((String)type), params);
            parameter.setCustomParam("isDefaultScheme", (Object)isDefaultScheme);
            parameter.setCustomParam("schemeId", (Object)paramSchemeId);
            parameter.setShowTitle(false);
            Map indexMap = (Map)this.getReturnDataConditionFromCache(rowIndex);
            if (indexMap != null) {
                Object value = indexMap.get("condrule");
                if (null != value) {
                    parameter.setCustomParam("value", (Object)SerializationUtils.toJsonString(value));
                }
            } else {
                this.logger.debug("ConditionData From Cache is null!");
            }
            this.showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u5e94\u8be5\u8bbe\u7f6e\u4e00\u4e2a\u201c\u5982\u679c\u201d\u903b\u8f91\uff0c\u4e14\u8be5\u201c\u5982\u679c\u201d\u903b\u8f91\u540e\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowCoordinateSettingPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void showContent(Map<String, Object> customParams, String key, String caption) {
        String modelJson = (String)customParams.get(MODELJSON);
        String entityNumber = (String)customParams.get("entityNumber");
        String value = (String)this.getModel().getValue(key);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(MODELJSON, modelJson);
        params.put("entityNumber", entityNumber);
        params.put("value", value);
        params.put("FROM", "MSG");
        super.showForm(this.getShowParameter(key, "wf_autocoordinatemsg", caption, params));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (propName) {
            case "radiogroup_participant": {
                this.participantRadioGroupChanged(newValue);
                break;
            }
            case "participant_logicsignal": {
                this.logicChanged(newValue, false, oldValue);
            }
        }
    }

    private void participantRadioGroupChanged(Object newValue) {
        List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.getReturnDataListFromCache(this, "participant_entryentity");
        if (newValue.equals("condition") && null == returnDataList) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u6240\u6709\u53c2\u4e0e\u4eba\u90fd\u4f1a\u6536\u5230%s\u4efb\u52a1\u201d\u3002", (String)"WorkflowCoordinateSettingPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName()), Integer.valueOf(2000));
        }
        this.getView().setVisible(Boolean.valueOf(newValue.equals("condition")), new String[]{"participant_cond_panel"});
        if (newValue.equals("all")) {
            this.clearConditionRule(returnDataList);
        }
    }

    private void clearConditionRule(List<Map<String, Object>> returnDataList) {
        if (null != returnDataList && !returnDataList.isEmpty()) {
            for (Map<String, Object> map : returnDataList) {
                map.remove("condrule");
                map.remove("conditionExpression");
                map.remove("condruleshowtext");
                map.put("defaultCondition", null);
            }
            this.getPageCache().put(ParticipantConfigureHelper.getDatasCacheKey("participant_entryentity"), SerializationUtils.toJsonString(returnDataList));
            this.updateConditionEntity(returnDataList);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "operation_add": 
            case "operation_modify": {
                this.setCloseBackForParticipant(actionId, returnData);
                break;
            }
            case "participant_condition": {
                this.setCloseDataForCondition(returnData);
                break;
            }
            case "circulatesuggestion": {
                this.setCloseDataForSuggestion(actionId, returnData);
                break;
            }
        }
    }

    private void setCloseBackForParticipant(String actionId, Object returnData) {
        if (returnData instanceof Map) {
            List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.setParticipantEntryValue(this, this.getParticipantEntryInfo((Map)returnData), actionId);
            this.updateConditionEntity(returnDataList);
        }
    }

    private void setCloseDataForSuggestion(String actionId, Object returnData) {
        Map returnMap;
        Object value;
        if (returnData instanceof Map && (value = (returnMap = (Map)returnData).get("customSubject")) != null) {
            this.getModel().setValue(actionId, value);
        }
    }

    private void returnDataToParent() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put(SHOWTEXT, (OrmLocaleValue)this.getModel().getValue(SHOWTEXT));
        List<Map<String, Object>> participantEntryEntity = ParticipantConfigureHelper.getReturnDataListFromCache(this, "participant_entryentity");
        returnData.put("participant", participantEntryEntity);
        String radioGroupValue = (String)this.getModel().getValue("radiogroup_participant");
        if ("condition".equals(radioGroupValue) && !this.hasIfLogicSignal().booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u5e94\u8be5\u8bbe\u7f6e\u4e00\u4e2a\u201c\u5982\u679c\u201d\u903b\u8f91\uff0c\u4e14\u8be5\u201c\u5982\u679c\u201d\u903b\u8f91\u540e\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowCoordinateSettingPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        returnData.put("radiogroup_participant", radioGroupValue);
        returnData.put("suggestion", (String)this.getModel().getValue(CIRCULATESUGGESTION));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private Boolean hasIfLogicSignal() {
        boolean hasIfLogicSignal = false;
        DynamicObjectCollection entryEntityConditions = this.getModel().getEntryEntity("entryentity_condition");
        for (DynamicObject entryEntityCondition : entryEntityConditions) {
            String logicsignal = (String)entryEntityCondition.get("participant_logicsignal");
            String condition = (String)entryEntityCondition.get("participant_condition");
            if (!WfUtils.isNotEmpty((String)logicsignal) || !WfUtils.isNotEmpty((String)condition) || Boolean.parseBoolean(logicsignal)) continue;
            hasIfLogicSignal = true;
            break;
        }
        return hasIfLogicSignal;
    }
}

