/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.alias.IPropertyConverter;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.design.property.alias.AliasConverterFactory;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowDecisionPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String NODE_PROPERTIES = "nodeProperties";
    private static final String DECISIONNAME = "decisionname";
    private static final String AUDIT_TYPE = "auditType";
    private static final String DEFAULT_DECISION = "defaultDecision";
    private static final String ENTITY_ID = "entityId";
    private static final String DOCUMENTATION = "documentation";
    private static final String APPROVE = "approve";
    private static final String COLUMN_WORKFLOWNUM = "workflownum";
    private static final String ITEM_ID = "itemId";
    private static final String NUMBER = "number";
    private static final String PREVIOUS_NODES = "previousNodes";
    private static final String REJECT = "reject";
    private static final String IS_YZJ = "isYzj";
    private static final String DEFAULTOPERATION = "defaultoperation";
    private static final String SELECTNODE = "selectnode";
    private static final String BTNTODEFAULT = "btntodefault";
    private static final String BTNADDROW = "btnaddrow";
    private static final String BTNDELETEROW = "btndeleterow";
    private static final String CHANGED_INDEXES = "indexes";
    private Log logger = LogFactory.getLog(WorkflowDecisionPlugin.class);
    private static final String ENTRYKEY = "entryentity";
    private static final String WFSELECTNODES = "wf_selectnodes";
    private static final String APPROVALTYPE = "approvaltype";
    private static final String IS_YZJ_ONEVOTEVETO = "isYzjOneVoteVeto";
    String[] decisionNumberBlackList = new String[]{"start", "end"};
    private static final String APPROVALSCENE = "approvalscene";
    private static final String DECISIONSCENE = "decisionScene";

    public void initialize() {
        this.addClickListeners(new String[]{BTNADDROW, BTNDELETEROW, BTNTODEFAULT});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        Button btn = (Button)this.getView().getControl("btnexit");
        btn.addClickListener((ClickListener)this);
        TextEdit edit = (TextEdit)this.getView().getControl(SELECTNODE);
        edit.addButtonClickListener((ClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BTNADDROW.equalsIgnoreCase(key)) {
            this.addDecisionItem();
        } else if (BTNDELETEROW.equals(key)) {
            this.deleteDecisionItem();
        } else if (BTNTODEFAULT.equalsIgnoreCase(key)) {
            this.toBeDefault();
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnexit": {
                this.getDecisonData();
                break;
            }
            case "selectnode": {
                this.showNodes(WFSELECTNODES, SELECTNODE, evt);
                break;
            }
            case "defaultoperation": {
                this.toBeDefault();
                break;
            }
        }
    }

    private void showNodes(String formId, String controlName, EventObject evt) {
        String isYzj = this.getPageCache().get(IS_YZJ);
        String business_model = (String)this.getView().getFormShowParameter().getCustomParam("business_model");
        if (StringUtils.isNotBlank((CharSequence)isYzj) && "true".equals(isYzj) && !"oneVoteVeto".equals(business_model)) {
            formId = "wf_yzjselectnodes";
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYKEY);
        int rowKey = grid.getEntryState().getFocusRow();
        String approvaltype = (String)this.getModel().getValue(APPROVALTYPE, grid.getEntryState().getFocusRow());
        if (REJECT.equals(approvaltype) || "forceReject".equals(approvaltype)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId(formId);
            String previouNodes = this.getPageCache().get(PREVIOUS_NODES);
            if (previouNodes != null) {
                List nodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PREVIOUS_NODES), List.class);
                parameter.setCustomParam(PREVIOUS_NODES, (Object)nodes);
            }
            parameter.setCustomParam("value", this.getModel().getValue(controlName + "data", rowKey));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, controlName));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        int rowKey = grid.getEntryState().getFocusRow();
        if (!SELECTNODE.equalsIgnoreCase(actionId)) {
            Map iData = (Map)evt.getReturnData();
            this.getModel().setValue(actionId, WfUtils.isNotEmptyString(iData.get("name")) ? iData.get("name") : iData.get(NUMBER), rowKey);
            this.getModel().setValue(actionId + "data", iData.get(NUMBER), rowKey);
        } else {
            List nodes = (List)evt.getReturnData();
            StringBuilder sb = new StringBuilder("{");
            for (Map map : nodes) {
                sb.append((String)map.get("name")).append(',');
            }
            String resultNodes = sb.substring(0, sb.length() - 1) + "}";
            resultNodes = "}".equals(resultNodes) ? "" : resultNodes;
            this.getModel().setValue(actionId, (Object)resultNodes, rowKey);
            this.getModel().setValue(actionId + "data", (Object)SerializationUtils.toJsonString((Object)nodes), rowKey);
            this.getModel().getValue(actionId + "data", rowKey);
            Set<String> indexes = this.getIndex();
            indexes.add(String.valueOf(rowKey));
            this.getPageCache().put(CHANGED_INDEXES, SerializationUtils.toJsonString(indexes));
        }
    }

    private void getDecisonData() {
        Map properties;
        DynamicObjectCollection entityList = this.getModel().getEntryEntity(ENTRYKEY);
        if (this.checkYZJDecisionOption((List<DynamicObject>)entityList)) {
            return;
        }
        boolean checkKeywordResult = this.checkKeywordResult((List<DynamicObject>)entityList);
        if (checkKeywordResult) {
            return;
        }
        ArrayList<String> workflownumList = new ArrayList<String>(entityList.size());
        ArrayList<String> showMessageList = new ArrayList<String>();
        String isDefaultScheme = (String)this.getView().getFormShowParameter().getCustomParam("isDefaultScheme");
        String schemeId = (String)this.getView().getFormShowParameter().getCustomParam("schemeId");
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam(ITEM_ID);
        Map childNumbersMap = new HashMap();
        if ("true".equals(isDefaultScheme)) {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            childNumbersMap = wfService.getRepositoryService().getChildrenSchemesDecisions(Long.valueOf(schemeId), itemId);
        }
        List comboItems = (List)JSON.parse((String)this.getPageCache().get("approvalScenefilter"));
        ArrayList approveScenes = new ArrayList();
        if (comboItems != null && comboItems.size() > 0) {
            comboItems.stream().forEach(a -> approveScenes.add(a.get("value").toString()));
        }
        for (int i = 0; i < entityList.size(); ++i) {
            String workflownum = ((DynamicObject)entityList.get(i)).getString(COLUMN_WORKFLOWNUM).toLowerCase();
            if (!workflownum.matches("^[A-Za-z0-9_]+$")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u201c\u7f16\u7801\u201d\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f\u3002", (String)"WorkflowDecisionPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), i + 1));
                return;
            }
            if (workflownumList.contains(workflownum)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1s\u201d\u884c\u548c\u7b2c\u201c%2s\u201d\u884c\u7684\u201c\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"WorkflowDecisionPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), workflownumList.indexOf(workflownum) + 1, i + 1));
                return;
            }
            if (!approveScenes.contains(((DynamicObject)entityList.get(i)).getString(APPROVALSCENE))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u51b3\u7b56\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowDecisionPlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]), i + 1));
                return;
            }
            if (!childNumbersMap.isEmpty()) {
                for (Map.Entry set : childNumbersMap.entrySet()) {
                    if (!((List)set.getValue()).contains(workflownum)) continue;
                    String showMessage = String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u7f16\u7801\u548c\u5b50\u65b9\u6848%2s\u4e2d\u7684\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkflowDecisionPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), i + 1, set.getKey());
                    showMessageList.add(showMessage);
                }
            }
            if (!showMessageList.isEmpty()) {
                DesignerModelUtil.showValidateResult(this, showMessageList, ResManager.loadKDString((String)"\u5b50\u65b9\u6848\u51b3\u7b56\u9879\u7f16\u7801\u6821\u9a8c\u7ed3\u679c", (String)"WorkflowDecisionPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"WorkflowDecisionPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), null);
                return;
            }
            workflownumList.add(workflownum);
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection rowKeyobjs = model.getEntryEntity(ENTRYKEY);
        int rowIndex = 0;
        ArrayList decData = new ArrayList();
        HashMap defaultValMap = new HashMap();
        Set<String> indexes = this.getIndex();
        boolean openedByScheme = false;
        IFormView grandParentView = this.getView().getParentView();
        while (grandParentView != null && (grandParentView = grandParentView.getParentView()) != null && !"pc_main_console".equals(grandParentView.getFormShowParameter().getFormId())) {
            if (!"wf_processconfig_scheme".equals(grandParentView.getFormShowParameter().getFormId())) continue;
            openedByScheme = true;
            break;
        }
        for (DynamicObject rowKeyObj : rowKeyobjs) {
            HashMap<String, Object> itemsData = new HashMap<String, Object>();
            HashMap<String, Object> data = new HashMap<String, Object>();
            String id = (String)model.getValue("id", rowIndex);
            data.put("id", WfUtils.isNotEmpty((String)id) ? id : BpmnDiffUtil.getListElementId((String)"decisionOptions"));
            data.put(NUMBER, model.getValue(COLUMN_WORKFLOWNUM, rowIndex));
            data.put("name", model.getValue(DECISIONNAME, rowIndex));
            data.put(DECISIONSCENE, model.getValue(APPROVALSCENE, rowIndex));
            data.put(AUDIT_TYPE, model.getValue(APPROVALTYPE, rowIndex));
            String sdata = (String)model.getValue("selectnodedata", rowIndex);
            if (!WfUtils.isEmpty((String)sdata)) {
                List nodes = (List)SerializationUtils.fromJsonString((String)sdata, List.class);
                ArrayList result = new ArrayList(nodes.size());
                HashMap<String, String> snm = null;
                for (Map map : nodes) {
                    snm = new HashMap<String, String>();
                    snm.put(ITEM_ID, (String)map.get("id"));
                    snm.put("name", (String)map.get("name"));
                    result.add(snm);
                }
                data.put("rejectOptions", result);
            }
            data.put(DEFAULT_DECISION, model.getValue(DEFAULTOPERATION, rowIndex));
            itemsData.put("id", model.getValue(COLUMN_WORKFLOWNUM, rowIndex));
            itemsData.put("name", model.getValue(DECISIONNAME, rowIndex));
            if (((Boolean)model.getValue(DEFAULTOPERATION, rowIndex)).booleanValue()) {
                defaultValMap = data;
            }
            if (indexes.contains(String.valueOf(rowIndex)) && openedByScheme) {
                BpmnDiffUtil.markAsIndependent(data);
            }
            ++rowIndex;
            decData.add(data);
            itemsData = null;
            data = null;
        }
        HashMap<String, List<Map<Object, Object>>> returnData = new HashMap<String, List<Map<Object, Object>>>();
        returnData.put("decisionOptions", decData);
        returnData.put("autoDecision", (List<Map<Object, Object>>)defaultValMap.get(NUMBER));
        returnData.put("autoDecisionWhenMatch", (List<Map<Object, Object>>)defaultValMap.get(NUMBER));
        FormShowParameter params = this.getView().getFormShowParameter();
        Map extendData = (Map)params.getCustomParam("context");
        if (extendData != null && (properties = (Map)extendData.get(NODE_PROPERTIES)) != null) {
            List<Map<String, Object>> variableVal = this.getUpdatedVariables(defaultValMap.get(NUMBER), properties.get("variableGroup.variables"));
            returnData.put("variables", variableVal);
        }
        this.getView().returnDataToParent(returnData);
        this.getPageCache().remove(PREVIOUS_NODES);
        this.getPageCache().remove("extendData");
        this.getView().close();
    }

    private boolean checkYZJDecisionOption(List<DynamicObject> entityList) {
        if (Boolean.parseBoolean(this.getPageCache().get(IS_YZJ))) {
            boolean isYzjOneVoteVeto = Boolean.parseBoolean(this.getPageCache().get(IS_YZJ_ONEVOTEVETO));
            if (isYzjOneVoteVeto) {
                int approvalTypeNum = 0;
                for (int i = 0; i < entityList.size(); ++i) {
                    if (APPROVE.equalsIgnoreCase(entityList.get(i).getString(APPROVALTYPE))) {
                        ++approvalTypeNum;
                    }
                    if (approvalTypeNum <= 1) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u7b2c%s\u884c\u51b3\u7b56\u7c7b\u578b\uff0c\u4f1a\u5ba1\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u591a\u4e2a\u540c\u610f\u7c7b\u578b\u7684\u51b3\u7b56\u9879\u3002", (String)"WorkflowDecisionPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), i + 1));
                    return true;
                }
            } else {
                int approveNum = 0;
                int rejectNum = 0;
                int forceReject = 0;
                int terminateNum = 0;
                for (int i = 0; i < entityList.size(); ++i) {
                    String approvalType = entityList.get(i).getString(APPROVALTYPE);
                    if (APPROVE.equals(approvalType)) {
                        ++approveNum;
                        continue;
                    }
                    if (REJECT.equals(approvalType)) {
                        ++rejectNum;
                        continue;
                    }
                    if ("forceReject".equals(approvalType)) {
                        ++forceReject;
                        continue;
                    }
                    if (!"terminate".equals(approvalType)) continue;
                    ++terminateNum;
                }
                if ("custom".equalsIgnoreCase(this.getPageCache().get("businessmodel"))) {
                    this.logger.debug("\u4f1a\u5ba1\u7684\u4e1a\u52a1\u6a21\u5f0f\u662f\u81ea\u5b9a\u4e49\u6a21\u5f0f\uff0c\u4e0d\u9650\u5236\u51b3\u7b56\u9879\uff0c\u53ef\u65b0\u589e\u591a\u4e2a");
                } else if (approveNum >= 2 || rejectNum >= 2 || forceReject >= 2 || terminateNum >= 2) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u6a21\u5f0f\u4e0b\uff0c\u201c\u540c\u610f\u201d\u3001\u201c\u9a73\u56de\u81f3xx\u8282\u70b9\u201d\u3001\u201c\u7ec8\u6b62xxx\u201d\u3001\u201c\u5f3a\u5236\u9a73\u56de\u201d\u8fd9\u56db\u79cd\u51b3\u7b56\u573a\u666f\uff0c\u4ec5\u5141\u8bb8\u5404\u589e\u52a0\u4e00\u79cd\u3002", (String)"WorkflowDecisionPlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkKeywordResult(List<DynamicObject> entityList) {
        boolean result = false;
        if (entityList == null || entityList.isEmpty()) {
            return true;
        }
        for (int i = 0; i < entityList.size(); ++i) {
            DynamicObject rowDynamicObject = entityList.get(i);
            String number = rowDynamicObject.getString(COLUMN_WORKFLOWNUM);
            if (!Arrays.asList(this.decisionNumberBlackList).contains(number)) continue;
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u7b2c%s\u884c\u7684\u51b3\u7b56\u9879\u7f16\u7801\u3002\u201cstart\u201d\u3001\u201cend\u201d\u4e3a\u5173\u952e\u5b57\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u51b3\u7b56\u9879\u7f16\u7801\u3002", (String)"WorkflowDecisionPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), i + 1));
            return true;
        }
        return result;
    }

    protected Set<String> getIndex() {
        String value = this.getPageCache().get(CHANGED_INDEXES);
        Set<String> indexes = new HashSet<String>();
        if (WfUtils.isNotEmpty((String)value)) {
            indexes = (Set)SerializationUtils.fromJsonString((String)value, Set.class);
        }
        return indexes;
    }

    private List<Map<String, Object>> getUpdatedVariables(Object defDecision, Object variables) {
        if (variables instanceof List) {
            List vars = (List)variables;
            for (Map variable : vars) {
                if (!"auditNumber".equals(variable.get("name")) || !"1".equals(variable.get("isDefault") + "")) continue;
                variable.put("defaultValue", defDecision);
                break;
            }
            return vars;
        }
        return null;
    }

    private void toBeDefault() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        int rowCount = this.getModel().getEntryRowCount(ENTRYKEY);
        if (rowCount > 0) {
            int rowIndex = grid.getEntryState().getFocusRow();
            if (rowIndex > -1) {
                int count = this.getModel().getEntryRowCount(ENTRYKEY);
                for (int j = 0; j < count; ++j) {
                    if (!((Boolean)this.getModel().getValue(DEFAULTOPERATION, j)).booleanValue()) continue;
                    this.getModel().setValue(DEFAULTOPERATION, (Object)Boolean.FALSE, j);
                    break;
                }
                this.getModel().setValue(DEFAULTOPERATION, (Object)Boolean.TRUE, rowIndex);
            } else {
                StandardTips.view((IFormView)this.getView()).notSelectRow();
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u6570\u636e\u3002", (String)"WorkflowDecisionPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void deleteDecisionItem() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        int rowCount = this.getModel().getEntryRowCount(ENTRYKEY);
        if (rowCount > 0) {
            int rowIndex = grid.getEntryState().getFocusRow();
            if (rowIndex < 0) {
                StandardTips.view((IFormView)this.getView()).notSelectRow();
                return;
            }
            Object isDefault = this.getModel().getValue(DEFAULTOPERATION, rowIndex);
            if (Boolean.TRUE.equals(isDefault)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u201c\u9ed8\u8ba4\u51b3\u7b56\u201d\uff0c\u8bf7\u66f4\u6539\u9ed8\u8ba4\u51b3\u7b56\u540e\u518d\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u3002", (String)"WorkflowDecisionPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryRow(ENTRYKEY, rowIndex);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u6570\u636e\u3002", (String)"WorkflowDecisionPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private String getYzjValidationTip(AbstractGrid grid, int rowIndex) {
        Object number = this.getModel().getValue(COLUMN_WORKFLOWNUM, rowIndex);
        if (("Consent".equals(number) || "Reject".equals(number)) && rowIndex < 2) {
            return ResManager.loadKDString((String)"\u8be5\u51b3\u7b56\u9879\u4e0d\u53ef\u5220\u9664\u3002", (String)"WorkflowDecisionPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private void addDecisionItem() {
        Collection optionalNumbers;
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        grid.clearEntryState();
        IDataModel model = this.getModel();
        int index = model.createNewEntryRow(ENTRYKEY);
        String isYzjOneVoteVeto = this.getPageCache().get(IS_YZJ_ONEVOTEVETO);
        if ("true".equals(isYzjOneVoteVeto)) {
            model.setValue(APPROVALTYPE, (Object)REJECT, index);
            model.setValue(APPROVALSCENE, (Object)"rejectToAllAuditNode", index);
        }
        if (!REJECT.equalsIgnoreCase((String)this.getModel().getValue(APPROVALTYPE, index))) {
            this.getModel().setValue(SELECTNODE, null, index);
            FieldEdit fieldEdit = (FieldEdit)this.getControl(SELECTNODE);
            fieldEdit.setEnable(SELECTNODE, false, index);
        }
        if ((optionalNumbers = (Collection)this.getView().getFormShowParameter().getCustomParam("optionalActions")) != null && !optionalNumbers.isEmpty() && !optionalNumbers.contains(APPROVE)) {
            String approvalType = (String)optionalNumbers.iterator().next();
            model.setValue(APPROVALTYPE, (Object)approvalType, index);
        }
        grid.selectRows(index);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter params = this.getView().getFormShowParameter();
        List<FlowElement> nodes = null;
        BpmnModel bpmnModel = null;
        boolean yzjTask = false;
        Map extendData = (Map)params.getCustomParam("context");
        String modelStr = extendData.get("model").toString();
        Map nodeProperties = (Map)extendData.get(NODE_PROPERTIES);
        Object yzjBusinessModel = nodeProperties.get("yzjBusinessModel");
        String stencilType = null;
        try {
            bpmnModel = DesignerModelUtil.getBpmnModel(modelStr);
            String itemId = (String)nodeProperties.get(ITEM_ID);
            String entityId = (String)nodeProperties.get(ENTITY_ID);
            this.getPageCache().put(ENTITY_ID, entityId);
            FlowElement flowElement = bpmnModel.getFlowElement(itemId);
            if (flowElement != null) {
                stencilType = flowElement.getType();
            }
            if (flowElement instanceof YunzhijiaTask) {
                this.getPageCache().put(IS_YZJ, "true");
                this.getPageCache().put("businessmodel", ((YunzhijiaTask)flowElement).getBusinessModel());
                yzjTask = true;
                if ("oneVoteVeto".equals(yzjBusinessModel)) {
                    this.getPageCache().put(IS_YZJ_ONEVOTEVETO, "true");
                }
            }
            HashMap<String, Map> operatMap = new HashMap<String, Map>();
            operatMap.put(NODE_PROPERTIES, nodeProperties);
            this.getPageCache().put("extendData", SerializationUtils.toJsonString(operatMap));
            if (!"wf_nodeconfigview".equals(params.getCustomParam("designer_formId"))) {
                nodes = DesignerModelUtil.getRejectNodes(bpmnModel, itemId);
                nodes = this.filterOptionalNodes(nodes);
            }
            this.getPageCache().put(PREVIOUS_NODES, SerializationUtils.toJsonString(nodes));
        }
        catch (Exception ex) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)ex));
            this.getView().showMessage(ex.getMessage());
        }
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        List<Map<String, Object>> items = (List<Map<String, Object>>)(value instanceof List ? value : new ArrayList());
        boolean isDefaultVal = false;
        if (items == null || items.size() < 1) {
            items = this.getDefaultVal(yzjTask);
            isDefaultVal = true;
        }
        if ("wf_nodeconfigview".equals(params.getCustomParam("designer_formId"))) {
            FieldEdit fieldEdit = (FieldEdit)this.getControl(SELECTNODE);
            fieldEdit.setEntryKey(ENTRYKEY);
            for (int i = 0; i < items.size(); ++i) {
                fieldEdit.setEnable(SELECTNODE, Boolean.FALSE.booleanValue(), i);
            }
        }
        Collection optionalNumbers = (Collection)params.getCustomParam("optionalActions");
        ProcTemplatePluginUtil.filterOptionalDatas(items, optionalNumbers);
        ComboEdit approvalScene = (ComboEdit)this.getControl(APPROVALSCENE);
        HashMap<String, Object> variables = new HashMap<String, Object>(1);
        if (bpmnModel != null && bpmnModel.getMainProcess() != null) {
            variables.put("isSubProcess", bpmnModel.getMainProcess().isSubProcess());
        }
        List<ComboItem> comboItems = ProcTemplatePluginUtil.getDecisionScene(optionalNumbers, stencilType, (String)yzjBusinessModel, nodes, variables);
        this.getPageCache().put("approvalScenefilter", SerializationUtils.toJsonString(comboItems));
        approvalScene.setComboItems(comboItems);
        if (items.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        int[] rowIndexs = model.batchCreateNewEntryRow(ENTRYKEY, items.size());
        int i = 0;
        FieldEdit fieldEdit = (FieldEdit)this.getControl(SELECTNODE);
        fieldEdit.setEntryKey(ENTRYKEY);
        List sceneValue = comboItems.stream().map(ComboItem::getValue).collect(Collectors.toList());
        for (Map<String, Object> item : items) {
            model.setValue("id", item.get("id"), rowIndexs[i]);
            model.setValue(COLUMN_WORKFLOWNUM, item.get(NUMBER), rowIndexs[i]);
            model.setValue(DECISIONNAME, item.get("name"), rowIndexs[i]);
            model.setValue(APPROVALTYPE, item.get(AUDIT_TYPE), rowIndexs[i]);
            if (!sceneValue.contains(item.get(DECISIONSCENE))) {
                model.setValue(APPROVALSCENE, null, rowIndexs[i]);
            } else {
                model.setValue(APPROVALSCENE, item.get(DECISIONSCENE), rowIndexs[i]);
            }
            if ("rejectToEditNode".equals(item.get(DECISIONSCENE)) || "rejectToPreAuditNode".equals(item.get(DECISIONSCENE)) || "rejectToParentProcEditNode".equals(item.get(DECISIONSCENE)) || "rejectToParentProcPreNode".equals(item.get(DECISIONSCENE)) || !REJECT.equals(item.get(AUDIT_TYPE)) && !"forceReject".equals(item.get(AUDIT_TYPE))) {
                fieldEdit.setEnable(SELECTNODE, false, rowIndexs[i]);
            }
            this.complexSetValue(SELECTNODE, this.getRejectOptions(item.get("rejectOptions"), bpmnModel), rowIndexs[i]);
            model.setValue(DEFAULTOPERATION, item.get(DEFAULT_DECISION), rowIndexs[i]);
            ++i;
        }
        if (isDefaultVal && nodes != null && nodes.size() > 1) {
            fieldEdit.setEnable(SELECTNODE, true, 0);
            FlowElement elem = nodes.get(0);
            StringBuilder sb = new StringBuilder("{");
            sb.append(elem.getName()).append('}');
            this.getModel().setValue(SELECTNODE, (Object)sb.toString(), 1);
            HashMap<String, String> saveMap = new HashMap<String, String>();
            saveMap.put("id", elem.getId());
            saveMap.put("name", elem.getName());
            saveMap.put(DOCUMENTATION, elem.getDocumentation());
            ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
            result.add(saveMap);
            this.getModel().setValue("selectnodedata", (Object)SerializationUtils.toJsonString(result), 1);
        }
        if (yzjTask) {
            FieldEdit fe = (FieldEdit)this.getControl(COLUMN_WORKFLOWNUM);
            fe.setEnable("", false, 0);
            fe.setEnable("", false, 1);
            fe = (FieldEdit)this.getControl(APPROVALTYPE);
            int controlCount = 2;
            if ("oneVoteVeto".equals(yzjBusinessModel)) {
                controlCount = 1;
            }
            for (int index = 0; index < controlCount; ++index) {
                fe.setEnable("", false, index);
            }
        }
    }

    private Object getRejectOptions(Object rejectOptions, BpmnModel bpmnModel) {
        if (bpmnModel == null) {
            this.logger.debug("bpmnModel is null, maybe the previous code is wrong!");
            return rejectOptions;
        }
        if (rejectOptions instanceof List) {
            List options = (List)rejectOptions;
            for (Map option : options) {
                String itemId = String.valueOf(option.get(ITEM_ID));
                FlowElement element = bpmnModel.getFlowElement(itemId);
                if (element == null) continue;
                option.put("name", element.getName());
            }
        }
        return rejectOptions;
    }

    public List<Map<String, Object>> getDefaultVal(boolean yzjTask) {
        String rejectOption = ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u5df2\u9009\u8282\u70b9", (String)"WorkflowDecisionPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        if (yzjTask) {
            rejectOption = ResManager.loadKDString((String)"\u4e0d\u540c\u610f", (String)"WorkflowDecisionPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        subMap.put(NUMBER, "Consent");
        subMap.put("name", ResManager.loadKDString((String)"\u540c\u610f", (String)"WorkflowDecisionPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        subMap.put(AUDIT_TYPE, APPROVE);
        subMap.put(APPROVALSCENE, APPROVE);
        subMap.put(DEFAULT_DECISION, Boolean.TRUE);
        list.add(subMap);
        HashMap<String, String> rejMap = new HashMap<String, String>();
        rejMap.put(NUMBER, "Reject");
        rejMap.put("name", rejectOption);
        rejMap.put(AUDIT_TYPE, REJECT);
        rejMap.put(APPROVALSCENE, "rejectToAllAuditNode");
        list.add(rejMap);
        if (yzjTask) {
            HashMap<String, String> forceRejectMap = new HashMap<String, String>();
            forceRejectMap.put(NUMBER, "ForceReject");
            forceRejectMap.put("name", (String)WFMultiLangConstants.getForceRejectName());
            forceRejectMap.put(AUDIT_TYPE, "forceReject");
            forceRejectMap.put(APPROVALSCENE, "forceReject");
            list.add(forceRejectMap);
        }
        return list;
    }

    private BpmnModel getBpmnModel() {
        try {
            FormShowParameter params = this.getView().getFormShowParameter();
            Map extendData = (Map)params.getCustomParam("context");
            if (extendData == null) {
                return null;
            }
            String modelStr = extendData.get("model").toString();
            return DesignerModelUtil.getBpmnModel(modelStr);
        }
        catch (Exception ex) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)ex));
            this.getView().showMessage(ex.getMessage());
            return null;
        }
    }

    private void setSelectNode(String approvalScene, int rowKey) {
        List nodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PREVIOUS_NODES), List.class);
        if (nodes != null && nodes.size() > 0) {
            Map<String, String> dataMap = new HashMap();
            HashMap saveMap = new HashMap();
            StringBuilder sb = new StringBuilder();
            if (approvalScene.equals("rejectToEditNode")) {
                BpmnModel bpmnModel = this.getBpmnModel();
                if (bpmnModel != null) {
                    UserTask userTask = BpmnModelUtil.getFirstUserTask((Process)bpmnModel.getMainProcess());
                    dataMap.put("id", userTask.getId());
                    dataMap.put("name", userTask.getName());
                }
            } else if (approvalScene.equals("rejectToAllAuditNode")) {
                dataMap = (Map)nodes.get(0);
            }
            sb.append("{");
            sb.append((String)dataMap.get("name")).append('}');
            this.getModel().setValue(SELECTNODE, (Object)sb.toString(), rowKey);
            saveMap.put("id", dataMap.get("id"));
            saveMap.put("name", dataMap.get("name"));
            saveMap.put(DOCUMENTATION, dataMap.get(DOCUMENTATION));
            ArrayList result = new ArrayList();
            result.add(saveMap);
            this.getModel().setValue(SELECTNODE, (Object)sb.toString(), rowKey);
            this.getModel().setValue("selectnodedata", (Object)SerializationUtils.toJsonString(result), rowKey);
        }
    }

    private void complexSetValue(String cloumnName, Object obj, int index) {
        IDataModel model = this.getModel();
        if (!StringUtils.isBlank((Object)obj)) {
            if (SELECTNODE.equals(cloumnName)) {
                List list = (List)obj;
                ArrayList result = new ArrayList(list.size());
                HashMap item = null;
                StringBuilder sb = new StringBuilder("{");
                for (Map snm : list) {
                    item = new HashMap();
                    item.put("id", snm.get(ITEM_ID));
                    item.put("name", snm.get("name"));
                    item.put(DOCUMENTATION, snm.get(DOCUMENTATION));
                    result.add(item);
                    sb.append(snm.get("name")).append(',');
                }
                String nodeNames = sb.substring(0, sb.length() - 1) + "}";
                String string = nodeNames = "{".equals(nodeNames) ? null : nodeNames;
                if ("}".equalsIgnoreCase(nodeNames)) {
                    model.setValue(cloumnName, null, index);
                } else {
                    model.setValue(cloumnName, (Object)nodeNames, index);
                }
                model.setValue(cloumnName + "data", (Object)SerializationUtils.toJsonString(result), index);
            } else {
                IPropertyConverter converter = AliasConverterFactory.create("wf_formoperation");
                HashMap<String, String> context = new HashMap<String, String>();
                context.put(ENTITY_ID, this.getPageCache().get(ENTITY_ID));
                converter.setContext(context, null);
                model.setValue(cloumnName, converter.convert(obj), index);
                model.setValue(cloumnName + "data", obj, index);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int focusRow = this.getEntryEntityFocusRow(ENTRYKEY);
        if (focusRow > -1) {
            String workflownum;
            String number = (String)this.getModel().getValue(COLUMN_WORKFLOWNUM, focusRow);
            String string = workflownum = WfUtils.isNotEmpty((String)number) ? number.trim() : "";
            if (number != null && !number.equals(workflownum)) {
                this.getModel().setValue(COLUMN_WORKFLOWNUM, (Object)workflownum, focusRow);
            }
        }
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        int rowKey = grid.getEntryState().getFocusRow();
        FieldEdit fieldEdit = (FieldEdit)this.getControl(SELECTNODE);
        fieldEdit.setEntryKey(ENTRYKEY);
        String propertyName = e.getProperty().getName();
        if (APPROVALSCENE.equalsIgnoreCase(propertyName)) {
            String approvalScene = (String)this.getModel().getValue(APPROVALSCENE);
            if (approvalScene.equals("rejectToEditNode")) {
                this.setSelectNode("rejectToEditNode", rowKey);
                this.getModel().setValue(APPROVALTYPE, (Object)REJECT, focusRow);
                fieldEdit.setEnable(SELECTNODE, false, rowKey);
            } else if (approvalScene.equals("rejectToAllAuditNode")) {
                this.setSelectNode("rejectToAllAuditNode", rowKey);
                this.getModel().setValue(APPROVALTYPE, (Object)REJECT, focusRow);
                fieldEdit.setEnable(SELECTNODE, true, rowKey);
            } else if (approvalScene.equals("rejectToPreAuditNode")) {
                this.getModel().setValue(APPROVALTYPE, (Object)REJECT, focusRow);
                fieldEdit.setEnable(SELECTNODE, false, rowKey);
                this.getModel().setValue(SELECTNODE, null, rowKey);
                this.getModel().setValue("selectnodedata", null, rowKey);
            } else if ("forceReject".equals(approvalScene)) {
                fieldEdit.setEnable(SELECTNODE, true, rowKey);
                this.getModel().setValue(APPROVALTYPE, (Object)"forceReject", focusRow);
            } else if ("rejectToParentProcEditNode".equals(approvalScene) || "rejectToParentProcPreNode".equals(approvalScene)) {
                this.getModel().setValue(APPROVALTYPE, (Object)REJECT, focusRow);
                fieldEdit.setEnable(SELECTNODE, false, rowKey);
                this.getModel().setValue(SELECTNODE, null, rowKey);
                this.getModel().setValue("selectnodedata", null, rowKey);
            } else {
                if ("terminate".equals(approvalScene) || "terminateMainProcess".equals(approvalScene)) {
                    this.getModel().setValue(APPROVALTYPE, (Object)"terminate", focusRow);
                } else {
                    this.getModel().setValue(APPROVALTYPE, (Object)APPROVE, focusRow);
                }
                fieldEdit.setEnable(SELECTNODE, false, rowKey);
                this.getModel().setValue(SELECTNODE, null, rowKey);
                this.getModel().setValue("selectnodedata", null, rowKey);
            }
        }
    }

    private int getEntryEntityFocusRow(String entryEntityName) {
        EntryGrid grid = (EntryGrid)this.getControl(entryEntityName);
        return grid.getEntryState().getFocusRow();
    }

    public List<FlowElement> filterOptionalNodes(List<FlowElement> nodesWithoutFilter) {
        ArrayList<FlowElement> filterNodes = new ArrayList<FlowElement>(nodesWithoutFilter.size());
        for (FlowElement node : nodesWithoutFilter) {
            if (node instanceof StartEvent || node instanceof EndEvent || node instanceof NotifyTask) continue;
            filterNodes.add(node);
        }
        return filterNodes;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(IS_YZJ_ONEVOTEVETO);
        this.getPageCache().remove(CHANGED_INDEXES);
    }
}

