/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.bpmn.graph.model.GraphItem;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowDesignerPlugin;
import kd.bos.workflow.design.plugin.event.BeforeAddNodeToDigramEvent;
import kd.bos.workflow.design.plugin.event.BeforeSaveDigramEvent;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.plugin.validate.IValidateResult;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.design.proctpl.plugin.WorkflowSaveAsProcTemplatePlugin;
import kd.bos.workflow.design.util.BizFlowPluginUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.generate.DiffElem;
import kd.bos.workflow.engine.impl.persistence.entity.design.DesignerEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeToolBoxEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeToolBoxEntityConstants;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.engine.repository.Model;
import kd.bos.workflow.gpt.GaiInitConfig;
import kd.bos.workflow.validation.ValidationError;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;
import org.apache.commons.beanutils.MethodUtils;

public class WorkflowDesignerIDEPlugin
extends AbstractWorkflowDesignerPlugin
implements IValidateResult {
    private static final String KEY_WFDESIGNER = "wfdesigner";
    protected static final String STYLE_CENTER = "center";
    private static final String BTN_SAVE = "save";
    protected static final String BTN_PUBLISH = "publish";
    private static final String BTN_SETUP = "processsetup";
    protected static final String BTN_CHECK = "checkbtn";
    protected static final String BTN_AUTOTEST = "autotest";
    private static final String BTN_EXPORTIMAGE = "exportimage";
    private static final String BTN_SAVEASTEMPLATE = "saveastemplate";
    public static final String ITEM_SAVE = "item_save";
    public static final String ITEM_CHECKBTN = "item_checkbtn";
    public static final String ITEM_PUBLISH = "item_publish";
    public static final String ITEM_AUTOTEST = "item_autotest";
    private static final String HIDDENVECTOR = "hiddenvector";
    private static final String SHOWVECTOR = "showvector";
    private static final String PANEL_SIDEBAR = "flexpanelap3";
    private static final String SAVED_MODEL_ID = "savedModelId";
    private static final String ACTIONID_PUBLISH = "modelPublishCallBack";
    private static final String KEY_OPENED_PAGE_ID = "opened_page_id";
    private static final String KEY_LAST_ADDNODETIME = "lasttime";
    public static final String SAVEPERMISSION = "0=KX5+QVF5+R";
    private static final String KEY_CATEGORY = "%s_%s_category";
    private static final String NUMBER_CATEGORY = "%s_category";
    private static final String CATEGORYNUMBER = "categoryNumber";
    private static final String FLEXPANEL = "flexpanel";
    private static final String FOLD = "fold";
    private static final String FOLDUNDERLINE = "fold_";
    private static final String LABEL = "label";
    private static final String NUMBER = "number";
    private static final String UNFOLD = "unfold";
    private static final String UNFOLDUNDERLINE = "unfold_";
    private static final String NODETEMPLATE = "nodetemplate";
    private static final String REFRESHICON = "refreshicon";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE, BTN_PUBLISH, "rightpanel", BTN_SETUP, BTN_CHECK, BTN_AUTOTEST, HIDDENVECTOR, SHOWVECTOR, REFRESHICON});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        String source = (String)parameter.getCustomParam("source");
        if (WfUtils.isNotEmpty((String)source) && "gpt".equalsIgnoreCase(source)) {
            parameter.setCustomParam("model_type", (Object)"WorkflowModel");
            String id = (String)parameter.getCustomParam("id");
            String entityNumber = (String)parameter.getCustomParam("entityNumber");
            if (WfUtils.isEmpty((String)id) && WfUtils.isNotEmpty((String)entityNumber)) {
                Long t = this.getRepositoryService().createEmptyModel(entityNumber);
                id = t == null ? "1716752139562276864" : String.valueOf(t);
            }
            parameter.setCustomParam("id", (Object)id);
            parameter.setClientParam("modelId", (Object)id);
            this.logger.debug(String.format("modelId:%s", id));
        }
    }

    protected void initDynamicPanels() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String modelType = (String)showParameter.getCustomParam("model_type");
        List<StencilConfig> configs = this.getDomainModelStencils(modelType);
        HashSet<String> types = new HashSet<String>(16);
        JSONArray confPanels = new JSONArray();
        JSONArray stencils = new JSONArray();
        this.initStencils(stencils, confPanels, configs, types);
        HashMap<String, JSONArray> sidebarDatas = new HashMap<String, JSONArray>();
        sidebarDatas.put("items", stencils);
        this.getView().updateControlMetadata(PANEL_SIDEBAR, sidebarDatas);
        this.addOtherConfigPanel(confPanels, types);
        HashMap<String, JSONArray> datas = new HashMap<String, JSONArray>();
        datas.put("items", confPanels);
        this.getView().updateControlMetadata("rightpanel", datas);
        HashSet<String> panelIds = new HashSet<String>(types.size());
        for (String type : types) {
            panelIds.add(this.getConfigurePanelId(type));
        }
        this.getView().setVisible(Boolean.FALSE, panelIds.toArray(new String[0]));
        this.getPageCache().put("allType", SerializationUtils.toJsonString(types));
    }

    protected List<StencilConfig> getDomainModelStencils(String modelType) {
        return DesignerModelUtil.getStencilConfigs(modelType, true);
    }

    protected DesignerEntity getDesignerEntity() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("id");
        String fields = String.format("%s,%s,%s,%s", "bpmnxmlid", "entrabillid", "entrabill", "key");
        return (DesignerEntity)this.getRepositoryService().findEntityById(Long.valueOf(modelId), "wf_model", fields);
    }

    protected void initStencils(JSONArray stencils, JSONArray confPanels, List<StencilConfig> configs, Set<String> types) {
        List<Long> nodeTemplateIds = this.getNodeTemplateIdsForToolBox();
        List<NodeTemplateEntity> nodeTemplateEntitys = this.getNodeTemplateEntitys(nodeTemplateIds);
        Map<String, NodeTemplateEntity> toolNodeTemplateMap = this.getToolNodeTemplateMap(nodeTemplateEntitys);
        Map<String, StencilConfig> stencilMap = this.getStencilMap(configs, nodeTemplateEntitys);
        LinkedHashMap<String, List<StencilConfig>> groupStencilMap = new LinkedHashMap<String, List<StencilConfig>>();
        LinkedHashMap<String, DynamicObject> groupMap = new LinkedHashMap<String, DynamicObject>();
        this.initGroupingInformation(stencilMap, toolNodeTemplateMap, groupStencilMap, groupMap);
        ArrayList<String> categoryNumbers = new ArrayList<String>();
        this.addStencilsJsonObject(stencils, confPanels, types, groupStencilMap, groupMap, categoryNumbers);
        this.getPageCache().put(CATEGORYNUMBER, SerializationUtils.toJsonString(categoryNumbers));
    }

    private List<NodeTemplateEntity> getNodeTemplateEntitys(List<Long> nodeTemplateIds) {
        QFilter nodeTemplateFilter1 = new QFilter("id", "in", nodeTemplateIds);
        QFilter nodeTemplateFilter2 = new QFilter("enable", "=", (Object)"1");
        QFilter[] nodeTemplateFilters = new QFilter[]{nodeTemplateFilter1, nodeTemplateFilter2};
        List nodeTemplateEntitys = this.getRepositoryService().findEntitiesByFilters("wf_nodetemplate", nodeTemplateFilters);
        HashMap<Long, NodeTemplateEntity> nodeTemplateEntitysMap = new HashMap<Long, NodeTemplateEntity>(nodeTemplateEntitys.size());
        for (NodeTemplateEntity nodeTemplateEntity : nodeTemplateEntitys) {
            nodeTemplateEntitysMap.put(nodeTemplateEntity.getId(), nodeTemplateEntity);
        }
        ArrayList<NodeTemplateEntity> orderedNodeTemplateEntitys = new ArrayList<NodeTemplateEntity>(nodeTemplateIds.size());
        for (Long nodeTemplateId : nodeTemplateIds) {
            orderedNodeTemplateEntitys.add((NodeTemplateEntity)nodeTemplateEntitysMap.get(nodeTemplateId));
        }
        return orderedNodeTemplateEntitys;
    }

    private Map<String, StencilConfig> getStencilMap(List<StencilConfig> configs, List<NodeTemplateEntity> nodeTemplateEntitys) {
        HashMap<String, StencilConfig> stencilConfigMap = new HashMap<String, StencilConfig>(nodeTemplateEntitys.size());
        for (StencilConfig config : configs) {
            stencilConfigMap.put(config.getId(), config);
        }
        for (NodeTemplateEntity nodeTemplateEntity : nodeTemplateEntitys) {
            StencilConfig config = (StencilConfig)stencilConfigMap.get(nodeTemplateEntity.getStencilType());
            if (config == null) {
                this.log.debug(String.format("The config of %s is null.", nodeTemplateEntity.getStencilType()));
                continue;
            }
            StencilConfig clone = config.clone();
            clone.setId(nodeTemplateEntity.getNumber());
            clone.setStencilName(nodeTemplateEntity.getName());
            clone.setTemplate(nodeTemplateEntity.getStencilType());
            clone.setVisible(true);
            stencilConfigMap.put(nodeTemplateEntity.getNumber(), clone);
        }
        LinkedHashMap<String, StencilConfig> stencilMap = new LinkedHashMap<String, StencilConfig>(stencilConfigMap.size());
        for (NodeTemplateEntity nodeTemplateEntity : nodeTemplateEntitys) {
            stencilMap.put(nodeTemplateEntity.getNumber(), (StencilConfig)stencilConfigMap.get(nodeTemplateEntity.getNumber()));
        }
        return stencilMap;
    }

    private void addStencilsJsonObject(JSONArray stencils, JSONArray confPanels, Set<String> types, Map<String, List<StencilConfig>> groupInfoMap, Map<String, DynamicObject> categoryMap, List<String> categoryNumbers) {
        Set<Map.Entry<String, List<StencilConfig>>> groupInfoEntrySet = groupInfoMap.entrySet();
        for (Map.Entry<String, List<StencilConfig>> groupInfo : groupInfoEntrySet) {
            DynamicObject category = categoryMap.get(groupInfo.getKey());
            if (categoryNumbers.isEmpty()) {
                this.getPageCache().put("fistCategory", category.getString(NUMBER));
            }
            categoryNumbers.add(category.getString(NUMBER));
            JSONArray items = new JSONArray();
            this.initStencils(groupInfo.getKey(), items, confPanels, types, groupInfo.getValue());
            if (items.isEmpty()) continue;
            JSONObject wholePanel = this.getWholePanel(category.getString(NUMBER));
            JSONObject categoryPanel = this.getCategoryNodeJSON(category);
            categoryPanel.put("items", (Object)items);
            JSONArray array = new JSONArray();
            array.add((Object)this.getCategoryLable(category));
            array.add((Object)this.getFoldIconJson(category, FOLD, "kdfont kdfont-bottom"));
            array.add((Object)this.getFoldIconJson(category, UNFOLD, "kdfont kdfont-top"));
            array.add((Object)categoryPanel);
            wholePanel.put("items", (Object)array);
            stencils.add((Object)wholePanel);
        }
    }

    private void initGroupingInformation(Map<String, StencilConfig> stencilMap, Map<String, NodeTemplateEntity> toolNodeTemplateMap, Map<String, List<StencilConfig>> groupInfoMap, Map<String, DynamicObject> groupMap) {
        Set<Map.Entry<String, StencilConfig>> entrySet = stencilMap.entrySet();
        for (Map.Entry<String, StencilConfig> entry : entrySet) {
            String key = entry.getKey();
            NodeTemplateEntity nodeTemplate = toolNodeTemplateMap.get(key);
            if (nodeTemplate == null) {
                this.logger.debug(String.format("nodeTemplate is null. %s", key));
                continue;
            }
            DynamicObject group = nodeTemplate.getGroup();
            String groupNumber = group.getString(NUMBER);
            List<StencilConfig> groupIdStencilConfig = groupInfoMap.get(groupNumber);
            if (groupIdStencilConfig == null) {
                groupIdStencilConfig = new ArrayList<StencilConfig>();
                groupIdStencilConfig.add(entry.getValue());
                groupInfoMap.put(groupNumber, groupIdStencilConfig);
                groupMap.put(groupNumber, group);
                continue;
            }
            groupIdStencilConfig.add(entry.getValue());
        }
    }

    private Map<String, NodeTemplateEntity> getToolNodeTemplateMap(List<NodeTemplateEntity> nodeTemplateEntitys) {
        LinkedHashMap<String, NodeTemplateEntity> toolNodeTemplateMap = new LinkedHashMap<String, NodeTemplateEntity>();
        if (!nodeTemplateEntitys.isEmpty()) {
            for (NodeTemplateEntity entity : nodeTemplateEntitys) {
                if (entity == null) continue;
                toolNodeTemplateMap.put(entity.getNumber(), entity);
            }
        }
        return toolNodeTemplateMap;
    }

    private List<Long> getNodeTemplateIdsForToolBox() {
        NodeToolBoxEntity nodeToolBoxEntity;
        RepositoryService repositoryService = this.getRepositoryService();
        ArrayList<Long> nodeTemplateIds = new ArrayList<Long>();
        List customNodeTemplates = new ArrayList();
        DesignerEntity model = this.getDesignerEntity();
        AppInfo appInfo = null;
        if (model != null && WfUtils.isNotEmpty((String)model.getEntityId())) {
            String appId = MetadataDao.getAppIdByFormId((String)model.getEntityId());
            this.log.debug(String.format("appId is %s", appId));
            appInfo = AppMetadataCache.getAppInfo((String)appId);
        }
        if (appInfo != null) {
            QFilter filter = new QFilter("cloudid", "=", (Object)appInfo.getCloudId()).and(new QFilter("stenciltype", "=", (Object)"HRActivity"));
            QFilter templateFilter = this.getNodeTemplateFilter(model);
            QFilter[] filters = new QFilter[]{templateFilter != null ? templateFilter : filter};
            customNodeTemplates = repositoryService.findEntitiesByFilters("wf_nodetemplate", filters);
        } else {
            this.log.debug("AppInfo is null.");
        }
        if (customNodeTemplates != null && !customNodeTemplates.isEmpty()) {
            for (NodeTemplateEntity nodeTemplate : customNodeTemplates) {
                if (nodeTemplate == null) continue;
                nodeTemplateIds.add(nodeTemplate.getId());
            }
        }
        if ((nodeToolBoxEntity = (NodeToolBoxEntity)repositoryService.findEntityById(NodeToolBoxEntityConstants.DEFAULTID, "wf_nodetoolbox")) == null) {
            return nodeTemplateIds;
        }
        DynamicObjectCollection nodeTemplateEntrys = nodeToolBoxEntity.getNodeTemplateEntry();
        for (DynamicObject nodeTemplateEntry : nodeTemplateEntrys) {
            DynamicObject nodeTemplate = nodeTemplateEntry.getDynamicObject(NODETEMPLATE);
            if (nodeTemplate == null || nodeTemplateIds.contains(nodeTemplate.getLong("id"))) continue;
            nodeTemplateIds.add(nodeTemplate.getLong("id"));
        }
        if (model == null) {
            return nodeTemplateIds;
        }
        this.log.debug(String.format("WorkflowDesignerIDEPlugin:getNodeTemplateIdsForToolBox nodeTemplateIds is :%S", Arrays.toString(nodeTemplateIds.toArray())));
        String number = model.getEntityNumber();
        QFilter filter1 = new QFilter("id", "in", nodeTemplateIds);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        QFilter filter3 = new QFilter("entityid", "=", (Object)number).or(new QFilter("entityid", "is null", null)).or(new QFilter("entityid", "=", (Object)""));
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        List nodeTemplates = this.getRepositoryService().findEntitiesByFilters("wf_nodetemplate", filters);
        HashMap<Long, Long> orderNodeTemplates = new HashMap<Long, Long>(nodeTemplates.size());
        for (NodeTemplateEntity nodeTemplateEntity : nodeTemplates) {
            Long id = nodeTemplateEntity.getId();
            orderNodeTemplates.put(id, id);
        }
        ArrayList<Long> enableNodeTemplateIds = new ArrayList<Long>(nodeTemplates.size());
        for (Long id : nodeTemplateIds) {
            Long nodeTemplateId = (Long)orderNodeTemplates.get(id);
            if (!WfUtils.isNotEmpty((Long)nodeTemplateId)) continue;
            enableNodeTemplateIds.add(nodeTemplateId);
        }
        return enableNodeTemplateIds;
    }

    private JSONObject getFoldIconJson(DynamicObject category, String key, String fontClass) {
        String number = category.getString(NUMBER);
        JSONObject foldIcon = new JSONObject();
        foldIcon.put("showStyle", (Object)0);
        foldIcon.put("clickable", (Object)Boolean.TRUE);
        foldIcon.put("type", (Object)"vector");
        foldIcon.put("text-align", (Object)STYLE_CENTER);
        foldIcon.put("fontClass", (Object)fontClass);
        foldIcon.put("fs", (Object)"16px");
        foldIcon.put("id", (Object)String.format(KEY_CATEGORY, key, number));
        JSONObject style = new JSONObject();
        JSONObject margin = new JSONObject();
        margin.put("b", (Object)"0px");
        margin.put("t", (Object)"16px");
        margin.put("l", (Object)"4px");
        margin.put("r", (Object)"0px");
        style.put("m", (Object)margin);
        foldIcon.put("s", (Object)style);
        JSONObject width = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)width, "15%");
        foldIcon.put("w", (Object)width);
        foldIcon.put("fc", (Object)"#B2B2B2");
        return foldIcon;
    }

    private JSONObject getWholePanel(String number) {
        JSONObject categoryPanel = new JSONObject();
        categoryPanel.put("id", (Object)String.format("group_%s", number));
        categoryPanel.put("type", (Object)FLEXPANEL);
        categoryPanel.put("wr", (Object)Boolean.TRUE);
        categoryPanel.put("gr", (Object)"1");
        categoryPanel.put("dr", (Object)"row");
        JSONObject width = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)width, "100%");
        categoryPanel.put("w", (Object)width);
        return categoryPanel;
    }

    private JSONObject getCategoryLable(DynamicObject category) {
        JSONObject categoryLable = new JSONObject();
        JSONObject style = new JSONObject();
        JSONObject margin = new JSONObject();
        margin.put("b", (Object)"0px");
        margin.put("t", (Object)"12px");
        margin.put("l", (Object)"12px");
        margin.put("r", (Object)"0px");
        style.put("m", (Object)margin);
        categoryLable.put("s", (Object)style);
        categoryLable.put("showStyle", (Object)0);
        categoryLable.put("clickable", (Object)Boolean.TRUE);
        categoryLable.put("type", (Object)LABEL);
        categoryLable.put("fs", (Object)"14px");
        categoryLable.put("fw", (Object)"bold");
        categoryLable.put("gr", (Object)"0");
        categoryLable.put("sk", (Object)"1");
        String number = category.getString(NUMBER);
        categoryLable.put("id", (Object)String.format(KEY_CATEGORY, LABEL, number));
        JSONObject caption = new JSONObject();
        ILocaleString name = category.getLocaleString("name");
        for (Lang lang : WfUtils.getSupportLangs()) {
            caption.put(lang.toString(), WfUtils.isEmpty((String)((String)name.get((Object)lang.toString()))) ? name.toString() : name.get((Object)lang.toString()));
        }
        categoryLable.put("caption", (Object)caption);
        categoryLable.put("cstyles", (Object)"eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cblxuJCB7XG5tYXgtd2lkdGggOiAxMDBweDtcbsKgfVxuIFxuIn0=");
        return categoryLable;
    }

    private JSONObject getCategoryNodeJSON(DynamicObject category) {
        JSONObject categoryNodePanel = new JSONObject();
        categoryNodePanel.put("type", (Object)FLEXPANEL);
        String number = category.getString(NUMBER);
        categoryNodePanel.put("id", (Object)String.format(NUMBER_CATEGORY, number));
        JSONObject text = new JSONObject();
        JSONObject height = new JSONObject();
        JSONObject width = new JSONObject();
        ILocaleString name = category.getLocaleString("name");
        for (Lang lang : WfUtils.getSupportLangs()) {
            text.put(lang.toString(), WfUtils.isEmpty((String)((String)name.get((Object)lang.toString()))) ? name.toString() : name.get((Object)lang.toString()));
            width.put(lang.toString(), (Object)"100%");
        }
        categoryNodePanel.put("text", (Object)text);
        categoryNodePanel.put("h", (Object)height);
        categoryNodePanel.put("w", (Object)width);
        JSONObject style = new JSONObject();
        JSONObject padding = new JSONObject();
        padding.put("l", (Object)"5px");
        padding.put("r", (Object)"0px");
        padding.put("b", (Object)"15px");
        style.put("p", (Object)padding);
        JSONObject border = new JSONObject();
        border.put("b", (Object)"1px_solid_#e5e5e5");
        style.put("b", (Object)border);
        categoryNodePanel.put("s", (Object)style);
        categoryNodePanel.put("wr", (Object)Boolean.TRUE);
        categoryNodePanel.put("gr", (Object)"1");
        categoryNodePanel.put("dr", (Object)"row");
        categoryNodePanel.put("bc", (Object)"#FFFFFF");
        return categoryNodePanel;
    }

    protected QFilter getNodeTemplateFilter(DesignerEntity designerEntity) {
        QFilter filter = null;
        String clazz = "kd.bos.ext.hr.wf.plugin.ActivityWFDesignerExtendPlugin";
        String method = "getActivityIds";
        Object plugin = null;
        try {
            plugin = TypesContainer.createInstance((String)clazz);
        }
        catch (Exception e) {
            this.log.info(e.getMessage());
        }
        try {
            Object result;
            if (plugin == null) {
                this.log.debug(String.format("%s not found.", clazz));
                return filter;
            }
            GraphModel graphModel = this.getGraphModel();
            JSONObject properties = null;
            if (graphModel != null) {
                properties = graphModel.getCellProperties("node_1");
            } else {
                String json = this.getRepositoryService().getResourceById(designerEntity.getResourceId()).getData();
                JSONObject data = JSON.parseObject((String)json);
                properties = data.getJSONObject("properties");
            }
            String value = "";
            List variables = (List)BpmnModelUtil.getProperty((Map)properties, (String)String.format("%s.%s", "variableGroup", "variables"));
            if (variables != null && !variables.isEmpty()) {
                for (Map variable : variables) {
                    if (!"hr_scheme".equals(variable.get("name"))) continue;
                    value = variable.get("defaultvalue");
                    break;
                }
            }
            if ((result = MethodUtils.invokeMethod((Object)plugin, (String)method, (Object)value)) instanceof Collection) {
                filter = new QFilter("bizidentification", "in", result);
            }
        }
        catch (InvocationTargetException e) {
            this.log.error(String.format("Invoke %s's %s Error! %s", clazz, method, WfUtils.getExceptionStacktrace((Throwable)e)));
            if (e.getTargetException() instanceof KDBizException) {
                this.getView().showTipNotification(e.getTargetException().getMessage());
                filter = new QFilter("1", "!=", (Object)1);
            }
        }
        catch (Exception e) {
            this.log.error(String.format("Invoke %s's %s Error! %s", clazz, method, WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return filter;
    }

    protected void initStencils(String groupKey, JSONArray stencils, JSONArray confPanels, Set<String> types, List<StencilConfig> configs) {
        if (configs == null || configs.isEmpty()) {
            return;
        }
        JSONArray nodes = new JSONArray();
        for (int i = 0; i < configs.size(); ++i) {
            StencilConfig stencilConfig;
            if (i % 2 == 0) {
                nodes = new JSONArray();
                String panelId = String.format("pairpanel_%s_%s", groupKey, i);
                JSONObject pairPanel = this.createStencilPairPanel(panelId);
                pairPanel.put("items", (Object)nodes);
                stencils.add((Object)pairPanel);
            }
            if ((stencilConfig = configs.get(i)) == null) continue;
            this.initStencil(nodes, confPanels, types, stencilConfig);
        }
    }

    protected JSONObject createStencilPairPanel(String panelId) {
        JSONObject pairPanel = new JSONObject();
        pairPanel.put("id", (Object)panelId);
        pairPanel.put("type", (Object)FLEXPANEL);
        pairPanel.put("gr", (Object)"1");
        pairPanel.put("dr", (Object)"row");
        pairPanel.put("ai", (Object)"stretch");
        JSONObject width = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)width, "100%");
        pairPanel.put("w", (Object)width);
        return pairPanel;
    }

    private void initStencil(JSONArray stencils, JSONArray confPanels, Set<String> types, StencilConfig config) {
        if (config.isVisible()) {
            this.log.debug("IDE Sidebar add stencil: " + config.getId());
            stencils.add((Object)this.getStencilJSON(config.getId(), config.getStencilName(), config.getImage()));
            if (confPanels != null) {
                confPanels.add((Object)this.getConfigureFlexJSON(config.getId()));
            }
            types.add(config.getId());
        }
    }

    protected void addOtherConfigPanel(JSONArray confPanels, Set<String> types) {
        confPanels.add((Object)this.getConfigureFlexJSON("SequenceFlow"));
        types.add("SequenceFlow");
        confPanels.add((Object)this.getConfigureFlexJSON("SSCImageUpload"));
        types.add("SSCImageUpload");
        confPanels.add((Object)this.getConfigureFlexJSON("Diagram"));
        types.add("Diagram");
    }

    protected JSONObject getStencilJSON(String type, String name, String imgPath) {
        JSONObject stencil = new JSONObject();
        JSONObject style = new JSONObject();
        JSONObject margin = new JSONObject();
        margin.put("b", (Object)"0px");
        margin.put("t", (Object)"12px");
        margin.put("l", (Object)"5%");
        margin.put("r", (Object)"0px");
        JSONObject padding = new JSONObject();
        padding.put("b", (Object)"0px");
        padding.put("t", (Object)"12px");
        padding.put("l", (Object)"0px");
        padding.put("r", (Object)"0px");
        JSONObject border = new JSONObject();
        border.put("c", (Object)"#EDF4F8");
        style.put("p", (Object)padding);
        style.put("m", (Object)margin);
        style.put("b", (Object)border);
        stencil.put("s", (Object)style);
        stencil.put("ai", (Object)STYLE_CENTER);
        stencil.put("id", (Object)type);
        JSONObject text = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)text, name);
        stencil.put("text", (Object)text);
        stencil.put("wr", (Object)Boolean.TRUE);
        stencil.put("type", (Object)FLEXPANEL);
        stencil.put("items", (Object)this.getStencilItems(type, name, imgPath));
        stencil.put("dr", (Object)"column");
        stencil.put("bc", (Object)"#F4F8FC");
        JSONObject width = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)width, "40%");
        stencil.put("w", (Object)width);
        stencil.put("wr", (Object)"unset");
        this.log.debug(String.format("getStencilJSON: %s %s", type, name));
        return stencil;
    }

    protected JSONArray getStencilItems(String type, String name, String imgPath) {
        JSONArray items = new JSONArray();
        JSONObject image = new JSONObject();
        image.put("showStyle", (Object)0);
        JSONObject width = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)width, "20px");
        image.put("w", (Object)width);
        image.put("imageKey", (Object)imgPath);
        image.put("clickable", (Object)Boolean.TRUE);
        JSONObject height = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)height, "20px");
        image.put("h", (Object)height);
        image.put("id", (Object)DesignerModelUtil.getStencilImageKey(type));
        JSONObject text = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)text, String.format(ResManager.loadKDString((String)"%s\u8282\u70b9", (String)"WorkflowDesignerIDEPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), name));
        image.put("text", (Object)text);
        image.put("type", (Object)"image");
        JSONObject label = new JSONObject();
        label.put("showStyle", (Object)0);
        JSONObject caption = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)caption, name);
        label.put("caption", (Object)caption);
        label.put("id", (Object)DesignerModelUtil.getStencilLabelKey(type));
        label.put("text", (Object)caption);
        label.put("fs", (Object)"12px");
        label.put("type", (Object)LABEL);
        label.put("text-align", (Object)STYLE_CENTER);
        label.put("gr", (Object)"0");
        label.put("sk", (Object)"0");
        JSONObject lableWidth = new JSONObject();
        this.setLocaleProperties((Map<String, Object>)lableWidth, "50px");
        label.put("w", (Object)lableWidth);
        label.put("atw", (Object)"true");
        JSONObject style = new JSONObject();
        JSONObject padding = new JSONObject();
        padding.put("t", (Object)"8px");
        padding.put("b", (Object)"8px");
        style.put("p", (Object)padding);
        label.put("s", (Object)style);
        items.add((Object)image);
        items.add((Object)label);
        return items;
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (key.startsWith(UNFOLDUNDERLINE)) {
            String value = key.replace(UNFOLDUNDERLINE, "");
            String incon = FOLDUNDERLINE + value;
            this.getView().setVisible(Boolean.TRUE, new String[]{incon});
            this.getView().setVisible(Boolean.FALSE, new String[]{value, key});
            return;
        }
        if (key.startsWith(FOLDUNDERLINE)) {
            String value = key.replace(FOLDUNDERLINE, "");
            String incon = UNFOLDUNDERLINE + value;
            this.getView().setVisible(Boolean.FALSE, new String[]{key});
            this.getView().setVisible(Boolean.TRUE, new String[]{value, incon});
            return;
        }
        if (key.startsWith(LABEL)) {
            return;
        }
        switch (key) {
            case "save": {
                this.save(true);
                break;
            }
            case "publish": {
                this.publish();
                break;
            }
            case "processsetup": {
                this.showProcessConfigure();
                break;
            }
            case "checkbtn": {
                this.check();
                break;
            }
            case "autotest": {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_model", (String)"1//JGEENPGO0")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u6a21\u62df\u6d4b\u8bd5\u201d\u6743\u9650\u3002", (String)"WorkflowDesignerIDEPlugin_24", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (null == this.save(false)) break;
                this.publishOrUpdateModel();
                break;
            }
            case "hiddenvector": {
                this.getView().setVisible(Boolean.FALSE, new String[]{HIDDENVECTOR, "flexpanelap1"});
                this.getView().setVisible(Boolean.TRUE, new String[]{SHOWVECTOR});
                break;
            }
            case "showvector": {
                this.getView().setVisible(Boolean.TRUE, new String[]{HIDDENVECTOR, "flexpanelap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{SHOWVECTOR});
                break;
            }
            case "refreshicon": {
                this.refreshStencilsPanel();
                break;
            }
            default: {
                key = key.replaceFirst("image|label", "");
                this.addNodeToDiagram(key);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "exportimage": {
                this.exportImage();
                break;
            }
            case "saveastemplate": {
                this.saveAsTemplate();
                break;
            }
            case "item_save": {
                this.save(true);
                break;
            }
            case "item_publish": {
                this.publish();
                break;
            }
            case "item_checkbtn": {
                this.check();
                break;
            }
            case "item_autotest": {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_model", (String)"1//JGEENPGO0")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u6a21\u62df\u6d4b\u8bd5\u201d\u6743\u9650\u3002", (String)"WorkflowDesignerIDEPlugin_24", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (null == this.save(false)) break;
                this.publishOrUpdateModel();
                break;
            }
            case "gtpdemo": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("wfgptdemo");
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("pageId", (Object)this.getView().getPageId());
                String modelId = (String)this.getView().getFormShowParameter().getCustomParam("id");
                if (WfUtils.isNotEmpty((String)modelId)) {
                    parameter.setCustomParam("currentModelId", (Object)modelId);
                }
                this.getView().showForm(parameter);
                break;
            }
            default: {
                super.itemClick(evt);
            }
        }
    }

    private void saveAsTemplate() {
        if (!this.hasPermission("2WFFI0/LTYLT")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5b58\u4e3a\u6a21\u677f\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowDesignerIDEPlugin_31", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        Long modelId = Long.valueOf(id);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_proctemplate");
        parameter.addCustPlugin(WorkflowSaveAsProcTemplatePlugin.class.getCanonicalName());
        parameter.setCaption(ResManager.loadKDString((String)"\u5b58\u4e3a\u6a21\u677f", (String)"WorkflowDesignerIDEPlugin_32", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam("modelId", (Object)modelId);
        this.getView().showForm(parameter);
    }

    public void refreshStencilsPanel() {
        JSONArray stencils = new JSONArray();
        HashSet<String> newTypes = new HashSet<String>();
        this.initStencils(stencils, null, this.getDomainModelStencils(this.modelType), newTypes);
        HashMap<String, JSONArray> sidebarDatas = new HashMap<String, JSONArray>();
        sidebarDatas.put("items", stencils);
        this.getView().updateControlMetadata(PANEL_SIDEBAR, sidebarDatas);
        this.addNodeConfigurePanelIfNecessary(newTypes);
        String categoryNumberStr = this.getPageCache().get(CATEGORYNUMBER);
        if (WfUtils.isNotEmpty((String)categoryNumberStr)) {
            List categoryNumbers = SerializationUtils.fromJsonStringToList((String)categoryNumberStr, String.class);
            String fistCategory = this.getPageCache().get("fistCategory");
            for (String categoryNumber : categoryNumbers) {
                if (WfUtils.isNotEmpty((String)fistCategory) && fistCategory.equals(categoryNumber)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{String.format(NUMBER_CATEGORY, categoryNumber), String.format(KEY_CATEGORY, UNFOLD, categoryNumber)});
                    this.getView().setVisible(Boolean.FALSE, new String[]{String.format(KEY_CATEGORY, FOLD, categoryNumber)});
                    continue;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{String.format(NUMBER_CATEGORY, categoryNumber), String.format(KEY_CATEGORY, UNFOLD, categoryNumber)});
                this.getView().setVisible(Boolean.TRUE, new String[]{String.format(KEY_CATEGORY, FOLD, categoryNumber)});
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.endsWith("image")) {
            Image image = new Image();
            image.setKey(key);
            image.setView(this.getView());
            image.addClickListener((ClickListener)this);
            e.setControl((Control)image);
        } else if (key.endsWith(LABEL) || key.startsWith(LABEL)) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            e.setControl((Control)label);
        } else if (key.startsWith(UNFOLD) || key.startsWith(FOLD)) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.addClickListener((ClickListener)this);
            e.setControl((Control)vector);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (Exception e2) {
            this.log.debug(String.format("getEntityType has error;error infomation is: %s", WfUtils.getExceptionStacktrace((Throwable)e2)));
            newMainType = null;
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        if (newMainType == null) {
            return;
        }
        String categoryNumberStr = this.getPageCache().get(CATEGORYNUMBER);
        if (WfUtils.isEmpty((String)categoryNumberStr)) {
            return;
        }
        List categoryNumbers = SerializationUtils.fromJsonStringToList((String)categoryNumberStr, String.class);
        for (String categoryNumber : categoryNumbers) {
            FieldProp fieldProp = new FieldProp();
            fieldProp.setName(String.format(NUMBER_CATEGORY, categoryNumber));
            fieldProp.setDbIgnore(true);
            fieldProp.setAlias("");
            newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
            FieldProp fieldProp1 = new FieldProp();
            fieldProp1.setName(String.format(KEY_CATEGORY, FOLD, categoryNumber));
            fieldProp1.setDbIgnore(true);
            fieldProp1.setAlias("");
            newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp1);
            FieldProp fieldProp2 = new FieldProp();
            fieldProp2.setName(String.format(KEY_CATEGORY, UNFOLD, categoryNumber));
            fieldProp2.setDbIgnore(true);
            fieldProp2.setAlias("");
            newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp2);
        }
    }

    protected DesignerEntity save(boolean showNotification) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_model", (String)SAVEPERMISSION)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fdd\u5b58\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowDesignerIDEPlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return null;
        }
        ModelEntity model = null;
        try {
            model = this.saveModel(false);
            if (model != null) {
                this.getPageCache().put(SAVED_MODEL_ID, String.valueOf(model.getId()));
            }
            if (model != null && showNotification) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WorkflowDesignerIDEPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                this.fireAfterSaveDigram(model.getKey(), model.getVersion(), KEY_WFDESIGNER);
            }
            this.showBlock(false, this.getView());
        }
        catch (Exception e) {
            String error = WfUtils.getExceptionStacktrace((Throwable)e);
            this.getView().showErrMessage(e.getMessage(), String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDesignerIDEPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), error));
        }
        return model;
    }

    public void updateNodeSequence(GraphModel graphModel) {
        GraphCell startCell = null;
        List children = graphModel.getRootCell().getChildShapes();
        for (GraphCell cell : children) {
            if (!"StartSignalEvent".equals(cell.getStencil().getId())) continue;
            startCell = cell;
            break;
        }
        GraphCell endCell = null;
        for (int i = children.size() - 1; i >= 0; --i) {
            GraphCell cell = (GraphCell)children.get(i);
            if (!"EndNoneEvent".equals(cell.getStencil().getId())) continue;
            endCell = cell;
            break;
        }
        if (endCell != null) {
            ProcTemplatePluginUtil.setSequenceProperty(endCell.getProperties(), 999);
        }
        if (startCell != null) {
            HashMap<String, Integer> seqMap = new HashMap<String, Integer>(children.size());
            ProcTemplatePluginUtil.setSequenceProperty(startCell.getProperties(), 0);
            LinkedList<GraphCellWraper> queue = new LinkedList<GraphCellWraper>();
            queue.offer(new GraphCellWraper(0, startCell));
            while (!queue.isEmpty()) {
                GraphCellWraper wrapper = (GraphCellWraper)queue.poll();
                int index = wrapper.getIndex() + 1;
                List outgoings = wrapper.getCell().getOutgoing();
                for (GraphItem item : outgoings) {
                    if (WfUtils.isEmpty((String)item.getResourceId())) continue;
                    GraphCell next = graphModel.getGraphCell(item.getResourceId());
                    String nextResId = next.getResourceId();
                    Integer seq = (Integer)seqMap.get(nextResId);
                    if (seq != null) {
                        if (index <= seq) continue;
                        seqMap.put(nextResId, index);
                        this.updateSequenceProperty(next, index);
                        continue;
                    }
                    seqMap.put(nextResId, index);
                    if ("SequenceFlow".equals(next.getStencil().getId())) {
                        queue.offer(new GraphCellWraper(wrapper.getIndex(), next));
                        continue;
                    }
                    this.updateSequenceProperty(next, index);
                    queue.offer(new GraphCellWraper(index, next));
                }
            }
        }
    }

    private void updateSequenceProperty(GraphCell next, int index) {
        String stencilType = next.getStencil().getId();
        if ("StartSignalEvent".equals(stencilType) || "EndNoneEvent".equals(stencilType)) {
            return;
        }
        Map props = next.getProperties();
        Integer sequence = (Integer)ProcTemplatePluginUtil.getControlIntensityProperty(props, "sequence");
        if (sequence == null || sequence == 0) {
            ProcTemplatePluginUtil.setSequenceProperty(props, index);
        }
    }

    private boolean fireBeforeSaveDigram() {
        GraphModel graphModel = this.getGraphModel();
        try {
            if (graphModel != null && graphModel.getRootCell() != null) {
                BeforeSaveDigramEvent evt = new BeforeSaveDigramEvent(this.getView(), KEY_WFDESIGNER, "beforeSaveDigram", null, graphModel.getRootCell().getChildShapes());
                this.fireCutomeEvent(evt);
                return !evt.isCancel();
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return false;
        }
        return true;
    }

    protected void publish() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_model", (String)"/8M0INTY9FDA")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u53d1\u5e03\u6743\u9650\u3002", (String)"WorkflowDesignerIDEPlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ModelEntity model = null;
        boolean flag = true;
        try {
            model = this.saveModel(true);
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002 ", (String)"WorkflowDesignerIDEPlugin_35", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            flag = false;
        }
        if (model != null && flag) {
            if (model.getKey().matches("^\\d+.+")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6d41\u7a0b\u7f16\u7801\u201d\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\u3002", (String)"WorkflowDesignerIDEPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (model.isDiscard()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u5e9f\u5f03\uff0c\u8bf7\u201c\u6062\u590d\u6d41\u7a0b\u201d\u540e\u518d\u53d1\u5e03\u3002", (String)"WorkflowDesignerIDEPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else {
                GraphModel graphModel;
                if (WfConfigurationUtil.isMustStartupCondition() && !this.hasStartupCondition(graphModel = this.getGraphModel())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u201c\u542f\u52a8\u6761\u4ef6\u201d\u540e\u53d1\u5e03\u3002", (String)"WorkflowDesignerIDEPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", model.getId());
                map.put("name", model.getName());
                map.put("businessid", model.getBusinessId());
                map.put(NUMBER, model.getKey());
                map.put("version", model.getVersion());
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("wf_modeldeploymentconfirm");
                parameter.setCustomParam("message", map);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONID_PUBLISH));
                this.getView().showForm(parameter);
            }
        }
    }

    private boolean hasStartupCondition(GraphModel graphModel) {
        Object processType = graphModel.getRootCellProperty("processType");
        if (ModelType.BizFlow.name().equals(processType)) {
            List eventStartItems;
            boolean hasEvtStartCondition;
            boolean hasStartCondition;
            List startItems = (List)graphModel.getRootCellProperty("startItems");
            boolean bl = hasStartCondition = startItems != null && !startItems.isEmpty();
            if (hasStartCondition) {
                for (Map item : startItems) {
                    Boolean allowStart = (Boolean)item.get("allowstart");
                    Object condition = item.get("condition");
                    if (!Boolean.TRUE.equals(allowStart) || !this.isConditionEmpty(condition)) continue;
                    return false;
                }
            }
            boolean bl2 = hasEvtStartCondition = (eventStartItems = (List)graphModel.getRootCellProperty("evtStartItems")) != null && !eventStartItems.isEmpty();
            if (hasEvtStartCondition) {
                for (Map item : eventStartItems) {
                    String eventNumber = (String)item.get("eventNumber");
                    Object condition = item.get("condition");
                    if (!WfUtils.isNotEmpty((String)eventNumber) || !this.isConditionEmpty(condition)) continue;
                    return false;
                }
            }
            return true;
        }
        return graphModel.getRootCellProperty("startupcondrule") != null;
    }

    private boolean isConditionEmpty(Object condition) {
        if (condition instanceof String) {
            return WfUtils.isEmpty((String)((String)condition));
        }
        return condition == null;
    }

    private void publishOrUpdateModel() {
        String modelId = this.getPageCache().get(SAVED_MODEL_ID);
        if (modelId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u9875\u9762\u3002", (String)"WorkflowDesignerIDEPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            IFormView openedView;
            HashMap<String, Object> content = new HashMap<String, Object>();
            content.put("graph_json", this.getGraphModel().getBpmnModelJson());
            List<ValidationError> result = this.validateBpmnModel(content);
            if (null != result && !result.isEmpty() && ValidatorUtil.hasErrorInfo(result)) {
                DesignerModelUtil.showProcessValidateInfo(this, result);
                return;
            }
            String openedPageId = this.getPageCache().get(KEY_OPENED_PAGE_ID);
            if (null != openedPageId && (openedView = this.getView().getView(openedPageId)) != null) {
                openedView.activate();
                this.getView().sendFormAction(openedView);
                return;
            }
            IFormView parentView = DesignerModelUtil.getTabControlView(this.getView());
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("modelId", (Object)modelId);
            parameter.setCustomParam("sp", (Object)"workflowDesinger");
            parameter.setFormId("wf_testinginput");
            if (parentView != null) {
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.EDIT);
                parentView.showForm(parameter);
                this.getView().sendFormAction(parentView);
            } else {
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
            }
            this.getPageCache().put(KEY_OPENED_PAGE_ID, parameter.getPageId());
        }
        catch (Exception e) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u51fa\u9519\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a%s\u3002", (String)"WorkflowDesignerIDEPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void check() {
        if (!this.checkVerificationPermission()) {
            return;
        }
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("graph_json", this.getGraphModel().getBpmnModelJson());
        try {
            List<ValidationError> result = this.validateBpmnModel(content);
            DesignerModelUtil.showProcessValidateInfo(this, result);
            this.fireAfterCheckDigram(result, KEY_WFDESIGNER);
        }
        catch (Exception e) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u51fa\u9519\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a%s\u3002", (String)"WorkflowDesignerIDEPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        this.showBlock(false, this.getView());
    }

    protected boolean checkVerificationPermission() {
        if (PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_model", (String)"47150e89000000ac")) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u6821\u9a8c\u201d\u6743\u9650\u3002", (String)"WorkflowDesignerIDEPlugin_22", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        return false;
    }

    private void addNodeToDiagram(String key) {
        long time = WfUtils.now().getTime();
        boolean ret = this.validateFrequency(time);
        if (!ret) {
            return;
        }
        StencilConfig config = DesignerModelUtil.getStencilConfig(this.modelType, key);
        if (config == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6dfb\u52a0\u5931\u8d25\uff0c\u627e\u4e0d\u5230 %s \u7684\u8282\u70b9\u914d\u7f6e\u3002", (String)"WorkflowDesignerIDEPlugin_26", (String)"bos-wf-formplugin", (Object[])new Object[0]), key));
            return;
        }
        String template = config.getTemplate();
        String tip = this.validateWhenAddNode(key, template);
        if (WfUtils.isNotEmpty((String)tip)) {
            this.getView().showTipNotification(tip, Integer.valueOf(3000));
            return;
        }
        this.getPageCache().put(KEY_LAST_ADDNODETIME, String.valueOf(time));
        String stencilType = key;
        String nodeTemplate = null;
        if (WfUtils.isNotEmpty((String)config.getTemplate())) {
            nodeTemplate = key;
            stencilType = config.getTemplate();
            HashSet<String> newTypes = new HashSet<String>();
            newTypes.add(stencilType);
            this.addNodeConfigurePanelIfNecessary(newTypes);
        }
        String style = this.getDefaultNodeStyle(key);
        HashMap<String, String> nodeInfo = new HashMap<String, String>();
        nodeInfo.put("name", config.getStencilName());
        nodeInfo.put("style", style);
        BeforeAddNodeToDigramEvent evt = new BeforeAddNodeToDigramEvent(this.getView(), KEY_WFDESIGNER, "beforeAddNode", null, nodeInfo);
        this.fireCutomeEvent(evt);
        String name = evt.getName() == null ? config.getStencilName() : evt.getName();
        this.getDesigner().addNodeToDiagram(config.getBaseType(), stencilType, nodeTemplate, name, style, config.isContainer());
    }

    private boolean validateFrequency(long time) {
        if (WfUtils.isSyncRun()) {
            return true;
        }
        try {
            String lasttime = this.getPageCache().get(KEY_LAST_ADDNODETIME);
            if (lasttime == null) {
                this.getPageCache().put(KEY_LAST_ADDNODETIME, String.valueOf(time));
            } else if (time - Long.parseLong(lasttime) < 1000L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WorkflowDesignerIDEPlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return true;
    }

    protected String getDefaultNodeStyle(String stencilType) {
        if ("Lane".equals(stencilType)) {
            return "html=1;horizontal=0;swimlaneFillColor=white;swimlaneLine=0;strokeColor=#BBBBBB;strokeWidth=1;align=center;";
        }
        if ("Pool".equals(stencilType)) {
            return "html=1;horizontal=0;startSize=20;strokeColor=#BBBBBB;strokeWidth=1;align=center;fillColor=#FFF;";
        }
        return "whiteSpace=wrap;spacingLeft=50;spacingRight=10;overflow=hidden;";
    }

    @Override
    public void afterRemoveCells(List<GraphCell> cells) {
        super.afterRemoveCells(cells);
        if (cells != null && !cells.isEmpty()) {
            for (GraphCell cell : cells) {
                this.removePageIdCache(cell.getStencil().getId());
            }
        }
    }

    private void removePageIdCache(String type) {
        String data = this.getPageCache().get(type);
        if (WfUtils.isNotEmpty((String)data)) {
            String pageId = data.split(String.valueOf(';'))[0];
            IFormView view = this.getView().getView(pageId);
            if (view != null) {
                view.close();
            }
            this.getPageCache().remove(type);
        }
    }

    protected String validateWhenAddNode(String key, String template) {
        if ("Pool".equals(key)) {
            GraphModel graphModel = this.getGraphModel();
            List children = graphModel.getRootCell().getChildShapes();
            for (GraphCell child : children) {
                if (!"Pool".equals(child.getStencil().getId())) continue;
                return ResManager.loadKDString((String)"\u201c\u753b\u5e03\u201d\u4e2d\u53ea\u80fd\u6dfb\u52a0\u4e00\u4e2a\u201c\u6c60\u201d\u3002", (String)"WorkflowDesignerIDEPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
        } else {
            if ("BoundaryErrorEvent".equals(key) || "BoundaryErrorEvent".equals(template)) {
                GraphModel graphModel = this.getGraphModel();
                String tip = this.getBoundaryValidate();
                if (WfUtils.isNotEmpty((String)tip)) {
                    return tip;
                }
                String parentType = this.getSelectionCellType();
                if (BpmnModelUtil.instanceofUserTask((String)parentType) || "AutoTask".equals(parentType)) {
                    return null;
                }
                if (graphModel != null && "BizFlowModel".equals(graphModel.getModeType())) {
                    return ResManager.loadKDString((String)"\u201c\u5f02\u5e38\u5206\u652f\u201d\u53ea\u80fd\u6dfb\u52a0\u5230\u4eba\u5de5\u3001\u5355\u636e\u3001\u81ea\u52a8\u8282\u70b9\u4e0a\u3002", (String)"WorkflowDesignerIDEPlugin_20", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                }
                return ResManager.loadKDString((String)"\u201c\u5f02\u5e38\u5206\u652f\u201d\u53ea\u80fd\u6dfb\u52a0\u5230\u4eba\u5de5\u3001\u5ba1\u6279\u3001\u4f1a\u5ba1\u3001\u5f71\u50cf\u4e0a\u4f20\u3001\u5171\u4eab\u5ba1\u6279\u3001\u81ea\u52a8\u8282\u70b9\u4e0a\u3002", (String)"WorkflowDesignerIDEPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            if ("BoundaryCompensateEvent".equals(key)) {
                String tip = this.getBoundaryValidate();
                if (WfUtils.isNotEmpty((String)tip)) {
                    return tip;
                }
                String parentType = this.getSelectionCellType();
                if (BpmnModelUtil.instanceofUserTask((String)parentType) || "AutoTask".equals(parentType) || "CallActivity".equals(parentType)) {
                    return null;
                }
                return ResManager.loadKDString((String)"\u201c\u8865\u507f\u5206\u652f\u201d\u53ea\u80fd\u6dfb\u52a0\u5230\u4eba\u5de5\u3001\u5355\u636e\u3001\u5b50\u6d41\u7a0b\u3001\u81ea\u52a8\u8282\u70b9\u4e0a\u3002", (String)"WorkflowDesignerIDEPlugin_27", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public String getBoundaryValidate() {
        List cells = this.getGraphModel().getRootCell().getChildShapes();
        for (GraphCell cell : cells) {
            String stencilType = cell.getStencil().getId();
            if (!"BoundaryCompensateEvent".equals(stencilType) && !"BoundaryErrorEvent".equals(stencilType) || !this.selectionCellId.equals(cell.getProperties().get("attachedToRefId"))) continue;
            return ResManager.loadKDString((String)"\u6bcf\u4e2a\u8282\u70b9\u53ea\u80fd\u5b9a\u4e49\u4e00\u4e2a\u201c\u5f02\u5e38\u5206\u652f\u201d\u8282\u70b9\u6216\u201c\u8865\u507f\u4e8b\u4ef6\u201d\u8282\u70b9\u3002", (String)"WorkflowDesignerIDEPlugin_28", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{SHOWVECTOR});
        try {
            this.initDynamicPanels();
        }
        catch (Exception exception) {
            this.log.error(String.format("Init dynamic panels failed, the exception: {%s}", WfUtils.getExceptionStacktrace((Throwable)exception)));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5de6\u4fa7\u8282\u70b9\u83dc\u5355\u9762\u677f\u6216\u8282\u70b9\u5c5e\u6027\u914d\u7f6e\u9762\u677f\u521d\u59cb\u5316\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDesignerIDEPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]), exception.getMessage()));
        }
        String categoryNumberStr = this.getPageCache().get(CATEGORYNUMBER);
        if (WfUtils.isNotEmpty((String)categoryNumberStr)) {
            List categoryNumbers = SerializationUtils.fromJsonStringToList((String)categoryNumberStr, String.class);
            String fistCategory = this.getPageCache().get("fistCategory");
            for (String categoryNumber : categoryNumbers) {
                if (WfUtils.isNotEmpty((String)fistCategory) && fistCategory.equals(categoryNumber)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{String.format(NUMBER_CATEGORY, categoryNumber), String.format(KEY_CATEGORY, UNFOLD, categoryNumber)});
                    this.getView().setVisible(Boolean.FALSE, new String[]{String.format(KEY_CATEGORY, FOLD, categoryNumber)});
                    continue;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{String.format(NUMBER_CATEGORY, categoryNumber), String.format(KEY_CATEGORY, UNFOLD, categoryNumber)});
                this.getView().setVisible(Boolean.TRUE, new String[]{String.format(KEY_CATEGORY, FOLD, categoryNumber)});
            }
        }
        if (Lang.zh_CN != Lang.get() && !WfConfigurationUtil.isEnableOtherLang().booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_PUBLISH});
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        boolean permFlag = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)this.getPermissionAppId(), (String)"wf_model", (String)"1//JGEENPGO0");
        if (!BizFlowPluginUtil.isBizFlow(this.modelType) && !WfConfigurationUtil.isProdEnvironment() && WfConfigurationUtil.canUseAutoTesting() && permFlag) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_AUTOTEST, ITEM_AUTOTEST});
        }
        this.initNetMutualExclusion();
        String formId = this.getView().getFormShowParameter().getFormId();
        if ((Lang.zh_CN == Lang.get() || WfConfigurationUtil.isEnableOtherLang().booleanValue()) && ("ide_workflowdesigner".equals(formId) || "ide_bizflowdesigner".equals(formId))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_SAVEASTEMPLATE});
        }
        this.initGpt();
    }

    private void initGpt() {
        String src = (String)this.getView().getFormShowParameter().getCustomParam("source");
        if (!"gpt".equalsIgnoreCase(src)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"rightpanel"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"rightpanel"});
        this.shrinkConfigurePanel(this.getView());
        try {
            IFormView iFormView = this.getView().getMainView();
            if (iFormView == null) {
                iFormView = this.getView().getParentView();
            }
            this.logger.debug(String.format("initGpt:formid[%s]", ((FormView)iFormView).getFormId()));
            String rootPageId = iFormView.getPageId();
            GaiInitConfig gaiInitConfig = new GaiInitConfig();
            gaiInitConfig.setSwitchSide(true);
            gaiInitConfig.setLockSide(true);
            String sql = "select fid from t_gai_process where fnumber = 'bos_createworkflow';";
            String id = null;
            try (DataSet ds = DB.queryDataSet((String)"wf.engine.querySchemeJsonIdBySchemeId", (DBRoute)DBRoute.of((String)"aidb"), (String)sql, (Object[])new Object[0]);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    id = row.getString("fid");
                }
            }
            if (WfUtils.isNotEmpty(id)) {
                gaiInitConfig.setSelectedProcessId(id);
            }
            this.logger.debug(String.format("id[%s]", id));
            TimeUnit.SECONDS.sleep(2L);
            DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"sideBarInit", (Object[])new Object[]{rootPageId, JSON.toJSONString((Object)gaiInitConfig)});
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private void initNetMutualExclusion() {
        if (!WfConfigurationUtil.isNetMutuallyExclusiveOpened()) {
            return;
        }
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("id");
        if (modelId == null) {
            this.log.debug("id is null.");
            return;
        }
        StringBuilder failInfo = new StringBuilder();
        boolean isAllowed = MutexHelper.require((IFormView)this.getView(), (String)"wf_model", (Object)modelId, (String)"donothing", (boolean)false, (StringBuilder)failInfo);
        if (!isAllowed) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_PUBLISH});
            this.getView().showTipNotification(failInfo.toString());
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("MUTEX_ENTITY_KEY", "wf_model");
        params.put("MUTEX_OPER_KEY", "donothing");
        params.put("MUTEX_OBJ_ID", modelId);
        this.getPageCache().put(params);
    }

    @Override
    public Map<String, Object> getDesignerInitData(Map<String, Object> params) {
        Object id = params.get("modelId");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (id != null) {
            RepositoryService service = this.getRepositoryService();
            Long modelId = Long.valueOf((String)id);
            ModelEntity model = (ModelEntity)service.getModel(modelId);
            this.initEntityNumber(model.getEntityNumber());
            if (model.getBPMNXMLID() != null) {
                ResourceEntity resource = service.getResourceById(model.getBPMNXMLID());
                String lang = RequestContext.get().getLang().toString();
                String modelJson = ExtractMultiLanguageWordsUtil.getMultiLanguageResourceData((ResourceEntity)resource, (String)lang);
                String graphXml = this.getInitGraphXml(modelId, null, null, modelJson, null);
                result.put("graph_xml", graphXml);
                result.put("flowType", model.getType());
                List diffElements = (List)params.get("diffElements");
                if (diffElements == null || diffElements.isEmpty()) {
                    result.put("animation", false);
                } else {
                    result.put("animation", this.transferAnimationFormat(diffElements));
                }
                result.put("updateProcInstId", true);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u8ba1\u5668\u52a0\u8f7d\u5931\u8d25\uff0c\u8be5\u6a21\u578b\u7f3a\u5c11\u5bf9\u5e94\u7684\u8d44\u6e90\u3002", (String)"WorkflowDesignerIDEPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        } else if (params.get("graphXmlKey") != null) {
            result.putAll((Map)params.get("graphXmlKey"));
        }
        return result;
    }

    private Object transferAnimationFormat(List<DiffElem> diffElements) {
        if (diffElements == null || diffElements.isEmpty()) {
            return false;
        }
        HashMap t = new HashMap();
        for (DiffElem diffElem : diffElements) {
            t.putIfAbsent(diffElem.getLevel(), new ArrayList());
            ((List)t.get(diffElem.getLevel())).add(diffElem.getKey());
        }
        ArrayList seq = new ArrayList(t.keySet());
        Collections.sort(seq);
        ArrayList ret = new ArrayList(seq.size());
        for (Integer s : seq) {
            ret.add(t.get(s));
        }
        return ret;
    }

    private void initEntityNumber(String entityNumber) {
        if (WfUtils.isEmpty((String)entityNumber)) {
            return;
        }
        String t = this.getPageCache().get("entityNumber");
        if (WfUtils.isEmpty((String)t)) {
            this.getPageCache().put("entityNumber", entityNumber);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    private ModelEntity saveModel(boolean isPublish) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String modelId = (String)showParameter.getCustomParam("id");
        if (modelId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u9875\u9762\u3002", (String)"WorkflowDesignerIDEPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return null;
        }
        boolean canSave = this.fireBeforeSaveDigram();
        if (!canSave) {
            return null;
        }
        RepositoryService service = this.getRepositoryService();
        ModelEntity model = (ModelEntity)service.getModel(Long.valueOf(modelId));
        if (model == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6d41\u7a0b\u5df2\u88ab\u5220\u9664\u3002", (String)"WorkflowDesignerIDEPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return null;
        }
        HashMap<String, String> content = new HashMap<String, String>();
        GraphModel graphModel = this.getGraphModel();
        String result = this.validatePoolAndLane(graphModel);
        if (result != null) {
            this.getView().showTipNotification(result);
            return null;
        }
        this.updateGeometry(graphModel);
        if (WfUtils.isNotEmpty((Long)model.getTemplateId())) {
            this.updateNodeSequence(graphModel);
            this.cacheModelJson();
        }
        content.put("graph_json", graphModel.getBpmnModelJson());
        Map<String, Object> properties = graphModel.getCellProperties("node_1");
        Object orgUnitId = properties.get("orgUnitId");
        if (!this.canDoOperation(Long.valueOf(orgUnitId.toString()))) {
            this.getView().showErrorNotification(WFMultiLangConstants.getNotAdminForOperation());
            return null;
        }
        this.updateProcessProperties(model, properties);
        service.saveModel((Model)model, content);
        this.clearDataChanged();
        return model;
    }

    private String validatePoolAndLane(GraphModel graphModel) {
        GraphCell root = graphModel.getRootCell();
        List cells = root.getChildShapes();
        String poolId = null;
        boolean hasPool = false;
        boolean hasLaneNotInPool = false;
        boolean hasNodesNotInPool = false;
        for (GraphCell cell : cells) {
            if ("Pool".equals(cell.getStencil().getId())) {
                hasPool = true;
                poolId = cell.getResourceId();
                continue;
            }
            if ("Lane".equals(cell.getStencil().getId())) {
                hasLaneNotInPool = true;
                continue;
            }
            hasNodesNotInPool = true;
        }
        if (hasPool) {
            if (hasLaneNotInPool) {
                return ResManager.loadKDString((String)"\u6cf3\u9053\u9700\u8981\u6dfb\u52a0\u5230\u6c60\u4e2d\u3002", (String)"WorkflowDesignerIDEPlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            if (hasNodesNotInPool) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u6d41\u7a0b\u4e2d\u6709\u201c\u6c60\u201d\uff0c\u8282\u70b9\u9700\u8981\u6dfb\u52a0\u5230\u6c60\u7684\u201c\u6cf3\u9053\u201d\u4e2d\u3002", (String)"WorkflowDesignerIDEPlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            GraphCell pool = graphModel.getGraphCell(poolId);
            if (pool.getChildShapes().isEmpty()) {
                return ResManager.loadKDString((String)"\u6c60\u4e2d\u81f3\u5c11\u9700\u8981\u6dfb\u52a0\u4e00\u4e2a\u6cf3\u9053\u3002", (String)"WorkflowDesignerIDEPlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
        } else if (hasLaneNotInPool) {
            return ResManager.loadKDString((String)"\u6cf3\u9053\u9700\u8981\u6dfb\u52a0\u5230\u6c60\u4e2d\u3002", (String)"WorkflowDesignerIDEPlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private void updateProcessProperties(ModelEntity model, Map<String, Object> properties) {
        Object name = properties.get("name");
        Object businessId = properties.get("businessId");
        Object description = properties.get("documentation");
        Object entraBill = properties.get("entraBill");
        Object entraBillId = properties.get("entraBillId");
        Object orgUnitId = properties.get("orgUnitId");
        String applicationId = "";
        if (name != null) {
            model.setName(name.toString());
        }
        if (businessId != null) {
            model.setBusinessId(businessId.toString());
        }
        if (description != null) {
            model.setDescription(description.toString());
        }
        if (entraBill != null) {
            model.setEntraBill(entraBill.toString());
        }
        if (entraBillId != null) {
            model.setEntraBillId(entraBillId.toString());
            applicationId = WfUtils.getApplicationIdByBillId((String)entraBillId.toString());
        }
        if (orgUnitId != null) {
            model.setOrgUnitId(Long.valueOf(orgUnitId.toString()));
        }
        if (!WfUtils.isEmpty((String)applicationId)) {
            model.setApplicationId(applicationId);
        }
    }

    public void updateGeometry(GraphModel graphModel) {
        Map<String, Object> data = this.getDesigner().getContent();
        String graphJson = (String)data.get("graph_json");
        GraphCell graphRoot = (GraphCell)SerializationUtils.fromJsonString((String)graphJson, GraphCell.class);
        graphModel.updateGraphGeometry(graphRoot);
    }

    private List<ValidationError> validateBpmnModel(Map<String, Object> content) {
        String graphJson = (String)content.get("graph_json");
        BpmnModel bpmnModel = null;
        try {
            bpmnModel = DesignerModelUtil.getBpmnModel(graphJson);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        List result = this.getRepositoryService().validateProcesses(bpmnModel, null);
        return result;
    }

    private boolean hasPermission(String permItem) {
        String appId = "a479ec06000000ac";
        if ("bpm".equalsIgnoreCase(this.getView().getFormShowParameter().getAppId())) {
            appId = "194JD185SVFC";
        }
        return PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)appId, (String)"wf_model", (String)permItem);
    }

    protected void exportImage() {
        if (!this.hasPermission("2V75SNJBBCG9")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5bfc\u51fa\u56fe\u7247\u7684\u6743\u9650\u3002", (String)"WorkflowDesignerIDEPlugin_36", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        DesignerEntity designerEntity = this.getDesignerEntity();
        this.getDesigner().exportImage(this.getView(), designerEntity.getNumber());
    }

    @Override
    public void afterDeleteCells(List<GraphCell> cells, List<GraphCell> selectedCells) {
        if (selectedCells.size() != cells.size()) {
            if (cells.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u9009\u8282\u70b9\u6216\u7ebf\u4e0d\u80fd\u5220\u9664\u3002", (String)"WorkflowDesignerIDEPlugin_33", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u9009\u8282\u70b9\u6216\u7ebf\u4e0d\u80fd\u5220\u9664\uff0c\u90e8\u5206\u5220\u9664\u5931\u8d25\u3002", (String)"WorkflowDesignerIDEPlugin_34", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected String getDesignerFormId() {
        return "ide_workflowdesigner";
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (null != returnData && ACTIONID_PUBLISH.equals(actionId)) {
            List validateResults;
            Map param = (Map)returnData;
            Object strResults = param.get("validateResults");
            if (WfUtils.isNotEmptyString(strResults)) {
                validateResults = SerializationUtils.fromJsonStringToList((String)strResults.toString(), ValidationError.class);
                DesignerModelUtil.showProcessValidateInfo(this, validateResults);
            } else {
                validateResults = null;
            }
            String status = (String)param.get("status");
            if ("S".equals(status)) {
                Long deploymentId = (Long)param.get("deploymentId");
                if (WfUtils.isNotEmpty((Long)deploymentId)) {
                    QFilter[] filters = new QFilter[]{new QFilter("deploymentid", "=", (Object)deploymentId)};
                    Long count = this.getRepositoryService().getEntityCountByFilter("wf_processdefinition", filters);
                    if (count < 1L) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\uff0c\u672a\u751f\u6210\u6d41\u7a0b\u5b9a\u4e49\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WorkflowDesignerIDEPlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"WorkflowDesignerIDEPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                this.fireAfterPublishDigram(param, KEY_WFDESIGNER);
            } else if ("E+".equals(status)) {
                this.getView().showErrorNotification(this.spliceErrorNotification(validateResults));
            } else if ("E".equals(status)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\u3002", (String)"WorkflowDesignerIDEPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private String spliceErrorNotification(List<ValidationError> validateResults) {
        StringBuilder sBuilder = new StringBuilder();
        if (validateResults != null && WfUtils.isNotEmptyForCollection(validateResults)) {
            for (int i = 0; i < validateResults.size(); ++i) {
                ValidationError error = validateResults.get(i);
                if (!error.isBizFlowEntityValidError()) continue;
                sBuilder.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u8282\u70b9\u65e0\u201c%2$s\u201d\u5b9e\u4f53\uff0c\u4e0d\u80fd\u53d1\u5e03\u3002", (String)"WorkflowDesignerIDEPlugin_29", (String)"bos-wf-formplugin", (Object[])new Object[0]), error.getActivityId(), error.getEntityNumber()));
                if (i >= validateResults.size() - 1) continue;
                sBuilder.append("\n");
            }
        }
        return sBuilder.toString();
    }

    @Override
    public void handleCustomEvent(String type, Map<String, Object> param) {
        if ("downloadFlowChart".equals(type)) {
            this.exportImage();
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pageId", this.getView().getPageId());
        this.getDesigner().notify("close", param, this.getView());
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_LAST_ADDNODETIME);
    }

    @Override
    protected String getType() {
        return "designer";
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }

    private static class GraphCellWraper {
        private int index;
        private GraphCell cell;

        public GraphCellWraper(int index, GraphCell cell) {
            this.index = index;
            this.cell = cell;
        }

        public int getIndex() {
            return this.index;
        }

        public GraphCell getCell() {
            return this.cell;
        }
    }
}

