/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.design.plugin.DynModelConfigListDataProvider;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;

public class WorkflowDynModelConfigListPlugin
extends AbstractListPlugin {
    private static final String BTN_ADDNEW = "btnaddnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndelete";
    private static final String KEY_DYNAMIC_CONFIG = "dynamic_model_config";
    private static final String CONFIRM_CALLBACK_DELETE = "delete_confirm";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new DynModelConfigListDataProvider());
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btnaddnew": {
                this.addNew();
                break;
            }
            case "btnedit": {
                this.edit();
                break;
            }
            case "btndelete": {
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                if (rows.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WorkflowDynModelConfigListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\uff1f", (String)"WorkflowDynModelConfigListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_CALLBACK_DELETE));
                break;
            }
        }
    }

    private void addNew() {
        this.getView().showForm(this.getFormShowParameter());
    }

    private void edit() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WorkflowDynModelConfigListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = (Long)rows.get(0).getPrimaryKeyValue();
        FormShowParameter parameter = this.getFormShowParameter();
        parameter.setCustomParam("id", (Object)id);
        parameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(parameter);
    }

    private FormShowParameter getFormShowParameter() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_dynamicmodelconfig");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_DYNAMIC_CONFIG));
        return parameter;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            return;
        }
        if (CONFIRM_CALLBACK_DELETE.equals(evt.getCallBackId())) {
            this.delete();
            ((IListView)this.getView()).refresh();
        }
    }

    private void delete() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        Long id = (Long)rows.get(0).getPrimaryKeyValue();
        String selectFields = "stenciltype,appid";
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"wf_dynmodelconfig", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        String appId = dynObj.getString("appid");
        String stencilType = dynObj.getString("stenciltype");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"wf_dynmodelconfig");
        DeleteServiceHelper.delete((IDataEntityType)type, (Object[])new Object[]{id});
        WfCacheHelper.putDynModelConfig((String)ModelConfigUtil.getAppDynConfigKey((String)appId), (String)stencilType, (String)"NULL");
        String isv = ISVService.getISVInfo().getId();
        WfCacheHelper.removeISVModelConfig((String)isv);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (KEY_DYNAMIC_CONFIG.equals(e.getActionId())) {
            ((IListView)this.getView()).refresh();
        }
    }
}

