/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.isv.ISVService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.domain.model.StencilElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;

public class WorkflowDynamicModelConfigPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CONFIRM = "btnok";
    private static final String STENCILTYPE = "stenciltype";
    private static final String BIZAPP = "bizapp";
    private static final String MODELCONFIG = "modelconfig";
    private static final String GRID_LISTENERS = "listeners";
    private static final String ENTRY_EVENTTYPE = "eventtype";
    private static final String ENTRY_TYPE = "type";
    private static final String ENTRY_IMPLEMENTATION = "implementation";
    private static final String KEY_STENCIL_INFO = "stencil_info_map";
    private static final String FIELD_ISV = "isv";
    private static final String FIELD_APPID = "appid";
    private static final String FIELD_CLOUDID = "cloudid";
    private static final String FIELD_MODELCONFIG = "customdefconfig";
    private static final String FIELD_STENCILTYPE = "stenciltype";
    private static final String FIELD_STENCILTYPE_NAME = "stenciltypename";
    private static final String FIELD_RUNTIME_CONFIG = "customruntimeconfig";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject evt) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long id = (Long)parameter.getCustomParam("id");
        if (id != null) {
            this.initControl(id);
        } else {
            this.initStencilTypeList(null);
        }
    }

    private void initControl(Long id) {
        String selectFields = String.format("%s, %s, %s, %s", FIELD_APPID, "stenciltype", FIELD_RUNTIME_CONFIG, FIELD_MODELCONFIG);
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"wf_dynmodelconfig", (String)selectFields, (QFilter[])filters);
        String config = dynObj.getString(FIELD_RUNTIME_CONFIG);
        String stencilType = dynObj.getString("stenciltype");
        String bizAppId = dynObj.getString(FIELD_APPID);
        String modelConfig = dynObj.getString(FIELD_MODELCONFIG);
        this.initStencilTypeList(stencilType);
        IDataModel model = this.getModel();
        model.setValue(BIZAPP, (Object)BizAppServiceHelp.getAppIdByAppNumber((String)bizAppId));
        model.setValue("stenciltype", (Object)stencilType);
        this.initListeners(config);
        model.setValue(MODELCONFIG, (Object)modelConfig);
    }

    private void initListeners(String config) {
        if (WfUtils.isEmpty((String)config)) {
            return;
        }
        JSONObject taskConfig = (JSONObject)SerializationUtils.fromJsonString((String)config, JSONObject.class);
        JSONObject properties = taskConfig.getJSONObject("properties");
        JSONArray executionListeners = properties.getJSONArray("executionListeners");
        JSONArray taskListeners = properties.getJSONArray("taskListeners");
        JSONArray listeners = new JSONArray();
        if (executionListeners != null) {
            listeners.addAll((Collection)executionListeners);
        }
        if (taskListeners != null) {
            listeners.addAll((Collection)taskListeners);
        }
        if (!listeners.isEmpty()) {
            int size = listeners.size();
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(GRID_LISTENERS, size);
            JSONObject listener = null;
            String value = null;
            for (int i = 0; i < size; ++i) {
                listener = listeners.getJSONObject(i);
                value = ExternalInterfaceUtil.getExtItfValue((String)listener.getString(ENTRY_IMPLEMENTATION));
                model.setValue(ENTRY_EVENTTYPE, listener.get((Object)"event"), i);
                model.setValue(ENTRY_IMPLEMENTATION, (Object)value, i);
            }
        }
    }

    private void initStencilTypeList(String value) {
        List stencils = ModelConfigUtil.getAllInheritedStencil((String)"UserTask", (boolean)true);
        if (stencils == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b\u4e0b\u62c9\u5217\u8868\u521d\u59cb\u5316\u5931\u8d25\uff0c\u672a\u89e3\u6790\u5230\u7c7b\u578b\u6570\u636e\u6216\u89e3\u6790\u5931\u8d25\u3002", (String)"WorkflowDynamicModelConfigPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(stencils.size());
        JSONObject stencilInfo = new JSONObject();
        for (StencilElement stencil : stencils) {
            stencilInfo.put(stencil.getId(), (Object)stencil.getName());
            items.add(new ComboItem(new LocaleString(stencil.getName()), stencil.getId()));
        }
        ComboEdit stencilType = (ComboEdit)this.getControl("stenciltype");
        stencilType.setComboItems(items);
        this.getModel().setValue("stenciltype", (Object)(value != null ? value : "UserTask"));
        this.getPageCache().put(KEY_STENCIL_INFO, stencilInfo.toJSONString());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey().toLowerCase();
        if (BTN_CONFIRM.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        JSONObject stencilInfo = (JSONObject)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_STENCIL_INFO), JSONObject.class);
        String tip = this.validate(stencilInfo);
        if (tip != null) {
            this.getView().showTipNotification(tip);
            return;
        }
        this.saveOrUpdate(stencilInfo);
        this.getView().close();
    }

    private void saveOrUpdate(JSONObject stencilInfo) {
        IDataModel model = this.getModel();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long id = (Long)parameter.getCustomParam("id");
        DynamicObject dynConfig = null;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"wf_dynmodelconfig");
        String userId = RequestContext.get().getUserId();
        Date date = WfUtils.now();
        boolean update = false;
        if (id == null) {
            dynConfig = new DynamicObject((DynamicObjectType)type);
            dynConfig.set("creater", (Object)userId);
            dynConfig.set("createdate", (Object)date);
        } else {
            update = true;
            dynConfig = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
        }
        DynamicObject app = (DynamicObject)model.getValue(BIZAPP);
        String appId = (String)app.getPkValue();
        String stencilType = (String)model.getValue("stenciltype");
        String isv = ISVService.getISVInfo().getId();
        JSONObject config = this.getListenersConfig();
        dynConfig.set(FIELD_RUNTIME_CONFIG, (Object)config.toString());
        dynConfig.set("stenciltype", (Object)stencilType);
        dynConfig.set(FIELD_APPID, (Object)app.getString("number"));
        dynConfig.set(FIELD_CLOUDID, app.getDynamicObject("bizcloud").getPkValue());
        dynConfig.set(FIELD_STENCILTYPE_NAME, stencilInfo.get(model.getValue("stenciltype")));
        dynConfig.set(FIELD_MODELCONFIG, model.getValue(MODELCONFIG));
        dynConfig.set(FIELD_ISV, (Object)isv);
        dynConfig.set("modifier", (Object)userId);
        dynConfig.set("modifydate", (Object)date);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynConfig});
        WfCacheHelper.putDynModelConfig((String)ModelConfigUtil.getAppDynConfigKey((String)appId), (String)stencilType, (String)date.toString());
        if (update) {
            WfCacheHelper.removeISVModelConfig((String)isv);
        }
    }

    private String validate(JSONObject stencilInfo) {
        DynamicObject app = (DynamicObject)this.getModel().getValue(BIZAPP);
        if (app == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\uff01", (String)"WorkflowDynamicModelConfigPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (WfUtils.isEmptyString((Object)this.getModel().getValue("stenciltype"))) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8282\u70b9\uff01", (String)"WorkflowDynamicModelConfigPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        String ret = this.validateListeners();
        if (ret != null) {
            return ret;
        }
        ret = this.validateModelConfig();
        if (ret != null) {
            return ret;
        }
        ret = this.validateUnique(app, stencilInfo);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private String validateUnique(DynamicObject app, JSONObject stencilInfo) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long id = (Long)parameter.getCustomParam("id");
        if (id == null) {
            String isv = ISVService.getISVInfo().getId();
            Object stencilType = this.getModel().getValue("stenciltype");
            QFilter[] filters = new QFilter[]{new QFilter(FIELD_APPID, "=", app.getPkValue()), new QFilter("stenciltype", "=", stencilType), new QFilter(FIELD_ISV, "=", (Object)isv)};
            if (QueryServiceHelper.exists((String)"wf_dynmodelconfig", (QFilter[])filters)) {
                return String.format(ResManager.loadKDString((String)"\u6240\u9009\u5e94\u7528\u4e0b\u5df2\u5b58\u5728 \u201c%s\u201d \u8282\u70b9\u7684\u914d\u7f6e\u3002", (String)"WorkflowDynamicModelConfigPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), stencilInfo.get(stencilType));
            }
        }
        return null;
    }

    private String validateModelConfig() {
        String config = (String)this.getModel().getValue(MODELCONFIG);
        if (WfUtils.isNotEmpty((String)config)) {
            try {
                JSON.parse((String)config);
            }
            catch (Exception e) {
                this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
                return ResManager.loadKDString((String)"\u8bf7\u5c06\u201c\u8282\u70b9\u5c5e\u6027\u9ed8\u8ba4\u914d\u7f6e\u201d\u4e3a\u201c\u6709\u6548\u7684JSON\u683c\u5f0f\u201d\uff0c\u5f53\u524d\u4e3a\u65e0\u6548JSON\u683c\u5f0f\u3002", (String)"WorkflowDynamicModelConfigPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private String validateListeners() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(GRID_LISTENERS);
        if (collection.isEmpty()) {
            return null;
        }
        DynamicObject dynObj = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            dynObj = (DynamicObject)collection.get(i);
            if (!WfUtils.isEmpty((String)dynObj.getString(ENTRY_IMPLEMENTATION))) continue;
            return String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7b2c\u201c%s\u201d\u884c\u7684\u201c\u63d2\u4ef6\u7c7b\u201d\u3002", (String)"WorkflowDynamicModelConfigPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), i + 1);
        }
        return null;
    }

    private JSONObject getListenersConfig() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(GRID_LISTENERS);
        JSONArray executionListeners = new JSONArray();
        JSONArray taskListeners = new JSONArray();
        String type = null;
        String value = null;
        for (DynamicObject dynObj : collection) {
            JSONObject listener = new JSONObject();
            type = dynObj.getString(ENTRY_EVENTTYPE);
            listener.put("event", (Object)type);
            value = ExternalInterfaceUtil.getFormattedValue((String)"class", (String)dynObj.getString(ENTRY_IMPLEMENTATION));
            listener.put(ENTRY_IMPLEMENTATION, (Object)value);
            listener.put("implementationtype", (Object)"class");
            if ("complete".equals(type)) {
                taskListeners.add((Object)listener);
                continue;
            }
            executionListeners.add((Object)listener);
        }
        JSONObject properties = new JSONObject();
        properties.put("executionListeners", (Object)executionListeners);
        properties.put("taskListeners", (Object)taskListeners);
        JSONObject task = new JSONObject();
        task.put("properties", (Object)properties);
        JSONObject stencil = new JSONObject();
        stencil.put("id", this.getModel().getValue("stenciltype"));
        task.put("stencil", (Object)stencil);
        return task;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_STENCIL_INFO);
    }
}

