/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.Pair;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateExtAttrEntity;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateUtil;
import org.apache.commons.lang.BooleanUtils;

public class WorkflowExpendConfigurePlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String EXTATTRGROUP = "extAttrGroup";
    private static final String OUTERMOSTFLEXPANEL = "outermostFlexPanel_%s";
    private static final String GROUPFLEXPANEL = "groupflexpanel_%s";
    private static final String GROUPCHECKBOX = "groupcheckbox_%s";
    private static final String KEY_ATTRIBUTEFIELD = "attributefield_%s_%s_%s";
    private static final String ATTRIBUTENUMBER = "attributeNumber";
    private static final String ATTRIBUTETYPE = "attributeType";
    private static final String CONTENTPANEL = "contentpanel";
    private static final String HEADAP = "headAp";
    private static final String ATTRIBUTENAME = "attributeName";
    private static final String ATTRIBUTECONTENTSETTING = "attributeContentSetting";
    private static final String ATTRIBUTEDESCRIPTION = "attributedeScription";
    private static final String BOS_ENTITYOBJECT = "bos_entityobject";
    private static final String START_GROUPCHECKBOX = "groupcheckbox_";
    private static final String EXTATTRVALUE = "extAttrValue";
    private static final String TEXT = "text";
    private static final String BASEDATA = "basedata";
    private static final String COMBO = "combo";
    private static final String CHECKBOX = "checkbox";
    private static final String INTEGER = "integer";
    private static final String GROUPENABLE = "groupEnable";
    protected static final String BASIC_INFO_REFRESH = "basicInfoRefresh";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        this.stencilType = (String)parameter.getCustomParam("stencil_type");
        NodeTemplateExtAttrEntity nodeTemplateExtAttrEntity = NodeTemplateUtil.getExtAttrDatas((String)this.stencilType, null);
        this.initExpendAttributesPanel(e, nodeTemplateExtAttrEntity.getExtAttrMap(), nodeTemplateExtAttrEntity.getExtNameMap());
    }

    private void initExpendAttributesPanel(LoadCustomControlMetasArgs e, Map<String, JSONArray> nodeTemplateExpendDatasMap, Map<String, String> nodeTemplateNameMap) {
        if (nodeTemplateExpendDatasMap == null) {
            return;
        }
        FlexPanelAp headPanelAp = this.getHeadPanelAp(nodeTemplateExpendDatasMap, nodeTemplateNameMap);
        HashMap<String, String> flexApMap = new HashMap<String, String>();
        flexApMap.put("id", CONTENTPANEL);
        flexApMap.put("items", (String)headPanelAp.createControl().get("items"));
        e.getItems().add(flexApMap);
    }

    private FlexPanelAp getHeadPanelAp(Map<String, JSONArray> nodeTemplateExpendDatasMap, Map<String, String> nodeTemplateNameMap) {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey(HEADAP);
        Set<Map.Entry<String, JSONArray>> nodeTemplateExpendDataEntrySet = nodeTemplateExpendDatasMap.entrySet();
        for (Map.Entry<String, JSONArray> nodeTemplateExpendData : nodeTemplateExpendDataEntrySet) {
            String key = nodeTemplateExpendData.getKey();
            String name = nodeTemplateNameMap.get(key);
            JSONArray expendAttributeDataArray = nodeTemplateExpendData.getValue();
            FlexPanelAp outermostFlexPanel = new FlexPanelAp();
            outermostFlexPanel.setKey(String.format(OUTERMOSTFLEXPANEL, key));
            Style outermostStyle = new Style();
            Margin outermostMargin = new Margin();
            outermostMargin.setBottom("0px");
            outermostMargin.setLeft("20px");
            outermostMargin.setRight("20px");
            outermostMargin.setTop("0px");
            outermostStyle.setMargin(outermostMargin);
            Padding outermostPadding = new Padding();
            outermostPadding.setTop("10px");
            outermostStyle.setPadding(outermostPadding);
            outermostFlexPanel.setStyle(outermostStyle);
            outermostFlexPanel.setWidth(new LocaleString("100%"));
            FieldAp checkBoxFieldAp = new FieldAp();
            checkBoxFieldAp.setKey(String.format(GROUPCHECKBOX, key));
            checkBoxFieldAp.setName(new LocaleString(name));
            checkBoxFieldAp.setFireUpdEvt(Boolean.TRUE.booleanValue());
            checkBoxFieldAp.setWidth(new LocaleString("100%"));
            checkBoxFieldAp.setHeight(new LocaleString("20px"));
            Style checkBoxStyle = new Style();
            Margin checkBoxMargin = new Margin();
            checkBoxMargin.setBottom("0px");
            checkBoxStyle.setMargin(checkBoxMargin);
            checkBoxFieldAp.setStyle(checkBoxStyle);
            CheckBoxField checkBoxField = new CheckBoxField();
            checkBoxField.setKey(String.format(GROUPCHECKBOX, key));
            checkBoxField.setName(new LocaleString(name));
            checkBoxField.setShowStyle(2);
            checkBoxFieldAp.setField((Field)checkBoxField);
            outermostFlexPanel.getItems().add(checkBoxFieldAp);
            FlexPanelAp groupFlexPanel = new FlexPanelAp();
            groupFlexPanel.setKey(String.format(GROUPFLEXPANEL, key));
            groupFlexPanel.setVisible("new,edit,submit,audit,view");
            Style style = new Style();
            Border border = new Border();
            border.setBottom("1px solid #D9D9D9");
            border.setLeft("1px solid #D9D9D9");
            border.setRight("1px solid #D9D9D9");
            border.setTop("1px solid #D9D9D9");
            Padding padding = new Padding();
            padding.setBottom("16px");
            padding.setLeft("20px");
            padding.setTop("16px");
            padding.setRight("20px");
            if (expendAttributeDataArray != null) {
                style.setBorder(border);
                style.setPadding(padding);
            }
            Margin margin = new Margin();
            margin.setTop("12px");
            style.setMargin(margin);
            groupFlexPanel.setStyle(style);
            if (expendAttributeDataArray != null) {
                for (Object object : expendAttributeDataArray) {
                    JSONObject expendAttribute = (JSONObject)object;
                    this.creatExpendAttribute(groupFlexPanel, expendAttribute, key);
                }
            }
            outermostFlexPanel.getItems().add(groupFlexPanel);
            headPanelAp.getItems().add(outermostFlexPanel);
        }
        return headPanelAp;
    }

    private void creatExpendAttribute(FlexPanelAp groupFlexPanel, JSONObject expendAttribute, String key) {
        String attributeType = expendAttribute.getString(ATTRIBUTETYPE);
        String attributeNumber = expendAttribute.getString(ATTRIBUTENUMBER);
        ILocaleString attributeName = WfMultiLangUtils.getMultiLangValue((Map)((Map)expendAttribute.get((Object)ATTRIBUTENAME)));
        String attributeContentSetting = expendAttribute.getString(ATTRIBUTECONTENTSETTING);
        ILocaleString attributedeScription = WfMultiLangUtils.getMultiLangValue((Map)((Map)expendAttribute.get((Object)ATTRIBUTEDESCRIPTION)));
        FieldAp expendAttributeField = this.creatAttributeFieldAp(attributeType, (LocaleString)attributeName, attributeNumber, attributeContentSetting, attributedeScription, key);
        groupFlexPanel.getItems().add(expendAttributeField);
    }

    private FieldAp creatAttributeFieldAp(String attributeType, LocaleString attributeName, String attributeNumber, String attributeContentSetting, ILocaleString attributedeScription, String key) {
        FieldAp attributeField = new FieldAp();
        String attributeFieldKey = String.format(KEY_ATTRIBUTEFIELD, key, attributeType, attributeNumber);
        attributeField.setId(attributeFieldKey.toLowerCase());
        attributeField.setKey(attributeFieldKey.toLowerCase());
        attributeField.setName(attributeName);
        attributeField.setFireUpdEvt(Boolean.TRUE.booleanValue());
        Tips ctlTips = new Tips();
        ctlTips.setContent((LocaleString)attributedeScription);
        ctlTips.setShowIcon(true);
        ctlTips.setTriggerType("hover");
        ctlTips.setType(TEXT);
        ctlTips.setBillno("wf_nodeexpendcombo");
        attributeField.setCtlTips(ctlTips);
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("0px");
        padding.setRight("10px");
        style.setPadding(padding);
        attributeField.setStyle(style);
        attributeField.setWidth(new LocaleString("100%"));
        switch (attributeType) {
            case "text": 
            case "dynamicform": {
                TextField textEdit = new TextField();
                textEdit.setId(attributeFieldKey.toLowerCase());
                textEdit.setKey(attributeFieldKey.toLowerCase());
                textEdit.setName(attributeName);
                if ("dynamicform".equals(attributeType)) {
                    textEdit.setEditStyle(1);
                }
                attributeField.setField((Field)textEdit);
                break;
            }
            case "basedata": {
                BasedataField basedataField = new BasedataField();
                basedataField.setId(attributeFieldKey.toLowerCase());
                basedataField.setKey(attributeFieldKey.toLowerCase());
                if (WfUtils.isEmpty((String)attributeContentSetting)) {
                    attributeContentSetting = BOS_ENTITYOBJECT;
                }
                basedataField.setBaseEntityId(attributeContentSetting);
                basedataField.setName(attributeName);
                attributeField.setField((Field)basedataField);
                break;
            }
            case "combo": {
                ComboField comboField = new ComboField();
                comboField.setId(attributeFieldKey.toLowerCase());
                comboField.setKey(attributeFieldKey.toLowerCase());
                comboField.setName(attributeName);
                JSONObject attributeContent = JSON.parseObject((String)attributeContentSetting);
                if (attributeContent != null) {
                    ArrayList<ComboItem> items = new ArrayList<ComboItem>(attributeContent.size());
                    Set attributeContentEntrySet = attributeContent.entrySet();
                    HashMap attributeMap = new HashMap(attributeContentEntrySet.size());
                    for (Map.Entry entry : attributeContentEntrySet) {
                        attributeMap.put(entry.getKey(), entry.getValue());
                    }
                    ArrayList attributeList = new ArrayList(attributeMap.entrySet());
                    Collections.sort(attributeList, Map.Entry.comparingByKey());
                    int rowIndex = 0;
                    for (Map.Entry entry : attributeList) {
                        ComboItem coverComboItem = new ComboItem(rowIndex, (LocaleString)WfMultiLangUtils.getMultiLangValue((Map)((Map)entry.getValue())), (String)entry.getKey());
                        items.add(coverComboItem);
                        ++rowIndex;
                    }
                    comboField.setItems(items);
                }
                attributeField.setField((Field)comboField);
                break;
            }
            case "checkbox": {
                attributeField.setHeight(new LocaleString("20px"));
                CheckBoxField checkBoxField = new CheckBoxField();
                checkBoxField.setKey(attributeFieldKey.toLowerCase());
                checkBoxField.setName(attributeName);
                checkBoxField.setShowStyle(2);
                attributeField.setField((Field)checkBoxField);
                break;
            }
            case "integer": {
                IntegerField integerField = new IntegerField();
                integerField.setKey(attributeFieldKey.toLowerCase());
                integerField.setName(attributeName);
                attributeField.setField((Field)integerField);
                break;
            }
        }
        return attributeField;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.stencilType = (String)parameter.getCustomParam("stencil_type");
        NodeTemplateExtAttrEntity nodeTemplateExtAttrEntity = NodeTemplateUtil.getExtAttrDatas((String)this.stencilType, null);
        Map extAttrMap = nodeTemplateExtAttrEntity.getExtAttrMap();
        if (extAttrMap == null || extAttrMap.isEmpty()) {
            this.log.debug("WorkflowExpendConfigurePlugin.getEntityType is error,the ExtAttrMap is null");
            return;
        }
        for (Map.Entry extAttr : extAttrMap.entrySet()) {
            this.registDynamicProps(newMainType, (String)extAttr.getKey(), (JSONArray)extAttr.getValue());
        }
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType, String number, JSONArray attributesArray) {
        BooleanProp groupBooleanProp = new BooleanProp();
        groupBooleanProp.setName(String.format(GROUPCHECKBOX, number));
        newMainType.registerSimpleProperty((DynamicSimpleProperty)groupBooleanProp);
        if (attributesArray == null) {
            return;
        }
        HashMap<String, String> attributeNumberAndGruoupNumberMap = new HashMap<String, String>(attributesArray.size());
        HashMap<String, String> keyAndNumberMap = new HashMap<String, String>(attributesArray.size());
        for (Object object : attributesArray) {
            JSONObject expendAttribute = (JSONObject)object;
            String attributeType = expendAttribute.getString(ATTRIBUTETYPE);
            String attributeNumber = expendAttribute.getString(ATTRIBUTENUMBER);
            String attributeFieldKey = String.format(KEY_ATTRIBUTEFIELD, number, attributeType, attributeNumber);
            attributeNumberAndGruoupNumberMap.put(String.format("%s_%s", "group", attributeFieldKey.toLowerCase()), number);
            keyAndNumberMap.put(attributeFieldKey.toLowerCase(), attributeNumber);
            switch (attributeType) {
                case "text": 
                case "dynamicform": {
                    TextProp textEdit = new TextProp();
                    textEdit.setName(attributeFieldKey.toLowerCase());
                    newMainType.registerSimpleProperty((DynamicSimpleProperty)textEdit);
                    break;
                }
                case "basedata": {
                    BasedataProp baseProp = new BasedataProp();
                    baseProp.setDbIgnore(true);
                    baseProp.setName(attributeFieldKey.toLowerCase());
                    String baseEntityId = expendAttribute.getString(ATTRIBUTECONTENTSETTING);
                    if (WfUtils.isEmpty((String)baseEntityId)) {
                        baseEntityId = BOS_ENTITYOBJECT;
                    }
                    baseProp.setBaseEntityId(baseEntityId);
                    MainEntityType dType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                    baseProp.setComplexType((IDataEntityType)dType);
                    baseProp.setAlias("");
                    String key = attributeFieldKey.toLowerCase() + "_id";
                    DynamicSimpleProperty refIdProp = baseProp.createRefIDProp();
                    refIdProp.setName(key);
                    refIdProp.setDbIgnore(true);
                    baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
                    baseProp.setRefIdPropName(key);
                    newMainType.registerComplexProperty((DynamicComplexProperty)baseProp);
                    newMainType.addProperty((DynamicProperty)refIdProp);
                    break;
                }
                case "combo": {
                    ComboProp comboField = new ComboProp();
                    comboField.setName(attributeFieldKey.toLowerCase());
                    newMainType.registerSimpleProperty((DynamicSimpleProperty)comboField);
                    break;
                }
                case "checkbox": {
                    BooleanProp checkBoxField = new BooleanProp();
                    checkBoxField.setName(attributeFieldKey.toLowerCase());
                    newMainType.registerSimpleProperty((DynamicSimpleProperty)checkBoxField);
                    break;
                }
                case "integer": {
                    IntegerProp integerField = new IntegerProp();
                    integerField.setName(attributeFieldKey.toLowerCase());
                    newMainType.registerSimpleProperty((DynamicSimpleProperty)integerField);
                    break;
                }
            }
        }
        if (this.getPageCache() != null) {
            this.getPageCache().put(attributeNumberAndGruoupNumberMap);
            this.getPageCache().put(keyAndNumberMap);
        }
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.stencilType = (String)parameter.getCustomParam("stencil_type");
        NodeTemplateExtAttrEntity nodeTemplateExtAttrEntity = NodeTemplateUtil.getExtAttrDatas((String)this.stencilType, null);
        FlexPanelAp dynamicPanel = this.getHeadPanelAp(nodeTemplateExtAttrEntity.getExtAttrMap(), nodeTemplateExtAttrEntity.getExtNameMap());
        Container myFldPanel = (Container)this.getView().getControl(CONTENTPANEL);
        myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
    }

    public void onGetControl(OnGetControlArgs e) {
        String controlKey = e.getKey();
        String lowerControlKey = controlKey.toLowerCase(Locale.ENGLISH);
        if (lowerControlKey.startsWith(START_GROUPCHECKBOX) || lowerControlKey.contains("_checkbox_")) {
            FieldEdit fieldEdit = new FieldEdit();
            fieldEdit.setKey(controlKey);
            fieldEdit.setView(this.getView());
            e.setControl((Control)fieldEdit);
        } else if (lowerControlKey.contains("_text_")) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(controlKey);
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        } else if (lowerControlKey.contains("_dynamicform_")) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(controlKey);
            textEdit.setView(this.getView());
            textEdit.addClickListener((ClickListener)this);
            e.setControl((Control)textEdit);
        } else if (lowerControlKey.contains("_basedata_")) {
            BasedataEdit baseEdit = new BasedataEdit();
            baseEdit.setKey(controlKey);
            baseEdit.setView(this.getView());
            e.setControl((Control)baseEdit);
        } else if (lowerControlKey.contains("_combo_")) {
            ComboEdit comboEdit = new ComboEdit();
            comboEdit.setKey(controlKey);
            comboEdit.setView(this.getView());
            e.setControl((Control)comboEdit);
        } else if (lowerControlKey.contains("_integer_")) {
            IntegerEdit integerEdit = new IntegerEdit();
            integerEdit.setKey(controlKey);
            integerEdit.setView(this.getView());
            e.setControl((Control)integerEdit);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        JSONObject extAttrGroup;
        NodeTemplateExtAttrEntity nodeTemplateExtAttrEntity = NodeTemplateUtil.getExtAttrDatas((String)this.stencilType, null);
        Map extAttrMap = nodeTemplateExtAttrEntity.getExtAttrMap();
        Set extAttrEntrySet = extAttrMap.entrySet();
        for (Map.Entry extAttr : extAttrEntrySet) {
            JSONArray attributes = (JSONArray)extAttr.getValue();
            if (attributes == null) continue;
            HashMap<String, String> dynamicformPageCacheMap = new HashMap<String, String>(attributes.size());
            for (Object attributeObject : attributes) {
                JSONObject attribute = (JSONObject)attributeObject;
                String attributeNumber = attribute.getString(ATTRIBUTENUMBER);
                String attributeType = attribute.getString(ATTRIBUTETYPE);
                String attrDefault = attribute.getString("attrDefault");
                if ("dynamicform".equals(attributeType)) {
                    dynamicformPageCacheMap.put(String.format("%s_formId", attributeNumber.toLowerCase()), attribute.getString(ATTRIBUTECONTENTSETTING));
                }
                if (!WfUtils.isNotEmpty((String)attrDefault)) continue;
                this.getModel().setValue(String.format(KEY_ATTRIBUTEFIELD, extAttr.getKey(), attributeType, attributeNumber).toLowerCase(), (Object)attrDefault);
            }
            this.getPageCache().put(dynamicformPageCacheMap);
        }
        JSONObject properties = this.getCellProperties();
        JSONObject jSONObject = extAttrGroup = DesignerModelUtil.getProperty((Map<String, Object>)properties, EXTATTRGROUP) instanceof JSONObject ? (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, EXTATTRGROUP) : JSONObject.parseObject((String)((String)DesignerModelUtil.getProperty((Map<String, Object>)properties, EXTATTRGROUP)));
        if (WfUtils.isNullObject((Object)extAttrGroup)) {
            extAttrGroup = new JSONObject();
        }
        this.setExpendAttributeValue(nodeTemplateExtAttrEntity, extAttrGroup);
        for (Map.Entry extAttr : extAttrEntrySet) {
            String groupNumber = (String)extAttr.getKey();
            JSONObject groupValue = new JSONObject();
            JSONArray attributes = (JSONArray)extAttr.getValue();
            groupValue.put(GROUPENABLE, this.getModel().getValue(START_GROUPCHECKBOX + groupNumber.toLowerCase()));
            if (attributes == null) continue;
            for (Object attributeObject : attributes) {
                JSONObject attribute = (JSONObject)attributeObject;
                String attributeNumber = attribute.getString(ATTRIBUTENUMBER);
                String attributeType = attribute.getString(ATTRIBUTETYPE);
                Object attributeValue = null;
                if ("dynamicform".equals(attributeType)) {
                    attributeValue = this.getPageCache().get("dynamicform_oldValue");
                    this.getPageCache().remove("dynamicform_oldValue");
                } else {
                    attributeValue = this.getModel().getValue(String.format(KEY_ATTRIBUTEFIELD, groupNumber, attributeType, attributeNumber.toLowerCase()));
                }
                if ((attributeValue = attributeValue instanceof DynamicObject ? ((DynamicObject)attributeValue).get("id") : attributeValue) == null || !WfUtils.isNotEmpty((String)String.valueOf(attributeValue))) continue;
                if (groupValue.getJSONObject(EXTATTRVALUE) == null) {
                    groupValue.put(EXTATTRVALUE, (Object)new JSONObject());
                }
                groupValue.getJSONObject(EXTATTRVALUE).put(attributeNumber.toLowerCase(), attributeValue);
            }
            extAttrGroup.put(groupNumber, (Object)groupValue);
        }
        this.setProperties(EXTATTRGROUP, extAttrGroup);
    }

    private void setExpendAttributeValue(NodeTemplateExtAttrEntity extAttrDatas, JSONObject allExtAttrOfNode) {
        Map extAttrMap;
        JSONObject properties = this.getCellProperties();
        Pair<Boolean, List<Map<String, Object>>> isInvalidAndRes = this.isInvalidSSCCreditCustomParamAndResult();
        if (allExtAttrOfNode == null) {
            if (((Boolean)isInvalidAndRes.getKey()).booleanValue()) {
                return;
            }
            allExtAttrOfNode = new JSONObject();
        }
        if ((extAttrMap = extAttrDatas.getExtAttrMap()) == null || extAttrMap.isEmpty()) {
            this.log.debug("WorkflowExpendConfigurePlugin.setExpendAttributeValue is error:extAttrMap is null");
            return;
        }
        for (Map.Entry extAttr : extAttrMap.entrySet()) {
            String groupNumber = (String)extAttr.getKey();
            Pair<Boolean, JSONObject> isEnableAndDataRes = this.isGrpEnableAndGetGroupData(allExtAttrOfNode, groupNumber, isInvalidAndRes);
            JSONObject groupData = (JSONObject)isEnableAndDataRes.getValue();
            Boolean groupEnable = (Boolean)isEnableAndDataRes.getKey();
            this.getModel().setValue(String.format(GROUPCHECKBOX, groupNumber.toLowerCase()), (Object)groupEnable);
            this.getView().setVisible(groupEnable, new String[]{String.format(GROUPFLEXPANEL, groupNumber.toLowerCase())});
            if (((JSONObject)isEnableAndDataRes.getValue()).isEmpty()) continue;
            JSONArray attributesArray = extAttr.getValue() == null ? new JSONArray() : (JSONArray)extAttr.getValue();
            JSONObject extAttrValue = groupData.getJSONObject(EXTATTRVALUE) == null ? new JSONObject() : groupData.getJSONObject(EXTATTRVALUE);
            HashMap<String, String> attributesPageCacheMap = new HashMap<String, String>(attributesArray.size());
            for (Object object : attributesArray) {
                JSONObject expendAttribute = (JSONObject)object;
                String attributeType = expendAttribute.getString(ATTRIBUTETYPE);
                String attributeNumber = expendAttribute.getString(ATTRIBUTENUMBER);
                Object attributeValue = extAttrValue.get((Object)attributeNumber.toLowerCase());
                if (attributeValue == null || attributeValue.equals(this.getModel().getValue(String.format(KEY_ATTRIBUTEFIELD, groupNumber, attributeType, attributeNumber).toLowerCase()))) continue;
                if ("dynamicform".equals(attributeType) && attributeValue instanceof String) {
                    JSONObject attributeValueJsonObject = JSONObject.parseObject((String)((String)attributeValue));
                    attributesPageCacheMap.put("dynamicform_oldValue", (String)attributeValue);
                    this.getModel().setValue(String.format(KEY_ATTRIBUTEFIELD, groupNumber, attributeType, attributeNumber).toLowerCase(), (Object)attributeValueJsonObject.getString("showValue"));
                    continue;
                }
                this.getModel().setValue(String.format(KEY_ATTRIBUTEFIELD, groupNumber, attributeType, attributeNumber).toLowerCase(), attributeValue);
            }
            this.getPageCache().put(attributesPageCacheMap);
        }
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.contains("_dynamicform_")) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            String[] formIdKey = key.split("_dynamicform_");
            formShowParameter.setFormId(this.getPageCache().get(String.format("%s_formId", formIdKey[1])));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            JSONObject properties = this.getCellProperties();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            JSONObject extAttrGroup = properties.getJSONObject(EXTATTRGROUP);
            String[] keys = key.split("_dynamicform_");
            String groupNumber = keys[0].substring("attributefield_".length(), keys[0].length());
            if (this.getModel().getValue(key) != null && WfUtils.isNotEmpty((String)((String)this.getModel().getValue(key)))) {
                JSONObject groupValue = extAttrGroup.getJSONObject(groupNumber);
                customParams.put(String.format("%sValue", groupNumber), groupValue);
            }
            customParams.put("key", keys[1]);
            customParams.put("groupNumber", groupNumber);
            customParams.put("entityNumber", properties.getString("entityNumber"));
            customParams.put("nodeName", properties.getString("name"));
            customParams.put("nodeNumber", properties.getString("number"));
            customParams.put("itemId", properties.getString("itemId"));
            customParams.put("bizIdentifyKey", properties.getString("bizIdentifyKey"));
            customParams.put("customParams", properties.getJSONArray("customParams"));
            formShowParameter.setCustomParams(customParams);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        String key = closedCallBackEvent.getActionId();
        if (key.contains("_dynamicform_") && returnData instanceof Map && returnData != null && !((Map)returnData).isEmpty()) {
            String showValue = (String)((Map)returnData).get("showValue");
            String saveValue = (String)((Map)returnData).get("saveValue");
            if (!WfConfigurationUtil.isAllowLengthThanSpecified() && WfUtils.isNotEmpty((String)showValue) && showValue.length() > 255) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355\u7684\u8fd4\u56de\u503c\u4e0d\u80fd\u5927\u4e8e255\u4e2a\u5b57\u7b26\u3002", (String)"WorkflowExpendConfigurePlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!WfConfigurationUtil.isAllowLengthThanSpecified() && WfUtils.isNotEmpty((String)saveValue) && saveValue.length() > 255) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355\u7684\u663e\u793a\u503c\u4e0d\u80fd\u5927\u4e8e255\u4e2a\u5b57\u7b26\u3002", (String)"WorkflowExpendConfigurePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue(closedCallBackEvent.getActionId(), (Object)showValue);
            String groupNumber = this.getPageCache().get(String.format("%s_%s", "group", key));
            JSONObject properties = this.getCellProperties();
            JSONObject extAttrGroup = DesignerModelUtil.getProperty((Map<String, Object>)properties, EXTATTRGROUP) instanceof JSONObject ? (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, EXTATTRGROUP) : JSONObject.parseObject((String)((String)DesignerModelUtil.getProperty((Map<String, Object>)properties, EXTATTRGROUP)));
            extAttrGroup = extAttrGroup == null ? new JSONObject() : extAttrGroup;
            JSONObject groupValue = extAttrGroup.getJSONObject(groupNumber);
            groupValue = groupValue == null ? new JSONObject() : groupValue;
            Map<String, String> attributeInfo = this.getAttributeTypeAndAttributeNumber(key);
            if (groupValue.getJSONObject(EXTATTRVALUE) == null) {
                groupValue.put(EXTATTRVALUE, (Object)new JSONObject());
            }
            JSONObject modelValue = new JSONObject();
            modelValue.put("showValue", (Object)showValue);
            modelValue.put("saveValue", (Object)saveValue);
            groupValue.getJSONObject(EXTATTRVALUE).put(attributeInfo.get(ATTRIBUTENUMBER), (Object)modelValue.toJSONString());
            extAttrGroup.put(groupNumber, (Object)groupValue);
            this.setProperties(EXTATTRGROUP, extAttrGroup);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (propName.contains("_dynamicform_") && WfUtils.isNotEmpty((String)((String)newValue))) {
            return;
        }
        String groupNumber = propName.startsWith("groupcheckbox") ? propName.replaceAll(START_GROUPCHECKBOX, "") : this.getPageCache().get(String.format("%s_%s", "group", propName));
        JSONObject properties = this.getCellProperties();
        JSONObject extAttrGroup = DesignerModelUtil.getProperty((Map<String, Object>)properties, EXTATTRGROUP) instanceof JSONObject ? (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, EXTATTRGROUP) : JSONObject.parseObject((String)((String)DesignerModelUtil.getProperty((Map<String, Object>)properties, EXTATTRGROUP)));
        extAttrGroup = extAttrGroup == null ? new JSONObject() : extAttrGroup;
        JSONObject groupValue = extAttrGroup.getJSONObject(groupNumber);
        JSONObject jSONObject = groupValue = groupValue == null ? new JSONObject() : groupValue;
        if (WfUtils.isNotEmpty((String)propName) && propName.startsWith(START_GROUPCHECKBOX)) {
            this.getView().setVisible((Boolean)newValue, new String[]{String.format(GROUPFLEXPANEL, groupNumber.toLowerCase())});
            groupValue.put(GROUPENABLE, (Object)((Boolean)newValue));
        } else {
            Object targetValue;
            Map<String, String> attributeInfo = this.getAttributeTypeAndAttributeNumber(propName);
            if (groupValue.getJSONObject(EXTATTRVALUE) == null) {
                groupValue.put(EXTATTRVALUE, (Object)new JSONObject());
            }
            targetValue = (targetValue = this.getModel().getValue(String.format(KEY_ATTRIBUTEFIELD, groupNumber, attributeInfo.get(ATTRIBUTETYPE), attributeInfo.get(ATTRIBUTENUMBER)))) instanceof DynamicObject ? ((DynamicObject)targetValue).get("id") : targetValue;
            targetValue = targetValue == null && BASEDATA.equals(attributeInfo.get(ATTRIBUTETYPE)) ? Long.valueOf(0L) : targetValue;
            groupValue.getJSONObject(EXTATTRVALUE).put(attributeInfo.get(ATTRIBUTENUMBER), targetValue);
        }
        extAttrGroup.put(groupNumber, (Object)groupValue);
        this.setProperties(EXTATTRGROUP, extAttrGroup);
    }

    private Pair<Boolean, JSONObject> isGrpEnableAndGetGroupData(JSONObject curExtAttrGroup, String curGroupNumber, Pair<Boolean, List<Map<String, Object>>> isInvalidAndRes) {
        String isRefresh;
        JSONObject groupData = (JSONObject)curExtAttrGroup.getOrDefault((Object)curGroupNumber, (Object)new JSONObject());
        Boolean groupEnable = groupData.getBoolean(GROUPENABLE);
        if (!NodeTemplateUtil.isSSCCredit((String)curGroupNumber, (String)this.stencilType) || ((Boolean)isInvalidAndRes.getKey()).booleanValue() || BooleanUtils.toBoolean((Boolean)groupEnable)) {
            return new Pair((Object)groupEnable, (Object)groupData);
        }
        groupData.put(GROUPENABLE, (Object)Boolean.TRUE);
        curExtAttrGroup.put(curGroupNumber, (Object)groupData);
        List value = (List)isInvalidAndRes.getValue();
        this.setProperty("customParams", value);
        IFormView parentView = this.getView().getParentView();
        if (WfUtils.isNotNullObject((Object)parentView) && !BooleanUtils.toBoolean((String)(isRefresh = parentView.getPageCache().get(BASIC_INFO_REFRESH)))) {
            parentView.getPageCache().put(BASIC_INFO_REFRESH, Boolean.TRUE.toString());
        }
        return new Pair((Object)Boolean.TRUE, (Object)groupData);
    }

    private Pair<Boolean, List<Map<String, Object>>> isInvalidSSCCreditCustomParamAndResult() {
        ArrayList customParams = (ArrayList)this.getProperty("customParams");
        if (WfUtils.isEmptyForCollection((Collection)customParams)) {
            return new Pair((Object)Boolean.TRUE, Collections.emptyList());
        }
        List customParamsNew = customParams.stream().filter(t -> !Objects.equals(t.get("number"), "creditcontrol_ssc") || !BooleanUtils.toBoolean((String)((String)t.get("value")))).collect(Collectors.toList());
        if (Objects.equals(customParams.size(), customParamsNew.size())) {
            return new Pair((Object)Boolean.TRUE, Collections.emptyList());
        }
        return new Pair((Object)Boolean.FALSE, customParamsNew);
    }

    private Map<String, String> getAttributeTypeAndAttributeNumber(String propName) {
        HashMap<String, String> attributeInfo = new HashMap<String, String>(2);
        String attributeType = "";
        switch (this.getControl(propName).getClass().getName()) {
            case "kd.bos.form.field.TextEdit": {
                attributeType = propName.contains("dynamicform") ? "dynamicform" : TEXT;
                break;
            }
            case "kd.bos.form.field.IntegerEdit": {
                attributeType = INTEGER;
                break;
            }
            case "kd.bos.form.field.BasedataEdit": {
                attributeType = BASEDATA;
                break;
            }
            case "kd.bos.form.field.ComboEdit": {
                attributeType = COMBO;
                break;
            }
            case "kd.bos.form.field.FieldEdit": {
                attributeType = CHECKBOX;
                break;
            }
        }
        attributeInfo.put(ATTRIBUTETYPE, attributeType);
        String[] formIdKey = propName.split(String.format("_%s_", attributeType));
        attributeInfo.put(ATTRIBUTENUMBER, formIdKey[1]);
        return attributeInfo;
    }
}

