/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.property.RegistKSPlugin;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.ScriptInfo;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class WorkflowExtInterfaceScriptPlugin
extends AbstractWorkflowPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final String COLUMN_BIZCLOUD = "bizcloud";
    private static final String BTN_CONFIRM = "confirmbtn";
    private static final String KDE_TEXT = "kde";
    private static final String KDE_ICON = "icon";
    private static final String BTN_REFRESH = "refresh";
    private static final String GRID = "entryentity";
    private static final String COLUMN_SCRIPTNUMBER = "scriptnumber";
    private static final String COLUMN_SCRIPTNAME = "scriptname";
    private static final String COLUMN_SCRIPTTYPE = "scripttype";
    private static final String COLUMN_BIZAPPID = "bizappid";
    private static final String COLUMN_BIZCLOUDID = "bizcloudid";
    private static final String COLUMN_SCRIPTID = "scriptid";
    private static final String BIZAPPID = "bizAppId";
    private static final String CLOUDID = "cloudId";
    private static final String KDE_FORMKEY = "bos_devp_kde";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CONFIRM, KDE_TEXT, KDE_ICON, BTN_REFRESH});
        EntryGrid entryGrid = (EntryGrid)this.getControl(GRID);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String appId = this.getBizAppIdByEntityId((String)parameter.getCustomParam("entityId"));
        if (appId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6307\u5b9a\u9875\u9762\u6240\u5728\u7684\u5e94\u7528\u3002", (String)"WorkflowExtInterfaceScriptPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.cacheAppData(appId);
        String value = (String)parameter.getCustomParam("value");
        this.initScriptGrid(value);
    }

    private String getBizAppIdByEntityId(String entityId) {
        if (WfUtils.isEmpty((String)entityId)) {
            return null;
        }
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp", (QFilter[])new QFilter[]{new QFilter("form", "=", (Object)entityId)});
        return dynObj.getString("bizapp");
    }

    private void cacheAppData(String appId) {
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)COLUMN_BIZCLOUD, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)appId)});
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(BIZAPPID, appId);
        data.put(CLOUDID, dynObj.getString(COLUMN_BIZCLOUD));
        this.getPageCache().put(data);
    }

    private void initScriptGrid(String value) {
        IDataModel model = this.getModel();
        List<ScriptInfo> infos = this.getPluginScripts();
        if (infos.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u6240\u5728\u5e94\u7528\u4e0b\u6ca1\u6709\u6d41\u7a0b\u63d2\u4ef6\u811a\u672c\uff0c\u8bf7\u5148\u8fdb\u5165KDE\u65b0\u5efa\u63d2\u4ef6\u3002", (String)"WorkflowExtInterfaceScriptPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
            return;
        }
        model.batchCreateNewEntryRow(GRID, infos.size());
        ScriptInfo info = null;
        HashMap valMap = ExternalInterfaceUtil.castJSONToMap((Object)value);
        Object scriptId = valMap.get("id");
        Integer selectedRow = null;
        for (int i = 0; i < infos.size(); ++i) {
            info = infos.get(i);
            model.setValue(COLUMN_SCRIPTNUMBER, (Object)info.getClassname().toLowerCase(), i);
            model.setValue(COLUMN_SCRIPTNAME, (Object)info.getName(), i);
            model.setValue(COLUMN_SCRIPTTYPE, (Object)RegistKSPlugin.getScriptNameByIndex((String)"7"), i);
            model.setValue(COLUMN_BIZAPPID, (Object)info.getAppId(), i);
            model.setValue(COLUMN_BIZCLOUDID, (Object)info.getCloudId(), i);
            model.setValue(COLUMN_SCRIPTID, (Object)info.getId(), i);
            if (selectedRow != null || !info.getId().equals(scriptId)) continue;
            selectedRow = i;
        }
        if (selectedRow != null) {
            EntryGrid grid = (EntryGrid)this.getControl(GRID);
            grid.selectRows(selectedRow.intValue());
        }
    }

    private List<ScriptInfo> getPluginScripts() {
        DynamicObject[] scriptInfos;
        String appId = this.getPageCache().get(BIZAPPID);
        String cloudId = this.getPageCache().get(CLOUDID);
        QFilter filter = new QFilter("inheritpath", "like", (Object)(appId + "%")).or("inheritpath", "like", (Object)("%," + appId + "%"));
        QFilter[] filters = new QFilter[]{new QFilter(COLUMN_BIZCLOUD, "=", (Object)cloudId).and(filter)};
        DynamicObjectCollection ret = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])filters);
        ArrayList<ScriptInfo> scripts = new ArrayList<ScriptInfo>();
        HashSet<String> appIds = new HashSet<String>();
        appIds.add(appId);
        if (ret != null && !ret.isEmpty()) {
            for (DynamicObject dynObj : ret) {
                appIds.add(dynObj.getString("id"));
            }
        }
        if ((scriptInfos = BusinessDataServiceHelper.load((String)"ide_pluginscript", (String)"id,txt_scriptname,txt_scriptnumber,cbox_script_type,classname,bizunitid,bizappid,bizcloud", (QFilter[])(filters = new QFilter[]{new QFilter(COLUMN_BIZAPPID, "in", appIds), new QFilter("cbox_script_type", "=", (Object)"7")}), (String)"classname")).length == 0) {
            return scripts;
        }
        ScriptInfo info = null;
        for (DynamicObject scriptInfo : scriptInfos) {
            String className = scriptInfo.getString("classname");
            if ((className == null || className.trim().length() == 0) && (className = this.getClassNameByBizUnitId(scriptInfo.getString(COLUMN_BIZAPPID), scriptInfo.getString("bizunitid"), scriptInfo.getString("txt_scriptnumber"))) == null) continue;
            info = new ScriptInfo();
            info.setId(scriptInfo.getString("id"));
            info.setAppId(scriptInfo.getString(COLUMN_BIZAPPID));
            info.setCloudId(cloudId);
            info.setName(scriptInfo.getString("txt_scriptname"));
            info.setType(scriptInfo.getString("cbox_script_type"));
            info.setClassname(className);
            scripts.add(info);
        }
        return scripts;
    }

    private String getClassNameByBizUnitId(String bizAppId, String bizUnitId, String scriptNumber) {
        AppFunctionPacketElement bizUnitInfo = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        if (bizUnitInfo == null) {
            return null;
        }
        String bizUnitNumber = bizUnitInfo.getNumber();
        String parentUnitNumber = null;
        if (bizUnitInfo != null && bizUnitInfo.getParentId().trim().length() != 0) {
            String parentBizUnitId = bizUnitInfo.getParentId();
            AppFunctionPacketElement parentBizUnitInfo = AppMetaServiceHelper.getFunctionPacketById((String)parentBizUnitId, (String)bizAppId, (boolean)false);
            parentUnitNumber = parentBizUnitInfo.getNumber();
        }
        AppMetadata appInfo = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizAppNumber = appInfo.getNumber();
        String bizCloudId = appInfo.getBizCloudID();
        String bizCloudNumber = (String)BusinessDataServiceHelper.loadSingleFromCache((Object)bizCloudId, (String)"bos_devportal_bizcloud", (String)"number").get("number");
        String className = null;
        className = parentUnitNumber == null ? bizCloudNumber + "." + bizAppNumber + "." + bizUnitNumber + "." + scriptNumber : bizCloudNumber + "." + bizAppNumber + "." + parentUnitNumber + "." + bizUnitNumber + "." + scriptNumber;
        return className.toLowerCase();
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "refresh": {
                this.getModel().deleteEntryData(GRID);
                this.initScriptGrid((String)this.getView().getFormShowParameter().getCustomParam("value"));
                break;
            }
            case "confirmbtn": {
                this.confirm();
                break;
            }
            case "kde": 
            case "icon": {
                String bizAppId = this.getPageCache().get(BIZAPPID);
                if (WfUtils.isEmpty((String)bizAppId)) {
                    this.logger.debug("NodeTemplate,There is't entityId");
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u6253\u5f00\uff0centityID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowBasicInfoPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                String bizCloudId = BizCloudServiceHelp.getBizCloudByAppID((String)bizAppId).getString("id");
                this.openKDE(bizAppId, bizCloudId, null);
                break;
            }
        }
    }

    private void confirm() {
        EntryGrid grid = (EntryGrid)this.getControl(GRID);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows.length > 0) {
            IDataModel model = this.getModel();
            int index = rows[0];
            String scriptId = (String)model.getValue(COLUMN_SCRIPTID, index);
            String fullNumber = (String)model.getValue(COLUMN_SCRIPTNUMBER, index);
            String template = "{\"number\":\"%s\", \"id\":\"%s\"}";
            this.getView().returnDataToParent((Object)String.format(template, fullNumber, scriptId));
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u811a\u672c\u201d\u3002", (String)"WorkflowExtInterfaceScriptPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void openKDE(String bizAppId, String bizCloudId, String scriptId) {
        if (WfUtils.isEmpty((String)bizAppId) || WfUtils.isEmpty((String)bizCloudId)) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NonModal);
        parameter.setFormId(KDE_FORMKEY);
        parameter.setCustomParam(COLUMN_BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam(COLUMN_BIZCLOUDID, (Object)bizCloudId);
        if (scriptId != null) {
            parameter.setCustomParam("bizscriptid", (Object)scriptId);
        }
        this.getView().showForm(parameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (COLUMN_SCRIPTNUMBER.equals(fieldName)) {
            int i = evt.getRowIndex();
            IDataModel model = this.getModel();
            this.openKDE((String)model.getValue(COLUMN_BIZAPPID, i), (String)model.getValue(COLUMN_BIZCLOUDID, i), (String)model.getValue(COLUMN_SCRIPTID, i));
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.confirm();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(BIZAPPID);
        this.getPageCache().remove(CLOUDID);
    }
}

