/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.OperationInfo;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class WorkflowExtItfOperationPlugin
extends AbstractWorkflowPlugin
implements RowClickEventListener {
    private static final String BTN_CONFIRM = "btnok";
    private static final String TAB_OPERATION = "tabap";
    private static final String CTRL_OPERATIONLIST = "operationlist";
    private static final String OPERATIONCODE = "operationcode";
    private static final String OPERATIONNAME = "operationname";
    private static final String OPERATIONTYPE = "operationtype";
    private static final String OPERATIONID = "operationid";
    private static final String CTRL_OPERATIONLIST_WITHDRAW = "operationlist_withdraw";
    private static final String OPERATIONCODE_WITHDRAW = "operationcode_withdraw";
    private static final String OPERATIONNAME_WITHDRAW = "operationname_withdraw";
    private static final String OPERATIONTYPE_WITHDRAW = "operationtype_withdraw";
    private static final String OPERATIONID_WITHDRAW = "operationid_withdraw";
    private static final String LAST_CLICKED_ROW = "clicked_row";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
        EntryGrid operationList = (EntryGrid)this.getControl(CTRL_OPERATIONLIST);
        operationList.addRowClickListener((RowClickEventListener)this);
        operationList = (EntryGrid)this.getControl(CTRL_OPERATIONLIST_WITHDRAW);
        operationList.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object value = parameter.getCustomParam("value");
        this.initOperationList(value);
        this.initControlVisibility(parameter);
    }

    private void initControlVisibility(FormShowParameter parameter) {
        Object operationSingle = parameter.getCustomParam("operationSingle");
        if (Boolean.TRUE.equals(operationSingle)) {
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("hideNav", true);
            this.getView().updateControlMetadata(TAB_OPERATION, data);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object value = parameter.getCustomParam("value");
        if (WfUtils.isNotEmptyString((Object)value)) {
            HashMap data = ExternalInterfaceUtil.castJSONToMap((Object)value);
            this.setSelectedOperation(data.get("forward"), false);
            this.setSelectedOperation(data.get("withdraw"), true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey().toLowerCase();
        if (BTN_CONFIRM.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        if (this.getSelectedOpertion(false) == null && this.getSelectedOpertion(true) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u3002", (String)"WorkflowExtItfOperationPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().returnDataToParent((Object)this.getOperationValue());
            this.getView().close();
        }
    }

    private String getOperationValue() {
        OperationInfo operation = this.getSelectedOpertion(false);
        OperationInfo withdrawOperation = this.getSelectedOpertion(true);
        String name = null;
        String number = null;
        String withdrawName = null;
        String withdrawNumber = null;
        if (operation != null) {
            name = operation.getName();
            number = operation.getNumber();
        }
        if (withdrawOperation != null) {
            withdrawName = withdrawOperation.getName();
            withdrawNumber = withdrawOperation.getNumber();
        }
        return ExternalInterfaceUtil.buildExtItfOperation((String)number, (String)name, withdrawNumber, (String)withdrawName);
    }

    private void initOperationList(Object value) {
        if (this.getModel().getEntryRowCount(CTRL_OPERATIONLIST) > 0) {
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityId = (String)parameter.getCustomParam("entityId");
        if (WfUtils.isEmpty((String)entityId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u6307\u5b9aEntityID\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\u64cd\u4f5c\u5217\u8868\u3002", (String)"WorkflowExtItfOperationPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List operations = metadata.getRootEntity().getOperations();
        Operation operation = null;
        if (operations.isEmpty()) {
            return;
        }
        Collection optionalNumbers = (Collection)parameter.getCustomParam("optionalActions");
        ProcTemplatePluginUtil.filterOptionalDatas(operations, optionalNumbers);
        int count = operations.size();
        model.batchCreateNewEntryRow(CTRL_OPERATIONLIST, count);
        model.batchCreateNewEntryRow(CTRL_OPERATIONLIST_WITHDRAW, count);
        for (int i = 0; i < count; ++i) {
            operation = (Operation)operations.get(i);
            model.setValue(OPERATIONCODE, (Object)operation.getKey(), i);
            model.setValue(OPERATIONNAME, (Object)operation.getName(), i);
            model.setValue(OPERATIONTYPE, (Object)operation.getOperationType(), i);
            model.setValue(OPERATIONID, (Object)operation.getId(), i);
            model.setValue(OPERATIONCODE_WITHDRAW, (Object)operation.getKey(), i);
            model.setValue(OPERATIONNAME_WITHDRAW, (Object)operation.getName(), i);
            model.setValue(OPERATIONTYPE_WITHDRAW, (Object)operation.getOperationType(), i);
            model.setValue(OPERATIONID_WITHDRAW, (Object)operation.getId(), i);
        }
    }

    private OperationInfo getSelectedOpertion(boolean withdraw) {
        IDataModel model = this.getModel();
        DynamicObject rowData = null;
        String gridKey = withdraw ? CTRL_OPERATIONLIST_WITHDRAW : CTRL_OPERATIONLIST;
        String operation = null;
        String name = null;
        EntryGrid grid = (EntryGrid)this.getView().getControl(gridKey);
        int[] selRows = grid.getSelectRows();
        int selectedRow = -1;
        String lastClickedKey = this.getClickedRowCacheKey(gridKey);
        if (selRows.length > 0 && (selRows.length != 1 || selRows[0] != -1)) {
            selectedRow = selRows[0];
        } else if (!"-1".equals(this.getPageCache().get(lastClickedKey)) && WfUtils.isNotEmpty((String)this.getPageCache().get(gridKey))) {
            selectedRow = Integer.parseInt(this.getPageCache().get(gridKey));
        }
        if (selectedRow > -1) {
            rowData = model.getEntryRowEntity(gridKey, selectedRow);
            operation = rowData.getString(withdraw ? OPERATIONCODE_WITHDRAW : OPERATIONCODE);
            name = rowData.getString(withdraw ? OPERATIONNAME_WITHDRAW : OPERATIONNAME);
            return new OperationInfo(operation, name);
        }
        return null;
    }

    private void setSelectedOperation(Object value, boolean withdraw) {
        String girdKey = withdraw ? CTRL_OPERATIONLIST_WITHDRAW : CTRL_OPERATIONLIST;
        EntryGrid grid = (EntryGrid)this.getControl(girdKey);
        if (WfUtils.isEmptyString((Object)value)) {
            grid.selectRows(-1);
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject rowData = null;
        int totalRowCount = model.getEntryRowCount(girdKey);
        for (int i = 0; i < totalRowCount; ++i) {
            rowData = model.getEntryRowEntity(girdKey, i);
            if (!value.equals(rowData.getString(withdraw ? OPERATIONCODE_WITHDRAW : OPERATIONCODE))) continue;
            this.getPageCache().put(girdKey, String.valueOf(i));
            grid.selectRows(i);
            break;
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid grid = (EntryGrid)evt.getSource();
        this.getPageCache().put(this.getClickedRowCacheKey(grid.getKey()), String.valueOf(evt.getRow()));
    }

    private String getClickedRowCacheKey(String gridKey) {
        return String.format("%s;%s", gridKey, LAST_CLICKED_ROW);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(LAST_CLICKED_ROW);
        this.getPageCache().remove(CTRL_OPERATIONLIST);
        this.getPageCache().remove(CTRL_OPERATIONLIST_WITHDRAW);
    }
}

