/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import org.apache.commons.lang.StringUtils;

public class WorkflowExtItfParameterConfigPlugin
extends AbstractWorkflowPlugin {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String BTNOK = "btnok";
    private static final String VALUE_PREFIX = "value_";
    private static final String VALUE_STRING = "value_string";
    private static final String PARAM_NUMBERS = "param_numbers";
    private static final String ENTRA_BILL_ID = "entrabillid";

    public void afterCreateNewData(EventObject e) {
        Object parameter = this.getView().getFormShowParameter().getCustomParam("extItf_parameter_value");
        JSONObject jsonObject = parameter instanceof JSONObject ? (JSONObject)parameter : null;
        this.initParameterConfig(jsonObject);
    }

    private void initParameterConfig(JSONObject parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue(NUMBER, parameter.get((Object)NUMBER));
        model.setValue(NAME, parameter.get((Object)NAME));
        String type = (String)parameter.get((Object)TYPE);
        model.setValue(TYPE, (Object)type);
        this.switchType(type, null);
        model.setValue(this.getControlName(type), parameter.get((Object)VALUE));
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{VALUE_STRING, BTNOK});
    }

    private void switchType(String newType, String oldType) {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{this.getControlName(oldType)});
        view.setVisible(Boolean.TRUE, new String[]{this.getControlName(newType)});
    }

    private String getControlName(String type) {
        if (WfUtils.isEmpty((String)type)) {
            type = "String";
        }
        return String.format("%s%s", VALUE_PREFIX, type.toLowerCase());
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "value_string": {
                this.showBusinessFieldList();
                break;
            }
            case "btnok": {
                this.confirm();
                break;
            }
        }
    }

    private void confirm() {
        String errorTip = this.validate();
        if (errorTip != null) {
            this.getView().showTipNotification(errorTip);
            return;
        }
        JSONObject parameter = this.getReturnData();
        this.getView().returnDataToParent((Object)parameter);
        this.getView().close();
    }

    private String validate() {
        String lang = RequestContext.get().getLang().toString();
        Object paramNumbers = this.getView().getFormShowParameter().getCustomParam(PARAM_NUMBERS);
        Map paramNumbersMap = paramNumbers instanceof Map ? (Map)paramNumbers : new HashMap();
        IDataModel model = this.getModel();
        String number = (String)model.getValue(NUMBER);
        if (WfUtils.isEmpty((String)number)) {
            return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570\u7f16\u7801\u201d\u3002", (String)"WorkflowExtItfParameterConfigPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (!PluginUtil.matchPattern("^[A-Za-z][A-Za-z0-9_]*$", number)) {
            return ResManager.loadKDString((String)"\u201c\u53c2\u6570\u7f16\u7801\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u4f7f\u7528\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"WorkflowExtItfParameterConfigPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (paramNumbersMap.containsKey(number)) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u201c\u53c2\u6570\u7f16\u7801\u201d\u4e0e\u7b2c%s\u884c\u5df2\u6709\u201c\u53c2\u6570\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"WorkflowExtItfParameterConfigPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), (Integer)paramNumbersMap.get(number) + 1);
        }
        ILocaleString localeName = (ILocaleString)model.getValue(NAME);
        if (WfUtils.isEmpty((ILocaleString)localeName)) {
            return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570\u540d\u201d\u3002", (String)"WorkflowExtItfParameterConfigPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (WfUtils.isEmpty((String)((String)localeName.get((Object)lang)))) {
            return ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7cfb\u7edf\u5f53\u524d\u8bed\u79cd\u201c\u53c2\u6570\u540d\u201d\u3002", (String)"WorkflowExtItfParameterConfigPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        String type = (String)model.getValue(TYPE);
        if ("String".equals(type) && WfUtils.isEmpty((String)((String)model.getValue(this.getControlName(type))))) {
            return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u6570\u503c\u201d\u3002", (String)"WorkflowExtItfParameterConfigPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private JSONObject getReturnData() {
        JSONObject parameter = new JSONObject();
        IDataModel model = this.getModel();
        parameter.put(NUMBER, model.getValue(NUMBER));
        parameter.put(NAME, model.getValue(NAME));
        String type = (String)model.getValue(TYPE);
        parameter.put(TYPE, (Object)type);
        parameter.put(VALUE, model.getValue(this.getControlName(type)));
        return parameter;
    }

    private void showBusinessFieldList() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTRA_BILL_ID);
        if (StringUtils.isBlank((String)entityId)) {
            String errorInfo = WFMultiLangConstants.getNodeBillNotNull();
            this.getView().showTipNotification(errorInfo);
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        String caption = ResManager.loadKDString((String)"\u53c2\u6570\u503c\u914d\u7f6e", (String)"WorkflowExtItfParameterConfigPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        parameter.setCaption(caption);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_basedatafieldlist");
        parameter.setCustomParam(ENTRA_BILL_ID, (Object)entityId);
        parameter.setCustomParam("entranceFlag", (Object)"pluginParams");
        Object defaultVal = this.getModel().getValue(VALUE_STRING);
        if (WfUtils.isNotEmptyString((Object)defaultVal)) {
            parameter.setCustomParam(VALUE, defaultVal);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, VALUE_STRING));
        this.getView().showForm(parameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (TYPE.equals(propName)) {
            this.switchType((String)newValue, (String)oldValue);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (VALUE_STRING.equals(actionId)) {
            this.setCloseData(returnData);
        }
    }

    private void setCloseData(Object returnData) {
        if (returnData instanceof List) {
            List configFields = (List)returnData;
            if (WfUtils.isNotEmptyForCollection((Collection)configFields)) {
                StringJoiner parameterValue = new StringJoiner(";");
                configFields.forEach(map -> {
                    String fieldName = (String)map.get(NAME);
                    parameterValue.add(fieldName);
                });
                if (WfUtils.isNotEmptyString((Object)parameterValue.toString())) {
                    this.getModel().setValue(VALUE_STRING, (Object)parameterValue.toString());
                }
            } else {
                this.getModel().setValue(VALUE_STRING, null);
            }
        }
    }
}

