/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import org.apache.commons.lang.StringUtils;

public class WorkflowExtItfParameterPlugin
extends AbstractWorkflowPlugin {
    private static final String PARAMETERS = "parameters";
    private static final String TOOLBAR_BTN = "advcontoolbarap3";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String GLANGUAGE = "glanguage";
    private static final String GLANG_NAME = "glangname";
    private static final String BTNOK = "btnok";
    private static final String ADDBTN = "addbtn";
    private static final String MODIFYBTN = "modifybtn";
    private static final String ENTRA_BILL_ID = "entrabillid";
    private static final String PARAM_NUMBERS = "param_numbers";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String paramsStr = (String)parameter.getCustomParam(VALUE);
        JSONArray jsonArray = JSONArray.parseArray((String)paramsStr);
        this.initParamsList(jsonArray);
    }

    private void initParamsList(JSONArray params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        int size = params.size();
        model.batchCreateNewEntryRow(PARAMETERS, size);
        for (int i = 0; i < size; ++i) {
            JSONObject param = params.getJSONObject(i);
            this.initParamEntryRow(model, param, i);
        }
    }

    private void initParamEntryRow(IDataModel model, JSONObject param, int index) {
        model.setValue(NUMBER, param.get((Object)NUMBER), index);
        model.setValue(GLANGUAGE, param.get((Object)GLANGUAGE), index);
        model.setValue(GLANG_NAME, param.get((Object)GLANG_NAME), index);
        model.setValue(NAME, param.get((Object)NAME), index);
        model.setValue(TYPE, param.get((Object)TYPE), index);
        model.setValue(VALUE, param.get((Object)VALUE), index);
        model.setValue(ID, param.get((Object)ID), index);
    }

    public void registerListener(EventObject e) {
        Toolbar toolbar = (Toolbar)this.getControl(TOOLBAR_BTN);
        toolbar.addItemClickListener((ItemClickListener)this);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String key = e.getEntryProp().getName();
        RowDataEntity data = e.getRowDataEntities()[0];
        switch (key) {
            case "parameters": {
                String id = data.getDataEntity().getString(ID);
                if (WfUtils.isEmpty((String)id)) {
                    id = BpmnDiffUtil.getListElementId((String)"extItfParams");
                }
                data.getDataEntity().set(ID, (Object)id);
                break;
            }
        }
        super.afterAddRow(e);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.confirm();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "addbtn": {
                this.openExtItfParamConfig(ADDBTN);
                break;
            }
            case "modifybtn": {
                this.openExtItfParamConfig(MODIFYBTN);
                break;
            }
        }
    }

    private void confirm() {
        JSONArray params = this.getReturnData();
        if (params != null && params.size() > 0) {
            this.getView().returnDataToParent((Object)params);
        } else {
            this.getView().returnDataToParent((Object)"");
        }
        this.getView().close();
    }

    private JSONArray getReturnData() {
        JSONArray params = null;
        DynamicObjectCollection datas = this.getModel().getEntryEntity(PARAMETERS);
        if (!datas.isEmpty()) {
            params = new JSONArray();
            for (DynamicObject data : datas) {
                JSONObject param = new JSONObject();
                param.put(NUMBER, data.get(NUMBER));
                this.putParamNameGlangValue(param, data);
                param.put(NAME, data.get(NAME));
                param.put(TYPE, data.get(TYPE));
                param.put(VALUE, data.get(VALUE));
                param.put(ID, data.get(ID));
                params.add((Object)param);
            }
        }
        return params;
    }

    private void putParamNameGlangValue(JSONObject param, DynamicObject data) {
        String lang = RequestContext.get().getLang().toString();
        ILocaleString paramLocaleName = (ILocaleString)data.get(NAME);
        String paramNameGLang = data.getString(GLANGUAGE);
        String oldParamNameGLangValue = data.getString(GLANG_NAME);
        if (StringUtils.isNotBlank((String)paramNameGLang) && StringUtils.isNotBlank((String)oldParamNameGLangValue) && !paramNameGLang.equals(lang)) {
            param.put(GLANGUAGE, (Object)paramNameGLang);
            String newParamNameGLangValue = (String)paramLocaleName.get((Object)paramNameGLang);
            if (StringUtils.isNotBlank((String)newParamNameGLangValue)) {
                param.put(GLANG_NAME, (Object)newParamNameGLangValue);
            } else {
                param.put(GLANG_NAME, (Object)oldParamNameGLangValue);
            }
        } else {
            param.put(GLANGUAGE, (Object)lang);
            param.put(GLANG_NAME, paramLocaleName.get((Object)lang));
        }
    }

    private void openExtItfParamConfig(String btnType) {
        JSONObject focusRowParamJson = null;
        Map<String, Integer> paramNumbers = null;
        Integer focusRow = null;
        if (MODIFYBTN.equals(btnType)) {
            if (this.getFocusRowIndex() < 0) {
                StandardTips.view((IFormView)this.getView()).notSelectRow();
                return;
            }
            focusRow = this.getFocusRowIndex();
            focusRowParamJson = this.getFocusRowParamJson();
        }
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        FormShowParameter parameter = new FormShowParameter();
        String caption = ResManager.loadKDString((String)"\u63d2\u4ef6\u53c2\u6570\u914d\u7f6e", (String)"WorkflowExtItfParameterPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        parameter.setCaption(caption);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_extitf_parameterconfig");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, btnType));
        parameter.setCustomParam(ENTRA_BILL_ID, (Object)entityId);
        parameter.setCustomParam("extItf_parameter_value", (Object)focusRowParamJson);
        paramNumbers = this.getAllExistingParamNumbers(focusRow);
        parameter.setCustomParam(PARAM_NUMBERS, paramNumbers);
        this.getView().showForm(parameter);
    }

    private Map<String, Integer> getAllExistingParamNumbers(Integer focusRow) {
        HashMap<String, Integer> paramNumbers = null;
        DynamicObjectCollection datas = this.getModel().getEntryEntity(PARAMETERS);
        if (!datas.isEmpty()) {
            paramNumbers = new HashMap<String, Integer>(datas.size());
            for (int i = 0; i < datas.size(); ++i) {
                if (focusRow != null && i == focusRow) continue;
                DynamicObject data = (DynamicObject)datas.get(i);
                String number = (String)data.get(NUMBER);
                paramNumbers.put(number, i);
            }
        }
        return paramNumbers;
    }

    private JSONObject getFocusRowParamJson() {
        JSONObject focusRowParamJson = null;
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(PARAMETERS).get(this.getFocusRowIndex());
        if (dynamicObject != null) {
            focusRowParamJson = new JSONObject();
            focusRowParamJson.put(NUMBER, dynamicObject.get(NUMBER));
            focusRowParamJson.put(NAME, dynamicObject.get(NAME));
            focusRowParamJson.put(TYPE, dynamicObject.get(TYPE));
            focusRowParamJson.put(VALUE, dynamicObject.get(VALUE));
        }
        return focusRowParamJson;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (ADDBTN.equals(actionId)) {
            this.addOneRowParameter(returnData);
        } else if (MODIFYBTN.equals(actionId)) {
            this.modifyFocusRowParameter(returnData);
        }
    }

    private void addOneRowParameter(Object returnData) {
        this.setOneRowParameter(returnData, this.getModel().createNewEntryRow(PARAMETERS));
    }

    private void modifyFocusRowParameter(Object returnData) {
        this.setOneRowParameter(returnData, this.getFocusRowIndex());
    }

    private void setOneRowParameter(Object returnData, int index) {
        if (returnData instanceof JSONObject) {
            JSONObject param = (JSONObject)returnData;
            IDataModel model = this.getModel();
            model.setValue(NUMBER, param.get((Object)NUMBER), index);
            model.setValue(NAME, param.get((Object)NAME), index);
            String type = (String)param.get((Object)TYPE);
            model.setValue(TYPE, (Object)type, index);
            Object value = param.get((Object)VALUE);
            if ("BigDecimal".equals(type) && value instanceof BigDecimal) {
                BigDecimal bigDecimalValue = ((BigDecimal)value).stripTrailingZeros();
                model.setValue(VALUE, (Object)bigDecimalValue, index);
            } else {
                model.setValue(VALUE, value, index);
            }
        }
    }

    private int getFocusRowIndex() {
        return ((EntryGrid)this.getControl(PARAMETERS)).getEntryState().getFocusRow();
    }
}

