/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bizflow.graph.handler.CardLinkManager;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.WorkflowViewBPMFlowchartPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowFloatLayerPlugin
extends AbstractWorkflowPlugin
implements RowClickEventListener {
    private static final String PROCINSTID = "procInstId";
    private static final String HISTORICACTIVITYINSTANCEID = "hiactinstid";
    private static final String VALUE = "value";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BUSINESSKEY = "businesskey";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String APPID = "appid";
    private static final String NUMBER = "number";
    private static final String BILLNUM = "billnum";
    private static final String SHOWALL = "showall";
    private static final String LABELAP = "labelap";

    public void registerListener(EventObject e) {
        EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRYENTITY);
        entryEntity.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{BILLNUM, SHOWALL});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BILLNUM.equals(key) || SHOWALL.equals(key)) {
            this.showStackedBills();
        }
    }

    private void showStackedBills() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object procInstIdStr = params.get(PROCINSTID);
        if (WfUtils.isJSONObject(procInstIdStr)) {
            return;
        }
        Long procInstId = Long.valueOf((String)procInstIdStr);
        String cellId = (String)params.get("cellId");
        List<Map<String, String>> datas = this.getEntryGridData(procInstId, cellId);
        List<Map<String, String>> retData = this.checkPermission(datas);
        String entityNumber = null;
        ArrayList<String> ids = new ArrayList<String>(retData.size());
        for (Map<String, String> data : retData) {
            ids.add(data.get(BUSINESSKEY));
            if (!WfUtils.isEmpty(entityNumber)) continue;
            entityNumber = data.get(ENTITYNUMBER);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType(entityNumber);
        String title = entityType.getDisplayName().getLocaleValue();
        boolean hasParent = false;
        IFormView view = this.getView();
        if (view.getParentView() != null) {
            hasParent = true;
            view = view.getParentView();
        }
        new CardLinkManager().clickShowBillListLink(view, title, entityNumber, ids);
        if (hasParent) {
            this.getView().sendFormAction(view);
        }
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object procInstIdStr = params.get(PROCINSTID);
        if (WfUtils.isJSONObject(procInstIdStr)) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 2);
            return;
        }
        Long procInstId = Long.valueOf((String)procInstIdStr);
        String cellId = (String)params.get("cellId");
        this.updateNodeNameByPocInstIdAndCellId(procInstId, cellId);
        this.updateEntryGridByPocInstId(procInstId, cellId);
    }

    private void updateEntryGridByPocInstId(Long procInstId, String cellId) {
        List<Map<String, String>> datas = this.getEntryGridData(procInstId, cellId);
        List<Map<String, String>> retData = this.checkPermission(datas);
        if (!retData.isEmpty()) {
            this.updateEntryGridData(retData);
            Label billNumLabel = (Label)this.getView().getControl(BILLNUM);
            if (retData.size() <= 10) {
                billNumLabel.setText(String.format(ResManager.loadKDString((String)"\u5171 %s \u5f20", (String)"WorkflowFloatLayerPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), retData.size()));
                this.getView().setVisible(Boolean.FALSE, new String[]{SHOWALL, LABELAP});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{SHOWALL, LABELAP});
                this.getView().setVisible(Boolean.FALSE, new String[]{BILLNUM});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"lockflex"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "flexpanelap3"});
        }
    }

    private List<Map<String, String>> getEntryGridData(Long procInstId, String cellId) {
        BpmnModel bpmnModel = this.getRepositoryService().getBpmnModel(null, procInstId);
        FlowElement flowElement = bpmnModel.getFlowElement(cellId);
        String floatLayerBillSummary = this.getFloatLayerBillSummary(flowElement);
        if (WfUtils.isEmpty((String)floatLayerBillSummary)) {
            this.showBlankPage();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8282\u70b9\u4e0a\u7684\u201c\u4e1a\u52a1\u6d41\u6d6e\u52a8\u5c42\u5355\u636e\u6458\u8981\u201d\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WorkflowFloatLayerPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return new ArrayList<Map<String, String>>();
        }
        QFilter qfilter = new QFilter(NUMBER, "=", (Object)floatLayerBillSummary);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_mbillsummary_cfg", (String)"id", (QFilter[])new QFilter[]{qfilter});
        if (dynamicObject == null) {
            this.showBlankPage();
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8282\u70b9\u4e0a\u914d\u7f6e\u7684\u201c\u4e1a\u52a1\u6d41\u6d6e\u52a8\u5c42\u5355\u636e\u6458\u8981\u201d\u201c%s\u201d\u662f\u5426\u5b58\u5728\u3002", (String)"WorkflowFloatLayerPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), floatLayerBillSummary));
            return new ArrayList<Map<String, String>>();
        }
        long id = dynamicObject.getLong("id");
        return this.initFloatLayerData(id, procInstId, cellId);
    }

    private void showBlankPage() {
        Label billNumLabel = (Label)this.getView().getControl(BILLNUM);
        billNumLabel.setText(String.format(ResManager.loadKDString((String)"\u5171 %s \u5f20", (String)"WorkflowFloatLayerPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), 0));
        this.getView().setVisible(Boolean.FALSE, new String[]{"lockflex"});
    }

    private List<Map<String, String>> initFloatLayerData(long billSummaryId, Long procInstId, String cellId) {
        DynamicObject billSummary = BusinessDataServiceHelper.loadSingle((Object)billSummaryId, (String)"wf_mbillsummary_cfg");
        DynamicObjectCollection configFields = (DynamicObjectCollection)billSummary.get(ENTRYENTITY);
        List filterEntityNumbers = ViewFlowchartUtil.getFilterEntityNumbers((Long)procInstId, (String)cellId);
        List historicActivityInstanceEntities = this.getHistoryService().getHistoricActivityByProcessInstanceIdAndActivityId(procInstId, cellId);
        Map<Object, DynamicObject> objectDynamicObjectMap = this.getAllBillInfos(filterEntityNumbers, historicActivityInstanceEntities);
        int size = historicActivityInstanceEntities.size();
        HashMap<String, String> appIdMap = new HashMap<String, String>(size);
        Map<Object, Set<String>> canNotReadFieldMap = this.collectCanNotReadFields(historicActivityInstanceEntities, appIdMap);
        ArrayList<String> businesskeys = new ArrayList<String>(size);
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>(size);
        for (HistoricActivityInstanceEntity hactinst : historicActivityInstanceEntities) {
            String businessKey = hactinst.getBusinessKey();
            String entityNumber = hactinst.getEntityNumber();
            if (!filterEntityNumbers.contains(entityNumber) || businesskeys.contains(businessKey) || objectDynamicObjectMap.isEmpty()) continue;
            businesskeys.add(businessKey);
            HashMap<String, String> data = new HashMap<String, String>();
            try {
                DynamicObject billInfo = objectDynamicObjectMap.get(Long.valueOf(businessKey));
                BusinessModelVariableScope scope = new BusinessModelVariableScope(businessKey, entityNumber);
                Set<String> canNotReadFieldSet = canNotReadFieldMap.get(Long.valueOf(businessKey));
                for (int i = 0; i < configFields.size(); ++i) {
                    DynamicObject configField = (DynamicObject)configFields.get(i);
                    String showContent = Optional.ofNullable(configField.getLocaleString("showcontent_mul")).map(Object::toString).orElseGet(() -> "");
                    if (WfUtils.isEmpty((String)showContent)) {
                        showContent = configField.getString("showcontent");
                    }
                    if (WfUtils.isEmpty((String)showContent)) {
                        showContent = String.format("{%s}", configField.get("fieldkey"));
                    }
                    showContent = BizFlowGraphUtil.getExpressionWithCanNotReadFields((String)showContent, canNotReadFieldSet);
                    String suggestionParser = this.getTaskService().contentParser(showContent, billInfo, (VariableScope)scope, true);
                    data.put(VALUE + i, suggestionParser);
                }
            }
            catch (Exception e) {
                this.logger.debug(String.format("bizflow---floatLayer---bill:%s(%s) is not exist:%s", entityNumber, businessKey, e));
                continue;
            }
            data.put(HISTORICACTIVITYINSTANCEID, String.valueOf(hactinst.getId()));
            data.put(BUSINESSKEY, businessKey);
            data.put(ENTITYNUMBER, entityNumber);
            data.put(APPID, (String)appIdMap.get(entityNumber));
            datas.add(data);
        }
        return datas;
    }

    private Map<Object, Set<String>> collectCanNotReadFields(List<HistoricActivityInstanceEntity> historicActivityInstanceEntities, Map<String, String> appIdMap) {
        int size = historicActivityInstanceEntities.size();
        HashMap<String, ArrayList<Long>> entityBusMap = new HashMap<String, ArrayList<Long>>(size);
        for (HistoricActivityInstanceEntity hactinst : historicActivityInstanceEntities) {
            String businessKey = hactinst.getBusinessKey();
            String entityNumber = hactinst.getEntityNumber();
            ArrayList<Long> businessKeyList = (ArrayList<Long>)entityBusMap.get(entityNumber);
            if (businessKeyList == null) {
                businessKeyList = new ArrayList<Long>(size);
            }
            businessKeyList.add(Long.valueOf(businessKey));
            entityBusMap.put(entityNumber, businessKeyList);
        }
        PermissionService permissionService = (PermissionService)kd.bos.service.ServiceFactory.getService(PermissionService.class);
        long currUserId = RequestContext.get().getCurrUserId();
        HashMap<Object, Set<String>> canNotReadFields = new HashMap<Object, Set<String>>(size);
        for (Map.Entry entry : entityBusMap.entrySet()) {
            String entityNumber = (String)entry.getKey();
            String appId = this.getAppId(entityNumber);
            appIdMap.put(entityNumber, appId);
            List ids = (List)entry.getValue();
            canNotReadFields.putAll(BizFlowGraphUtil.getCanNotReadFields((PermissionService)permissionService, (long)currUserId, (String)appId, (String)entityNumber, (List)ids, (boolean)true));
        }
        return canNotReadFields;
    }

    private Map<Object, DynamicObject> getAllBillInfos(List<String> filterEntityNumbers, List<HistoricActivityInstanceEntity> historicActivityInstanceEntities) {
        Object[] pkArray = new Object[historicActivityInstanceEntities.size()];
        int i = 0;
        for (HistoricActivityInstanceEntity hactinst : historicActivityInstanceEntities) {
            String businessKey = hactinst.getBusinessKey();
            String entityNumber = hactinst.getEntityNumber();
            if (!filterEntityNumbers.contains(entityNumber)) continue;
            pkArray[i] = Long.valueOf(businessKey);
            ++i;
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])pkArray, (String)filterEntityNumbers.get(0));
    }

    private List<Map<String, String>> checkPermission(List<Map<String, String>> datas) {
        ArrayList<Map<String, String>> retData = new ArrayList<Map<String, String>>(datas.size());
        if (datas.isEmpty()) {
            return retData;
        }
        HashMap billIdMap = new HashMap(datas.size());
        HashMap<String, String> appIdMap = new HashMap<String, String>(datas.size());
        for (Map<String, String> data : datas) {
            String entityNumber = data.get(ENTITYNUMBER);
            if (billIdMap.get(entityNumber) == null) {
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(Long.valueOf(data.get(BUSINESSKEY)));
                billIdMap.put(entityNumber, ids);
            } else {
                ((List)billIdMap.get(entityNumber)).add(Long.valueOf(data.get(BUSINESSKEY)));
            }
            String appId = data.get(APPID);
            appIdMap.put(entityNumber, appId);
        }
        PermissionService permissionService = (PermissionService)kd.bos.service.ServiceFactory.getService(PermissionService.class);
        long currUserId = RequestContext.get().getCurrUserId();
        HashMap dataPermission = new HashMap(datas.size());
        for (Map.Entry entry : billIdMap.entrySet()) {
            String entityNumber = (String)entry.getKey();
            List ids = (List)billIdMap.get(entityNumber);
            String appId = (String)appIdMap.get(entityNumber);
            Map ret = BizFlowGraphUtil.checkPermission((PermissionService)permissionService, (Long)currUserId, (String)appId, (String)entityNumber, (List)ids);
            this.logger.debug(String.format("user: %s, appId: %s, entityNumber: %s, has view permission: %s", currUserId, appId, entityNumber, ret));
            dataPermission.putAll(ret);
        }
        for (Map map : datas) {
            Long businessKey = Long.valueOf((String)map.get(BUSINESSKEY));
            if (!((Boolean)dataPermission.get(businessKey)).booleanValue()) continue;
            retData.add(map);
        }
        return retData;
    }

    private String getFloatLayerBillSummary(FlowElement flowElement) {
        String floatLayerBillSummary = null;
        if (flowElement instanceof UserTask) {
            floatLayerBillSummary = ((UserTask)flowElement).getFloatLayerBillSummary();
        } else if (flowElement instanceof CallActivity) {
            floatLayerBillSummary = ((CallActivity)flowElement).getFloatLayerBillSummary();
        }
        return floatLayerBillSummary;
    }

    private void updateEntryGridData(List<Map<String, String>> datas) {
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, datas.size());
        for (int i = 0; i < datas.size(); ++i) {
            Map<String, String> data = datas.get(i);
            for (int j = 0; j < data.size() && this.getControl(VALUE + j) != null; ++j) {
                this.getModel().setValue(VALUE + j, (Object)data.get(VALUE + j), i);
            }
            this.getModel().setValue(HISTORICACTIVITYINSTANCEID, (Object)data.get(HISTORICACTIVITYINSTANCEID), i);
        }
    }

    private void updateNodeNameByPocInstIdAndCellId(Long procInstId, String cellId) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        BpmnModel bpmnModel = wfService.getRepositoryService().getBpmnModel(null, procInstId);
        String nodeName = bpmnModel.getFlowElement(cellId).getName();
        Label nodeNameLabel = (Label)this.getView().getControl("nodename");
        nodeNameLabel.setText(nodeName);
    }

    public void entryRowClick(RowClickEvent evt) {
        int index = evt.getRow();
        String historicActivityInstanceId = (String)this.getModel().getValue(HISTORICACTIVITYINSTANCEID, index);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object procInstIdStr = params.get(PROCINSTID);
        if (WfUtils.isJSONObject(procInstIdStr)) {
            return;
        }
        String procInstId = String.valueOf(procInstIdStr);
        IFormView view = this.getView().getParentView();
        this.logger.debug("WorkflowFloatLayerPlugin getEntityId:" + view.getEntityId());
        FormViewPluginProxy proxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        List plugins = proxy.getPlugIns();
        this.logger.debug("plugins size:" + plugins.size());
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof WorkflowViewBPMFlowchartPlugin)) continue;
            this.logger.debug("WorkflowFloatLayerPlugin iFormPlugin:" + plugin.getPluginName());
            ((WorkflowViewBPMFlowchartPlugin)plugin).updateBillSummaryAndApprovalRecored(procInstId, historicActivityInstanceId);
            this.getView().sendFormAction(view);
            break;
        }
    }

    private String getAppId(String entityNumber) {
        String appId = this.getView().getFormShowParameter().getAppId();
        return BizFlowGraphUtil.getAppId((String)entityNumber, (String)appId);
    }
}

