/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricConditionalRuleEntity;

public class WorkflowHistoricCondRulePlugin
extends AbstractWorkflowPlugin {
    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String condRuleId = (String)parameter.getCustomParam("condruleid");
        String type = (String)parameter.getCustomParam("type");
        String processName = (String)parameter.getCustomParam("processName");
        String processVersion = (String)parameter.getCustomParam("processVersion");
        String node = (String)parameter.getCustomParam("node");
        model.setValue("type", (Object)type);
        model.setValue("process", (Object)processName);
        model.setValue("processversion", (Object)processVersion);
        model.setValue("node", (Object)node);
        this.getView().setVisible(Boolean.FALSE, new String[]{"node"});
        if (condRuleId == null) {
            return;
        }
        List rules = this.getRepositoryService().getHistoricConditionalRules(Long.valueOf(condRuleId));
        if (rules != null && !rules.isEmpty()) {
            int size = rules.size();
            if (size <= 1) {
                return;
            }
            int[] indexes = model.batchCreateNewEntryRow("entryentity", size - 1);
            HistoricConditionalRuleEntity rule = null;
            int index = 0;
            String expression = null;
            for (int i = 1; i < size; ++i) {
                index = indexes[i - 1];
                rule = (HistoricConditionalRuleEntity)rules.get(i);
                expression = WfUtils.isNotEmpty((String)rule.getPlugin()) ? rule.getPlugin() : rule.getExpression();
                model.setValue("validtime", (Object)rule.getValidtime(), index);
                model.setValue("invalidtime", (Object)rule.getInvalidTime(), index);
                model.setValue("showtext", (Object)rule.getShowtext(), index);
                model.setValue("expression", (Object)expression, index);
                model.setValue("modifier", (Object)rule.getModifierId(), index);
                model.setValue("modifydate", (Object)rule.getModifyDate(), index);
                model.setValue("description", (Object)rule.getDescription(), index);
            }
        }
    }
}

