/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.IListView;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowListPlugin;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.basedata.BaseDataRefRecordEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.KeyAuditorEntity;

public class WorkflowKeyAuditorListPlugin
extends AbstractWorkflowListPlugin {
    private static final String QUERY = "query";
    private static final String KEYAUDITOR = "keyauditor";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{QUERY});
    }

    public void itemClick(ItemClickEvent evt) {
        if (QUERY.equals(evt.getItemKey())) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_keyauditor", (String)"47150e89000000ac")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u67e5\u8be2\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowKeyAuditorListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseChangeLogsUtil.queryLog(this.getView(), KEYAUDITOR);
        }
    }

    public void click(EventObject evt) {
        System.out.println();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ((args.getSource() instanceof Delete || args.getSource() instanceof StatusConvert) && args.getOperationResult().isSuccess()) {
            BaseChangeLogsUtil.addChangeLog(this.getView(), args.getSource(), KEYAUDITOR);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete) {
            BaseChangeLogsUtil.putBaseArrayCache(this.getView(), "wf_keyauditor");
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            StringBuilder refTip = new StringBuilder();
            for (int i = 0; i < rows.size(); ++i) {
                Long roleId = (Long)rows.get(i).getPrimaryKeyValue();
                List entities = this.getManagementService().getBaseDataRefEntities("WorkflowKeyAuditor", roleId);
                if (!WfUtils.isNotEmptyForCollection((Collection)entities)) continue;
                args.setCancel(true);
                KeyAuditorEntity roleEntity = (KeyAuditorEntity)this.getRepositoryService().findEntityById(roleId, "wf_keyauditor", "name");
                if (roleEntity == null) continue;
                String roleName = roleEntity.getName().toString();
                StringBuilder tip = new StringBuilder();
                tip.append(roleName).append(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u6570\u636e\u5df2\u88ab\u5f15\u7528\u3002", (String)"WorkflowKeyAuditorListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5b58\u5728\u8be5\u5f15\u7528\u7684\u6d41\u7a0b\uff1a", (String)"WorkflowKeyAuditorListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                HashSet<String> procNums = new HashSet<String>(16);
                for (BaseDataRefRecordEntity entity : entities) {
                    String procNum = entity.getProcnum();
                    if (!procNums.contains(procNum)) {
                        tip.append(entity.getProcnum()).append("\uff1b");
                    }
                    procNums.add(procNum);
                }
                refTip.append((CharSequence)tip).append("\n");
            }
            if (refTip.length() > 0) {
                this.getView().showTipNotification(refTip.toString(), Integer.valueOf(8000));
            }
        }
    }
}

