/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.design.plugin.ExportModelSQLUtil;
import kd.bos.workflow.design.plugin.event.AfterExportProcessEvent;
import kd.bos.workflow.design.plugin.event.AfterImportProcessEvent;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.design.util.WFModelManagerUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.validation.validator.impl.BpmnModelValidator;
import org.apache.commons.io.FilenameUtils;

public class WorkflowModelManagePlugin
extends AbstractListPlugin
implements ClickListener,
IConfirmCallBack {
    protected static Log logger = LogFactory.getLog(WorkflowModelManagePlugin.class);
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String MESSAGE = "message";
    private static final String VERSION = "version";
    private static final String NUMBER = "number";
    private static final String WF_MODEL = "wf_model";
    private static final String DUPLICATE = "duplicate";
    private static final String OPERATION_CREATEBYTEMPLATE = "createbytemplate";
    private static final String BTN_IMPORTJSON = "importjson";
    private static final String BAR_EXPORTSQL = "barexportsql";
    private static final String BAREXIT = "barexit";
    private static final String BAR_REFRESH = "barrefresh";
    private static final String BAR_PUBLISH = "barpublish";
    private static final String BAR_ADDNEW = "baraddnew";
    private static final String BAR_DELETE = "bardelete";
    private static final String BAR_EDIT = "baredit";
    private static final String BAR_IMPORT_MODEL = "barimportmodel";
    private static final String BAR_EXPORT_MODEL = "barexportmodel";
    private static final String PROCATEGORY = "procategory";
    private static final String DISCARD = "discard";
    private static final String START = "start";
    private static final String ID = "id";
    private static final String OK = "ok";
    protected static final String OPERATE_NEW = "new";
    private static final String MODEL_ID_ARR = "modelIdArr";
    private static final String MODEL_DELETE_CALL_BACK = "modelDeleteCallBack";
    private static final String MODEL_PUBLISH_ALL_CALL_BACK = "modelPublishAllCallBack";
    private static final String MODEL_PUBLISH_CALL_BACK = "modelPublishCallBack";
    protected static final String MODEL_WINDOW_CLOSE = "modelWindowClose";
    private static final String WF_IMPORT = "wf_import";
    private static final String WF_MODEL_WIZARD = "wf_modelwizard";
    private static final String WF_MODEL_WIZARD_DUPLICATE = "wf_modelwizardduplicate";
    private static final String publishConfirmFormId = "wf_modeldeploymentconfirm";
    private static final String publishConfirmAllFormId = "wf_modelsdeployment";
    private static final String WF_MODIFYEXPORTFILENAME = "wf_modifyexportfilename";
    private final String OPENED_DESIGNER_IDS = "designer_ids";
    private boolean isSucessExport = true;
    private final String FIELD_KEY = "key";
    private static final String KEY_WFDESIGNER = "wfdesigner";

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getView().getControl("billlistap");
        list.setOrderBy("modifydate desc");
    }

    protected void setDefaultFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("type", "=", (Object)ModelType.AuditFlow.name()));
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.setDefaultFilter(e);
        WfAdminUtil.addWfOrgFilter((SetFilterEvent)e, (String)WF_MODEL);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        super.listRowDoubleClick(evt);
        this.openDesginerUseRowDoubleClick(evt);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        this.disableButton();
    }

    private void disableButton() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows.size() > 0) {
            Long pkid = (Long)selectedRows.get(0).getPrimaryKeyValue();
            QFilter filter1 = new QFilter(ID, "=", (Object)pkid);
            QFilter[] qFilter = new QFilter[]{filter1};
            DynamicObject[] results = BusinessDataServiceHelper.load((String)WF_MODEL, (String)DISCARD, (QFilter[])qFilter);
            if (results.length > 0) {
                if (results[0].getBoolean(DISCARD)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{START});
                    this.getView().setEnable(Boolean.FALSE, new String[]{DISCARD});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{START});
                    this.getView().setEnable(Boolean.TRUE, new String[]{DISCARD});
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!Lang.get().equals((Object)Lang.zh_CN) && !WfConfigurationUtil.isEnableOtherLang().booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_ADDNEW, BAR_EDIT, BAR_DELETE});
        }
        PluginUtil.setControlInvisible(this.getView(), "moelexit");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (WfAdminUtil.controlBtnByAdmin((Long)userId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BAR_ADDNEW, DUPLICATE, BAR_EDIT, BAR_DELETE, BAR_PUBLISH, "export", BAR_EXPORTSQL, BAR_IMPORT_MODEL, BAR_EXPORT_MODEL, PROCATEGORY, DISCARD, START});
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        switch (e.getActionId()) {
            case "modelWindowClose": {
                this.refresh();
                break;
            }
            case "modelPublishCallBack": 
            case "modelPublishAllCallBack": {
                if (!OK.equals(e.getReturnData())) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"WorkflowModelManagePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                this.refresh();
                break;
            }
            case "modelDeleteCallBack": {
                if (!OK.equals(e.getReturnData())) break;
                this.deleteModels();
                break;
            }
            case "wf_import": {
                if (e.getReturnData() == null) break;
                List processNumbers = (List)e.getReturnData();
                if (WfUtils.isNotEmptyForCollection((Collection)processNumbers)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"WorkflowModelManagePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    this.refresh();
                    this.fireAfterImportProcess(processNumbers, KEY_WFDESIGNER);
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002", (String)"WorkflowModelManagePlugin_53", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                break;
            }
            case "wf_modifyexportfilename": {
                this.packedZipAndExportFile(e);
                break;
            }
        }
    }

    private void packedZipAndExportFile(ClosedCallBackEvent closedCallBackEvent) {
        ArrayList<String> processNumbers;
        StringBuilder logStr;
        ListSelectedRowCollection rows;
        block55: {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            String filename = (String)closedCallBackEvent.getReturnData();
            rows = ((IListView)this.getView()).getSelectedRows();
            logStr = new StringBuilder();
            String path = System.getProperty("user.home") + File.separator + "KINGDEEDOWNLOAD" + File.separator + "workflow0";
            String localPath = FilenameUtils.normalize((String)(path + File.separator + WfUtils.now().getTime()));
            File localFile = new File(FilenameUtils.getName((String)localPath));
            if (!localFile.exists()) {
                localFile.mkdirs();
            }
            String zipFilename = filename + ".zip";
            String fullPath = WfUtils.checkPath((String)(localPath + File.separator + zipFilename));
            File zipFile = new File(FilenameUtils.getName((String)fullPath));
            processNumbers = new ArrayList<String>(rows.size());
            try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
                for (ListSelectedRow row : rows) {
                    long id = (Long)row.getPrimaryKeyValue();
                    String processNumber = row.getNumber();
                    processNumbers.add(processNumber);
                    DeployFile deployFile = this.getRepositoryService().getDeployModel(id);
                    if (deployFile == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u90e8\u7f72\u6d41\u7a0b\u6a21\u578b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowModelManagePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DeployFile df = deployFile;
                    String content = df.getFileContent();
                    String fileName = df.getFileName();
                    try (BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));){
                        ZipEntry entry = new ZipEntry(fileName);
                        entry.setMethod(8);
                        out.putNextEntry(entry);
                        int n = 0;
                        byte[] buf = new byte[1024];
                        while ((n = in.read(buf)) != -1) {
                            out.write(buf, 0, n);
                        }
                    }
                    catch (Exception e) {
                        logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                        throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("Error:%s. sql:%s", e.getMessage(), "exportModel")});
                    }
                    logStr.append(deployFile.getFileName()).append('(').append(id).append(")\u3001");
                }
                logStr.deleteCharAt(logStr.length() - 1);
            }
            catch (IOException e) {
                if (localFile.exists()) {
                    ExportModelSQLUtil.deleteFile(localFile);
                }
                throw new RuntimeException(e);
            }
            String downloadFile = WfUtils.checkPath((String)(localPath + File.separator + zipFilename));
            try {
                FileInputStream in = new FileInputStream(FilenameUtils.getName((String)downloadFile));
                Object object = null;
                try {
                    String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipFilename, (InputStream)in, 5000);
                    this.getView().openUrl(url);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        if (object != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
            catch (IOException e) {
                logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                this.getView().showErrorNotification(e.getMessage());
                if (!localFile.exists()) break block55;
                ExportModelSQLUtil.deleteFile(localFile);
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"WorkflowModelManagePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        if (WfUtils.isNotEmptyForCollection(processNumbers)) {
            this.fireAfterExportProcess(processNumbers, KEY_WFDESIGNER);
        }
        WfUtils.addOpLogByAppId((String)this.getView().getFormShowParameter().getAppId(), (String)WF_MODEL, (String)"export", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u51fa\u6d41\u7a0b", "WorkflowModelManagePlugin_7", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5171\u5bfc\u51fa%1$s\u4e2a\u6d41\u7a0b\uff1a%2$s", "WorkflowModelManagePlugin_38", "bos-wf-formplugin"), (Object[])new Object[]{rows.size(), logStr.toString()});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "modelDeleteCallBack": {
                this.deleteModels();
                break;
            }
            case "discard": {
                this.realDiscardProcess();
                break;
            }
            case "start": {
                this.realStartProcess();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evtArgs) {
        super.afterDoOperation(evtArgs);
        String operateKey = evtArgs.getOperateKey();
        if (OPERATION_CREATEBYTEMPLATE.equals(operateKey)) {
            this.createByTemplate();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "duplicate": {
                this.duplicateModel();
                break;
            }
            case "baredit": {
                this.openDesigner();
                break;
            }
            case "barpublish": {
                this.publishModelConfirm();
                break;
            }
            case "barrefresh": {
                this.refresh();
                break;
            }
            case "barexit": {
                this.getView().close();
                break;
            }
            case "barexportsql": {
                this.exportModelSQL();
                break;
            }
            case "importjson": {
                this.importJson();
                break;
            }
            case "barexportmodel": {
                this.exportModel();
                break;
            }
            case "barimportmodel": {
                this.showImportForm();
                break;
            }
            case "procategory": {
                this.showProcessCategory();
                break;
            }
            case "discard": {
                this.discadProcess();
                break;
            }
            case "start": {
                this.startProcess();
                break;
            }
        }
    }

    private void createByTemplate() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_modelwizardbytemplate");
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    private void startProcess() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"4715a0df000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6062\u590d\u6d41\u7a0b\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_50", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() == 0) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        String information = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u6062\u590d\u9009\u4e2d\u7684%s\u6761\u6570\u636e\u5417?", (String)"WorkflowModelManagePlugin_43", (String)"bos-wf-formplugin", (Object[])new Object[0]), rows.size());
        this.getView().showConfirm(information, MessageBoxOptions.YesNo, new ConfirmCallBackListener(START));
    }

    private void realStartProcess() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        DynamicObject[] processes = new DynamicObject[rows.size()];
        StringBuilder logStr = new StringBuilder();
        for (int i = 0; i < rows.size(); ++i) {
            Long id = (Long)rows.get(i).getPrimaryKeyValue();
            QFilter f1 = new QFilter(ID, "=", (Object)id);
            QFilter[] filters = new QFilter[]{f1};
            DynamicObject[] process = BusinessDataServiceHelper.load((String)WF_MODEL, (String)(id + " ,discard"), (QFilter[])filters);
            process[0].set(DISCARD, (Object)0);
            processes[i] = process[0];
            logStr.append(id).append(",");
        }
        Object[] result = SaveServiceHelper.save((DynamicObject[])processes);
        if (result.length == rows.size()) {
            IListView listView = (IListView)this.getView();
            listView.getTreeListView().refreshTreeView();
            listView.refresh();
            listView.clearSelection();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6062\u590d\u6210\u529f\u3002", (String)"WorkflowModelManagePlugin_40", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            logStr.deleteCharAt(logStr.length() - 1);
            WfUtils.addOpLogByAppId((String)this.getView().getFormShowParameter().getAppId(), (String)WF_MODEL, (String)START, (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u6062\u590d", "WorkflowModelManagePlugin_58", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u6062\u590d\u6210\u529f\uff0c\u6062\u590d\u6d41\u7a0b\u7684Id\uff1a[%s]", "WorkflowModelManagePlugin_59", "bos-wf-formplugin"), (Object[])new Object[]{logStr.toString()});
        }
    }

    private void discadProcess() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"4715a0df000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5e9f\u5f03\u6d41\u7a0b\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_49", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() == 0) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        String information = String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5e9f\u5f03\u9009\u4e2d\u7684%s\u6761\u6570\u636e\u5417?", (String)"WorkflowModelManagePlugin_41", (String)"bos-wf-formplugin", (Object[])new Object[0]), rows.size());
        this.getView().showConfirm(information, MessageBoxOptions.YesNo, new ConfirmCallBackListener(DISCARD));
    }

    private void realDiscardProcess() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        DynamicObject[] processes = new DynamicObject[rows.size()];
        StringBuilder logStr = new StringBuilder();
        for (int i = 0; i < rows.size(); ++i) {
            String id = rows.get(i).getPrimaryKeyValue().toString();
            DynamicObject process = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)WF_MODEL));
            process.set(ID, (Object)id);
            process.set(DISCARD, (Object)Boolean.TRUE);
            processes[i] = process;
            logStr.append(id).append(",");
        }
        SaveServiceHelper.update((DynamicObject[])processes);
        IListView listView = (IListView)this.getView();
        listView.getTreeListView().refreshTreeView();
        listView.refresh();
        listView.clearSelection();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5e9f\u5f03\u6210\u529f\u3002", (String)"WorkflowModelManagePlugin_42", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        logStr.deleteCharAt(logStr.length() - 1);
        WfUtils.addOpLogByAppId((String)this.getView().getFormShowParameter().getAppId(), (String)WF_MODEL, (String)DISCARD, (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u5e9f\u5f03", "WorkflowModelManagePlugin_56", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u5e9f\u5f03\u6210\u529f\uff0c\u5e9f\u5f03\u6d41\u7a0b\u7684Id\uff1a[%s]", "WorkflowModelManagePlugin_57", "bos-wf-formplugin"), (Object[])new Object[]{logStr.toString()});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            args.setCancel(true);
            return;
        }
        super.beforeDoOperation(args);
        String oprationKey = ((FormOperate)args.getSource()).getOperateKey();
        if (OPERATE_NEW.equals(oprationKey)) {
            this.openModelWindow(WF_MODEL_WIZARD, ResManager.loadKDString((String)"\u65b0\u589e\u5ba1\u6279\u6d41", (String)"WorkflowModelManagePlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), null, null);
            args.cancel = true;
        } else if ("delete".equals(oprationKey)) {
            this.deleteModelConfirm();
            args.setCancel(true);
        }
    }

    private void showProcessCategory() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"4715a0df000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u91cd\u65b0\u8bbe\u7f6e\u6d41\u7a0b\u7c7b\u522b\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_48", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)this.getView().getFormShowParameter().getAppId(), (String)WF_MODEL, (String)PROCATEGORY, (MultiLangEnumBridge)new MultiLangEnumBridge("\u91cd\u65b0\u8bbe\u7f6e\u6d41\u7a0b\u7c7b\u522b", "WorkflowModelManagePlugin_68", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7528\u6237\u201c%s\u201d\u6ca1\u6709\u201c\u91cd\u65b0\u8bbe\u7f6e\u6d41\u7a0b\u7c7b\u522b\u201d\u7684\u6743\u9650\u3002", "WorkflowModelManagePlugin_69", "bos-wf-formplugin"), (Object[])new Object[]{RequestContext.get().getCurrUserId()});
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() == 0) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            idList.add((Long)rows.get(i).getPrimaryKeyValue());
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_procategory");
        parameter.setCustomParam("idList", idList);
        this.getView().showForm(parameter);
    }

    private void showImportForm() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"4730fc9f000003ae")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u5bfc\u5165\u201d\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(WF_IMPORT);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, WF_IMPORT));
        this.getView().showForm(parameter);
    }

    private void exportModel() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"4730fc9f000004ae")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        String key = rows.get(0).getNumber();
        String fileName = "";
        if (rows.size() > 1) {
            int size = rows.size();
            fileName = String.format("%s(%s)", key, String.valueOf(size));
        } else {
            fileName = key;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(WF_MODIFYEXPORTFILENAME);
        parameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u6d41\u7a0b", (String)"WorkflowModelManagePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam(KEY, (Object)fileName);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, WF_MODIFYEXPORTFILENAME));
        this.getView().showForm(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteModels() {
        String id = this.getPageCache().get(MODEL_ID_ARR);
        id = id.substring(1, id.length() - 1);
        String[] idArr = id.split(", ");
        Long[] ids = new Long[idArr.length];
        for (int i = 0; i < idArr.length; ++i) {
            ids[i] = Long.valueOf(idArr[i]);
        }
        try {
            RepositoryService wfService = this.getRepositoryService();
            wfService.deleteModels(ids);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WorkflowModelManagePlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            this.refresh();
        }
        catch (Exception e1) {
            logger.error("\u5220\u9664\u6a21\u578b\u5931\u8d25", (Throwable)e1);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowModelManagePlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), e1.getMessage()));
        }
        finally {
            this.getPageCache().remove(MODEL_ID_ARR);
        }
    }

    private void duplicateModel() {
        StandardTips tips = StandardTips.view((IFormView)this.getView());
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"47156aff000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u201d\u7684\u201c\u590d\u5236\u201d\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.size() == 0) {
            tips.notSelectRow();
        } else if (rows.size() > 1) {
            tips.selectMultiRow(rows.size());
        } else {
            Object id = rows.get(0).getPrimaryKeyValue();
            DynamicObject model = this.getModelById((Long)id);
            String caption = null;
            String type = model.getString("type");
            caption = ModelType.BizFlow.name().equals(type) ? ResManager.loadKDString((String)"\u590d\u5236\u4e1a\u52a1\u6d41", (String)"WorkflowModelManagePlugin_47", (String)"bos-wf-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u590d\u5236\u5ba1\u6279\u6d41", (String)"WorkflowModelManagePlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.openModelWindow(WF_MODEL_WIZARD_DUPLICATE, caption, id, type);
        }
    }

    private void importJson() {
        String fileName = "d://hyh.json";
        WFModelManagerUtil.importJson(fileName);
        this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"WorkflowModelManagePlugin_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        this.refresh();
    }

    private void openModelWindow(String formId, String formCaption, Object id, String type) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"4715a0df000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(formCaption);
        if (id != null) {
            parameter.setCustomParam("pkid", id);
        }
        if (type != null) {
            parameter.setCustomParam("processType", (Object)type);
        }
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, MODEL_WINDOW_CLOSE);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void openDesigner() {
        StandardTips view = StandardTips.view((IFormView)this.getView());
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"4715a0df000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.size() == 0) {
            view.notSelectRow();
            return;
        }
        if (rows.size() > 1) {
            view.selectMultiRow(rows.size());
        } else if (rows.size() == 1) {
            Long id = (Long)rows.get(0).getPrimaryKeyValue();
            this.openDesignerForm(id);
        }
    }

    private void openDesginerUseRowDoubleClick(ListRowClickEvent evt) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"4715a0df000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter instanceof ListShowParameter && !((ListShowParameter)parameter).isLookUp()) {
            Long pkValue = 0L;
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            if (selectedRows.size() == 1) {
                pkValue = (Long)selectedRows.get(0).getPrimaryKeyValue();
            } else {
                int rowInd = ((ListView)this.getView()).getFocusRow();
                for (ListSelectedRow row : selectedRows) {
                    if (rowInd != row.getRowKey()) continue;
                    pkValue = (Long)row.getPrimaryKeyValue();
                    break;
                }
            }
            this.openDesignerForm(pkValue);
            evt.setCancel(true);
        }
    }

    private void openDesignerForm(Long id) {
        String ids = this.getPageCache().get("designer_ids");
        Map<String, String> idsMap = ids != null ? (Map)SerializationUtils.fromJsonString((String)ids, Map.class) : new HashMap();
        String idStr = String.valueOf(id);
        String pageId = null;
        IFormView openedView = null;
        pageId = (String)idsMap.get(idStr);
        if (pageId != null && (openedView = this.getView().getView(pageId)) != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        try {
            ModelEntity model = (ModelEntity)this.getRepositoryService().findEntityById(id, WF_MODEL, "type");
            pageId = ModelType.BizFlow.name().equals(model.getType()) ? DesignerModelUtil.openBizFlowDesigner(id, this.getView()) : DesignerModelUtil.openAuditFlowDesigner(id, this.getView());
            idsMap.put(idStr, pageId);
            this.getPageCache().put("designer_ids", SerializationUtils.toJsonString(idsMap));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bbe\u8ba1\u5668\u6253\u5f00\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowModelManagePlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private void deleteModelConfirm() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"4715e1f1000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_26", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.size() == 0) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        } else {
            int count = rows.size();
            Object[] idArr = new Long[count];
            for (int i = 0; i < count; ++i) {
                idArr[i] = (Long)rows.get(i).getPrimaryKeyValue();
            }
            this.getPageCache().put(MODEL_ID_ARR, Arrays.toString(idArr));
            StringBuilder sb1 = new StringBuilder();
            List<DynamicObject> ldob = this.getModelByIds((Long[])idArr);
            for (DynamicObject dob : ldob) {
                if (WfUtils.isEmptyString((Object)dob.get(VERSION))) continue;
                sb1.append(dob.get(KEY)).append('\uff0c');
            }
            if (WfUtils.isNotEmptyString((Object)sb1)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u201c%s\u201d\u5df2\u53d1\u5e03\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"WorkflowModelManagePlugin_28", (String)"bos-wf-formplugin", (Object[])new Object[0]), sb1.substring(0, sb1.length() - 1)));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"WorkflowModelManagePlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(MODEL_DELETE_CALL_BACK));
            }
        }
    }

    private void publishModelConfirm() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"/8M0INTY9FDA")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u53d1\u5e03\u201d\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_31", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        boolean result = true;
        String name = null;
        String number = null;
        if (rows == null || rows.size() == 0) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        } else if (rows.size() == 1) {
            Long id = (Long)rows.get(0).getPrimaryKeyValue();
            DynamicObject dob = this.getModelById(id);
            HashMap<String, Object> map = new HashMap<String, Object>();
            name = dob.get(NAME).toString();
            number = dob.get(KEY).toString();
            map.put(ID, id);
            map.put(NAME, name);
            map.put(NUMBER, number);
            map.put(VERSION, dob.get(VERSION));
            result = this.validateBpmnModels(id, name, number);
            if (!result) {
                return;
            }
            this.showConfirmWindow(publishConfirmFormId, map, MODEL_PUBLISH_CALL_BACK);
        } else if (rows.size() > 1) {
            int count = rows.size();
            Long[] idArr = new Long[count];
            for (int i = 0; i < count; ++i) {
                idArr[i] = (Long)rows.get(i).getPrimaryKeyValue();
            }
            List<DynamicObject> ldob = this.getModelByIds(idArr);
            ArrayList list = new ArrayList(ldob.size());
            Long id = null;
            for (DynamicObject dob : ldob) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                name = dob.get(NAME).toString();
                id = dob.getLong(ID);
                number = dob.get(KEY).toString();
                map.put(ID, id);
                map.put(NAME, name);
                map.put(NUMBER, number);
                map.put(VERSION, dob.get(VERSION));
                result = this.validateBpmnModels(id, name, number);
                if (!result) {
                    return;
                }
                list.add(map);
            }
            this.showConfirmWindow(publishConfirmAllFormId, list, MODEL_PUBLISH_ALL_CALL_BACK);
        }
    }

    private boolean validateBpmnModels(Long id, String name, String number) {
        BpmnModel bpmnModel = this.getBpmnModelByModelId(id);
        try {
            List result = new BpmnModelValidator().validateBpmnModel(bpmnModel);
            if (result.isEmpty()) {
                return true;
            }
            DesignerModelUtil.showProcessValidateResult((AbstractFormPlugin)this, result, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u201c%2$s\u201d\u6821\u9a8c\u5931\u8d25\u3002", (String)"WorkflowModelManagePlugin_33", (String)"bos-wf-formplugin", (Object[])new Object[0]), name, number));
        }
        catch (Exception e) {
            logger.error("\u6a21\u578b\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    private BpmnModel getBpmnModelByModelId(Long id) {
        RepositoryService service = this.getRepositoryService();
        String json = service.getResourceByModelIdAndType(id, "graph_json").getData();
        BpmnModel bpmnModel = null;
        try {
            bpmnModel = DesignerModelUtil.getBpmnModel(json);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6a21\u578b\u5f02\u5e38", (Throwable)e);
        }
        return bpmnModel;
    }

    private List<DynamicObject> getModelByIds(Long[] idArr) {
        ORM orm = ORM.create();
        QFilter q = new QFilter(ID, "in", (Object)idArr);
        DynamicObjectCollection ldob = orm.query(WF_MODEL, new QFilter[]{q});
        return ldob;
    }

    private DynamicObject getModelById(Long id) {
        ORM orm = ORM.create();
        QFilter q = new QFilter(ID, "=", (Object)id);
        DynamicObject dob = orm.queryOne(WF_MODEL, "id,key,name,version,type", new QFilter[]{q});
        return dob;
    }

    private void showConfirmWindow(String formId, Object message, String callbackFlag) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formId);
        parameter.setCustomParam(MESSAGE, message);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callbackFlag));
        this.getView().showForm(parameter);
    }

    private void refresh() {
        IListView listView = (IListView)this.getView();
        listView.refresh();
        listView.clearSelection();
    }

    private RepositoryService getRepositoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRepositoryService();
    }

    private void exportModelSQL() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"4730fc9f000004ae")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        } else if (!rows.isEmpty()) {
            int count = rows.size();
            ExportModelSQLUtil exportSQL = new ExportModelSQLUtil(this.getView(), this.getRepositoryService());
            for (int i = 0; i < count; ++i) {
                this.isSucessExport = exportSQL.createSQL(rows.get(i).getPrimaryKeyValue().toString());
            }
            if (this.isSucessExport) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"WorkflowModelManagePlugin_22", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                WfUtils.addOpLogByAppId((String)this.getView().getFormShowParameter().getAppId(), (String)WF_MODEL, (String)BAR_EXPORTSQL, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u51fa\u6d41\u7a0bSQL", "WorkflowModelManagePlugin_44", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5bfc\u51fa\u6d41\u7a0bSQL\u7684Id\u4e3a:%s", "WorkflowModelManagePlugin_45", "bos-wf-formplugin"), (Object[])new Object[]{rows.get(0).getPrimaryKeyValue().toString()});
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent evt = args.getHyperLinkClickEvent();
        if (KEY.equals(evt.getFieldName())) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_MODEL, (String)"4715a0df000000ac")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"WorkflowModelManagePlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.openDesignerForm((Long)((IListView)this.getView()).getFocusRowPkId());
            args.setCancel(true);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("designer_ids");
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }

    private void fireAfterExportProcess(List<String> processNumbers, String scene) {
        try {
            AfterExportProcessEvent evt = new AfterExportProcessEvent(this.getView(), scene, "afterExportProcess", null, processNumbers);
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            proxy.fireCustomEvent((CustomEventArgs)evt);
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u89e6\u53d1\u6d41\u7a0b\u5bfc\u51fa\u4e8b\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowModelManagePlugin_52", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void fireAfterImportProcess(List<String> processNumbers, String scene) {
        try {
            AfterImportProcessEvent evt = new AfterImportProcessEvent(this.getView(), scene, "afterImportProcess", null, processNumbers);
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            proxy.fireCustomEvent((CustomEventArgs)evt);
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u89e6\u53d1\u6d41\u7a0b\u5bfc\u5165\u4e8b\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ImportModelPlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }
}

