/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WFEngineVersion;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityImpl;
import kd.bos.workflow.engine.repository.Model;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowModelWizardBaseInfoPlugin
extends AbstractWorkflowPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final String ENTRABILL_FLAG = "entrabillFlag";
    protected static final String ORGUNITID = "orgunitid";
    protected static final String MODELKEY = "key";
    protected static final String MODELBUSINESSID = "businessid";
    protected static final String MODELNAME = "name";
    protected static final String CATEGORY = "category";
    protected static final String MODELDESCRIPTION = "description";
    protected static final String ENTRABILL = "entrabill";
    protected static final String ENTRABILLNAME = "entrabillname";
    protected static final String ENTRABILLID = "entrabillid";
    protected static final String APPLICATIONID = "applicationid";
    protected static final String ID = "id";
    protected static final String BTN_CONFIRM = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ENTRABILLNAME, BTN_CONFIRM});
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(ORGUNITID);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getAppIdFromFocusTreeNode() != null) {
            this.getView().getModel().setValue(CATEGORY, (Object)this.getAppIdFromFocusTreeNode());
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "entrabillname": {
                DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, ENTRABILL_FLAG);
                break;
            }
            case "btnok": {
                this.confirm();
                break;
            }
        }
    }

    protected void confirm() {
        if (!this.checkBaseData()) {
            return;
        }
        ModelEntityImpl model = this.createModelEntity();
        try {
            this.saveModelAndOpenDesigner(model);
            this.getView().close();
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\u3002", (String)"WorkflowModelWizardPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage());
        }
    }

    protected void saveModelAndOpenDesigner(ModelEntityImpl model) {
        HashMap resources = new HashMap();
        ArrayList configs = new ArrayList();
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bosVersion", WFEngineVersion.getVersion());
        config.put("type", "Process");
        config.put("number", this.getModel().getValue(MODELKEY).toString());
        config.put(MODELNAME, this.getModel().getValue(MODELNAME));
        config.put("documentation", this.getModel().getValue(MODELDESCRIPTION));
        config.put("orgUnitId", model.getOrgUnitId());
        config.put("entraBill", model.getEntraBill());
        config.put("entraBillId", model.getEntraBillId());
        config.put("entraBillName", (String)this.getModel().getValue(ENTRABILLNAME));
        config.put("applicationId", model.getApplicationId());
        config.put(MODELBUSINESSID, model.getBusinessId());
        config.put("processType", ModelType.BizFlow.name());
        configs.add(config);
        config = new HashMap();
        config.put("type", "StartSignalEvent");
        config.put(MODELNAME, this.getStartNodeName());
        configs.add(config);
        config = new HashMap();
        config.put("type", "SequenceFlow");
        configs.add(config);
        config = new HashMap();
        config.put("type", "EndNoneEvent");
        config.put(MODELNAME, this.getEndNodeName());
        configs.add(config);
        resources.put("featuresConfig", configs);
        this.getRepositoryService().saveModel((Model)model, resources);
        DesignerModelUtil.openBizFlowDesigner(model.getId(), this.getView());
    }

    private String getStartNodeName() {
        return ResManager.loadKDString((String)"\u5f00\u59cb", (String)"WorkflowModelWizardPlugin_36", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }

    private String getEndNodeName() {
        return ResManager.loadKDString((String)"\u7ed3\u675f", (String)"WorkflowModelWizardPlugin_37", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }

    protected ModelEntityImpl createModelEntity() {
        IDataModel dataModel = this.getView().getModel();
        Long orgUnitId = (Long)((DynamicObject)dataModel.getValue(ORGUNITID)).get(ID);
        String entrabillId = this.getPageCache().get(ENTRABILLID);
        String entrabillNumber = this.getPageCache().get(ENTRABILL);
        String applicationId = WfUtils.getApplicationIdByBillId((String)entrabillId);
        String businessId = (String)dataModel.getValue(MODELBUSINESSID);
        ModelEntityImpl model = new ModelEntityImpl();
        model.setName((ILocaleString)dataModel.getValue(MODELNAME));
        model.setKey((String)dataModel.getValue(MODELKEY));
        model.setDescription((ILocaleString)dataModel.getValue(MODELDESCRIPTION));
        model.setCategory((Long)((DynamicObject)dataModel.getValue(CATEGORY)).getPkValue());
        model.setType(ModelType.BizFlow.name());
        Long userIdL = Long.valueOf(RequestContext.get().getUserId());
        model.setCreatorId(userIdL);
        model.setModifierId(userIdL);
        model.setOrgUnitId(orgUnitId);
        model.setEntraBillId(entrabillId);
        model.setEntraBill(entrabillNumber);
        model.setApplicationId(applicationId);
        model.setBusinessId(businessId);
        model.setCreateDate(WfUtils.now());
        return model;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (ENTRABILL_FLAG.equals(evt.getActionId()) && evt.getReturnData() != null) {
            Map ret = (Map)evt.getReturnData();
            if (ret.get(ID) != null) {
                this.getPageCache().put(ENTRABILLID, ret.get(ID).toString());
            }
            if (ret.get("number") != null) {
                this.getPageCache().put(ENTRABILL, ret.get("number").toString());
            }
            this.getModel().setValue(ENTRABILLNAME, ret.get(MODELNAME));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        IFormView view = this.getView();
        if (ENTRABILLNAME.equalsIgnoreCase(propName)) {
            this.fillingValue(newValue);
        }
    }

    protected void fillingValue(Object billName) {
        String billNumber = this.getPageCache().get(ENTRABILL);
        String billId = this.getPageCache().get(ENTRABILLID);
        String businessId = this.getPageCache().get(MODELBUSINESSID);
        String defaultName = null;
        defaultName = this.isBizFlow() ? ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u7a0b", (String)"WorkflowModelWizardBaseInfoPlugin_20", (String)"bos-wf-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba1\u6279\u6d41\u7a0b", (String)"WorkflowModelWizardBaseInfoPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        this.getView().getModel().setValue(MODELBUSINESSID, (Object)businessId);
        this.getView().getModel().setValue(MODELNAME, (Object)(billName + defaultName));
        this.getView().getModel().setValue(MODELKEY, (Object)this.createAutoKey("00", billNumber));
        this.fillingCategoryValue(billId);
    }

    protected void fillingCategoryValue(String billId) {
        if (this.getAppIdFromFocusTreeNode() != null) {
            this.getView().getModel().setValue(CATEGORY, (Object)this.getAppIdFromFocusTreeNode());
        } else {
            this.getView().getModel().setValue(CATEGORY, (Object)this.addProcessCategoryIfNeed(billId));
        }
    }

    private Long addProcessCategoryIfNeed(String billId) {
        if (StringUtils.isBlank((CharSequence)billId)) {
            return null;
        }
        Long processCategoryId = null;
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = BizAppServiceHelp.getBizAppByFormID((String)billId);
        }
        catch (Exception e) {
            this.logger.error(String.format("getBizAppByFormID failed! billId: %s, error: %s", billId, WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        if (dynamicObject == null) {
            return null;
        }
        String appId = (String)dynamicObject.get(ID);
        List processCategoryEntities = this.getRepositoryService().getProcateByApplicationId(appId);
        if (processCategoryEntities != null && processCategoryEntities.size() > 0) {
            processCategoryId = ((ProcessCategoryEntity)processCategoryEntities.get(0)).getId();
        } else {
            ProcessCategoryEntityImpl procateEntity = new ProcessCategoryEntityImpl();
            procateEntity.setILocaleStringName(dynamicObject.getLocaleString(MODELNAME));
            procateEntity.setDescription(dynamicObject.get(MODELDESCRIPTION).toString());
            procateEntity.setNumber((String)dynamicObject.get("number"));
            procateEntity.setApplicationId((String)dynamicObject.get(ID));
            procateEntity.setLeaf(Boolean.TRUE);
            this.getRepositoryService().saveOrUpdateEntity((Entity)procateEntity);
            processCategoryId = procateEntity.getId();
        }
        return processCategoryId;
    }

    private Long getAppIdFromFocusTreeNode() {
        try {
            IFormView parentView = this.getView().getParentView();
            TreeView treeView = (TreeView)parentView.getControl("treeview");
            String nodeId = treeView.getTreeState().getFocusNodeId();
            if (WfUtils.isEmpty((String)nodeId) || "0".equals(nodeId)) {
                return null;
            }
            ProcessCategoryEntity processCategoryEntity = this.getRepositoryService().getProcateById(Long.valueOf(nodeId));
            if (processCategoryEntity != null) {
                return processCategoryEntity.getId();
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6d41\u7a0b\u7c7b\u522b\u8282\u70b9\u5931\u8d25", (Throwable)e);
            return null;
        }
        return null;
    }

    protected boolean checkBaseData() {
        long userId;
        DynamicObject org;
        Object orgUnitId;
        String errorMsg = "";
        StringBuilder msg = new StringBuilder();
        String[][] arg = new String[][]{{MODELKEY, ResManager.loadKDString((String)"\u201c\u6d41\u7a0b\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0])}, {ENTRABILLNAME, ResManager.loadKDString((String)"\u201c\u5355\u636e\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0])}, {MODELNAME, ResManager.loadKDString((String)"\u201c\u6d41\u7a0b\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0])}, {MODELBUSINESSID, ResManager.loadKDString((String)"\u201c\u6d41\u7a0b\u6807\u8bc6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0])}, {ORGUNITID, ResManager.loadKDString((String)"\u201c\u6240\u5c5e\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0])}, {CATEGORY, ResManager.loadKDString((String)"\u201c\u6240\u5c5e\u5206\u7c7b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0])}};
        for (int i = 0; i < arg.length; ++i) {
            if (!StringUtils.isBlank((Object)this.getModel().getValue(arg[i][0]))) continue;
            msg.append(arg[i][1]);
        }
        errorMsg = msg.toString();
        if (WfUtils.isNotEmpty((String)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return false;
        }
        String regKey = this.getModel().getValue(MODELKEY).toString();
        int maxKeyLength = WfConfigurationUtil.getWorkflowProcessKeyMaxLength();
        if (regKey == null || !PluginUtil.matchPattern("^[A-Za-z][A-Za-z0-9_]*$", regKey)) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6d41\u7a0b\u7f16\u7801\u8bf7\u4f7f\u7528\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), errorMsg);
        } else if (regKey.length() > maxKeyLength) {
            errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u6d41\u7a0b\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%2$s\u4e2a\u5b57\u7b26\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), errorMsg, maxKeyLength);
        } else if (regKey.matches("([A-Za-z0-9_])*[A-Za-z](Task|Activity|SubProcess|Node|Element|Gateway|Flow|Event)([A-Za-z0-9_])*")) {
            errorMsg = String.format(ResManager.loadKDString((String)"%s\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u5305\u542bXxxTask\u3001XxxActivity\u3001XxxSubProcess\u3001XxxNode\u3001XxxElement\u3001XxxGateway\u3001XxxFlow\u3001XxxEvent\u7b49\u6d41\u7a0b\u5173\u952e\u5b57\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), errorMsg);
        }
        String businessId = String.valueOf(this.getModel().getValue(MODELBUSINESSID));
        errorMsg = errorMsg + WfUtils.validateBusinessId((String)businessId);
        String regName = this.getModel().getValue(MODELNAME).toString();
        if (WfUtils.isEmpty((String)regName)) {
            errorMsg = errorMsg + ResManager.loadKDString((String)"\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (WfUtils.isNotEmpty((String)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return false;
        }
        if (this.checkNameOrNumber(MODELKEY)) {
            errorMsg = errorMsg + String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), this.getModel().getValue(MODELKEY));
        }
        if ((orgUnitId = this.getModel().getValue(ORGUNITID)) instanceof DynamicObject && null != (org = (DynamicObject)orgUnitId).getPkValue() && !WfAdminUtil.canDoOperation((Long)(userId = Long.parseLong(RequestContext.get().getUserId())), (Long)((Long)org.getPkValue()))) {
            errorMsg = errorMsg + WFMultiLangConstants.getNotAdminForOperation();
        }
        if (WfUtils.isNotEmpty((String)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return false;
        }
        return true;
    }

    private boolean checkNameOrNumber(String prop) {
        EntityQueryBuilder eb = this.getRepositoryService().createModelQuery();
        if (MODELKEY.equals(prop)) {
            eb.addFilter(MODELKEY, (Object)this.getModel().getValue(prop).toString());
        } else if (MODELNAME.equals(prop)) {
            eb.addFilter(MODELNAME, (Object)this.getModel().getValue(prop).toString());
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Long count = wfService.getRepositoryService().getModelCountByQuery(eb);
        return count > 0L;
    }

    private String createAutoKey(String orgUnitNumber, String billNumber) {
        HashMap<String, String> modelInfoMap = new HashMap<String, String>();
        modelInfoMap.put("billNumber", billNumber);
        modelInfoMap.put("entraBillId", this.getPageCache().get(ENTRABILLID));
        modelInfoMap.put("orgUnitId", String.valueOf(RequestContext.get().getOrgId()));
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        int autoKeyNumber = wfService.getRepositoryService().getModelKeyAutoNumber(modelInfoMap);
        String prefix = null;
        prefix = this.isBizFlow() ? "Proc_" + billNumber + "_bizflow_" : "Proc_" + billNumber + "_audit_";
        String newNumber = prefix + autoKeyNumber;
        while (this.exists(newNumber)) {
            newNumber = prefix + ++autoKeyNumber;
        }
        return newNumber;
    }

    protected boolean isBizFlow() {
        return "wf_modelwizardbaseinfo".equals(this.getView().getFormShowParameter().getFormId()) || ModelType.BizFlow.name().equals(this.getView().getFormShowParameter().getCustomParam("processType"));
    }

    private boolean exists(String number) {
        QFilter[] filters = new QFilter[]{new QFilter(MODELKEY, "=", (Object)number)};
        return QueryServiceHelper.exists((String)"wf_model", (QFilter[])filters);
    }

    void showSelectorForm(String pageNo, String callback) {
        FormShowParameter parameter = new FormShowParameter();
        if ("wf_formoperation".equals(pageNo)) {
            HashMap<String, String> formKeyMap = new HashMap<String, String>();
            formKeyMap.put("formKey", this.getPageCache().get(ENTRABILL));
            HashMap<String, HashMap<String, String>> customParams = new HashMap<String, HashMap<String, String>>();
            customParams.put("nodeProperties", formKeyMap);
            parameter.setCustomParam("context", customParams);
        } else {
            parameter.setShowTitle(false);
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(pageNo);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callback));
        this.getView().showForm(parameter);
    }

    private Object getAppName(String billId) {
        DynamicObject dynamicObject = BizAppServiceHelp.getBizAppByFormID((String)billId);
        if (dynamicObject != null) {
            return dynamicObject.getPkValue();
        }
        return null;
    }

    protected void openDesignWindow(Long id) {
        DesignerModelUtil.openAuditFlowDesigner(id, this.getView());
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if (ORGUNITID.equals(fieldKey)) {
            String billNumber = this.getPageCache().get(ENTRABILL);
            if (WfUtils.isEmpty((String)billNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5355\u636e\u201d\uff0c\u518d\u9009\u62e9\u201c\u6240\u5c5e\u7ec4\u7ec7\u201d\u3002", (String)"WorkflowModelWizardBaseInfoPlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                evt.setCancel(true);
            } else {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)billNumber);
                String mainOrgPropName = dt.getMainOrg();
                if (WfUtils.isNotEmpty((String)mainOrgPropName)) {
                    MainOrgProp orgProp = (MainOrgProp)dt.getProperty(mainOrgPropName);
                    evt.getFormShowParameter().setCustomParam("orgFuncId", (Object)orgProp.getOrgFunc());
                }
            }
        }
    }
}

