/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.plugin.WorkflowModelWizardBaseInfoPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;

public class WorkflowModelWizardDuplicatePlugin
extends WorkflowModelWizardBaseInfoPlugin
implements ClickListener {
    protected static Log logger = LogFactory.getLog(WorkflowModelWizardDuplicatePlugin.class);
    private static final String BTNOK = "btnok";
    private static final String NAME = "name";
    private static final String PKID = "pkid";
    private static final String MODELS = "models";
    private static final String CATEGORY = "category";
    private static final String PRIMARYSUBPROCESS = "primarysubprocess";
    private static final String ISSUBPROCESS = "issubprocess";

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("orgunitid");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initControlValue();
    }

    private void initControlValue() {
        IFormView formView = this.getView();
        FormShowParameter parameter = formView.getFormShowParameter();
        Object id = parameter.getCustomParam(PKID);
        this.getView().getModel().setValue(MODELS, id);
        this.getView().setEnable(Boolean.FALSE, new String[]{CATEGORY});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"wf_model");
        if (dynamicObject != null) {
            String billNumber = (String)dynamicObject.get("entrabill");
            String billId = (String)((DynamicObject)dynamicObject.get("entrabillid")).get("id");
            String billName = ((DynamicObject)dynamicObject.get("entrabillid")).get(NAME).toString();
            DynamicObject orgUnit = (DynamicObject)dynamicObject.get("orgunitid");
            if (orgUnit != null) {
                this.getModel().setValue("orgunitid", orgUnit.getPkValue());
            }
            this.getPageCache().put("entrabillid", billId);
            String businessId = (String)dynamicObject.get("businessid");
            this.getPageCache().put("businessid", businessId);
            this.getPageCache().put("entrabill", billNumber);
            this.getModel().setValue("entrabillname", (Object)billName);
            if (this.isBizFlow()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ISSUBPROCESS});
            }
            if (!this.isBizFlow() && "sub".equals(dynamicObject.getString(PRIMARYSUBPROCESS))) {
                this.getModel().setValue(ISSUBPROCESS, (Object)true);
            }
            this.fillingValue(billName);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.duplicateModel();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void duplicateModel() {
        IDataModel dataModel = this.getView().getModel();
        if (!this.checkBaseData()) {
            return;
        }
        DynamicObject dob = (DynamicObject)dataModel.getValue(MODELS);
        Long modelId = dob.getLong("id");
        HashMap<String, Object> duplicateProperties = new HashMap<String, Object>();
        duplicateProperties.put("key", dataModel.getValue("key"));
        duplicateProperties.put(NAME, dataModel.getValue(NAME));
        duplicateProperties.put("businessid", dataModel.getValue("businessid"));
        duplicateProperties.put("description", dataModel.getValue("description"));
        dob = (DynamicObject)dataModel.getValue("orgunitid");
        duplicateProperties.put("orgunitid", dob.get("id"));
        duplicateProperties.put("entrabillname", dataModel.getValue("entrabillname"));
        String entraBillId = this.getPageCache().get("entrabillid");
        duplicateProperties.put("entrabillid", this.getPageCache().get("entrabillid"));
        duplicateProperties.put("entrabill", this.getPageCache().get("entrabill"));
        duplicateProperties.put("applicationid", WfUtils.getApplicationIdByBillId((String)entraBillId));
        String primarySubProcessResult = "main";
        if (Boolean.TRUE.equals(dataModel.getValue(ISSUBPROCESS))) {
            primarySubProcessResult = "sub";
        }
        duplicateProperties.put(PRIMARYSUBPROCESS, primarySubProcessResult);
        try {
            RepositoryService service = this.getRepositoryService();
            modelId = service.dulicateAndSaveModel(modelId, duplicateProperties);
            String type = (String)this.getView().getFormShowParameter().getCustomParam("processType");
            if (ModelType.BizFlow.name().equals(type)) {
                DesignerModelUtil.openBizFlowDesigner(modelId, this.getView());
            } else {
                DesignerModelUtil.openAuditFlowDesigner(modelId, this.getView());
            }
            this.getView().close();
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b\u6a21\u578b\u590d\u5236\u5931\u8d25", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u590d\u5236\u6d41\u7a0b\u5931\u8d25\u3002", (String)"WorkflowModelWizardDuplicatePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }
}

