/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.BillExceptionOp;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.design.plugin.NodeConfig;
import kd.bos.workflow.design.plugin.WorkflowModelWizardBaseInfoPlugin;
import kd.bos.workflow.design.util.ExtItfPluginUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WFEngineVersion;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.repository.Model;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowModelWizardPlugin
extends WorkflowModelWizardBaseInfoPlugin
implements ClickListener {
    private static final String BOSVERSION = "bosVersion";
    private static final String PAGECACHE_SAVE_VALUE = "saving";
    private static final String PAGECACHE_SAVE_KEY = "saveKey";
    private static final String BTNBASESAVE = "buttonbasesave";
    private static final String BTNMORESAVE = "buttonmoresave";
    private static final String BUTTON_SAVE = "buttonsave";
    private static final String BTNNEXT1 = "buttonnext1";
    private static final String BTNNEXT2 = "buttonnext2";
    private static final String BTNLAST1 = "buttonlast1";
    private static final String BTNLAST2 = "buttonlast2";
    private static final String BASEINFO = "baseinfo";
    private static final String AUDITFEATURE = "auditfeature";
    private static final String STATUS_SETTING = "statussetting";
    private static final String CBAPPROVALSERIES = "comboapprovalseries";
    private static final String CBYZJAUDIT = "comboyzjaudit";
    private static final String CHECKBOX_SEND_MESSAGE = "checkboxsendmessage";
    private static final String COMBO_REJECT_EDIT = "comborejectedit";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENTRY_NODE = "entrynode";
    private static final String ENTRY_NODE_ID = "entrynodeid";
    private static final String ENTRY_DESCISION = "entrydescision";
    private static final String ENTRY_BACK_OPERATE = "entrybackoperate";
    private static final String ENTRY_PASSED_OPERATE = "entrypassedoperate";
    private static final String ENTRY_DESCISION_NUMBER = "entrydescisionnumber";
    private static final String ENTRY_BACK_OPERATE_NUMBER = "entrybackoperatenumber";
    private static final String ENTRY_PASSED_OPERATE_NUMBER = "entrypassedoperatenumber";
    private static final String NODE_CONFIG_NAME = "name";
    private static final String NODE_CONFIG_ENTITY_NUMBER = "entityNumber";
    private static final String NODE_CONFIG_ENTITY_NAME = "entityName";
    private static final String NODE_CONFIG_ENTITY_ID = "entityId";
    private static final String NODE_CONFIG_FINAL_AUDIT = "finalAudit";
    private static final String NODE_CONFIG_EXECUTION_LISTENERS = "executionListeners";
    private static final String NODE_CONFIG_TASK_LISTENERS = "taskListeners";
    private static final String NODE_CONFIG_DECISION_OPTIONS = "decisionOptions";
    private static final String NODE_CONFIG_BACK_REJECTED_ACTIVITY = "backRejectedActivity";
    private static final String DECISION_APPROVE_NUMBER = "Consent";
    private static final String DECISION_REJECT_NUMBER = "Reject";
    private static final String DECISION_REJECT_TO_EDIT_NUMBER = "RejectToEdit";
    private static final String DECISION_REJECT_TO_PRE_AUDIT_NUMBER = "RejectToPreAudit";
    private static final String DECISION_REJECT_TO_ALL_AUDIT_NUMBER = "RejectToAllAudit";
    private static final String DECISION_TERMINATE_NUMBER = "Terminate";
    private static final String OPERATION_SUBMIT = "submit";
    private static final String OPERATION_UNSUBMIT = "unsubmit";
    private static final String OPERATION_AUDIT = "audit";
    private static final String OPERATION_UNAUDIT = "unaudit";
    private static final String OPERATION_DELETE = "delete";
    private static final String NODE_NAME = "nodeName";
    private static final String NODE_ID = "nodeId";
    private static final String MUL_COMBO_REJECT = "mulcomboreject";
    private static final String MUL_COMBO_DESCISION = "mulcombodescision";
    private static final String WF_FORMOPERATION = "wf_formoperation";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNBASESAVE, BTNMORESAVE, BTNNEXT1, BTNLAST1, BTNNEXT2, BTNLAST2, ENTRY_PASSED_OPERATE, ENTRY_BACK_OPERATE, BUTTON_SAVE});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.TRUE, new String[]{BASEINFO});
        this.getView().setVisible(Boolean.FALSE, new String[]{AUDITFEATURE});
        this.getView().setVisible(Boolean.FALSE, new String[]{STATUS_SETTING});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        if (CBAPPROVALSERIES.equalsIgnoreCase(propName)) {
            this.packageYZJAuditCombo();
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "buttonnext1": {
                this.stepNext1();
                break;
            }
            case "buttonlast1": {
                this.stepLast1();
                break;
            }
            case "buttonnext2": {
                this.stepNext2();
                break;
            }
            case "buttonlast2": {
                this.stepLast2();
                break;
            }
            case "buttonbasesave": {
                this.saveModelFilter(BTNBASESAVE);
                break;
            }
            case "buttonmoresave": {
                this.saveModelFilter(BUTTON_SAVE);
                break;
            }
            case "entrypassedoperate": {
                super.showSelectorForm(WF_FORMOPERATION, ENTRY_PASSED_OPERATE);
                break;
            }
            case "entrybackoperate": {
                super.showSelectorForm(WF_FORMOPERATION, ENTRY_BACK_OPERATE);
                break;
            }
            case "buttonsave": {
                this.saveModelFilter(BUTTON_SAVE);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() == null) {
            return;
        }
        Map ret = (Map)evt.getReturnData();
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int index = grid.getEntryState().getFocusRow();
        if (ENTRY_PASSED_OPERATE.equals(evt.getActionId())) {
            this.getModel().setValue(ENTRY_PASSED_OPERATE, ret.get(NODE_CONFIG_NAME), index);
            this.getModel().setValue(ENTRY_PASSED_OPERATE_NUMBER, ret.get("number"), index);
        } else if (ENTRY_BACK_OPERATE.equals(evt.getActionId())) {
            this.getModel().setValue(ENTRY_BACK_OPERATE, ret.get(NODE_CONFIG_NAME), index);
            this.getModel().setValue(ENTRY_BACK_OPERATE_NUMBER, ret.get("number"), index);
        }
    }

    private void packageYZJAuditCombo() {
        ComboEdit yzjAuditCombo = (ComboEdit)this.getView().getControl(CBYZJAUDIT);
        ArrayList<ComboItem> yzjComboItem = new ArrayList<ComboItem>();
        try {
            int level = Integer.parseInt((String)this.getView().getModel().getValue(CBAPPROVALSERIES));
            for (int i = 0; i <= level; ++i) {
                if (i == 0) {
                    yzjComboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u8bbe\u4f1a\u5ba1\u8282\u70b9", (String)"WorkflowModelWizardPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0])), String.valueOf(i)));
                    continue;
                }
                yzjComboItem.add(new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"\u8bbe\u5728\u7b2c%s\u7ea7", (String)"WorkflowModelWizardPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), i)), String.valueOf(i)));
            }
            yzjAuditCombo.setComboItems(yzjComboItem);
            this.getView().getModel().setValue(CBYZJAUDIT, (Object)((ComboItem)yzjComboItem.get(0)).getValue());
        }
        catch (NumberFormatException numberFormatException) {
            yzjAuditCombo.setComboItems(yzjComboItem);
        }
    }

    private String[] getYZJComboAuditLevel() {
        return new String[]{ResManager.loadKDString((String)"\u4e00", (String)"WorkflowModelWizardPlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"WorkflowModelWizardPlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"WorkflowModelWizardPlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"WorkflowModelWizardPlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"WorkflowModelWizardPlugin_20", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"WorkflowModelWizardPlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"WorkflowModelWizardPlugin_22", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"WorkflowModelWizardPlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"WorkflowModelWizardPlugin_24", (String)"bos-wf-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"WorkflowModelWizardPlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[0])};
    }

    private void stepNext1() {
        if (!this.checkBaseData()) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{BASEINFO});
        this.getView().setVisible(Boolean.TRUE, new String[]{AUDITFEATURE});
        this.getView().setVisible(Boolean.FALSE, new String[]{STATUS_SETTING});
    }

    private void stepNext2() {
        if (!this.checkData()) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{BASEINFO});
        this.getView().setVisible(Boolean.FALSE, new String[]{AUDITFEATURE});
        this.getView().setVisible(Boolean.TRUE, new String[]{STATUS_SETTING});
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = (DynamicObjectCollection)dataEntity.get(ENTRY_ENTITY);
        if (entrys.size() > 0) {
            entrys.clear();
            this.getView().updateView();
            this.getView().setVisible(Boolean.FALSE, new String[]{BASEINFO});
            this.getView().setVisible(Boolean.FALSE, new String[]{AUDITFEATURE});
            this.getView().setVisible(Boolean.TRUE, new String[]{STATUS_SETTING});
        }
        String audit = "";
        String auditName = "";
        String unAudit = "";
        String unAuditName = "";
        String unsubmit = "";
        String unsubmitName = "";
        String submit = "";
        String submitName = "";
        String entraBill = this.getPageCache().get("entrabill");
        if (this.containOperation(entraBill, OPERATION_AUDIT)) {
            audit = OPERATION_AUDIT;
            Operation operation = this.getOperation(entraBill, OPERATION_AUDIT);
            auditName = operation.getName().getLocaleValue();
        }
        if (this.containOperation(entraBill, OPERATION_UNAUDIT)) {
            unAudit = OPERATION_UNAUDIT;
            unAuditName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"WorkflowModelWizardPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        int i = 0;
        if (this.containOperation(entraBill, OPERATION_UNSUBMIT)) {
            this.entryRowLoadData(new String[]{this.getUserNodeName(), this.getUserNodeId(3), "", "", "", ResManager.loadKDString((String)"\u64a4\u9500", (String)"WorkflowModelWizardPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), "", OPERATION_UNSUBMIT}, i++);
        } else {
            this.entryRowLoadData(new String[]{this.getUserNodeName(), this.getUserNodeId(3), "", "", "", unsubmitName, "", unsubmit}, i++);
        }
        boolean isTerminate = false;
        if (this.getDescisionValue().contains("3")) {
            isTerminate = true;
        }
        int level = this.getAuditLevel();
        for (int j = 1; j <= level; ++j) {
            int index = 2 * j + 3;
            String[] approvalValues = null;
            String[] rejectValues = null;
            String[] rejectEditValues = null;
            String[] rejectPreAuditValues = null;
            String[] rejectAllAuditValues = null;
            String[] terminateValues = null;
            if (this.isFinalNode(j)) {
                if (this.isYZJNode(j)) {
                    approvalValues = new String[]{this.getYZJNodeName(), this.getYZJNodeId(index), ResManager.loadKDString((String)"\u540c\u610f", (String)"WorkflowModelWizardPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_APPROVE_NUMBER, auditName, unAuditName, audit, unAudit};
                    rejectValues = new String[]{this.getYZJNodeName(), this.getYZJNodeId(index), ResManager.loadKDString((String)"\u4e0d\u540c\u610f", (String)"WorkflowModelWizardPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_REJECT_TO_ALL_AUDIT_NUMBER, unsubmitName, submitName, unsubmit, submit};
                } else {
                    approvalValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u540c\u610f", (String)"WorkflowModelWizardPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_APPROVE_NUMBER, auditName, unAuditName, audit, unAudit};
                    if (this.isOnlySelectedRejectToEdit() || j == 1) {
                        rejectValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u63d0\u4ea4\u8282\u70b9", (String)"WorkflowModelWizardPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_REJECT_TO_EDIT_NUMBER, unsubmitName, submitName, unsubmit, submit};
                    } else {
                        if (this.isRejectToEdit()) {
                            rejectEditValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u63d0\u4ea4\u8282\u70b9", (String)"WorkflowModelWizardPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_REJECT_TO_EDIT_NUMBER, submitName, submitName, unsubmit, submit};
                        }
                        if (this.isRejectToLast()) {
                            rejectPreAuditValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9", (String)"WorkflowModelWizardPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_REJECT_TO_PRE_AUDIT_NUMBER, "", "", "", ""};
                        }
                        if (this.isRejectToLastAll()) {
                            rejectAllAuditValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u5df2\u9009\u8282\u70b9", (String)"WorkflowModelWizardPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_REJECT_TO_ALL_AUDIT_NUMBER, "", "", "", ""};
                        }
                    }
                    if (isTerminate) {
                        terminateValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u4e0d\u540c\u610f\u5e76\u7ec8\u6b62", (String)"WorkflowModelWizardPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_TERMINATE_NUMBER, "", "", "", ""};
                    }
                }
            } else if (this.isYZJNode(j)) {
                approvalValues = new String[]{this.getYZJNodeName(), this.getYZJNodeId(index), ResManager.loadKDString((String)"\u540c\u610f", (String)"WorkflowModelWizardPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_APPROVE_NUMBER, "", "", "", ""};
                rejectValues = new String[]{this.getYZJNodeName(), this.getYZJNodeId(index), ResManager.loadKDString((String)"\u4e0d\u540c\u610f", (String)"WorkflowModelWizardPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_REJECT_TO_ALL_AUDIT_NUMBER, unsubmitName, submitName, unsubmit, submit};
            } else {
                approvalValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u540c\u610f", (String)"WorkflowModelWizardPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_APPROVE_NUMBER, "", "", "", ""};
                if (this.isOnlySelectedRejectToEdit() || j == 1) {
                    rejectValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u63d0\u4ea4\u8282\u70b9", (String)"WorkflowModelWizardPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_REJECT_TO_EDIT_NUMBER, unsubmitName, submitName, unsubmit, submit};
                } else {
                    if (this.isRejectToEdit()) {
                        rejectEditValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u63d0\u4ea4\u8282\u70b9", (String)"WorkflowModelWizardPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_REJECT_TO_EDIT_NUMBER, submitName, submitName, unsubmit, submit};
                    }
                    if (this.isRejectToLast()) {
                        rejectPreAuditValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9", (String)"WorkflowModelWizardPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_REJECT_TO_PRE_AUDIT_NUMBER, "", "", "", ""};
                    }
                    if (this.isRejectToLastAll()) {
                        rejectAllAuditValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u9a73\u56de\u81f3\u5df2\u9009\u8282\u70b9", (String)"WorkflowModelWizardPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_REJECT_TO_ALL_AUDIT_NUMBER, "", "", "", ""};
                    }
                }
                if (isTerminate) {
                    terminateValues = new String[]{this.getAuditNodeName(j), this.getAuditNodeId(index), ResManager.loadKDString((String)"\u4e0d\u540c\u610f\u5e76\u7ec8\u6b62", (String)"WorkflowModelWizardPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), DECISION_TERMINATE_NUMBER, "", "", "", ""};
                }
            }
            this.entryRowLoadData(approvalValues, i++);
            if (this.isOnlySelectedRejectToEdit() || this.isYZJNode(j) || j == 1) {
                this.entryRowLoadData(rejectValues, i++);
            } else {
                if (rejectEditValues != null) {
                    this.entryRowLoadData(rejectEditValues, i++);
                }
                if (rejectPreAuditValues != null) {
                    this.entryRowLoadData(rejectPreAuditValues, i++);
                }
                if (rejectAllAuditValues != null) {
                    this.entryRowLoadData(rejectAllAuditValues, i++);
                }
            }
            if (null == terminateValues) continue;
            this.entryRowLoadData(terminateValues, i++);
        }
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        grid.selectRows(-1);
    }

    private void stepLast1() {
        this.getView().setVisible(Boolean.TRUE, new String[]{BASEINFO});
        this.getView().setVisible(Boolean.FALSE, new String[]{AUDITFEATURE});
        this.getView().setVisible(Boolean.FALSE, new String[]{STATUS_SETTING});
    }

    private void stepLast2() {
        this.getView().setVisible(Boolean.FALSE, new String[]{BASEINFO});
        this.getView().setVisible(Boolean.TRUE, new String[]{AUDITFEATURE});
        this.getView().setVisible(Boolean.FALSE, new String[]{STATUS_SETTING});
    }

    private void saveModelFilter(String saveType) {
        if (this.isSaving()) {
            return;
        }
        try {
            this.getPageCache().put(PAGECACHE_SAVE_KEY, PAGECACHE_SAVE_VALUE);
            if (!this.checkBaseData()) {
                return;
            }
            if (BTNBASESAVE.equals(saveType)) {
                this.saveBaseModelInfo();
            } else if (BUTTON_SAVE.equals(saveType)) {
                if (!this.checkData()) {
                    return;
                }
                this.saveDetailedModelInfo();
            }
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u51fa\u9519", (String)"WorkflowModelWizardPlugin_26", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage());
        }
        finally {
            this.getPageCache().remove(PAGECACHE_SAVE_KEY);
        }
    }

    private boolean checkData() {
        StringBuilder errorMessage = new StringBuilder();
        if (WfUtils.isEmpty((String)this.getDescisionValue())) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u51b3\u7b56\u9879\u3002", (String)"WorkflowModelWizardPlugin_27", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        if (WfUtils.isNotEmpty((String)this.getDescisionValue()) && this.getDescisionValue().indexOf("1,2") == -1) {
            errorMessage.append(ResManager.loadKDString((String)"\u201c\u540c\u610f\u201d\u548c\u201c\u9a73\u56de\u201d\u4e3a\u9ed8\u8ba4\u51b3\u7b56\u9879\uff0c\u5fc5\u9009\u3002", (String)"WorkflowModelWizardPlugin_28", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        if (WfUtils.isEmpty((String)this.getRejectValue())) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u53ef\u9a73\u56de\u9879\u201d\u3002", (String)"WorkflowModelWizardPlugin_29", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        if (WfUtils.isNotEmpty((String)errorMessage.toString())) {
            this.getView().showErrorNotification(errorMessage.toString());
            return false;
        }
        return true;
    }

    private void saveBaseModelInfo() {
        ArrayList<Map<String, Object>> configs = new ArrayList<Map<String, Object>>();
        Map<String, Object> config = this.packageProcess();
        configs.add(config);
        config = new HashMap<String, Object>();
        config.put("type", "StartSignalEvent");
        config.put(NODE_CONFIG_NAME, this.getStartNodeName());
        configs.add(config);
        config = new HashMap<String, Object>();
        config.put("type", "SequenceFlow");
        configs.add(config);
        config = new HashMap<String, Object>();
        config.put("type", "EndNoneEvent");
        config.put(NODE_CONFIG_NAME, this.getEndNodeName());
        configs.add(config);
        this.saveModelEntity(configs);
    }

    private ModelEntityImpl getModelEntity() {
        IDataModel dataModel = this.getView().getModel();
        ModelEntityImpl model = new ModelEntityImpl();
        model.setName((ILocaleString)dataModel.getValue(NODE_CONFIG_NAME));
        model.setKey((String)dataModel.getValue("key"));
        model.setBusinessId((String)dataModel.getValue("businessid"));
        model.setDescription((ILocaleString)dataModel.getValue("description"));
        model.setCategory(Long.valueOf(((DynamicObject)dataModel.getValue("category")).getPkValue().toString()));
        model.setType(ModelType.AuditFlow.name());
        Long userIdL = Long.valueOf(RequestContext.get().getUserId());
        model.setCreatorId(userIdL);
        model.setModifierId(userIdL);
        String orgUnitId = ((DynamicObject)dataModel.getValue("orgunitid")).get("id").toString();
        model.setOrgUnitId(Long.valueOf(orgUnitId));
        String entraBillId = this.getPageCache().get("entrabillid");
        model.setEntraBillId(entraBillId);
        model.setEntraBill(this.getPageCache().get("entrabill"));
        model.setApplicationId(WfUtils.getApplicationIdByBillId((String)entraBillId));
        model.setCreateDate(WfUtils.now());
        Object issubprocess = dataModel.getValue("issubprocess");
        if (Boolean.TRUE.equals(issubprocess)) {
            model.setPrimarySubprocess("sub");
        } else {
            model.setPrimarySubprocess("main");
        }
        return model;
    }

    private void saveDetailedModelInfo() {
        int level = -1;
        int YZJLevel = -1;
        level = this.getAuditLevel();
        YZJLevel = this.getYZJLevel();
        List<Map<String, Object>> configs = this.getDetailedConfig(level, YZJLevel);
        this.saveModelEntity(configs);
    }

    private List<Map<String, Object>> getDetailedConfig(int level, int YZJLevel) {
        ArrayList<Map<String, Object>> configs = new ArrayList<Map<String, Object>>();
        Map<Object, Object> config = new HashMap();
        config = this.packageProcess();
        configs.add(config);
        Stack<Map<String, String>> auditItems = new Stack<Map<String, String>>();
        int itemIdSuffix = 0;
        config = new HashMap();
        String startEventNumber = this.getEventStartNumber(++itemIdSuffix);
        config.put("type", "StartSignalEvent");
        config.put("number", startEventNumber);
        config.put(NODE_CONFIG_NAME, this.getStartNodeName());
        config.put("itemId", this.getEventStartId(itemIdSuffix));
        configs.add(config);
        configs.add(this.packageSequenceFlow(++itemIdSuffix));
        if (level != -1) {
            config = new HashMap();
            auditItems.push(this.packageUserNode(config, ++itemIdSuffix));
            configs.add(config);
            configs.add(this.packageSequenceFlow(++itemIdSuffix));
            for (int i = 1; i <= level; ++i) {
                Map<Object, Object> currentNodeInfo = new HashMap();
                config = new HashMap();
                currentNodeInfo = i == YZJLevel ? this.packageYZJNode(config, ++itemIdSuffix) : this.packageAuditNode(config, ++itemIdSuffix, i);
                this.packageDecisionOption(config, currentNodeInfo, auditItems, i);
                if (i == level) {
                    this.packageFinalAuditConfig(config);
                }
                configs.add(config);
                auditItems.push(currentNodeInfo);
                configs.add(this.packageSequenceFlow(++itemIdSuffix));
            }
        }
        config = new HashMap();
        String endEventNumber = this.getEventEndNumber(++itemIdSuffix);
        config.put("type", "EndNoneEvent");
        config.put("number", endEventNumber);
        config.put(NODE_CONFIG_NAME, this.getEndNodeName());
        config.put("itemId", this.getEventEndId(itemIdSuffix));
        configs.add(config);
        return configs;
    }

    private Map<String, Object> packageProcess() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        String entrabillId = this.getPageCache().get("entrabillid");
        String entrabillNumber = this.getPageCache().get("entrabill");
        String entrabillName = (String)this.getModel().getValue("entrabillname");
        String businessId = (String)this.getModel().getValue("businessid");
        config.put(BOSVERSION, WFEngineVersion.getVersion());
        config.put("type", "Process");
        config.put("number", this.getModel().getValue("key").toString());
        config.put(NODE_CONFIG_NAME, this.getModel().getValue(NODE_CONFIG_NAME));
        config.put("documentation", this.getModel().getValue("description"));
        String orgUnitId = ((DynamicObject)this.getModel().getValue("orgunitid")).get("id").toString();
        config.put("orgUnitId", Long.valueOf(orgUnitId));
        config.put("entraBill", entrabillNumber);
        config.put("entraBillId", entrabillId);
        config.put("businessid", businessId);
        config.put("entraBillName", entrabillName);
        config.put("subProcess", this.getModel().getValue("issubprocess"));
        if (this.containOperation(entrabillNumber, OPERATION_DELETE)) {
            ArrayList<BillExceptionOp> exceptionOps = new ArrayList<BillExceptionOp>();
            BillExceptionOp deleteOp = new BillExceptionOp();
            deleteOp.setId(BpmnDiffUtil.getListElementId((String)"billExceptionOp"));
            deleteOp.setOper(OPERATION_DELETE);
            deleteOp.setOpername(ResManager.loadKDString((String)"\u5220\u9664", (String)"WorkflowModelWizardPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            deleteOp.setProcaction("terminate");
            exceptionOps.add(deleteOp);
            config.put("billExceptionOp", exceptionOps);
        }
        if (WfConfigurationUtil.isSupportStrongControl() && WfConfigurationUtil.isBillWithdrawJumpToUserNode()) {
            ArrayList<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>(1);
            String withdrawAuditedProcOp = ExternalInterfaceUtil.buildExtItfOperationValue((String)OPERATION_UNSUBMIT, (String)ResManager.loadKDString((String)"\u64a4\u9500", (String)"WorkflowModelWizardPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), (String)"", (String)"");
            ActivitiListener listener = this.packageExecutionListener("withdraw_audited_proc", withdrawAuditedProcOp, "operation");
            if (listener != null) {
                executionListeners.add(listener);
                config.put(NODE_CONFIG_EXECUTION_LISTENERS, executionListeners);
            }
        }
        return config;
    }

    private void packageFinalAuditConfig(Map<String, Object> config) {
        config.put(NODE_CONFIG_FINAL_AUDIT, Boolean.TRUE);
        if (this.isSendMessage()) {
            config.put("outMsg", PluginUtil.getMessageNotifyInfo(null, this.getRepositoryService(), "outMsg"));
        }
    }

    private void saveModelEntity(List<Map<String, Object>> configs) {
        ModelEntityImpl model = this.getModelEntity();
        HashMap<String, List<Map<String, Object>>> resources = new HashMap<String, List<Map<String, Object>>>();
        resources.put("featuresConfig", configs);
        try {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            wfService.getRepositoryService().saveModel((Model)model, resources);
            this.openDesignWindow(model.getId());
            this.getView().close();
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\u3002", (String)"WorkflowModelWizardPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage());
        }
    }

    private boolean isSaving() {
        String saveCacheValue = this.getPageCache().get(PAGECACHE_SAVE_KEY);
        return WfUtils.isEmpty((String)saveCacheValue) && PAGECACHE_SAVE_VALUE.equals(saveCacheValue);
    }

    private Map<String, String> packageUserNode(Map<String, Object> config, int itemIdSuffix) {
        this.packageBaseNode(config, "UserTask");
        String userTaskNumber = this.getUserNodeNumber(itemIdSuffix);
        String userTaskItemId = this.getUserNodeId(itemIdSuffix);
        config.put("type", "UserTask");
        config.put("number", userTaskNumber);
        config.put("itemId", userTaskItemId);
        config.put(NODE_CONFIG_NAME, this.getUserNodeName());
        Operation operation = this.getOperation(this.getPageCache().get("entrabill"), OPERATION_SUBMIT);
        if (operation != null) {
            ArrayList<DecisionOption> defaultOptions = new ArrayList<DecisionOption>();
            DecisionOption option = new DecisionOption();
            option.setName(operation.getName().getLocaleValue());
            option.setNumber(operation.getKey());
            option.setId(BpmnDiffUtil.getListElementId((String)NODE_CONFIG_DECISION_OPTIONS));
            defaultOptions.add(option);
            config.put(NODE_CONFIG_DECISION_OPTIONS, defaultOptions);
        }
        List<ActivitiListener> executionListeners = this.packageExcutionListrnersByEntry(userTaskItemId);
        String rejectOperation = ExternalInterfaceUtil.buildExtItfOperationValue((String)OPERATION_UNSUBMIT, (String)ResManager.loadKDString((String)"\u64a4\u9500", (String)"WorkflowModelWizardPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), (String)OPERATION_SUBMIT, (String)ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"WorkflowModelWizardPlugin_35", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        ActivitiListener listener = this.packageExecutionListener("start", rejectOperation, "operation");
        if (listener != null) {
            listener.setOperation("reject");
            executionListeners.add(listener);
        }
        config.put(NODE_CONFIG_EXECUTION_LISTENERS, executionListeners);
        HashMap<String, String> auditItem = new HashMap<String, String>();
        auditItem.put(NODE_NAME, this.getUserNodeName());
        auditItem.put(NODE_ID, userTaskItemId);
        return auditItem;
    }

    private Map<String, String> packageAuditNode(Map<String, Object> config, int itemIdSuffix, int i) {
        this.packageBaseNode(config, "AuditTask");
        config.put("type", "AuditTask");
        String tempPreNumber = this.getAuditNodeNumber(itemIdSuffix);
        String tempPreItemId = this.getAuditNodeId(itemIdSuffix);
        String tempPreName = this.getAuditNodeName(i);
        config.put("number", tempPreNumber);
        config.put("itemId", tempPreItemId);
        config.put(NODE_CONFIG_NAME, tempPreName);
        HashMap<String, String> auditItem = new HashMap<String, String>();
        auditItem.put(NODE_NAME, tempPreName);
        auditItem.put(NODE_ID, tempPreItemId);
        return auditItem;
    }

    private Map<String, String> packageYZJNode(Map<String, Object> config, int itemIdSuffix) {
        this.packageBaseNode(config, "YunzhijiaTask");
        config.put("votePercentage", 1);
        config.put("type", "YunzhijiaTask");
        String tempPreItemNumber = this.getYZJNodeNumber(itemIdSuffix);
        String tempPreItemId = this.getYZJNodeId(itemIdSuffix);
        config.put("number", tempPreItemNumber);
        config.put("itemId", tempPreItemId);
        config.put(NODE_CONFIG_NAME, this.getYZJNodeName());
        HashMap<String, String> auditItem = new HashMap<String, String>();
        auditItem.put(NODE_NAME, this.getYZJNodeName());
        auditItem.put(NODE_ID, tempPreItemId);
        return auditItem;
    }

    private Map<String, Object> packageBaseNode(Map<String, Object> config, String nodeType) {
        IDataModel dataModel = this.getView().getModel();
        String entrabillId = this.getPageCache().get("entrabillid");
        String entrabillNumber = this.getPageCache().get("entrabill");
        String entrabillName = (String)dataModel.getValue("entrabillname");
        config.put(NODE_CONFIG_ENTITY_NUMBER, entrabillNumber);
        config.put(NODE_CONFIG_ENTITY_NAME, entrabillName);
        config.put(NODE_CONFIG_ENTITY_ID, entrabillId);
        if (nodeType.equalsIgnoreCase("UserTask")) {
            int index = this.getComboValue(COMBO_REJECT_EDIT, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9a73\u56de\u4fee\u6539\u540e\u4e0b\u62c9\u5217\u8868\u503c", (String)"WorkflowModelWizardPlugin_31", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            if (index == 1) {
                config.put(NODE_CONFIG_BACK_REJECTED_ACTIVITY, Boolean.FALSE);
            } else if (index == 2) {
                config.put(NODE_CONFIG_BACK_REJECTED_ACTIVITY, Boolean.TRUE);
            }
        }
        return config;
    }

    private Map<String, Object> packageSequenceFlow(int itemIdSuffix) {
        String number = this.getSequenceFlowNumber(itemIdSuffix);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("type", "SequenceFlow");
        config.put("number", number);
        config.put("itemId", this.getSequenceFlowId(itemIdSuffix));
        return config;
    }

    private void addActivitiListener(List<ActivitiListener> listeners, NodeConfig nodeConfig) {
        ActivitiListener listener = this.getListenerFromDecisionOption(nodeConfig);
        if (listener != null) {
            listeners.add(listener);
        }
    }

    private void packageDecisionOption(Map<String, Object> config, Map<String, String> currentNodeInfo, Stack<Map<String, String>> auditItems, int i) {
        ArrayList<ActivitiListener> listeners = new ArrayList<ActivitiListener>();
        ArrayList<DecisionOption> options = new ArrayList<DecisionOption>();
        NodeConfig nodeConfig = null;
        if (this.isDescisionApproved()) {
            nodeConfig = this.packageOptionByEntry(currentNodeInfo, DECISION_APPROVE_NUMBER);
            options.add(nodeConfig.getDecisionOption());
            this.addActivitiListener(listeners, nodeConfig);
        }
        if (this.isDescisionReject()) {
            DecisionOption option = null;
            if (i == 1 || this.isYZJNode(i)) {
                nodeConfig = this.isYZJNode(i) ? this.packageOptionByEntry(currentNodeInfo, DECISION_REJECT_TO_ALL_AUDIT_NUMBER) : this.packageOptionByEntry(currentNodeInfo, DECISION_REJECT_TO_EDIT_NUMBER);
                option = nodeConfig.getDecisionOption();
                if (auditItems != null) {
                    Map auditItem = (Map)auditItems.get(0);
                    option.setRejectOptions(this.packageSelectNodeModel(auditItem));
                }
                options.add(option);
                this.addActivitiListener(listeners, nodeConfig);
            } else {
                if (this.isRejectToLastAll()) {
                    nodeConfig = this.packageOptionByEntry(currentNodeInfo, DECISION_REJECT_TO_ALL_AUDIT_NUMBER);
                    option = nodeConfig.getDecisionOption();
                    if (auditItems != null) {
                        ArrayList<SelectNodesModel> selectNodesModels = new ArrayList<SelectNodesModel>();
                        for (Map map : auditItems) {
                            selectNodesModels.addAll(this.packageSelectNodeModel(map));
                        }
                        option.setRejectOptions(selectNodesModels);
                    }
                    options.add(option);
                    this.addActivitiListener(listeners, nodeConfig);
                }
                if (this.isRejectToEdit()) {
                    nodeConfig = this.packageOptionByEntry(currentNodeInfo, DECISION_REJECT_TO_EDIT_NUMBER);
                    option = nodeConfig.getDecisionOption();
                    if (auditItems != null) {
                        Map auditItem = (Map)auditItems.get(0);
                        option.setRejectOptions(this.packageSelectNodeModel(auditItem));
                    }
                    options.add(option);
                    this.addActivitiListener(listeners, nodeConfig);
                }
                if (this.isRejectToLast()) {
                    nodeConfig = this.packageOptionByEntry(currentNodeInfo, DECISION_REJECT_TO_PRE_AUDIT_NUMBER);
                    options.add(nodeConfig.getDecisionOption());
                    this.addActivitiListener(listeners, nodeConfig);
                }
            }
        }
        if (this.isDescisionDisapprovedAndReject() && !this.isYZJNode(i)) {
            nodeConfig = this.packageOptionByEntry(currentNodeInfo, DECISION_TERMINATE_NUMBER);
            options.add(nodeConfig.getDecisionOption());
            this.addActivitiListener(listeners, nodeConfig);
        }
        config.put(NODE_CONFIG_TASK_LISTENERS, listeners);
        config.put(NODE_CONFIG_DECISION_OPTIONS, options);
    }

    private ActivitiListener getListenerFromDecisionOption(NodeConfig nodeConfig) {
        String withdraw;
        String forward = nodeConfig.getOperation();
        String operation = ExtItfPluginUtil.buildExtItfOperationValue(forward, withdraw = nodeConfig.getRecallOperation(), this.getPageCache().get("entrabillid"), null);
        ActivitiListener listener = this.packageExecutionListener("complete", operation, "operation");
        if (listener != null) {
            listener.setOperation(nodeConfig.getDecisionOption().getNumber());
        }
        return listener;
    }

    private List<ActivitiListener> packageExcutionListrnersByEntry(String userNodeId) {
        ArrayList<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>();
        if (userNodeId == null) {
            return executionListeners;
        }
        DynamicObjectCollection dobc = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (dobc != null) {
            for (DynamicObject dob : dobc) {
                String withdrawName;
                String withdraw;
                String forwardName;
                if (!userNodeId.equals(dob.get(ENTRY_NODE_ID))) continue;
                if (this.isPassedOperateEmpty(dob) && this.isBackOperateEmpty(dob)) break;
                String forward = (String)dob.get(ENTRY_PASSED_OPERATE_NUMBER);
                String operation = ExternalInterfaceUtil.buildExtItfOperationValue((String)forward, (String)(forwardName = (String)dob.get(ENTRY_PASSED_OPERATE)), (String)(withdraw = (String)dob.get(ENTRY_BACK_OPERATE_NUMBER)), (String)(withdrawName = (String)dob.get(ENTRY_BACK_OPERATE)));
                ActivitiListener listener = this.packageExecutionListener("end", operation, "operation");
                if (listener != null) {
                    listener.setOperation(listener.getEvent());
                }
                executionListeners.add(listener);
                break;
            }
        }
        return executionListeners;
    }

    private ActivitiListener packageExecutionListener(String event, String implementation, String type) {
        if (WfUtils.isEmptyString((Object)implementation)) {
            return null;
        }
        ActivitiListener listener = new ActivitiListener();
        listener.setEvent(event);
        listener.setImplementationType(type);
        listener.setImplementation(implementation);
        listener.setId(BpmnDiffUtil.getListElementId((String)NODE_CONFIG_EXECUTION_LISTENERS));
        return listener;
    }

    private NodeConfig packageOptionByEntry(Map<String, String> currentNodeInfo, String descisionType) {
        NodeConfig config = new NodeConfig();
        DecisionOption option = new DecisionOption();
        config.setDecisionOption(option);
        DynamicObjectCollection dobc = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (dobc == null) {
            return config;
        }
        for (DynamicObject dob : dobc) {
            if (!currentNodeInfo.get(NODE_ID).equals(dob.get(ENTRY_NODE_ID)) || !descisionType.equals(dob.get(ENTRY_DESCISION_NUMBER))) continue;
            option.setId(BpmnDiffUtil.getListElementId((String)NODE_CONFIG_DECISION_OPTIONS));
            option.setName((String)dob.get(ENTRY_DESCISION));
            option.setNumber((String)dob.get(ENTRY_DESCISION_NUMBER));
            if (!this.isPassedOperateEmpty(dob)) {
                config.setOperation((String)dob.get(ENTRY_PASSED_OPERATE_NUMBER));
            }
            if (!this.isBackOperateEmpty(dob)) {
                config.setRecallOperation((String)dob.get(ENTRY_BACK_OPERATE_NUMBER));
            }
            switch (descisionType) {
                case "Consent": {
                    option.setDefaultDecision(true);
                    option.setDecisionScene("approve");
                    option.setAuditType("approve");
                    break;
                }
                case "Terminate": {
                    option.setDecisionScene("terminate");
                    option.setAuditType("terminate");
                    break;
                }
                case "RejectToEdit": {
                    option.setDecisionScene("rejectToEditNode");
                    option.setAuditType("reject");
                    break;
                }
                case "RejectToPreAudit": {
                    option.setDecisionScene("rejectToPreAuditNode");
                    option.setAuditType("reject");
                    break;
                }
                case "RejectToAllAudit": {
                    option.setDecisionScene("rejectToAllAuditNode");
                    option.setAuditType("reject");
                }
            }
            break;
        }
        return config;
    }

    private List<SelectNodesModel> packageSelectNodeModel(Map<String, String> auditItem) {
        ArrayList<SelectNodesModel> SelectNodesModels = new ArrayList<SelectNodesModel>();
        SelectNodesModel selectNodesModel = new SelectNodesModel();
        selectNodesModel.setName(auditItem.get(NODE_NAME));
        selectNodesModel.setDocumentation("");
        selectNodesModel.setItemId(auditItem.get(NODE_ID));
        SelectNodesModels.add(selectNodesModel);
        return SelectNodesModels;
    }

    private String getUserNodeName() {
        return String.format(ResManager.loadKDString((String)"%s\u63d0\u4ea4", (String)"WorkflowModelWizardPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), this.getModel().getValue("entrabillname"));
    }

    private String getAuditNodeName(int i) {
        return String.format(ResManager.loadKDString((String)"%s\u7ea7\u5ba1\u6279", (String)"WorkflowModelWizardPlugin_32", (String)"bos-wf-formplugin", (Object[])new Object[0]), this.getYZJComboAuditLevel()[i - 1]);
    }

    private String getYZJNodeName() {
        return ResManager.loadKDString((String)"\u4f1a\u5ba1", (String)"WorkflowModelWizardPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }

    private String getStartNodeName() {
        return ResManager.loadKDString((String)"\u5f00\u59cb", (String)"WorkflowModelWizardPlugin_36", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }

    private String getEndNodeName() {
        return ResManager.loadKDString((String)"\u7ed3\u675f", (String)"WorkflowModelWizardPlugin_37", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    }

    private boolean isOnlySelectedRejectToEdit() {
        return this.isRejectToEdit() && !this.isRejectToLast() && !this.isRejectToLastAll();
    }

    private boolean isFinalNode(int i) {
        return this.getAuditLevel() == i;
    }

    private void entryRowLoadData(String[] values, int i) {
        if (values == null || values.length != 8) {
            return;
        }
        this.getModel().createNewEntryRow(ENTRY_ENTITY);
        this.getModel().setValue(ENTRY_NODE, (Object)values[0], i);
        this.getModel().setValue(ENTRY_NODE_ID, (Object)values[1], i);
        this.getModel().setValue(ENTRY_DESCISION, (Object)values[2], i);
        this.getModel().setValue(ENTRY_DESCISION_NUMBER, (Object)values[3], i);
        this.getModel().setValue(ENTRY_PASSED_OPERATE, (Object)values[4], i);
        this.getModel().setValue(ENTRY_BACK_OPERATE, (Object)values[5], i);
        this.getModel().setValue(ENTRY_PASSED_OPERATE_NUMBER, (Object)values[6], i);
        this.getModel().setValue(ENTRY_BACK_OPERATE_NUMBER, (Object)values[7], i);
    }

    private boolean isPassedOperateEmpty(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return true;
        }
        return WfUtils.isEmptyString((Object)dynamicObject.get(ENTRY_PASSED_OPERATE));
    }

    private boolean isBackOperateEmpty(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return true;
        }
        return WfUtils.isEmptyString((Object)dynamicObject.get(ENTRY_BACK_OPERATE));
    }

    private boolean isYZJNode(int i) {
        return this.getYZJLevel() == i;
    }

    private int getAuditLevel() {
        return this.getComboValue(CBAPPROVALSERIES, ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u201c\u5ba1\u6279\u7ea7\u6570\u201d\u3002", (String)"WorkflowModelWizardPlugin_33", (String)"bos-wf-formplugin", (Object[])new Object[0]));
    }

    private int getYZJLevel() {
        return this.getComboValue(CBYZJAUDIT, ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u4e91\u4e4b\u5bb6\u5ba1\u6279\u7ea7\u6570\u3002", (String)"WorkflowModelWizardPlugin_34", (String)"bos-wf-formplugin", (Object[])new Object[0]));
    }

    private int getComboValue(String comboId, String errorMessage) {
        try {
            return Integer.parseInt((String)this.getView().getModel().getValue(comboId));
        }
        catch (NumberFormatException numberFormatException) {
            throw new WFIllegalArgumentException(errorMessage);
        }
    }

    private boolean isDescisionApproved() {
        String descision = this.getDescisionValue();
        return descision.indexOf(49) > -1;
    }

    private boolean isDescisionReject() {
        String descision = this.getDescisionValue();
        return descision.indexOf(50) > -1;
    }

    private boolean isDescisionDisapprovedAndReject() {
        String descision = this.getDescisionValue();
        return descision.indexOf(51) > -1;
    }

    private String getDescisionValue() {
        String decision = (String)this.getModel().getValue(MUL_COMBO_DESCISION);
        return decision;
    }

    private boolean isRejectToEdit() {
        String descision = this.getRejectValue();
        return descision.indexOf(49) > -1;
    }

    private boolean isRejectToLast() {
        String descision = this.getRejectValue();
        return descision.indexOf(50) > -1;
    }

    private boolean isRejectToLastAll() {
        String descision = this.getRejectValue();
        return descision.indexOf(51) > -1;
    }

    private String getRejectValue() {
        String descision = (String)this.getModel().getValue(MUL_COMBO_REJECT);
        return descision;
    }

    private boolean isSendMessage() {
        return (Boolean)this.getModel().getValue(CHECKBOX_SEND_MESSAGE);
    }

    private boolean containOperation(String entrabillNumber, String opreationKey) {
        return this.getOperation(entrabillNumber, opreationKey) != null;
    }

    private Operation getOperation(String entrabillNumber, String opreationKey) {
        MetadataReader reader = new MetadataReader();
        String entityId = reader.loadIdByNumber(entrabillNumber, MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMetadata.getEntityId(), (MetaCategory)MetaCategory.Entity);
        List operations = metadata.getRootEntity().getOperations();
        if (operations == null) {
            return null;
        }
        for (Operation operation : operations) {
            if (!opreationKey.equalsIgnoreCase(operation.getKey())) continue;
            return operation;
        }
        return null;
    }

    private String getEventStartId(int number) {
        return this.getNodeId(this.getEventStartNumber(number));
    }

    private String getUserNodeId(int number) {
        return this.getNodeId(this.getUserNodeNumber(number));
    }

    private String getAuditNodeId(int number) {
        return this.getNodeId(this.getAuditNodeNumber(number));
    }

    private String getYZJNodeId(int number) {
        return this.getNodeId(this.getYZJNodeNumber(number));
    }

    private String getSequenceFlowId(int number) {
        return this.getNodeId(this.getSequenceFlowNumber(number));
    }

    private String getEventEndId(int number) {
        return this.getNodeId(this.getEventEndNumber(number));
    }

    private String getNodeId(String nodeNumber) {
        return String.format("%s_%s", this.getModel().getValue("key").toString(), nodeNumber);
    }

    private String getEventStartNumber(int number) {
        return "StartSignalEvent" + number;
    }

    private String getUserNodeNumber(int number) {
        return "UserTask" + number;
    }

    private String getAuditNodeNumber(int number) {
        return "AuditTask" + number;
    }

    private String getYZJNodeNumber(int number) {
        return "YunzhijiaTask" + number;
    }

    private String getSequenceFlowNumber(int number) {
        return "SequenceFlow" + number;
    }

    private String getEventEndNumber(int number) {
        return "EndNoneEvent" + number;
    }
}

