/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.PluginUtil;

public class WorkflowModifyExportFilenamePlugin
extends AbstractWorkflowPlugin {
    public static final String FILENAME = "filename";
    public static final String CONFIRMBTN = "confirmbtn";

    @Override
    public void initialize() {
        this.addClickListeners(new String[]{CONFIRMBTN});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String filename = (String)this.getView().getFormShowParameter().getCustomParam("key");
        this.getModel().setValue(FILENAME, (Object)filename);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (key.equals(CONFIRMBTN)) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        String filename = (String)this.getModel().getValue(FILENAME);
        if ("zh_CN".equals(RequestContext.get().getLang().toString()) && !PluginUtil.matchPattern("^([\\w\\u4e00-\\u9fa5\\-\\(\\)\\uFF08\\uFF09]+[\\w\\u4e00-\\u9fa5\\-\\(\\)\\s]*)$", filename)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6587\u4ef6\u540d\u79f0\u201d\u5e94\u4f7f\u7528\u5b57\u6bcd\u3001\u4e2d\u6587\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u62ec\u53f7\u6216\u6a2a\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f\u3002", (String)"WorkflowModifyExportFilenamePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)filename);
        this.getView().close();
    }
}

