/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.ParticipantConfigureHelper;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.msg.MessageServiceConfig;
import kd.bos.workflow.engine.msg.util.MessageUtils;

public class WorkflowMsgNotifyConfigurePlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String INENTRY = "inmsg";
    private static final String OUTENTRY = "outmsg";
    private static final String OUTENTRY_SENDEVT = "outmsg_sendevt";
    private static final String OUTENTRY_NOTIFYTYPE = "outmsg_notifytype";
    private static final String INENTRY_NOTIFYTYPE = "inmsg_notifytype";
    private static final String INENTRY_SENDEVT = "inmsg_sendevt";
    private static final String OUTMSG_RULE = "outmsg_rule";
    private static final String SV_OUTMSG_RULE = "sv_outmsg_rule";
    private static final String INMSG_RULE = "inmsg_rule";
    private static final String SV_INMSG_RULE = "sv_inmsg_rule";
    private static final String SV_OUTENTRY_CONTENT = "sv_outmsg_content";
    private static final String SV_INENTRY_CONTENT = "sv_inmsg_content";
    private static final String SV_OUTENTRY_NOTIFYSUBJECT = "sv_outmsg_notifysubject";
    private static final String SV_INENTRY_NOTIFYSUBJECT = "sv_inmsg_notifysubject";
    private static final String OUTENTRY_CONTENT = "outmsg_content";
    private static final String INENTRY_CONTENT = "inmsg_content";
    private static final String OUTENTRY_NOTIFYSUBJECT = "outmsg_notifysubject";
    private static final String INENTRY_NOTIFYSUBJECT = "inmsg_notifysubject";
    private static final String OUTENTRY_RECEIVER = "outmsg_receiver";
    private static final String INENTRY_RECEIVER = "inmsg_receiver";
    private static final String SV_OUTENTRY_RECEIVER = "sv_outmsg_receiver";
    private static final String SV_INENTRY_RECEIVER = "sv_inmsg_receiver";
    private static final String OUTMSG_ID = "outmsg_id";
    private static final String INMSG_ID = "inmsg_id";
    private static final String INENTRY_MESSAGETYPE = "inmsg_messagetype";
    private static final String OUTENTRY_MESSAGETYPE = "outmsg_messagetype";
    private static final String DEFNOTITYPE = "defNotifyType";
    private static final String DEALTABID = "tabpageap_deal";
    private static final String ENTITY_PARTICIPANT_IN = "in_participant_entity";
    private static final String BTN_ADD_PAR_IN = "in_add_participant";
    private static final String PARTICIPANT_PICTURE_IN = "participant_picture_in";
    private static final String PARTICIPANT_VALUE_PREFIX_IN = "participant_sv_prefix_in";
    private static final String PARTICIPANT_SHOWVALUE_IN = "participant_showvalue_in";
    private static final String ENTITY_PARTICIPANT_OUT = "out_participant_entity";
    private static final String BTN_ADD_PART_OUT = "out_add_participant";
    private static final String PARTICIPANT_PICTURE_OUT = "participant_picture_out";
    private static final String PARTICIPANT_VALUE_PREFIX_OUT = "participant_sv_prefix_out";
    private static final String PARTICIPANT_SHOWVALUE_OUT = "participant_showvalue_out";
    private static final String NOTIFYTYPE = "notifyType";
    private static final String NOTIFY = "notify";
    private static final String REPORTTYPE = "reportType";
    private static final String REFERENCEPERSON = "referencePerson";
    private static final String PERSONRELATION = "personRelation";
    private static final String RECEIVER = "receiver";
    private static final String BTN_INMSG_COPY = "btn_inmsg_copy";
    private static final String BTN_INMSG_PASTE = "btn_inmsg_paste";
    private static final String BTN_OUTMSG_COPY = "btn_outmsg_copy";
    private static final String BTN_OUTMSG_PASTE = "btn_outmsg_paste";
    private static final String ENTITYNUMBER = "entityNumber";
    private static final String SENDEVT = "sendevt";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(ENTITY_PARTICIPANT_IN, ENTITY_PARTICIPANT_OUT, PARTICIPANT_PICTURE_OUT, PARTICIPANT_VALUE_PREFIX_OUT, PARTICIPANT_SHOWVALUE_OUT, PARTICIPANT_PICTURE_IN, PARTICIPANT_VALUE_PREFIX_IN, PARTICIPANT_SHOWVALUE_IN, SV_OUTMSG_RULE, SV_INMSG_RULE);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit outContent = (TextEdit)this.getControl(SV_OUTENTRY_CONTENT);
        outContent.addButtonClickListener((ClickListener)this);
        TextEdit inContent = (TextEdit)this.getControl(SV_INENTRY_CONTENT);
        inContent.addButtonClickListener((ClickListener)this);
        TextEdit outmsgRule = (TextEdit)this.getControl(SV_OUTMSG_RULE);
        outmsgRule.addButtonClickListener((ClickListener)this);
        TextEdit inmsgRule = (TextEdit)this.getControl(SV_INMSG_RULE);
        inmsgRule.addButtonClickListener((ClickListener)this);
        TextEdit outEntryReceiver = (TextEdit)this.getControl(SV_OUTENTRY_RECEIVER);
        outEntryReceiver.addButtonClickListener((ClickListener)this);
        TextEdit inEntryReceiver = (TextEdit)this.getControl(SV_INENTRY_RECEIVER);
        inEntryReceiver.addButtonClickListener((ClickListener)this);
        this.addClickListeners(new String[]{BTN_INMSG_COPY, BTN_INMSG_PASTE, BTN_OUTMSG_COPY, BTN_OUTMSG_PASTE});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initSendTimeItems();
        this.initNotifytype();
        this.loadMessageType();
        JSONObject properties = this.getCellProperties();
        JSONArray inMsg = this.getMessage(properties, INENTRY);
        JSONArray outMsg = this.getMessage(properties, OUTENTRY);
        this.initMessageGrid(inMsg, outMsg);
        this.initControlVisible();
    }

    private void initSendTimeItems() {
        this.initSendTimeWhenOut();
        this.initSendTimeWhenIn();
    }

    private void initNotifytype() {
        List configs = this.getRepositoryService().getMessageConfigs();
        LinkedHashMap<String, Object> items = new LinkedHashMap<String, Object>();
        if (configs != null && configs.size() > 0) {
            StringBuilder notifyType = new StringBuilder();
            for (MessageServiceConfig config : configs) {
                items.put(config.getServiceName(), config.getServiceKey());
                if (!config.isDefaultService()) continue;
                notifyType.append(config.getServiceKey()).append(',');
            }
            if (items.size() == 1) {
                if (notifyType.length() == 0) {
                    notifyType.append(((MessageServiceConfig)configs.get(0)).getServiceKey());
                }
                if (notifyType.lastIndexOf(",") > -1) {
                    this.getPageCache().put(DEFNOTITYPE, notifyType.substring(0, notifyType.length() - 1));
                } else {
                    this.getPageCache().put(DEFNOTITYPE, notifyType.toString());
                }
            }
        }
        PluginUtil.setComboForControl(items, (ComboEdit)this.getControl(OUTENTRY_NOTIFYTYPE));
        PluginUtil.setComboForControl(items, (ComboEdit)this.getControl(INENTRY_NOTIFYTYPE));
    }

    private void loadMessageType() {
        LinkedHashMap<String, Object> sendEvt = new LinkedHashMap<String, Object>();
        if (BpmnModelUtil.instanceofUserTask((String)this.stencilType)) {
            sendEvt.put(WFMultiLangConstants.getMessageTypeTodoName(), "todo");
        }
        sendEvt.put(WFMultiLangConstants.getMessageTypeNotifyName(), NOTIFY);
        PluginUtil.setComboForControl(sendEvt, (ComboEdit)this.getControl(INENTRY_MESSAGETYPE));
    }

    private void initMessageGrid(JSONArray inMsg, JSONArray outMsg) {
        super.initEntryGridValue((EntryGrid)this.getControl(INENTRY), inMsg);
        super.initEntryGridValue((EntryGrid)this.getControl(OUTENTRY), outMsg);
    }

    @Override
    protected void initEntryGridValue(EntryGrid grid, JSONArray array) {
    }

    @Override
    protected Object getEntryFieldValue(EntryGrid grid, JSONObject obj, String ctrlKey) {
        Object val = super.getEntryFieldValue(grid, obj, ctrlKey);
        if (val != null && ctrlKey.contains("_notifytype")) {
            String[] types;
            StringBuilder v = new StringBuilder();
            List configs = this.getRepositoryService().getMessageConfigs();
            for (String type : types = ((String)val).split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)type)) continue;
                for (MessageServiceConfig cfg : configs) {
                    if (!cfg.getServiceKey().equalsIgnoreCase(type)) continue;
                    v.append(type).append(',');
                }
            }
            String vstring = v.toString();
            if (WfUtils.isNotEmpty((String)v.toString())) {
                vstring = v.substring(0, v.length() - 1);
            }
            return vstring;
        }
        if (val instanceof List && (INENTRY_RECEIVER.equals(ctrlKey) || OUTENTRY_RECEIVER.equals(ctrlKey))) {
            return JSON.toJSONString((Object)val);
        }
        return val;
    }

    private void initSendTimeWhenOut() {
        LinkedHashMap<String, Object> sendEvt = new LinkedHashMap<String, Object>();
        sendEvt.put(WFMultiLangConstants.getSentEvtOutName(), "end");
        JSONArray outSendEvt = new JSONArray();
        outSendEvt.add((Object)"end");
        JSONArray decisionOptions = null;
        try {
            JSONObject properties = this.getCellProperties();
            if (BpmnModelUtil.instanceofAuditTask((String)this.stencilType)) {
                decisionOptions = properties.getJSONArray("decisionOptions");
            } else if (BpmnModelUtil.instanceofUserTask((String)this.stencilType) && (decisionOptions = properties.getJSONArray("decisionOptions")) == null) {
                decisionOptions = properties.getJSONArray("operation");
            }
            if (decisionOptions != null && decisionOptions.size() > 1) {
                for (int i = 0; i < decisionOptions.size(); ++i) {
                    JSONObject node = decisionOptions.getJSONObject(i);
                    sendEvt.put(node.getString("name"), node.getString("number"));
                    outSendEvt.add((Object)node.getString("number"));
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u53d1\u9001\u65f6\u673a\u201d\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"WorkflowMsgNotifyConfigurePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        this.getView().getPageCache().put(OUTENTRY, outSendEvt.toString());
        PluginUtil.setComboForControl(sendEvt, (ComboEdit)this.getControl(OUTENTRY_SENDEVT));
    }

    private void initSendTimeWhenIn() {
        LinkedHashMap<String, Object> sendEvt = new LinkedHashMap<String, Object>();
        sendEvt.put(WFMultiLangConstants.getSentEvtInName(), "start");
        JSONArray inSendEvt = new JSONArray();
        inSendEvt.add((Object)"start");
        if (BpmnModelUtil.instanceofUserTask((String)this.stencilType)) {
            if (!(BpmnModelUtil.instanceofSSCApprover((String)this.stencilType) || BpmnModelUtil.instanceofSSCImageUpload((String)this.stencilType) || BpmnModelUtil.instanceofBillTask((String)this.stencilType))) {
                sendEvt.put(WFMultiLangConstants.getSentEvtIntaskReceivedName(), "taskReceived");
                inSendEvt.add((Object)"taskReceived");
            }
            if (!"BizFlowModel".equals(this.modelType)) {
                sendEvt.put(WFMultiLangConstants.getSentEvtInrejectName(), "reject");
                inSendEvt.add((Object)"reject");
            }
        }
        this.getView().getPageCache().put(INENTRY, inSendEvt.toString());
        PluginUtil.setComboForControl(sendEvt, (ComboEdit)this.getControl(INENTRY_SENDEVT));
    }

    private void initControlVisible() {
        if (!BpmnModelUtil.instanceofUserTask((String)this.stencilType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{INENTRY_SENDEVT, OUTENTRY_SENDEVT});
            if ("NotifyTask".equalsIgnoreCase(this.stencilType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{DEALTABID});
                Tab tab = (Tab)this.getControl("messagetab");
                tab.activeTab("tabpageap_todo");
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{INENTRY_CONTENT, OUTENTRY_CONTENT});
    }

    private JSONArray getMessage(JSONObject properties, String key) {
        String entryKey;
        JSONArray messages = (JSONArray)properties.get((Object)(key.equals(INENTRY) ? "inMsg" : "outMsg"));
        String string = entryKey = "NotifyTask".equalsIgnoreCase(this.stencilType) ? INENTRY : OUTENTRY;
        if (messages == null && entryKey.equals(key)) {
            messages = this.compatibleMessage(properties);
        }
        return messages;
    }

    private JSONArray compatibleMessage(JSONObject properties) {
        JSONArray val = null;
        if ("NotifyTask".equalsIgnoreCase(this.stencilType)) {
            val = this.parseMessageModel(properties, "inMsg.receiver");
            if (val != null && val.size() > 0) {
                this.setProperty("inMsg", val);
                this.deleteProperties(this.itemId, NOTIFYTYPE, "content", "notifyReceivers");
            }
        } else {
            Boolean isNotify = (Boolean)DesignerModelUtil.getProperty((Map<String, Object>)properties, "message.notify");
            if (null != isNotify && isNotify.booleanValue()) {
                JSONObject oVal = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, "message");
                val = this.parseMessageModel(oVal, "outMsg.receiver");
                this.setProperty("outMsg", val);
            }
            this.deleteProperty("message");
        }
        return val;
    }

    protected JSONArray parseMessageModel(JSONObject oVal, String propertyName) {
        JSONArray val = new JSONArray();
        JSONObject tmp = new JSONObject();
        tmp.put(NOTIFY, oVal.get((Object)NOTIFY) == null ? Boolean.TRUE : oVal.get((Object)NOTIFY));
        tmp.put(NOTIFYTYPE, oVal.get((Object)NOTIFYTYPE));
        tmp.put(SENDEVT, (Object)"start");
        tmp.put("messageType", (Object)NOTIFY);
        tmp.put("content", oVal.get((Object)"content"));
        Object receiver = oVal.get((Object)"notifyReceivers");
        JSONArray arr = null;
        if (receiver instanceof JSONArray) {
            arr = (JSONArray)receiver;
        } else if (receiver instanceof JSONObject && ((JSONObject)receiver).get((Object)"participant") != null) {
            arr = (JSONArray)((JSONObject)receiver).get((Object)"participant");
        }
        if (arr != null && arr.size() > 0) {
            JSONArray tArr = new JSONArray();
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject t;
                JSONObject o = arr.getJSONObject(i);
                String type = o.getString("type");
                String value = o.getString("value");
                if ("PROCESSPERSON".equalsIgnoreCase(type) && "initiator".equalsIgnoreCase(value)) {
                    t = new JSONObject();
                    t.put("defaultCondition", (Object)Boolean.FALSE);
                    t.put("description", (Object)ResManager.loadKDString((String)"\u5173\u7cfb\uff1a\u6d41\u7a0b-\u6d41\u7a0b\u53d1\u8d77\u4eba\u672c\u4eba", (String)"WorkflowMsgNotifyConfigurePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    t.put("type", (Object)"relation");
                    t.put(REPORTTYPE, (Object)"admin_org");
                    t.put("property", (Object)propertyName);
                    t.put("value", (Object)ResManager.loadKDString((String)"\u6d41\u7a0b-\u6d41\u7a0b\u53d1\u8d77\u4eba\u672c\u4eba", (String)"WorkflowMsgNotifyConfigurePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    t.put("roleId", (Object)"0");
                    t.put(REFERENCEPERSON, (Object)"PROC_initiator");
                    t.put(PERSONRELATION, (Object)"self");
                    tArr.add((Object)t);
                    continue;
                }
                if ("PERSON".equalsIgnoreCase(type)) {
                    t = new JSONObject();
                    t.put("openpagebyformid", (Object)"bos_usertreelistf7_part");
                    t.put("selectedType", (Object)"person");
                    t.put("property", (Object)propertyName);
                    t.put("type", (Object)"person");
                    t.put("value", (Object)value);
                    tArr.add((Object)t);
                    continue;
                }
                if (!"RELATION".equalsIgnoreCase(type)) continue;
                t = new JSONObject();
                t.put(REPORTTYPE, (Object)o.getString(REPORTTYPE));
                t.put("defaultCondition", (Object)o.getBoolean("defaultCondition"));
                t.put("value", (Object)o.getString("value"));
                t.put("mainDescription", (Object)o.getString("mainDescription"));
                t.put("type", (Object)o.getString("type"));
                t.put("property", (Object)propertyName);
                t.put("orgUnitId", (Object)o.getString("orgUnitId"));
                t.put(REFERENCEPERSON, (Object)o.getString(REFERENCEPERSON));
                t.put(PERSONRELATION, (Object)o.getString(PERSONRELATION));
                tArr.add((Object)t);
            }
            tmp.put(RECEIVER, (Object)tArr);
        }
        if (WfUtils.isNotEmpty((String)tmp.getString("content")) && !WfUtils.isNullObject((Object)tmp.getJSONArray(RECEIVER))) {
            val.add((Object)tmp);
        }
        return val;
    }

    @Override
    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        String sign = "";
        switch (key) {
            case "sv_outmsg_content": {
                this.showContent(OUTENTRY, SV_OUTENTRY_CONTENT);
                break;
            }
            case "sv_inmsg_content": {
                this.showContent(INENTRY, SV_INENTRY_CONTENT);
                break;
            }
            case "sv_outmsg_rule": {
                this.showMsgSendRule(OUTENTRY, SV_OUTMSG_RULE);
                break;
            }
            case "sv_inmsg_rule": {
                this.showMsgSendRule(INENTRY, SV_INMSG_RULE);
                break;
            }
            case "sv_outmsg_receiver": {
                sign = "out";
                this.showMseReceiver(sign);
                break;
            }
            case "sv_inmsg_receiver": {
                sign = "in";
                this.showMseReceiver(sign);
                break;
            }
            case "btn_outmsg_copy": {
                this.copyMessageModel(OUTENTRY);
                break;
            }
            case "btn_outmsg_paste": {
                this.pasteMessageModel(OUTENTRY);
                break;
            }
            case "btn_inmsg_copy": {
                this.copyMessageModel(INENTRY);
                break;
            }
            case "btn_inmsg_paste": {
                this.pasteMessageModel(INENTRY);
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void copyMessageModel(String msgEntryKey) {
        JSONObject properties = this.getCellProperties();
        JSONArray msgArray = this.getMessage(properties, msgEntryKey);
        EntryGrid msgEntry = (EntryGrid)this.getControl(msgEntryKey);
        int[] rows = msgEntry.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u6d88\u606f\u3002", (String)"WorkflowMsgNotifyConfigurePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            JSONObject copyObject = new JSONObject();
            String entityNumber = this.getEntityNumber(properties);
            copyObject.put(ENTITYNUMBER, (Object)entityNumber);
            JSONArray copyMsgArray = new JSONArray();
            if (msgArray != null) {
                for (int i : rows) {
                    copyMsgArray.add(msgArray.get(i));
                }
            }
            copyObject.put("copyMsgArray", (Object)copyMsgArray);
            WfCacheHelper.putCopyMessageModel((String)copyObject.toJSONString());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"WorkflowMsgNotifyConfigurePlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private String getEntityNumber(JSONObject properties) {
        String entityNumber = properties.getString(ENTITYNUMBER);
        if ("AutoTask".equals(this.stencilType)) {
            String entityId = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "service.entityId");
            entityNumber = MetadataDao.getEntityNumberById((String)entityId);
        }
        return entityNumber;
    }

    private void pasteMessageModel(String msgEntryKey) {
        String copy = WfCacheHelper.getCopyMessageModel();
        if (WfUtils.isJSONObject((Object)copy)) {
            JSONObject copyObject = JSONObject.parseObject((String)copy);
            String entityNumberFromCopy = copyObject.getString(ENTITYNUMBER);
            JSONArray copyMsgArray = copyObject.getJSONArray("copyMsgArray");
            if (WfUtils.isNotEmpty((String)entityNumberFromCopy) && copyMsgArray != null) {
                JSONObject obj;
                int i;
                String entityNumber = this.getEntityNumber(this.getCellProperties());
                if (!entityNumberFromCopy.equals(entityNumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b9e\u4f53\u6ca1\u6709\u53ef\u4ee5\u7c98\u8d34\u7684\u6d88\u606f\u3002", (String)"WorkflowMsgNotifyConfigurePlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!BpmnModelUtil.instanceofUserTask((String)this.stencilType)) {
                    String sendEvt = OUTENTRY.equals(msgEntryKey) ? "end" : "start";
                    for (i = 0; i < copyMsgArray.size(); ++i) {
                        obj = copyMsgArray.getJSONObject(i);
                        obj.put(SENDEVT, (Object)sendEvt);
                    }
                }
                JSONArray sendEvtArray = JSONArray.parseArray((String)this.getView().getPageCache().get(msgEntryKey));
                for (i = 0; i < copyMsgArray.size(); ++i) {
                    obj = copyMsgArray.getJSONObject(i);
                    String sendEvt = obj.getString(SENDEVT);
                    if (!sendEvtArray.contains((Object)sendEvt)) {
                        obj.remove((Object)SENDEVT);
                    }
                    String field = OUTENTRY.equals(msgEntryKey) ? "outMsg" : "inMsg";
                    obj.put("id", (Object)BpmnDiffUtil.getListElementId((String)field));
                    JSONArray receiverArray = obj.getJSONArray(RECEIVER);
                    if (null == receiverArray || receiverArray.isEmpty()) continue;
                    for (int j = 0; j < receiverArray.size(); ++j) {
                        JSONObject receiverObj = receiverArray.getJSONObject(j);
                        if (null == receiverObj) continue;
                        receiverObj.put("id", (Object)BpmnDiffUtil.getListElementId((String)"participant"));
                    }
                }
                super.initEntryGridValue((EntryGrid)this.getControl(msgEntryKey), copyMsgArray);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u7c98\u8d34\u7684\u6d88\u606f\u3002", (String)"WorkflowMsgNotifyConfigurePlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u7c98\u8d34\u7684\u6d88\u606f\u3002", (String)"WorkflowMsgNotifyConfigurePlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void showMseReceiver(String sign) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_nodemes_receiver");
        parameter.setCustomParam("itemId", (Object)this.itemId);
        parameter.setCustomParam("ModelJson", (Object)this.getModelJsonString());
        String receiver = "in".equals(sign) ? INENTRY_RECEIVER : OUTENTRY_RECEIVER;
        Object value = this.getModel().getValue(receiver, this.getEntryEntityFocusRow("in".equals(sign) ? INENTRY : OUTENTRY));
        parameter.setCustomParam("data", value);
        String actionId = "in".equals(sign) ? BTN_ADD_PAR_IN : BTN_ADD_PART_OUT;
        parameter.setCustomParam("needSourceElement", (Object)BTN_ADD_PAR_IN.equals(actionId));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        if ("in".equals(sign) && BpmnModelUtil.instanceofUserTask((String)this.stencilType) && !BpmnModelUtil.instanceofSSCApprover((String)this.stencilType) && !BpmnModelUtil.instanceofSSCImageUpload((String)this.stencilType)) {
            if ("taskReceived".equals(this.getModel().getValue(INENTRY_SENDEVT))) {
                parameter.setCustomParam("referencePersonScene", (Object)"taskReceived");
            } else {
                parameter.setCustomParam("referencePersonScene", (Object)INENTRY);
            }
        }
        this.getView().showForm(parameter);
    }

    private void showMsgSendRule(String entryEntityName, String actionId) {
        int focusRow = this.getEntryEntityFocusRow(entryEntityName);
        if (DesignerModelUtil.getProperty((Map<String, Object>)this.getCellProperties(), entryEntityName) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"WorkflowMsgNotifyConfigurePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        WorkflowMsgNotifyConfigurePlugin.openConditionalRule(this.getView(), this.getCellProperties(), this.getModelJsonString(), this.itemId, ConditionalRuleType.msgSendRule, entryEntityName, focusRow, "rule", actionId);
    }

    public static String openConditionalRule(IFormView view, JSONObject properties, String modelJson, String itemId, ConditionalRuleType type, String entryEntityName, int focusRow, String property, String actionId) {
        JSONArray entryEntityProperties = (JSONArray)DesignerModelUtil.getProperty((Map<String, Object>)properties, entryEntityName);
        JSONObject focusRowProperties = entryEntityProperties.getJSONObject(focusRow);
        JSONObject conditionRule = null;
        if (!WfUtils.isEmptyString((Object)focusRowProperties.get((Object)property))) {
            conditionRule = (JSONObject)focusRowProperties.get((Object)property);
        }
        String typeStr = type.toString();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("type", typeStr);
        context.put("model", modelJson);
        context.put("property", property);
        HashMap<String, String> nodeProperties = new HashMap<String, String>();
        nodeProperties.put("itemId", itemId);
        context.put("nodeProperties", nodeProperties);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("context", context);
        params.put("value", conditionRule != null ? conditionRule.toJSONString() : null);
        params.put("needSourceElement", false);
        String typeName = ConditionalRuleType.getTypeName((String)typeStr);
        FormShowParameter parameter = WorkflowMsgNotifyConfigurePlugin.getFormShowParameter(view, "wf_conditionrule_update", actionId);
        parameter.setShowTitle(false);
        parameter.setCaption(typeName);
        parameter.setCustomParams(params);
        parameter.setCustomParam("isDefaultScheme", view.getFormShowParameter().getCustomParam("isDefaultScheme"));
        parameter.setCustomParam("schemeId", view.getFormShowParameter().getCustomParam("schemeId"));
        parameter.setHasRight(true);
        view.showForm(parameter);
        return parameter.getPageId();
    }

    private static FormShowParameter getFormShowParameter(IFormView view, String formId, String actionId) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        IFormPlugin plugin = pluginProxy.getPlugin(WorkflowMsgNotifyConfigurePlugin.class.getName());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        return parameter;
    }

    private void showContent(String entryId, String actionId) {
        String entityId;
        JSONObject properties = this.getCellProperties();
        String modelJson = this.getModelJsonString();
        String entityNumber = null;
        if ("AutoTask".equals(this.stencilType)) {
            entityId = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "service.entityId");
            if (WfUtils.isNotEmpty((String)entityId)) {
                entityNumber = EntityMetadataCache.getDataEntityTypeById((String)entityId).getName();
            } else {
                JSONObject processProps = this.getProcessProperties();
                entityNumber = (String)processProps.get((Object)"entraBill");
            }
        } else if (BpmnModelUtil.instanceofUserTask((String)this.stencilType)) {
            entityNumber = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, ENTITYNUMBER);
        } else if ("CallActivity".equals(this.stencilType)) {
            entityNumber = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, ENTITYNUMBER);
        } else if ("NotifyTask".equals(this.stencilType)) {
            entityNumber = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, ENTITYNUMBER);
        } else if ("BroadcastTask".equals(this.stencilType)) {
            entityId = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "entityId");
            entityNumber = MetadataDao.getNumberById((String)entityId);
        } else if ("WaitTask".equals(this.stencilType)) {
            entityNumber = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, ENTITYNUMBER);
        } else {
            JSONObject processProps = this.getProcessProperties();
            entityNumber = (String)processProps.get((Object)"entraBill");
        }
        if (WfUtils.isEmpty((String)entityNumber)) {
            if ("BillTask".equals(this.stencilType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u6765\u6e90\u5355\u636e\u201d\u3002", (String)"WorkflowMsgNotifyConfigurePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"WorkflowMsgNotifyConfigurePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("modelJson", modelJson);
        content.put(ENTITYNUMBER, entityNumber);
        content.put("showTitle", Boolean.TRUE);
        content.put("operationSource", "flowNode");
        EntryGrid grid = (EntryGrid)this.getControl(entryId);
        int index = grid.getEntryState().getFocusRow();
        if (index > -1) {
            boolean isOnlyEmail;
            DynamicObject obj = this.getModel().getEntryRowEntity(entryId, index);
            Object channel = this.getModel().getValue(entryId + "_notifytype");
            boolean bl = isOnlyEmail = channel == null ? false : MessageChannelUtils.isOnlyEmailChannel((String)((String)channel));
            if (obj != null) {
                String msgContent = (String)obj.get(INENTRY.equals(entryId) ? INENTRY_CONTENT : OUTENTRY_CONTENT);
                String msgTitle = (String)obj.get(INENTRY.equals(entryId) ? INENTRY_NOTIFYSUBJECT : OUTENTRY_NOTIFYSUBJECT);
                if (WfUtils.isNotEmpty((String)msgContent) || WfUtils.isNotEmpty((String)msgTitle)) {
                    JSONObject jsonObject = new JSONObject();
                    if (WfUtils.isJSONObject((Object)msgTitle) || WfUtils.isJSONObject((Object)msgContent)) {
                        JSONObject titleObj = JSONObject.parseObject((String)msgTitle);
                        JSONObject contentObj = JSONObject.parseObject((String)msgContent);
                        if (isOnlyEmail) {
                            jsonObject.put("emailTitle", (Object)titleObj);
                            jsonObject.put("emailContent", (Object)contentObj);
                        } else {
                            jsonObject.put("title", (Object)titleObj);
                            jsonObject.put("content", (Object)contentObj);
                        }
                    } else {
                        LocaleString titleStr = new LocaleString();
                        LocaleString contentStr = new LocaleString();
                        String lang = Lang.get().toString();
                        if (WfUtils.isNotEmpty((String)msgTitle)) {
                            titleStr.setItem(lang, (Object)msgTitle);
                        }
                        if (WfUtils.isNotEmpty((String)msgContent)) {
                            contentStr.setItem(lang, (Object)msgContent);
                        }
                        if (isOnlyEmail) {
                            jsonObject.put("emailTitle", (Object)titleStr);
                            jsonObject.put("emailContent", (Object)contentStr);
                        } else {
                            jsonObject.put("title", (Object)titleStr);
                            jsonObject.put("content", (Object)contentStr);
                        }
                    }
                    content.put("value", jsonObject.toString());
                }
            }
            content.put("FROM", "MSG");
            String openPageFormId = isOnlyEmail ? "wf_emailcontent" : "wf_msgcontent";
            this.showForm(actionId, openPageFormId, ResManager.loadKDString((String)"\u6d88\u606f\u5185\u5bb9", (String)"WorkflowMsgNotifyConfigurePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), content);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (!(evt.getReturnData() instanceof Map)) {
            return;
        }
        Map returnData = (Map)evt.getReturnData();
        switch (actionId) {
            case "sv_outmsg_content": {
                this.setContent(OUTENTRY, returnData);
                break;
            }
            case "sv_inmsg_content": {
                this.setContent(INENTRY, returnData);
                break;
            }
            case "in_add_participant": {
                String receiverStringIn = (String)returnData.get("receivers");
                this.updateMessageReceivers(INENTRY, receiverStringIn);
                break;
            }
            case "out_add_participant": {
                String receiverStringOut = (String)returnData.get("receivers");
                this.updateMessageReceivers(OUTENTRY, receiverStringOut);
                break;
            }
            case "sv_outmsg_rule": {
                this.updateMsgSendRule(returnData, OUTENTRY, OUTMSG_RULE);
                break;
            }
            case "sv_inmsg_rule": {
                this.updateMsgSendRule(returnData, INENTRY, INMSG_RULE);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void updateMsgSendRule(Object returnData, String entryEntityName, String propertyName) {
        this.log.debug(String.format("\u66f4\u65b0\u6d88\u606f\u53d1\u9001\u89c4\u5219\u7684\u503creturnData: %s", returnData));
        int focusRow = this.getEntryEntityFocusRow(entryEntityName);
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.log.debug(String.format("returnData instanceof Map, %s", data));
            if (data.isEmpty()) {
                this.log.debug(String.format("data is empty == true, propertyName[%s], focusRow[%s]", propertyName, focusRow));
                this.getModel().setValue(propertyName, null, focusRow);
                return;
            }
            if (focusRow > -1) {
                this.log.debug(String.format("returnData\u8f6c\u6362\u6210JsonString,[%s]", WfUtils.mapToString((Object)data)));
                this.getModel().setValue(propertyName, (Object)SerializationUtils.toJsonString((Object)data), focusRow);
            }
        }
    }

    private void updateMessageReceivers(String msgEntryId, String data) {
        String receiverId = INENTRY.equals(msgEntryId) ? INENTRY_RECEIVER : OUTENTRY_RECEIVER;
        String receiverEntity = INENTRY.equals(msgEntryId) ? INENTRY : OUTENTRY;
        int rowIndex = this.getEntryEntityFocusRow(receiverEntity);
        this.getModel().setValue(receiverId, (Object)data, rowIndex);
    }

    private void setContent(String entry, Map<String, Object> returnData) {
        EntryGrid grid = (EntryGrid)this.getControl(entry);
        int index = grid.getEntryState().getFocusRow();
        if (index > -1) {
            String content = "";
            String title = "";
            Object contentObj = null;
            Object titleObj = null;
            if (returnData.size() > 0) {
                JSONObject jsonObject = JSONObject.parseObject((String)SerializationUtils.toJsonString(returnData));
                if (returnData.containsKey("emailTitle") || returnData.containsKey("emailContent")) {
                    contentObj = jsonObject.get((Object)"emailContent");
                    titleObj = jsonObject.get((Object)"emailTitle");
                } else {
                    contentObj = jsonObject.get((Object)"content");
                    titleObj = jsonObject.get((Object)"title");
                }
                content = contentObj instanceof JSONObject ? MessageUtils.handleData((JSONObject)((JSONObject)contentObj)) : String.valueOf(contentObj);
                title = titleObj instanceof JSONObject ? MessageUtils.handleData((JSONObject)((JSONObject)titleObj)) : String.valueOf(titleObj);
            }
            this.getModel().setValue(INENTRY.equals(entry) ? INENTRY_CONTENT : OUTENTRY_CONTENT, (Object)String.valueOf(contentObj), index);
            this.getModel().setValue(INENTRY.equals(entry) ? INENTRY_NOTIFYSUBJECT : OUTENTRY_NOTIFYSUBJECT, (Object)String.valueOf(titleObj), index);
            this.getModel().setValue(INENTRY.equals(entry) ? SV_INENTRY_CONTENT : SV_OUTENTRY_CONTENT, (Object)content, index);
            this.getModel().setValue(INENTRY.equals(entry) ? SV_INENTRY_NOTIFYSUBJECT : SV_OUTENTRY_NOTIFYSUBJECT, (Object)title, index);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object getGridCellVal(String name, DynamicObject dynObj) {
        if (INENTRY_RECEIVER.equals(name) || OUTENTRY_RECEIVER.equals(name)) {
            String data = dynObj.getString(name);
            if (!WfUtils.isNotEmpty((String)data)) return null;
            try {
                JSONArray ret = (JSONArray)JSONUtils.cast((String)data, JSONArray.class);
                if (ret == null || ret.isEmpty()) return ret;
                for (int i = 0; i < ret.size(); ++i) {
                    Map impl = (Map)ret.get(i);
                    impl.put("property", INENTRY_RECEIVER.equals(name) ? "inMsg.receiver" : "outMsg.receiver");
                }
                return ret;
            }
            catch (IOException e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6 \u201c%s\u201d \u5c5e\u6027\u503c\u5931\u8d25\u3002", (String)"WorkflowMsgNotifyConfigurePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), name));
                this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
                return super.getGridCellVal(name, dynObj);
            }
        } else {
            if (!INMSG_RULE.equals(name) && !OUTMSG_RULE.equals(name)) return super.getGridCellVal(name, dynObj);
            if (dynObj.get(name) == null || !WfUtils.isNotEmpty((String)dynObj.get(name).toString())) return null;
            return SerializationUtils.fromJsonString((String)dynObj.get(name).toString(), Map.class);
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        int index;
        super.afterAddRow(e);
        String gridKey = e.getEntryProp().getName();
        if (!this.isMessageSendGrid(gridKey)) {
            return;
        }
        RowDataEntity[] data = e.getRowDataEntities();
        if (data != null && data.length > 0 && (index = data[0].getRowIndex()) > -1) {
            String defNotifyType = this.getPageCache().get(DEFNOTITYPE);
            String receiver = null;
            if (gridKey.equals(INENTRY)) {
                receiver = this.getPageCache().get(ParticipantConfigureHelper.getDatasCacheKey(ENTITY_PARTICIPANT_IN));
                this.getModel().setValue(INMSG_ID, (Object)BpmnDiffUtil.getListElementId((String)"inMsg"), index);
                this.getView().getModel().setValue(INENTRY_RECEIVER, (Object)receiver, index);
                this.getView().getModel().setValue(INENTRY_SENDEVT, (Object)"start", index);
                this.getView().getModel().setValue(INENTRY_MESSAGETYPE, (Object)NOTIFY, index);
                if (defNotifyType != null) {
                    this.getView().getModel().setValue(INENTRY_NOTIFYTYPE, (Object)defNotifyType, index);
                }
            } else if (gridKey.equals(OUTENTRY)) {
                receiver = this.getPageCache().get(ParticipantConfigureHelper.getDatasCacheKey(ENTITY_PARTICIPANT_OUT));
                this.getModel().setValue(OUTMSG_ID, (Object)BpmnDiffUtil.getListElementId((String)"outMsg"), index);
                this.getView().getModel().setValue(OUTENTRY_RECEIVER, (Object)receiver, index);
                this.getView().getModel().setValue(OUTENTRY_MESSAGETYPE, (Object)NOTIFY, index);
                this.getView().getModel().setValue(OUTENTRY_SENDEVT, (Object)"end", index);
                if (defNotifyType != null) {
                    this.getView().getModel().setValue(OUTENTRY_NOTIFYTYPE, (Object)defNotifyType, index);
                }
            }
        }
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String gridKey = e.getEntryProp().getName();
        if (!this.isMessageSendGrid(gridKey)) {
            return;
        }
    }

    private boolean isMessageSendGrid(String key) {
        return INENTRY.equals(key) || OUTENTRY.equals(key);
    }

    @Override
    protected Object getEntryFieldShowValue(String property, Object value) {
        if ("rule".equals(property)) {
            if (!WfUtils.isEmptyString((Object)value)) {
                String lang = RequestContext.get().getLang().toString();
                if (value instanceof String) {
                    JSONObject josn = JSONObject.parseObject((String)((String)value));
                    if (!josn.isEmpty()) {
                        return josn.getJSONObject("showtext").get((Object)lang);
                    }
                    return null;
                }
                if (value instanceof JSONObject) {
                    JSONObject data = (JSONObject)value;
                    JSONObject showText = null;
                    if (data.containsKey((Object)"showtext") && (showText = data.getJSONObject("showtext")) != null) {
                        return showText.get((Object)lang);
                    }
                    return null;
                }
            }
        } else if ("content".equals(property)) {
            if (WfUtils.isJSONObject((Object)value)) {
                return MessageUtils.handleData((JSONObject)JSONObject.parseObject((String)((String)value)));
            }
        } else if ((value instanceof List || value instanceof String) && RECEIVER.equals(property)) {
            List receiver = null;
            if (value instanceof String && StringUtils.isNotBlank((Object)value)) {
                receiver = (List)SerializationUtils.fromJsonString((String)((String)value), List.class);
            } else if (value instanceof List) {
                receiver = (List)value;
            }
            StringBuilder receiverShowText = this.getReceiverShowText(receiver);
            return super.getEntryFieldShowValue(property, receiverShowText);
        }
        return super.getEntryFieldShowValue(property, value);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(ParticipantConfigureHelper.getDatasCacheKey(ENTITY_PARTICIPANT_IN));
        this.getPageCache().remove(ParticipantConfigureHelper.getDatasCacheKey(ENTITY_PARTICIPANT_OUT));
        this.getPageCache().remove(OUTENTRY);
        this.getPageCache().remove(INENTRY);
    }

    private StringBuilder getReceiverShowText(List<Map<String, Object>> receivers) {
        StringBuilder receiverShowText = new StringBuilder();
        if (receivers == null || receivers.isEmpty()) {
            return null;
        }
        int size = receivers.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> receiver = receivers.get(i);
            String receiver_prefix = ParticipantHelper.receiverPrefix((String)((String)receiver.get("type")));
            String receiver_value = ParticipantConfigureHelper.getTextFromParams(receiver);
            receiverShowText.append(receiver_prefix).append(receiver_value);
            if (i >= size - 1) continue;
            receiverShowText.append(' ').append(';').append(' ');
        }
        return receiverShowText;
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (StringUtils.isBlank((Object)newValue)) {
            if (SV_OUTMSG_RULE.equals(propName)) {
                this.getModel().setValue(OUTMSG_RULE, newValue, rowIndex);
                this.getModel().endInit();
            } else if (SV_INMSG_RULE.equals(propName)) {
                this.getModel().setValue(INMSG_RULE, newValue, rowIndex);
                this.getModel().endInit();
            } else if (SV_OUTENTRY_RECEIVER.equals(propName)) {
                this.getModel().setValue(OUTENTRY_RECEIVER, null, rowIndex);
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            } else if (SV_INENTRY_RECEIVER.equals(propName)) {
                this.getModel().setValue(INENTRY_RECEIVER, null, rowIndex);
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            } else if (SV_INENTRY_CONTENT.equals(propName)) {
                this.getModel().setValue(INENTRY_CONTENT, newValue, rowIndex);
                this.getModel().setValue(INENTRY_NOTIFYSUBJECT, newValue, rowIndex);
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            } else if (SV_OUTENTRY_CONTENT.equals(propName)) {
                this.getModel().setValue(OUTENTRY_CONTENT, newValue, rowIndex);
                this.getModel().setValue(OUTENTRY_NOTIFYSUBJECT, newValue, rowIndex);
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            } else {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        } else {
            if (INENTRY_SENDEVT.equals(propName)) {
                String inmsgReceiver = (String)this.getModel().getValue(INENTRY_RECEIVER, rowIndex);
                String svCurrentParticipantName = (String)this.getModel().getValue(SV_INENTRY_RECEIVER, rowIndex);
                if (WfUtils.isNotEmpty((String)inmsgReceiver) && WfUtils.isNotEmpty((String)svCurrentParticipantName)) {
                    this.getModel().setValue(INENTRY_RECEIVER, (Object)this.transformName(newValue, inmsgReceiver), rowIndex);
                    this.getModel().setValue(SV_INENTRY_RECEIVER, (Object)this.transformName(newValue, svCurrentParticipantName), rowIndex);
                }
            }
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    private String transformName(Object sendEvt, String oldString) {
        if (WfUtils.isNotEmptyString((Object)oldString)) {
            if ("taskReceived".equals(sendEvt)) {
                return oldString.replace(WFMultiLangConstants.getCurrentParticipantName(), WFMultiLangConstants.getTaskReceiverName());
            }
            return oldString.replace(WFMultiLangConstants.getTaskReceiverName(), WFMultiLangConstants.getCurrentParticipantName());
        }
        return null;
    }
}

