/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.model.ParticipantEntryInfo;
import kd.bos.workflow.design.util.ParticipantConfigureHelper;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowMsgReceiverPlugin
extends AbstractWorkflowPlugin {
    private static final String ENTITY_PARTICIPANT = "participant_entity";
    private static final String BTN_ADD_PART = "add_participant";
    private static final String BTN_EDIT_PART = "edit_participant";
    private static final String BTN_DEL_PART = "del_participant";
    private static final String PARTICIPANT_PICTURE = "participant_picture";
    private static final String PARTICIPANT_VALUE_PREFIX = "participant_sv_prefix";
    private static final String PARTICIPANT_SHOWVALUE = "participant_showvalue";
    private static final String RETURNDATALIST = "returnDataAllList";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String value = (String)this.getView().getFormShowParameter().getCustomParam("data");
        List receiver = null;
        if (WfUtils.isNotEmpty((String)value)) {
            receiver = (List)SerializationUtils.fromJsonString((String)value, List.class);
        }
        this.initMessageReceivers(receiver);
    }

    private void initMessageReceivers(List<Map<String, Object>> receiver) {
        if (receiver != null && !receiver.isEmpty()) {
            this.initReceivers(receiver);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTITY_PARTICIPANT});
        }
    }

    private void initReceivers(List<Map<String, Object>> receiver) {
        this.getView().setVisible(Boolean.TRUE, new String[]{ENTITY_PARTICIPANT});
        ParticipantEntryInfo info = new ParticipantEntryInfo(ENTITY_PARTICIPANT, PARTICIPANT_PICTURE, PARTICIPANT_VALUE_PREFIX, PARTICIPANT_SHOWVALUE, null);
        ParticipantConfigureHelper.initParticipantEntryEntity(this, info, receiver);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADD_PART, BTN_DEL_PART, BTN_EDIT_PART, "btnok"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "add_participant": {
                this.addParticipant(key);
                break;
            }
            case "edit_participant": {
                this.modifyParticipant(key);
                break;
            }
            case "del_participant": {
                this.deleteParticipant(key);
                break;
            }
            case "btnok": {
                this.returnToParent();
                break;
            }
        }
    }

    private void addParticipant(String key) {
        String entryId = ENTITY_PARTICIPANT;
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        String ModelJson = (String)this.getView().getFormShowParameter().getCustomParam("ModelJson");
        ParticipantConfigureHelper.addParticipant(this, entryId, itemId, ModelJson, key);
    }

    private void modifyParticipant(String key) {
        String entryId = ENTITY_PARTICIPANT;
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        String ModelJson = (String)this.getView().getFormShowParameter().getCustomParam("ModelJson");
        ParticipantConfigureHelper.modifyParticipant(this, entryId, itemId, ModelJson, key);
    }

    private void deleteParticipant(String key) {
        String entryId = ENTITY_PARTICIPANT;
        ParticipantConfigureHelper.deleteParticipant(this, entryId);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (!(evt.getReturnData() instanceof Map)) {
            return;
        }
        Map returnData = (Map)evt.getReturnData();
        switch (actionId) {
            case "add_participant": {
                this.updateParticipant(actionId, "operation_add", returnData);
                break;
            }
            case "edit_participant": {
                this.updateParticipant(actionId, "operation_modify", returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void updateParticipant(String actionId, String operation, Map<String, Object> returnData) {
        ParticipantEntryInfo info = new ParticipantEntryInfo();
        info.setRowData(returnData);
        info.setEntryId(ENTITY_PARTICIPANT);
        info.setValueId(PARTICIPANT_SHOWVALUE);
        info.setPictureId(PARTICIPANT_PICTURE);
        info.setPrefixId(PARTICIPANT_VALUE_PREFIX);
        ParticipantConfigureHelper.setParticipantEntryValue(this, info, operation);
    }

    private void returnToParent() {
        String cacheKey = WorkflowMsgReceiverPlugin.getDatasCacheKey(ENTITY_PARTICIPANT);
        String cacheData = this.getPageCache().get(cacheKey);
        HashMap<String, String> receiverMap = new HashMap<String, String>();
        if (WfUtils.isNotEmpty((String)cacheData)) {
            receiverMap.put("receivers", cacheData);
            this.getView().returnDataToParent(receiverMap);
        }
        this.getView().close();
    }

    public static String getDatasCacheKey(String entryId) {
        return String.format("%s_%s", RETURNDATALIST, entryId);
    }
}

