/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.ConditionalRuleUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.ExpireOperationUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.rule.expression.property.ExpressionProperty;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;
import org.apache.commons.lang.BooleanUtils;

public class WorkflowNodeControlPlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String PROPERTY_ENTITY_NUMBER = "entityNumber";
    private static final String PROPERTY_EXPIRE_MODEL = "expireModel";
    private static final String PROPERTY_SKIP_CONDITION = "skipCondition";
    private static final String SKIPCONDITION = "skipcondition";
    private static final String EXPIREMODEL_PANEL = "expiremodel_panel";
    private static final String TIMECONTROLS_ID = "timecontrols_id";
    private static final String SV_TIMECONTROLS_OPERATION = "sv_timecontrols_operation";
    private static final String TIMECONTROLS_OPERATION = "timecontrols_operation";
    private static final String TIMECONTROLS = "timecontrols";
    private static final String TIMECONTROLS_INDEX = "timecontrolsIndex";
    private static final String EXPIRETIME_EXPRESSION = "expiretime_expression";
    private static final String EXPIRETIME_PLUGIN = "expiretime_plugin";
    private static final String EXPIRETIME_FIXEDVALUE = "expiretime";
    private static final String TIMEUNIT = "timeunit";
    private static final String EXPIRETYPE = "expiretype";
    private static final String TIMECONTROLS_DURATION = "timecontrols_duration";
    private static final String TIMECONTROLS_CONTROLTYPE = "timecontrols_controltype";
    private static final String TIMECONTROLS_TIMETYPE = "timecontrols_timetype";
    private static final String EXPIREBTN = "expirebtn";
    private static final String EXPIRETIME = "expireTime";
    private static final String EXPRESSIONTYPE = "expressionType";
    private static final String FORK = "fork";
    private static final String LEAVEWITHALLNOTJOIN = "leavewithallnotjoin";
    protected static final String JOIN = "join";
    private static final String OUTSET_PANEL = "outset_panel";
    private static final String INSET_PANEL = "inset_panel";
    private static final String LEAVEWHENALLMEET = "leavewhenallmeet";
    private static final String PASSTYPEPANEL = "passtypepanel";
    private static final String OUTSET = "outset";
    private static final String CIRCULATEWHENMATCH = "circulatewhenmatch";
    private static final String FP_CIRCULATESETTING = "fp_circulatesetting";
    private static final String CIRCULATE = "circulate";
    private static final String SHOWTEXT = "showtext";
    private static final String ALLOWSENDTODO = "allowsendtodo";
    private static final String ADVCONAP2 = "advconap2";
    private static final String SIGNATURE_FLEX = "signatureflex";
    private static final String FORCE_SIGNATURE_FLEX = "fp_forcesignature";
    public static final String ALLOW_SIGNATURE = "allowSignature";
    private static final String ALLOW_SIGNATURE_LOW = "allowsignature";
    public static final String FORCE_SIGNATURE = "forceSignature";
    private static final String FORCE_SIGNATURE_LOW = "forcesignature";
    private static final String SIGNATURE_MODEL = "SignatureModel";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(SKIPCONDITION, EXPIRETIME_EXPRESSION, EXPIRETIME_PLUGIN);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SKIPCONDITION, SV_TIMECONTROLS_OPERATION, CIRCULATE, EXPIRETIME_EXPRESSION, EXPIRETIME_PLUGIN});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject properties = this.getCellProperties();
        this.initSkipCondition(properties);
        this.initExpireControl(properties);
        this.initOutSetPanel(properties);
        this.initCirculateSetting(properties);
        this.initAllowSendTodo(properties);
        this.initSignature(properties);
    }

    private void initAllowSendTodo(JSONObject properties) {
        if ("BizFlowModel".equals(this.modelType) && "BillTask".equals(this.stencilType)) {
            this.setProperty(properties, ALLOWSENDTODO, false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ADVCONAP2});
            this.getModel().setValue(ALLOWSENDTODO, (Object)false);
        }
    }

    private void initSignature(JSONObject properties) {
        if (Objects.equals("SSCApprove", this.stencilType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SIGNATURE_FLEX});
            return;
        }
        JSONObject signatureModel = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, SIGNATURE_MODEL);
        if (WfUtils.isNullObject((Object)signatureModel)) {
            return;
        }
        Boolean allowSignature = signatureModel.getBoolean(ALLOW_SIGNATURE);
        if (!BooleanUtils.toBoolean((Boolean)allowSignature)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FORCE_SIGNATURE_FLEX});
            return;
        }
        this.getModel().setValue(ALLOW_SIGNATURE_LOW, (Object)Boolean.TRUE);
        Boolean forceSignature = signatureModel.getBoolean(FORCE_SIGNATURE);
        if (BooleanUtils.toBoolean((Boolean)forceSignature)) {
            this.getModel().setValue(FORCE_SIGNATURE, (Object)Boolean.TRUE);
        }
    }

    private void initOutSetPanel(JSONObject properties) {
        Object enableOutSet = DesignerModelUtil.getProperty((Map<String, Object>)properties, FORK);
        if ("WorkflowModel".equals(this.modelType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LEAVEWITHALLNOTJOIN});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LEAVEWHENALLMEET});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"insetcontainer"});
        }
        if (enableOutSet != null && ((Boolean)enableOutSet).booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{OUTSET_PANEL});
            Object outset = DesignerModelUtil.getProperty((Map<String, Object>)properties, OUTSET);
            if (LEAVEWHENALLMEET.equals(outset) && "WorkflowModel".equals(this.modelType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{PASSTYPEPANEL});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{PASSTYPEPANEL});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{OUTSET_PANEL});
        }
        Object enableInSet = DesignerModelUtil.getProperty((Map<String, Object>)properties, JOIN);
        if (enableInSet != null && ((Boolean)enableInSet).booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{INSET_PANEL});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{INSET_PANEL});
        }
    }

    private void initSkipCondition(JSONObject properties) {
        JSONObject skipCondition = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, PROPERTY_SKIP_CONDITION);
        if (skipCondition != null && !skipCondition.isEmpty()) {
            this.getModel().setValue(SKIPCONDITION, (Object)ConditionalRuleUtil.getShowText(skipCondition));
        } else {
            skipCondition = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, "control.skipCondition");
            if (skipCondition != null) {
                this.deleteProperties(this.itemId, "control.skipCondition");
                this.setProperty(properties, PROPERTY_SKIP_CONDITION, skipCondition);
            }
        }
        if (this.isMandatory(properties)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{SKIPCONDITION});
        }
    }

    protected boolean isMandatory(JSONObject props) {
        return Boolean.TRUE.equals(DesignerModelUtil.getProperty((Map<String, Object>)props, String.format("%s.%s", "controlIntensity", "mandatory")));
    }

    private void initExpireControl(JSONObject properties) {
        JSONObject expireJson = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, PROPERTY_EXPIRE_MODEL);
        if (expireJson == null) {
            return;
        }
        boolean expireBtn = expireJson.getBooleanValue(EXPIREBTN);
        this.getView().setVisible(Boolean.valueOf(expireBtn), new String[]{EXPIREMODEL_PANEL});
        String expireType = expireJson.getString("expireType");
        String expireTime = expireJson.getString(EXPIRETIME);
        if (WfUtils.isNotEmpty((String)expireTime) && expireTime.matches("[0-9]+[dhm]")) {
            this.switchTimeControlMode("fixedValue");
            int index = expireTime.length() - 1;
            String unit = expireTime.substring(index);
            String value = expireTime.substring(0, index);
            this.getModel().setValue(TIMEUNIT, (Object)unit);
            this.getModel().setValue(EXPIRETYPE, (Object)"fixedValue");
            this.getModel().setValue(EXPIRETIME_FIXEDVALUE, (Object)value);
        } else {
            this.switchTimeControlMode(expireType);
            if ("expression".equals(expireType)) {
                this.getModel().setValue(EXPIRETIME_EXPRESSION, (Object)expireTime);
                String expressionType = expireJson.getString(EXPRESSIONTYPE);
                if (WfUtils.isNotEmpty((String)expireTime) && ExpressionPropUtils.isExpressionDateType((String)expressionType)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{TIMEUNIT});
                }
            } else if ("plugin".equals(expireType)) {
                this.getModel().setValue(EXPIRETIME_PLUGIN, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)expireTime));
            } else if ("".equals(expireType)) {
                this.getModel().setValue(EXPIRETIME_EXPRESSION, null);
            }
        }
        Object timeControls = expireJson.get((Object)"timeControls");
        if (timeControls instanceof JSONArray) {
            JSONArray ja = (JSONArray)timeControls;
            for (int i = 0; i < ja.size(); ++i) {
                JSONObject o = (JSONObject)ja.get(i);
                String controltype = (String)o.get((Object)"controltype");
                if (!WfUtils.isNotEmpty((String)controltype) || !controltype.equals("onDuration")) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{TIMECONTROLS_DURATION});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{TIMECONTROLS_TIMETYPE});
            }
        }
    }

    private void initCirculateSetting(JSONObject properties) {
        Boolean circulateWhenMatch = (Boolean)DesignerModelUtil.getProperty((Map<String, Object>)properties, "circulateModel.circulateWhenMatch");
        this.getModel().setValue(CIRCULATEWHENMATCH, (Object)circulateWhenMatch);
        this.getView().setVisible(circulateWhenMatch, new String[]{FP_CIRCULATESETTING});
        Object circulateObject = DesignerModelUtil.getProperty((Map<String, Object>)properties, "circulateModel.circulate");
        if (!WfUtils.isEmptyString((Object)circulateObject)) {
            JSONObject circulate = (JSONObject)circulateObject;
            this.getModel().setValue(CIRCULATE, ((JSONObject)circulate.get((Object)SHOWTEXT)).get((Object)Lang.get().toString()));
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        JSONObject properties = this.getCellProperties();
        switch (key = ctrl.getKey()) {
            case "skipcondition": {
                this.getView().getFormShowParameter().setCustomParam("isDefaultScheme", (Object)this.getIdeViewPageCacheData("isDefaultScheme"));
                this.getView().getFormShowParameter().setCustomParam("schemeId", (Object)this.getIdeViewPageCacheData("schemeId"));
                DesignerPluginUtil.openConditionalRule(this.getView(), (IFormPlugin)this, this.getCellProperties(), this.getModelJsonString(), this.itemId, ConditionalRuleType.skip, PROPERTY_SKIP_CONDITION, SKIPCONDITION);
                break;
            }
            case "sv_timecontrols_operation": {
                this.openTimeControlOperationPage();
                break;
            }
            case "circulate": {
                this.openCirculateSettingPage();
                break;
            }
            case "expiretime_plugin": {
                this.showPageForExpiretime(properties, this.getModelJsonString());
                break;
            }
            case "expiretime_expression": {
                this.showPageForExpression(properties, this.getModelJsonString());
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void showPageForExpression(JSONObject properties, String modelJson) {
        String entityNumber = properties.getString(PROPERTY_ENTITY_NUMBER);
        String errorInfo = WFMultiLangConstants.getNodeBillNotNull();
        if ("BillTask".equals(this.stencilType)) {
            entityNumber = properties.getString("sourceEntityNumber");
            errorInfo = WFMultiLangConstants.getBillTaskSourceBillNotNull();
        }
        if (WfUtils.isEmpty((String)entityNumber)) {
            this.getView().showTipNotification(errorInfo);
            return;
        }
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("bpmnModel", modelJson);
        content.put(PROPERTY_ENTITY_NUMBER, entityNumber);
        content.put("ruleType", (String)ConditionalRuleType.skip);
        content.put("fromSubjectModelAndApp", "fromSubjectModelAndApp");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "expression"));
        parameter.setFormId("wf_valueexpression");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(content);
        parameter.setCustomParam("filter", (Object)String.format("%1$s,%2$s", "number", "date"));
        JSONObject expireModel = (JSONObject)properties.get((Object)PROPERTY_EXPIRE_MODEL);
        Object expireTime = expireModel.get((Object)EXPIRETIME);
        if (expireTime != null) {
            String expireTimeStr = (String)expireTime;
            String value = expireTimeStr.replace("$", "").replace("{", "").replace("}", "");
            parameter.setCustomParam("expression", (Object)value);
        }
        this.showForm(parameter);
    }

    private void showPageForExpiretime(JSONObject properties, String modelJson) {
        try {
            String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"});
            JSONObject expireJson = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, PROPERTY_EXPIRE_MODEL);
            String value = (String)DesignerModelUtil.getProperty((Map<String, Object>)expireJson, EXPIRETIME);
            DesignerPluginUtil.openExternalInterface(this.getView(), (IFormPlugin)this, types, properties.getString("entityId"), value);
        }
        catch (Exception e) {
            this.log.error(String.format("\u521d\u59cb\u5916\u90e8\u63a5\u53e3\u76f8\u5173\u4fe1\u606f\u51fa\u9519--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01 %s %s", e.getMessage(), WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    public void openTimeControlOperationPage() {
        JSONObject properties = this.getCellProperties();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(TIMECONTROLS);
        int rowIndex = grid.getEntryState().getFocusRow();
        Object o = this.getModel().getValue(TIMECONTROLS_OPERATION, rowIndex);
        String controlType = (String)this.getModel().getValue(TIMECONTROLS_CONTROLTYPE, rowIndex);
        if (WfUtils.isEmpty((String)controlType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63a7\u5236\u7c7b\u578b\u3002", (String)"WorkflowNodeControlPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        this.getPageCache().put(TIMECONTROLS_INDEX, rowIndex + "");
        Object decisionOptions = DesignerModelUtil.getProperty((Map<String, Object>)properties, "decisionOptions");
        Object entityNumber = DesignerModelUtil.getProperty((Map<String, Object>)properties, PROPERTY_ENTITY_NUMBER);
        HashMap<String, Object> params = new HashMap<String, Object>();
        String entityId = (String)BpmnModelUtil.getProperty((Map)properties, (String)"service.entityId");
        if (WfUtils.isEmpty((String)entityId)) {
            JSONObject processProps = this.getProcessProperties();
            entityId = (String)processProps.get((Object)"entraBillId");
        }
        params.put("entityId", entityId);
        params.put("modelJson", this.getModelJsonString());
        if ("BillTask".equals(this.stencilType)) {
            entityNumber = DesignerModelUtil.getProperty((Map<String, Object>)properties, "sourceEntityNumber");
            params.put("hideAutoAudit", Boolean.TRUE);
        }
        params.put("model_type", this.getModelType());
        params.put(PROPERTY_ENTITY_NUMBER, entityNumber);
        params.put("decisionOptions", decisionOptions);
        params.put("controlType", controlType);
        params.put("params", ExpireOperationUtil.getExpireOperation(o, this.stencilType, controlType));
        params.put("itemId", this.itemId);
        this.showForm(SV_TIMECONTROLS_OPERATION, "wf_expireoperation_edit", params);
    }

    private void openCirculateSettingPage() {
        JSONObject properties = this.getCellProperties();
        Object entityNumber = DesignerModelUtil.getProperty((Map<String, Object>)properties, PROPERTY_ENTITY_NUMBER);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelJson", this.getModelJsonString());
        params.put("properties", properties);
        params.put("itemId", this.itemId);
        params.put(PROPERTY_ENTITY_NUMBER, entityNumber);
        params.put("stencilType", this.stencilType);
        params.put("isDefaultScheme", this.getIdeViewPageCacheData("isDefaultScheme"));
        params.put("schemeId", this.getIdeViewPageCacheData("schemeId"));
        params.put("needSourceElement", Boolean.TRUE);
        this.showForm(CIRCULATE, "wf_circulatesetting", params);
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "skipcondition": {
                this.skipConditionChanged(newValue);
                break;
            }
            case "circulate": {
                this.circulateChanged(newValue);
                break;
            }
            case "expirebtn": {
                this.switchExpirePanelState(newValue);
                break;
            }
            case "expiretime_expression": 
            case "expiretime_plugin": {
                this.expireTimeChanged(newValue);
                break;
            }
            case "timecontrols_controltype": {
                this.timeControlTypeChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "fork": {
                this.getView().setVisible((Boolean)newValue, new String[]{OUTSET_PANEL});
                if (((Boolean)newValue).booleanValue()) {
                    String value = (String)this.getModel().getValue(OUTSET);
                    if (LEAVEWHENALLMEET.equals(value) && "WorkflowModel".equals(this.modelType)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{PASSTYPEPANEL});
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{PASSTYPEPANEL});
                    }
                }
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "join": {
                this.getView().setVisible((Boolean)newValue, new String[]{INSET_PANEL});
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "outset": {
                String val = (String)this.getModel().getValue(OUTSET);
                if (LEAVEWHENALLMEET.equals(val) && "WorkflowModel".equals(this.modelType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{PASSTYPEPANEL});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{PASSTYPEPANEL});
                }
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "circulatewhenmatch": {
                this.switchCirculatePanelState(newValue);
                break;
            }
            case "expiretype": {
                this.switchTimeControlMode(newValue);
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "sv_timecontrols_operation": {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                if (!WfUtils.isEmpty((String)((String)newValue))) break;
                this.getModel().setValue(TIMECONTROLS_OPERATION, null, rowIndex);
                super.propertyChanged(TIMECONTROLS_OPERATION, null, oldValue, rowIndex);
                break;
            }
            case "allowsignature": {
                this.switchSignaturePanelState(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void circulateChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty(CIRCULATE, null);
        }
    }

    private void expireTimeChanged(Object newValue) {
        if (WfUtils.isEmptyString((Object)newValue)) {
            this.setProperty(EXPIRETIME, newValue);
            this.setProperty(EXPRESSIONTYPE, newValue);
            this.getView().setVisible(Boolean.TRUE, new String[]{TIMEUNIT});
        }
    }

    private void switchTimeControlMode(Object newValue) {
        if ("plugin".equals(newValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{EXPIRETIME_EXPRESSION, EXPIRETIME_FIXEDVALUE});
            this.getView().setVisible(Boolean.TRUE, new String[]{EXPIRETIME_PLUGIN});
            this.getModel().setValue(EXPIRETIME_FIXEDVALUE, null);
            this.getModel().setValue(EXPIRETIME_EXPRESSION, null);
        } else if ("expression".equals(newValue) || "".equals(newValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{EXPIRETIME_PLUGIN, EXPIRETIME_FIXEDVALUE});
            this.getView().setVisible(Boolean.TRUE, new String[]{EXPIRETIME_EXPRESSION});
            this.getModel().setValue(EXPIRETIME_FIXEDVALUE, null);
            this.getModel().setValue(EXPIRETIME_PLUGIN, null);
        } else if ("fixedValue".equals(newValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{EXPIRETIME_PLUGIN, EXPIRETIME_EXPRESSION});
            this.getView().setVisible(Boolean.TRUE, new String[]{EXPIRETIME_FIXEDVALUE});
            this.getModel().setValue(EXPIRETIME_EXPRESSION, null);
            this.getModel().setValue(EXPIRETIME_PLUGIN, null);
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{TIMEUNIT});
    }

    private void skipConditionChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty(SKIPCONDITION, null);
        }
    }

    private void switchExpirePanelState(Object newValue) {
        this.getView().setVisible((Boolean)newValue, new String[]{EXPIREMODEL_PANEL});
        this.setProperty(EXPIREBTN, newValue);
    }

    private void timeControlTypeChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        Object expireControlType = this.getModel().getValue(TIMECONTROLS_CONTROLTYPE, rowIndex);
        if (!WfUtils.isEmptyString((Object)expireControlType) && "onDuration".equals(expireControlType)) {
            this.getModel().setValue(TIMECONTROLS_DURATION, null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{TIMECONTROLS_DURATION});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{TIMECONTROLS_TIMETYPE});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{TIMECONTROLS_DURATION});
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{TIMECONTROLS_TIMETYPE});
        }
        Object val = this.getModel().getValue(SV_TIMECONTROLS_OPERATION, rowIndex);
        if (WfUtils.isNotEmptyString((Object)val) && val.toString().contains(ResManager.loadKDString((String)"\u53d1\u9001", (String)"WorkflowNodeControlPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]))) {
            this.getModel().setValue(SV_TIMECONTROLS_OPERATION, (Object)"", rowIndex);
            this.getModel().setValue(TIMECONTROLS_OPERATION, (Object)"", rowIndex);
        }
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
    }

    private void switchCirculatePanelState(Object newValue) {
        this.getView().setVisible((Boolean)newValue, new String[]{FP_CIRCULATESETTING});
        this.setProperty(CIRCULATEWHENMATCH, newValue);
    }

    private void switchSignaturePanelState(String propName, Object newValue, Object oldValue, int rowIndex) {
        boolean isAllowSignature = Objects.equals(Boolean.TRUE, newValue);
        this.getView().setVisible(Boolean.valueOf(isAllowSignature), new String[]{FORCE_SIGNATURE_FLEX});
        Object forceSignature = this.getModel().getValue(FORCE_SIGNATURE_LOW);
        boolean isForceSignature = Objects.equals(Boolean.TRUE, forceSignature);
        if (!isAllowSignature && isForceSignature) {
            this.setProperty(FORCE_SIGNATURE, Boolean.FALSE);
            this.getModel().setValue(FORCE_SIGNATURE_LOW, (Object)Boolean.FALSE);
        }
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = evt.getActionId()) {
            case "skipcondition": {
                this.setCloseSkipCondition((Map)returnData);
                break;
            }
            case "sv_timecontrols_operation": {
                this.setTimeControlOperation(returnData);
                break;
            }
            case "circulate": {
                this.setCloseBackForCirculate(returnData);
                break;
            }
            case "externalInterface": {
                this.setCloseDataForexpireTimePlugin(returnData);
                break;
            }
            case "expression": {
                this.setExpiretime((Map)returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setExpiretime(Map<String, Object> m) {
        if (m != null && !WfUtils.isNullObject((Object)m.get("expression")) && WfUtils.isNotEmptyString((Object)m.get("prop"))) {
            String expression = "${" + m.get("expression") + "}";
            this.getModel().setValue(EXPIRETIME_EXPRESSION, (Object)expression);
            this.setProperty(EXPIRETIME, expression);
            ExpressionProperty prop = (ExpressionProperty)SerializationUtils.fromJsonString((String)String.valueOf(m.get("prop")), ExpressionProperty.class);
            String expressionType = prop.getControlType();
            this.setProperty(EXPRESSIONTYPE, expressionType);
            if (ExpressionPropUtils.isExpressionDateType((String)expressionType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{TIMEUNIT});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{TIMEUNIT});
            }
        }
    }

    private void setCloseDataForexpireTimePlugin(Object returnData) {
        if (returnData != null) {
            this.getModel().setValue(EXPIRETIME_PLUGIN, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)((String)returnData)));
            this.setProperty(EXPIRETIME, returnData);
        }
    }

    private void setTimeControlOperation(Object returnData) {
        if (returnData instanceof Map) {
            Map m = (Map)returnData;
            int focus = Integer.parseInt(this.getPageCache().get(TIMECONTROLS_INDEX));
            this.getPageCache().remove(TIMECONTROLS_INDEX);
            this.getModel().setValue(TIMECONTROLS_OPERATION, (Object)SerializationUtils.toJsonString((Object)m), focus);
            this.getModel().setValue(SV_TIMECONTROLS_OPERATION, m.get("name"), focus);
        }
    }

    private void setCloseBackForCirculate(Object returnData) {
        if (returnData instanceof Map) {
            Map circulateData = (Map)returnData;
            this.getModel().setValue(CIRCULATE, (Object)DesignerPluginUtil.getLocaleValue(circulateData.get(SHOWTEXT)));
            this.setProperty(CIRCULATE, circulateData);
        }
    }

    @Override
    protected Object getEntryFieldShowValue(String property, Object value) {
        if ("operation".equals(property) && value instanceof Map) {
            Map m = (Map)value;
            return m.get("name");
        }
        return super.getEntryFieldShowValue(property, value);
    }

    @Override
    protected Object getGridCellVal(String name, DynamicObject dynObj) {
        if (TIMECONTROLS_OPERATION.equals(name) && dynObj.get(name) != null && WfUtils.isNotEmpty((String)dynObj.get(name).toString())) {
            Map m = (Map)SerializationUtils.fromJsonString((String)dynObj.get(name).toString(), Map.class);
            return m;
        }
        return super.getGridCellVal(name, dynObj);
    }

    private void setCloseSkipCondition(Map<String, Object> evtData) {
        if (evtData.isEmpty()) {
            this.getModel().setValue(SKIPCONDITION, null);
            this.setProperty(SKIPCONDITION, null);
            return;
        }
        this.getModel().setValue(SKIPCONDITION, (Object)DesignerPluginUtil.getLocaleValue(evtData.get(SHOWTEXT)));
        this.setProperty(SKIPCONDITION, evtData);
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        if (TIMECONTROLS.equals(e.getEntryProp().getName())) {
            RowDataEntity data = e.getRowDataEntities()[0];
            data.getDataEntity().set(TIMECONTROLS_ID, (Object)BpmnDiffUtil.getListElementId((String)"timeControls"));
        }
        super.afterAddRow(e);
    }
}

