/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.workflow.design.plugin.AbstractWorkflowNodeParamsPlugin;

public class WorkflowNodeCustomParamsPlugin
extends AbstractWorkflowNodeParamsPlugin {
    private static final String BUILTIN = "builtIn";
    private static final String FIELD_BUILTIN = "builtin";

    @Override
    protected String getParamsField() {
        return "customParams";
    }

    @Override
    protected void initParamsList() {
        JSONArray params = (JSONArray)this.getView().getFormShowParameter().getCustomParam("value");
        if (params == null || params.isEmpty()) {
            return;
        }
        int size = params.size();
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow("entryentity", size);
        for (int i = 0; i < size; ++i) {
            JSONObject param = params.getJSONObject(i);
            this.initParamRow(model, param, i);
        }
    }

    @Override
    protected void initParamRow(IDataModel model, JSONObject param, int index) {
        super.initParamRow(model, param, index);
        boolean builtIn = Boolean.TRUE.equals(param.getBoolean(BUILTIN));
        model.setValue(FIELD_BUILTIN, (Object)builtIn, index);
        if (builtIn) {
            FieldEdit numberField = (FieldEdit)this.getControl("number");
            numberField.setEnable("number", false, index);
            FieldEdit nameField = (FieldEdit)this.getControl("name");
            nameField.setEnable("name", false, index);
            FieldEdit valueField = (FieldEdit)this.getControl("value");
            valueField.setEnable("value", false, index);
        }
    }

    @Override
    protected JSONObject getParamRowData(DynamicObject data) {
        JSONObject param = super.getParamRowData(data);
        param.put(BUILTIN, (Object)data.getBoolean(FIELD_BUILTIN));
        return param;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs evt) {
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        int[] rows = grid.getSelectRows();
        if (rows.length < 1) {
            return;
        }
        Object builtIn = this.getModel().getValue(FIELD_BUILTIN, rows[0]);
        if (Boolean.TRUE.equals(builtIn)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u7f6e\u53c2\u6570\u4e0d\u80fd\u5220\u9664\u3002", (String)"WorkflowNodeCustomParamsPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }
}

