/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;

public class WorkflowNotifyContentPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CONFIRM = "btnok";
    private static final String CONTENT = "content";
    private static final String INSERT_EXPRESSION = "insertexpression";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM, INSERT_EXPRESSION});
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParam("value");
        this.getModel().setValue(CONTENT, value);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_CONFIRM.equals(key)) {
            this.confirm();
        } else if (INSERT_EXPRESSION.equals(key)) {
            this.showExpressionForm();
        }
    }

    private void confirm() {
        Object content = this.getModel().getValue(CONTENT);
        if (WfUtils.isEmptyString((Object)content)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6d88\u606f\u5185\u5bb9\u201d\u3002", (String)"WorkflowNotifyContentPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent(content);
        this.getView().close();
    }

    private void showExpressionForm() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String modelJson = (String)showParameter.getCustomParam("modelJson");
        String entityNumber = (String)showParameter.getCustomParam("entityNumber");
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("bpmnModel", modelJson);
        content.put("entityNumber", entityNumber);
        content.put("ruleType", ConditionalRuleType.skip);
        this.showForm(INSERT_EXPRESSION, "wf_valueexpression", content);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map m;
        Object returnObj;
        String key = closedCallBackEvent.getActionId();
        if (key.equals(INSERT_EXPRESSION) && (returnObj = closedCallBackEvent.getReturnData()) != null && !WfUtils.isNullObject((m = (Map)returnObj).get("expression"))) {
            String expression = "${" + m.get("expression") + "}";
            Object content = this.getModel().getValue(CONTENT);
            content = WfUtils.isNotEmptyString((Object)content) ? content : "";
            content = content + expression;
            this.getModel().setValue(CONTENT, content);
        }
    }
}

