/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;

public class WorkflowNotifyTaskConfigurePlugin
extends AbstractWorkflowConfigurePlugin
implements TabSelectListener {
    private final String TAB_MESSAGE = "msgtab";
    private final String MESSAGE_PANEL = "task_msg_panel";
    private static final String ENTITYNAME = "entityName";
    private static final String ENTITYID = "entityId";
    private static final String ENTRYBILL = "entrybill";
    private static final String ENTITYNUMBER = "entityNumber";
    private final String KEY_MESSAGE_PAGEID = "message_pageId";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String ENTITY_NAME = "entityName";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{ENTRYBILL});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCreateNewData(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getFormShowParameter() != null && "wf_nodeconfigview".equals(parentView.getFormShowParameter().getFormId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
        try {
            this.beginInit();
            super.afterCreateNewData(e);
            this.initBillProprertis();
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WorkflowNotifyTaskConfigurePlugin.class);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key = evt.getTabKey();
        if ("msgtab".equals(key)) {
            this.loadMessagePage();
        }
    }

    protected void loadMessagePage() {
        String pageId = this.getPageCache().get("message_pageId");
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_msgnotify_configure", "task_msg_panel");
            this.getPageCache().put("message_pageId", pageId);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("message_pageId");
    }

    private void initBillProprertis() {
        JSONObject properties = this.getCellProperties();
        String entityName = (String)properties.get((Object)"entityName");
        if (entityName != null) {
            this.getModel().setValue(ENTRYBILL, (Object)entityName);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "entrybill": {
                this.showPageForEntryBill();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void showPageForEntryBill() {
        HashMap<String, Object> map = new HashMap<String, Object>(17);
        map.put("NodeEntityNumbers", DesignerModelUtil.getNodeBill(this.getGraphModel(), this.itemId));
        DesignerModelUtil.openSelectEntitiesPageByCunstomerParams(this.getView(), (IFormPlugin)this, ENTRYBILL, map);
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (ENTRYBILL.equals(propName) && (newValue == null || "".equals(newValue.toString().trim()))) {
            this.setProperties(ENTITYID, null, "entityNumber", null, "entityName", null);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "entrybill": {
                this.setCloseDataForEntryBill(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setCloseDataForEntryBill(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.getModel().setValue(ENTRYBILL, data.get("name"));
            String entityId = (String)data.get("id");
            this.setProperties(ENTITYID, entityId, "entityName", data.get("name"), "entityNumber", data.get("number"));
        }
    }
}

