/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowOperateEntityPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private String ENTRYKEY = "entryentity";
    private static final String FCODE = "FCode";

    public void initialize() {
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
        Button btncel = (Button)this.getView().getControl("btncancel");
        btncel.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.ENTRYKEY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter params = this.getView().getFormShowParameter();
        List<Operation> operations = this.getOperations(params);
        if (null != operations) {
            this.setEntryEntityData(params, operations);
            this.setSelCheckBox(params);
            this.getView().updateView();
        }
    }

    private void setSelCheckBox(FormShowParameter params) {
        Object selCheckBox = params.getCustomParam("selchexkbox");
        if (WfUtils.isNotEmptyString((Object)selCheckBox)) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put("selchexkbox", selCheckBox);
            prop.put("colDefsGUID", UUID.randomUUID().toString());
            this.getView().updateControlMetadata(this.ENTRYKEY, prop);
        }
    }

    private void setEntryEntityData(FormShowParameter params, List<Operation> operations) {
        Object selectValues = params.getCustomParam("selectValues");
        ArrayList<Integer> selectIndexList = new ArrayList<Integer>();
        IDataModel model = this.getModel();
        int i = 0;
        String operationKey = null;
        for (Operation operation : operations) {
            operationKey = operation.getKey();
            model.createNewEntryRow(this.ENTRYKEY);
            model.setValue(FCODE, (Object)operationKey, i);
            model.setValue("FName", (Object)operation.getName(), i);
            model.setValue("FType", (Object)operation.getOperationType(), i);
            model.setValue("FId", (Object)operation.getId(), i);
            if (WfUtils.isNotEmptyString((Object)selectValues) && Arrays.asList(selectValues.toString().split(",")).contains(operationKey)) {
                selectIndexList.add(i);
            }
            ++i;
        }
        this.getPageCache().put("selectIndexList", SerializationUtils.toJsonString(selectIndexList));
    }

    private List<Operation> getOperations(FormShowParameter params) {
        Map extendData = (Map)params.getCustomParam("context");
        Map nodeProperties = (Map)extendData.get("nodeProperties");
        Map processProperties = (Map)extendData.get("processProperties");
        String entityId = null;
        String formKey = "";
        if (nodeProperties != null) {
            formKey = (String)nodeProperties.get("formKey");
            entityId = (String)nodeProperties.get("entityId");
        } else if (processProperties != null) {
            formKey = (String)processProperties.get("entraBill");
        }
        if (WfUtils.isEmptyString((Object)formKey) && WfUtils.isEmpty(entityId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u754c\u9762\u5143\u6570\u636e\u6216\u5b9e\u4f53\u5143\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowOperateEntityPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return null;
        }
        String autoTask = (String)extendData.get("autoTask");
        if (WfUtils.isNotEmpty((String)autoTask) && nodeProperties != null) {
            entityId = (String)nodeProperties.get("service.entityId");
        } else if (WfUtils.isEmpty((String)entityId) && WfUtils.isNotEmpty((String)formKey)) {
            MetadataReader reader = new MetadataReader();
            String formId = reader.loadIdByNumber(formKey, MetaCategory.Form);
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
            entityId = formMetadata.getEntityId();
        }
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List operations = metadata.getRootEntity().getOperations();
        Collection optionalNumbers = (Collection)params.getCustomParam("optionalActions");
        ProcTemplatePluginUtil.filterOptionalDatas(operations, optionalNumbers);
        if (params.getCustomParam("onlyEntityOperation") != null && operations != null && !WfConfigurationUtil.ifShowFormOperation()) {
            Iterator iterator = operations.iterator();
            while (iterator.hasNext()) {
                Operation operation = (Operation)iterator.next();
                if (OperationTypeCache.isEntityOperation((String)operation.getOperationType())) continue;
                iterator.remove();
            }
        }
        return operations;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSelectRows();
    }

    private void setSelectRows() {
        List selectIndexList;
        String selectIndexCache = this.getPageCache().get("selectIndexList");
        if (WfUtils.isNotEmpty((String)selectIndexCache) && 0 != (selectIndexList = (List)SerializationUtils.fromJsonString((String)selectIndexCache, List.class)).size()) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(this.ENTRYKEY);
            int[] selectIndex = new int[selectIndexList.size()];
            for (int j = 0; j < selectIndexList.size(); ++j) {
                selectIndex[j] = (Integer)selectIndexList.get(j);
            }
            grid.selectRows(selectIndex, selectIndex[0]);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnDataToParent();
        } else if (key.equalsIgnoreCase("btncancel")) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(this.ENTRYKEY);
        int[] rowKeys = grid.getEntryState().getSelectedRows();
        if (rowKeys.length > 0) {
            Cloneable returnData = null;
            HashMap<String, Object> paramMap = null;
            IDataModel model = this.getModel();
            FormShowParameter params = this.getView().getFormShowParameter();
            Object selCheckBox = params.getCustomParam("selchexkbox");
            if (WfUtils.isNotEmptyString((Object)selCheckBox) && Boolean.parseBoolean(selCheckBox.toString())) {
                ArrayList<HashMap<String, Object>> paramList = new ArrayList<HashMap<String, Object>>(rowKeys.length);
                for (int rowKey : rowKeys) {
                    paramMap = new HashMap();
                    paramMap.put("name", model.getValue("FName", rowKey));
                    paramMap.put("number", model.getValue(FCODE, rowKey));
                    paramList.add(paramMap);
                }
                returnData = paramList;
            } else {
                paramMap = new HashMap<String, Object>();
                int rowKey = rowKeys[0];
                paramMap.put("id", model.getValue(FCODE, rowKey));
                paramMap.put("name", model.getValue("FName", rowKey));
                paramMap.put("number", model.getValue(FCODE, rowKey));
                paramMap.put("type", model.getValue("FType", rowKey));
                returnData = paramMap;
            }
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"WorkflowOperateEntityPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.returnDataToParent();
    }
}

