/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.proctpl.plugin.ProcTemplatePluginUtil;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowOptionalDecisionItemsPlugin
extends AbstractWorkflowPlugin {
    private static final String KEY_ID = "id";
    private static final String KEY_NAME = "name";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_SELECTEDROWS = "rows";
    private static final String BUTTON_CONFIRM = "btnconfirm";
    private static final String ENTRY_DECISIONITEMS = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        this.initDecisionItems();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSelectRows();
    }

    private void initDecisionItems() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List datas = (List)parameter.getCustomParam("datas");
        HashSet<String> selectedNumbers = new HashSet<String>();
        if (datas != null && !datas.isEmpty()) {
            selectedNumbers = new HashSet(datas.size());
            for (Map data : datas) {
                selectedNumbers.add((String)data.get(KEY_NUMBER));
            }
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>(selectedNumbers.size());
        IDataModel model = this.getModel();
        ComboItem item = null;
        String stencilType = (String)parameter.getCustomParam("stencilType");
        String businessModel = (String)parameter.getCustomParam("businessModel");
        List<ComboItem> items = ProcTemplatePluginUtil.getDecisionScene(null, stencilType, businessModel, null);
        model.batchCreateNewEntryRow(ENTRY_DECISIONITEMS, items.size());
        for (int i = 0; i < items.size(); ++i) {
            item = items.get(i);
            String number = item.getValue();
            model.setValue(KEY_ID, (Object)BpmnDiffUtil.getListElementId((String)"decisionOptions"), i);
            model.setValue(KEY_NAME, (Object)String.valueOf(item.getCaption()), i);
            model.setValue(KEY_NUMBER, (Object)number, i);
            if (!selectedNumbers.contains(number)) continue;
            indexes.add(i);
        }
        this.getPageCache().put(KEY_SELECTEDROWS, SerializationUtils.toJsonString(indexes));
    }

    private void setSelectRows() {
        List indexes;
        String selectedRows = this.getPageCache().get(KEY_SELECTEDROWS);
        if (WfUtils.isNotEmpty((String)selectedRows) && !(indexes = (List)SerializationUtils.fromJsonString((String)selectedRows, List.class)).isEmpty()) {
            int[] rows = new int[indexes.size()];
            for (int i = 0; i < indexes.size(); ++i) {
                rows[i] = (Integer)indexes.get(i);
            }
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_DECISIONITEMS);
            grid.selectRows(rows, rows[0]);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BUTTON_CONFIRM.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        IDataModel model = this.getModel();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_DECISIONITEMS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows.length > 0) {
            HashMap<String, Object> data = null;
            ArrayList datas = new ArrayList(10);
            for (int row : rows) {
                data = new HashMap<String, Object>();
                data.put(KEY_ID, model.getValue(KEY_ID, row));
                data.put(KEY_NAME, model.getValue(KEY_NAME, row));
                data.put(KEY_NUMBER, model.getValue(KEY_NUMBER, row));
                datas.add(data);
            }
            this.getView().returnDataToParent(datas);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u51b3\u7b56\u9879\u201d\u3002", (String)"WorkflowOptionalDecisionItemsPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_SELECTEDROWS);
    }
}

