/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class WorkflowPageParameterPlugin
extends AbstractWorkflowPlugin {
    protected static final String PARAMETERID = "parameterid";
    protected static final String PARAMETERS = "parameters";
    private static final String PARAMETERNAME = "parametername";
    private static final String PARAMETERNUMBER = "parameternumber";
    private static final String PARAMETERVALUE = "parametervalue";
    protected static final String MODEL_PARAMETERNAME = "parameterName";
    private static final String MODEL_PARAMETERNUMBER = "parameterNumber";
    private static final String MODEL_PARAMETERVALUE = "parameterValue";
    private static final String BTNOK = "btnok";
    private static final String PARAMETERIDRETURN = "id";

    public void afterCreateNewData(EventObject e) {
        List array;
        Object parameters = ApprovalPluginUtil.getCustomParamFromFormShowParameter(this.getView(), PARAMETERS);
        if (parameters instanceof List && WfUtils.isNotEmptyForCollection((Collection)(array = (List)parameters))) {
            Map mObject = null;
            this.getModel().batchCreateNewEntryRow(PARAMETERS, array.size());
            int index = 0;
            for (Object object : array) {
                if (!(object instanceof Map)) continue;
                mObject = (Map)object;
                this.getModel().setValue(PARAMETERNAME, mObject.get(MODEL_PARAMETERNAME), index);
                this.getModel().setValue(PARAMETERNUMBER, mObject.get(MODEL_PARAMETERNUMBER), index);
                this.getModel().setValue(PARAMETERVALUE, mObject.get(MODEL_PARAMETERVALUE), index);
                this.getModel().setValue(PARAMETERID, mObject.get(PARAMETERIDRETURN), index);
                ++index;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String key = e.getEntryProp().getName();
        RowDataEntity data = e.getRowDataEntities()[0];
        switch (key) {
            case "parameters": {
                data.getDataEntity().set(PARAMETERID, (Object)BpmnDiffUtil.getListElementId((String)"pageParameter"));
                break;
            }
        }
        super.afterAddRow(e);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PARAMETERVALUE, BTNOK});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "parametervalue": {
                this.openValueExpression();
                break;
            }
            case "btnok": {
                this.setReturnData();
                break;
            }
        }
    }

    private void setReturnData() {
        ArrayList returnDatas = null;
        HashMap<String, Object> returnData = null;
        HashSet<Object> repeatSet = null;
        int rowCount = this.getModel().getEntryRowCount(PARAMETERS);
        Object[] collection = this.getModel().getEntryEntity(PARAMETERS, 0, rowCount);
        if (WfUtils.isEmptyForArrays((Object[])collection)) {
            returnDatas = new ArrayList(1);
            repeatSet = new HashSet<Object>(1);
        } else {
            returnDatas = new ArrayList(collection.length);
            repeatSet = new HashSet(collection.length);
        }
        Object parameterName = null;
        Object parameterNumber = null;
        Object parameterValue = null;
        StringBuilder errorMsg = new StringBuilder();
        for (Object dynObj : collection) {
            parameterName = dynObj.get(PARAMETERNAME);
            parameterNumber = dynObj.get(PARAMETERNUMBER);
            parameterValue = dynObj.get(PARAMETERVALUE);
            if (WfUtils.isEmptyString((Object)parameterNumber)) {
                errorMsg.append(ResManager.loadKDString((String)"\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowPageParameterPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else if (!PluginUtil.matchPattern("^[A-Za-z][A-Za-z0-9_]*$", parameterNumber.toString())) {
                errorMsg.append(ResManager.loadKDString((String)"\u201c\u53c2\u6570\u7f16\u7801\u201d\u8bf7\u4f7f\u7528\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"WorkflowPageParameterPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            if (WfUtils.isEmptyString((Object)parameterValue)) {
                errorMsg.append(ResManager.loadKDString((String)"\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowPageParameterPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            if (WfUtils.isNotEmpty((String)errorMsg.toString())) {
                this.getView().showErrorNotification(errorMsg.toString());
                return;
            }
            repeatSet.add(parameterNumber);
            returnData = new HashMap<String, Object>(1);
            returnData.put(MODEL_PARAMETERNAME, parameterName);
            returnData.put(MODEL_PARAMETERNUMBER, parameterNumber);
            returnData.put(MODEL_PARAMETERVALUE, parameterValue);
            returnData.put(PARAMETERIDRETURN, dynObj.get(PARAMETERID));
            returnDatas.add(returnData);
        }
        if (null != collection && collection.length != repeatSet.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u53c2\u6570\u7f16\u7801\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"WorkflowPageParameterPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent(returnDatas);
        this.getView().close();
    }

    private void openValueExpression() {
        Object entityNumber = ApprovalPluginUtil.getCustomParamFromFormShowParameter(this.getView(), "entityNumber");
        FormShowParameter parameter = this.getShowParameter(PARAMETERVALUE, "wf_valueexpression");
        parameter.setCustomParam("entityNumber", entityNumber);
        parameter.setCustomParam("isVal", (Object)Boolean.TRUE);
        Object defaultVal = this.getModel().getValue(PARAMETERVALUE, ((EntryGrid)this.getControl(PARAMETERS)).getEntryState().getFocusRow());
        if (WfUtils.isNotEmptyString((Object)defaultVal)) {
            String expression = null;
            expression = defaultVal.toString();
            if (expression.startsWith("${") && expression.matches("\\$\\{.+\\}")) {
                expression = expression.replaceAll("\\$|\\{|\\}", "");
                parameter.setCustomParam("expression", (Object)expression);
            } else {
                parameter.setCustomParam("tip", (Object)WFMultiLangConstants.getValueIsNotExpressionTip());
            }
        }
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = evt.getActionId();
        if (PARAMETERVALUE.equals(actionId)) {
            this.setCloseData(returnData);
        }
    }

    private void setCloseData(Object returnData) {
        Map expressionData;
        Object expression;
        if (returnData instanceof Map && WfUtils.isNotEmptyString(expression = (expressionData = (Map)returnData).get("expression"))) {
            this.getModel().setValue(PARAMETERVALUE, (Object)("${" + expression + "}"), ((EntryGrid)this.getControl(PARAMETERS)).getEntryState().getFocusRow());
        }
    }
}

