/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.plugin.model.ParticipantEntryInfo;
import kd.bos.workflow.design.plugin.model.StencilProperty;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.ParticipantConfigureHelper;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;

public class WorkflowParticipantConfigurePlugin
extends AbstractWorkflowConfigurePlugin {
    public static final String ENTRYENTITY_ALL = "participant_entryentity";
    public static final String TRIGGER = "trigger";
    public static final String RADIOGROUPFIELD = "radiogroup_participant";
    protected static final String RADIOGROUPFIELD_VALUE_ALL = "all";
    protected static final String RADIOGROUPFIELD_VALUE_CONDITION = "condition";
    protected static final String FLEXPANELAP_CONDITION = "participant_cond_panel";
    public static final String ENTRYENTITY_CONDITION = "entryentity_condition";
    public static final String LOGICSIGNAL_KEY = "defaultCondition";
    protected static final String OPERATION_ADD = "operation_add";
    protected static final String OPERATION_MODIFY = "operation_modify";
    public static final String CONDRULE_ALL = "condrule";
    public static final String CONDITIONEXPRESSION = "conditionExpression";
    public static final String CONDRULESHOWTEXT = "condruleshowtext";
    private static final String SIGNTYPE = "signtype";
    public static final String IMAGEURL = "participant_picture";
    public static final String SHOWVALUE = "participant_showvalue";
    public static final String VALUE_SHOWTEXTPRE = "participant_showvaluepre";
    protected static final String BTN_ADD_ALL = "btn_add_all";
    protected static final String BTN_EDIT_ALL = "btn_edit_all";
    protected static final String BTN_DEL_ALL = "btn_del_all";
    protected static final String BUTTONAP_ADD = "buttonap_add";
    public static final String LOGICSIGNAL = "participant_logicsignal";
    public static final String CONDITION = "participant_condition";
    protected static final String PARTICIPANT = "participant_participant";
    protected static final Object LOGIC_CLEAR = "clear";
    public static final String DISPLAYINFO = "displayinfo";
    private static final String CONDRULE = "condrule";
    private static final String RETURNDATAALLLISTPARTICIPANTENTRYENTITY = "returnDataAllList_participant_entryentity";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(ENTRYENTITY_ALL, ENTRYENTITY_CONDITION, IMAGEURL, SHOWVALUE, VALUE_SHOWTEXTPRE);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADD_ALL, BTN_EDIT_ALL, BTN_DEL_ALL, CONDITION, DISPLAYINFO, BUTTONAP_ADD});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setLogicSignals();
        this.loadParticipantPage(this.getCellProperties());
    }

    @Override
    protected void initPropertyValue(StencilProperty property, Control control, JSONObject properties, String propName, List<Object> updateProperties, Map<String, Object> isvPropsConfig) {
        if (DISPLAYINFO.equals(control.getKey())) {
            super.initPropertyValue(property, control, properties, propName, updateProperties, isvPropsConfig);
        }
    }

    @Override
    protected void initPropertyDefaultValue(JSONObject properties, String name, String controlName, List<Object> updateProperties, Map<String, Object> isvPropsConfig, StencilProperty property) {
        if ("participant".equals(property.getGroupId())) {
            super.initPropertyDefaultValue(properties, name, controlName, updateProperties, isvPropsConfig, property);
        }
    }

    private void loadParticipantPage(JSONObject properties) {
        if (properties == null) {
            this.logger.debug("cell's properties is null!");
            return;
        }
        JSONObject participant = properties.getJSONObject("participant");
        if (participant == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRYENTITY_ALL});
            this.setVisibleForBtn(true);
            return;
        }
        List participants = (List)participant.get((Object)"participant");
        if (WfUtils.isEmptyForCollection((Collection)participants)) {
            this.setVisibleForBtn(true);
        } else {
            this.setVisibleForBtn(false);
        }
        this.initParticipantListAndConditionEntry(participants);
        Boolean displaySetting = participant.getBoolean("displaySetting");
        String displayInfo = participant.getString("displayInfo");
        if (displaySetting != null && !displaySetting.booleanValue() && WfUtils.isNotEmpty((String)displayInfo)) {
            this.getModel().setValue(DISPLAYINFO, null);
            this.setProperties("displayInfo", null);
        } else {
            this.getModel().setValue(DISPLAYINFO, (Object)displayInfo);
        }
    }

    protected void initParticipantListAndConditionEntry(List<Map<String, Object>> participants) {
        if (participants != null && !participants.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ENTRYENTITY_ALL});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRYENTITY_ALL});
        }
        ParticipantConfigureHelper.initParticipantEntryEntity(this, this.getParticipantEntryInfo(null), participants);
        this.initConditionParticipant(participants);
    }

    @Override
    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        this.logger.debug("kd.bos.workflow.design.plugin.WorkflowParticipantConfigurePlugin.click key:" + key);
        switch (key) {
            case "buttonap_add": 
            case "btn_add_all": {
                ParticipantConfigureHelper.addParticipant(this, ENTRYENTITY_ALL, this.itemId, this.getModelJsonString(), OPERATION_ADD);
                break;
            }
            case "btn_edit_all": {
                ParticipantConfigureHelper.modifyParticipant(this, ENTRYENTITY_ALL, this.itemId, this.getModelJsonString(), OPERATION_MODIFY);
                break;
            }
            case "btn_del_all": {
                this.deleteAll();
                break;
            }
            case "participant_condition": {
                this.showConditionalRule();
                break;
            }
            case "displayinfo": {
                this.showParticipantDisplaysPage();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void showParticipantDisplaysPage() {
        Object infoValue = this.getModel().getValue(DISPLAYINFO);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DISPLAYINFO));
        parameter.setFormId("wf_participantsetting");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("value", infoValue);
        JSONObject properties = this.getCellProperties();
        String entityNumber = properties.getString("entityNumber");
        parameter.setCustomParam("entityNumber", (Object)entityNumber);
        parameter.setCustomParam("source", (Object)"participantConfigure");
        this.showForm(parameter);
    }

    protected int getFocusRowIndex(String entryName) {
        return ParticipantConfigureHelper.getFocusRowIndex(this.getView(), entryName);
    }

    private void showConditionalRule() {
        int rowIndex = this.getFocusRowIndex(ENTRYENTITY_CONDITION);
        Object logicValue = this.getModel().getValue(LOGICSIGNAL, rowIndex);
        if (null != logicValue && !Boolean.parseBoolean(logicValue.toString()) && !logicValue.equals(LOGIC_CLEAR)) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            String type = ConditionalRuleType.participant.toString();
            context.put("type", type);
            context.put("property", "condrule");
            context.put("model", this.getModelJsonString());
            HashMap<String, String> nodeProperties = new HashMap<String, String>();
            nodeProperties.put("itemId", this.itemId);
            context.put("nodeProperties", nodeProperties);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("context", context);
            FormShowParameter parameter = this.getShowParameter(CONDITION, "wf_conditionrule_update", ConditionalRuleType.getTypeName((String)type), params);
            parameter.setCustomParam("isDefaultScheme", (Object)this.getIdeViewPageCacheData("isDefaultScheme"));
            parameter.setCustomParam("schemeId", (Object)this.getIdeViewPageCacheData("schemeId"));
            parameter.setShowTitle(false);
            Map indexMap = (Map)this.getReturnDataConditionFromCache(rowIndex);
            if (indexMap != null) {
                Object value = indexMap.get("condrule");
                if (null != value) {
                    parameter.setCustomParam("value", (Object)SerializationUtils.toJsonString(value));
                }
            } else {
                this.logger.debug("ConditionData From Cache is null!");
            }
            this.showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u5e94\u8be5\u8bbe\u7f6e\u4e00\u4e2a\u201c\u5982\u679c\u201d\u903b\u8f91\uff0c\u4e14\u8be5\u201c\u5982\u679c\u201d\u903b\u8f91\u540e\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowParticipantConfigurePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    protected Object getReturnDataConditionFromCache(Integer rowIndex) {
        String pageCache = this.getPageCache().get(ParticipantConfigureHelper.getDatasCacheKey(ENTRYENTITY_ALL));
        if (WfUtils.isEmpty((String)pageCache)) {
            return null;
        }
        List raturnDataList = (List)SerializationUtils.fromJsonString((String)pageCache, List.class);
        if (rowIndex == null || raturnDataList == null) {
            return null;
        }
        if (raturnDataList.size() <= rowIndex) {
            return null;
        }
        Map indexMap = (Map)raturnDataList.get(rowIndex);
        return indexMap;
    }

    private void deleteAll() {
        List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.deleteParticipant(this, ENTRYENTITY_ALL);
        this.setProperty("participant", returnDataList);
        this.updateConditionEntity(returnDataList);
        if (WfUtils.isEmptyForCollection(returnDataList)) {
            this.setVisibleForBtn(true);
        }
    }

    protected void initConditionParticipant(List<Map<String, Object>> participants) {
        String condition = RADIOGROUPFIELD_VALUE_ALL;
        if (this.isConditionPart(participants)) {
            condition = RADIOGROUPFIELD_VALUE_CONDITION;
        }
        this.initRadioGroup(condition);
        this.updateConditionEntity(participants);
    }

    protected void updateConditionEntity(List<Map<String, Object>> participants) {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY_CONDITION);
        if (participants != null && !participants.isEmpty()) {
            model.batchCreateNewEntryRow(ENTRYENTITY_CONDITION, participants.size());
            this.getPageCache().put("initCondition", "true");
            int i = 0;
            for (Map<String, Object> data : participants) {
                this.setRowDataCondition(model, data, i);
                ++i;
            }
            this.getPageCache().put("initCondition", "false");
        }
    }

    protected void setLogicSignals() {
        LinkedHashMap<String, Object> logicSignals = new LinkedHashMap<String, Object>();
        logicSignals.put(ResManager.loadKDString((String)"\u5982\u679c", (String)"WorkflowParticipantConfigurePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Boolean.FALSE);
        logicSignals.put(ResManager.loadKDString((String)"\u5426\u5219", (String)"WorkflowParticipantConfigurePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Boolean.TRUE);
        logicSignals.put("", LOGIC_CLEAR);
        PluginUtil.setComboForControl(logicSignals, (ComboEdit)this.getControl(LOGICSIGNAL));
    }

    private void initRadioGroup(Object radioValue) {
        String realRadioValue = null == radioValue ? RADIOGROUPFIELD_VALUE_ALL : radioValue.toString();
        this.getModel().setValue(RADIOGROUPFIELD, (Object)realRadioValue);
        this.getView().setVisible(Boolean.valueOf(realRadioValue.equals(RADIOGROUPFIELD_VALUE_CONDITION)), new String[]{FLEXPANELAP_CONDITION});
    }

    private boolean isConditionPart(List<Map<String, Object>> participants) {
        if (participants == null || participants.isEmpty()) {
            return false;
        }
        for (Map<String, Object> participant : participants) {
            Object condRule = participant.get("condrule");
            if (condRule == null) continue;
            if (condRule instanceof Map) {
                Map conditionalRule = (Map)condRule;
                if (!WfUtils.isNotEmptyString(conditionalRule.get("expression")) && !WfUtils.isNotEmptyString(conditionalRule.get("plugin"))) continue;
                return true;
            }
            this.log.debug("\u53c2\u4e0e\u4eba\u6761\u4ef6\u89c4\u5219\u683c\u5f0f\u4e0d\u6b63\u786e\uff01" + condRule);
        }
        return false;
    }

    private void setRowDataCondition(IDataModel model, Map<String, Object> map, int rowIndex) {
        Map o;
        String showTxt;
        if (model == null || map == null || map.isEmpty() || rowIndex < 0) {
            return;
        }
        String logicSignal = this.getString(map.get(LOGICSIGNAL_KEY));
        if (!WfUtils.isEmpty((String)logicSignal)) {
            ParticipantConfigureHelper.setIfCheck(model, LOGICSIGNAL, logicSignal, rowIndex);
        }
        if (WfUtils.isEmpty((String)(showTxt = this.getString(map.get(CONDRULESHOWTEXT)))) && (o = (Map)map.get("condrule")) != null && (o = (Map)o.get("showtext")) != null) {
            showTxt = (String)o.get(RequestContext.get().getLang().toString());
        }
        ParticipantConfigureHelper.setIfCheck(model, CONDITION, showTxt, rowIndex);
        ParticipantConfigureHelper.setIfCheck(model, PARTICIPANT, ParticipantConfigureHelper.getTextFromParams(map), rowIndex);
    }

    private String getString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId.toLowerCase(Locale.getDefault())) {
            case "operation_add": 
            case "operation_modify": {
                this.setCloseDataForParticipant(actionId, returnData);
                break;
            }
            case "participant_condition": {
                List<Map<String, Object>> returnDataList = this.setCloseDataForCondition(returnData);
                if (returnData == null) break;
                this.setProperty("participant", returnDataList);
                break;
            }
            case "displayinfo": {
                if (!(evt.getReturnData() instanceof Map)) break;
                Map returnDataMap = (Map)returnData;
                String value = (String)returnDataMap.get("settingValue");
                this.getModel().setValue(DISPLAYINFO, (Object)value);
                this.setProperties("displayInfo", value, "displaySetting", true);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setCloseDataForParticipant(String actionId, Object returnData) {
        if (returnData instanceof Map) {
            List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.setParticipantEntryValue(this, this.getParticipantEntryInfo((Map)returnData), actionId);
            this.setProperty("participant", returnDataList);
            this.updateConditionEntity(returnDataList);
            if (OPERATION_ADD.equalsIgnoreCase(actionId)) {
                this.setVisibleForBtn(false);
            }
        }
    }

    protected List<Map<String, Object>> setCloseDataForCondition(Object returnData) {
        List<Map<String, Object>> returnDataList = new ArrayList<Map<String, Object>>();
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            int rowIndex = this.getFocusRowIndex(ENTRYENTITY_CONDITION);
            String conditionshowtext = null;
            Object expression = null;
            if (!data.isEmpty()) {
                conditionshowtext = DesignerPluginUtil.getLocaleValue(data.get("showtext"));
                expression = data.get("expression");
            }
            this.getModel().setValue(CONDITION, (Object)conditionshowtext, rowIndex);
            HashMap<String, Object> condrule = new HashMap<String, Object>();
            condrule.put("condrule", data);
            condrule.put(CONDITIONEXPRESSION, expression);
            condrule.put(CONDRULESHOWTEXT, conditionshowtext);
            returnDataList = this.setReturnDataToCacheByCondition(rowIndex, condrule, OPERATION_MODIFY);
        }
        return returnDataList;
    }

    private List<Map<String, Object>> setReturnDataToCacheByCondition(int rowIndex, Map<String, Object> data, String operation) {
        Map<String, Object> originalMap = ParticipantConfigureHelper.getReturnDataMapFromCache(this, ENTRYENTITY_ALL, rowIndex);
        if (null != originalMap) {
            originalMap.putAll(data);
        } else {
            originalMap = data;
        }
        List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.setReturnDataToCache(this, ENTRYENTITY_ALL, originalMap, rowIndex, operation);
        return returnDataList;
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "radiogroup_participant": {
                this.participantRadioChanged(propName, newValue);
                break;
            }
            case "participant_logicsignal": {
                this.logicChanged(newValue, true, oldValue);
                break;
            }
            case "businessmodel": 
            case "signtype": {
                break;
            }
            case "displayinfo": {
                if (newValue != null && !"".equals(newValue.toString().trim())) break;
                this.setProperties("displayInfo", null, "displaySetting", true);
                break;
            }
            case "participant_condition": {
                Map indexMap;
                if (newValue != null && !"".equals(newValue.toString().trim()) || (indexMap = (Map)this.getReturnDataConditionFromCache(rowIndex)) == null) break;
                Map<String, Object> originalMap = ParticipantConfigureHelper.getReturnDataMapFromCache(this, ENTRYENTITY_ALL, rowIndex);
                originalMap.put("condrule", null);
                originalMap.put(CONDITIONEXPRESSION, null);
                originalMap.put(CONDRULESHOWTEXT, null);
                List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.setReturnDataToCache(this, ENTRYENTITY_ALL, originalMap, rowIndex, OPERATION_MODIFY);
                this.setProperty("participant", returnDataList);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    protected void logicChanged(Object newValue, boolean needUpProperty, Object oldValue) {
        Boolean initCondition = Boolean.valueOf(this.getPageCache().get("initCondition"));
        if (!initCondition.booleanValue()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            boolean isClearCondition = LOGIC_CLEAR.equals(newValue);
            data.put(LOGICSIGNAL_KEY, isClearCondition ? null : newValue);
            int rowIndex = this.getFocusRowIndex(ENTRYENTITY_CONDITION);
            if (null != newValue) {
                boolean isRestoreSettingLogic;
                boolean isLogicOtherForNew = Boolean.parseBoolean(newValue.toString());
                if (isLogicOtherForNew && (isRestoreSettingLogic = this.restoreSettingLogic())) {
                    needUpProperty = false;
                    this.getModel().setValue(LOGICSIGNAL, oldValue, rowIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u8bbe\u7f6e\u201c\u5426\u5219\u201d\u6761\u4ef6\uff0c\u4e0d\u53ef\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"WorkflowParticipantConfigurePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                if (isLogicOtherForNew || isClearCondition) {
                    data.put("condrule", null);
                    data.put(CONDITIONEXPRESSION, null);
                    data.put(CONDRULESHOWTEXT, null);
                    this.getModel().setValue(CONDITION, null, rowIndex);
                }
            }
            List<Map<String, Object>> returnDataList = this.setReturnDataToCacheByCondition(rowIndex, data, OPERATION_MODIFY);
            if (needUpProperty) {
                this.setProperty("participant", returnDataList);
            }
        }
    }

    private boolean restoreSettingLogic() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY_CONDITION);
        if (null != collection && !collection.isEmpty()) {
            Object defaultConditionObj = null;
            int defaultConditionCount = 0;
            for (DynamicObject obj : collection) {
                if (null == obj || null == (defaultConditionObj = obj.get(LOGICSIGNAL)) || !Boolean.parseBoolean(defaultConditionObj.toString())) continue;
                ++defaultConditionCount;
            }
            if (defaultConditionCount > 1) {
                return true;
            }
        }
        return false;
    }

    private void participantRadioChanged(String name, Object newValue) {
        List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.getReturnDataListFromCache(this, ENTRYENTITY_ALL);
        if (newValue.equals(RADIOGROUPFIELD_VALUE_CONDITION) && null == returnDataList) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u201c\u6240\u6709\u53c2\u4e0e\u4eba\u90fd\u4f1a\u6536\u5230\u4efb\u52a1\u201d\u3002", (String)"WorkflowParticipantConfigurePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
        this.getView().setVisible(Boolean.valueOf(newValue.equals(RADIOGROUPFIELD_VALUE_CONDITION)), new String[]{FLEXPANELAP_CONDITION});
        if (newValue.equals(RADIOGROUPFIELD_VALUE_ALL)) {
            this.setClearCondrule(returnDataList);
        }
        this.setProperty(name, newValue);
    }

    private void setClearCondrule(List<Map<String, Object>> returnDataList) {
        if (null != returnDataList && 0 != returnDataList.size()) {
            for (Map<String, Object> map : returnDataList) {
                map.remove("condrule");
                map.remove(CONDITIONEXPRESSION);
                map.remove(CONDRULESHOWTEXT);
                map.put(LOGICSIGNAL_KEY, null);
            }
            this.getPageCache().put(ParticipantConfigureHelper.getDatasCacheKey(ENTRYENTITY_ALL), SerializationUtils.toJsonString(returnDataList));
            this.setProperty("participant", returnDataList);
            this.updateConditionEntity(returnDataList);
        }
    }

    protected ParticipantEntryInfo getParticipantEntryInfo(Map<String, Object> data) {
        if (data != null) {
            return new ParticipantEntryInfo(ENTRYENTITY_ALL, IMAGEURL, VALUE_SHOWTEXTPRE, SHOWVALUE, data);
        }
        return new ParticipantEntryInfo(ENTRYENTITY_ALL, IMAGEURL, VALUE_SHOWTEXTPRE, SHOWVALUE);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(ParticipantConfigureHelper.getDatasCacheKey(ENTRYENTITY_ALL));
    }

    @Override
    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        int focusIndex;
        if (!ENTRYENTITY_ALL.equals(e.getEntryProp().getName())) {
            return;
        }
        String participantEntryEntityStr = this.getPageCache().get(RETURNDATAALLLISTPARTICIPANTENTRYENTITY);
        if (WfUtils.isEmpty((String)participantEntryEntityStr)) {
            return;
        }
        List participantEntryEntityList = SerializationUtils.fromJsonStringToList((String)participantEntryEntityStr, Map.class);
        int[] focusIndexs = e.getRowIndexs();
        int n = focusIndex = focusIndexs != null && focusIndexs.length > 0 ? focusIndexs[0] : 0;
        if (participantEntryEntityList != null && participantEntryEntityList.size() >= focusIndex && focusIndex > 0) {
            Map temporaryParticipant = (Map)participantEntryEntityList.get(focusIndex - 1);
            participantEntryEntityList.set(focusIndex - 1, participantEntryEntityList.get(focusIndex));
            participantEntryEntityList.set(focusIndex, temporaryParticipant);
            this.getPageCache().put(RETURNDATAALLLISTPARTICIPANTENTRYENTITY, SerializationUtils.toJsonString((Object)participantEntryEntityList));
            this.participantIdChange(participantEntryEntityList);
            this.setProperty("participant", participantEntryEntityList);
            EntryGrid conditionEntryentity = (EntryGrid)this.getControl(ENTRYENTITY_CONDITION);
            conditionEntryentity.getEntryState().selectRow(focusIndex);
            this.getView().invokeOperation("moveupconditionentry");
        }
    }

    @Override
    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        if (!ENTRYENTITY_ALL.equals(e.getEntryProp().getName())) {
            return;
        }
        String participantEntryEntityStr = this.getPageCache().get(RETURNDATAALLLISTPARTICIPANTENTRYENTITY);
        if (WfUtils.isEmpty((String)participantEntryEntityStr)) {
            return;
        }
        List participantEntryEntityList = SerializationUtils.fromJsonStringToList((String)participantEntryEntityStr, Map.class);
        int[] focusIndexs = e.getRowIndexs();
        int focusIndex = focusIndexs[0];
        if (participantEntryEntityList != null && participantEntryEntityList.size() > focusIndex) {
            Map temporaryParticipant = (Map)participantEntryEntityList.get(focusIndex + 1);
            participantEntryEntityList.set(focusIndex + 1, participantEntryEntityList.get(focusIndex));
            participantEntryEntityList.set(focusIndex, temporaryParticipant);
            this.getPageCache().put(RETURNDATAALLLISTPARTICIPANTENTRYENTITY, SerializationUtils.toJsonString((Object)participantEntryEntityList));
            this.participantIdChange(participantEntryEntityList);
            this.setProperty("participant", participantEntryEntityList);
            EntryGrid conditionEntryentity = (EntryGrid)this.getControl(ENTRYENTITY_CONDITION);
            conditionEntryentity.getEntryState().selectRow(focusIndex);
            this.getView().invokeOperation("movedownconditionentry");
        }
    }

    private void participantIdChange(List<Map<String, Object>> participantEntryEntityList) {
        if ("false".equals(this.getIdeViewPageCacheData("isDefaultScheme")) && WfUtils.isEmpty((String)this.getPageCache().get("participantRearrangement"))) {
            long[] ids = ORM.create().genLongIds("wf_participantmodel", participantEntryEntityList.size());
            for (int i = 0; i < ids.length; ++i) {
                Map<String, Object> participantEntryEntity = participantEntryEntityList.get(i);
                participantEntryEntity.put("id", ids[i]);
            }
            this.getPageCache().put("participantRearrangement", "true");
        }
    }

    private void setVisibleForBtn(Boolean isVisible) {
        this.getView().setVisible(isVisible, new String[]{BUTTONAP_ADD});
        this.getView().setVisible(Boolean.valueOf(isVisible == false), new String[]{BTN_ADD_ALL, BTN_EDIT_ALL, BTN_DEL_ALL, "moveup", "movedown"});
    }
}

