/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.ConditionalRuleUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class WorkflowProcessControlPlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String ENTRABILLID = "entraBillId";
    private static final String PROCPLUGINS = "plugin";
    private static final String PROCPLUGINS_ID = "plugin_id";
    private static final String SHOWVALUE_EXTITF = "sv_plugin_implementation";
    private static final String PROCPLUGINS_EXTITF = "plugin_implementation";
    private static final String PROCPLUGINS_EXTITF_TYPE = "plugin_implementationtype";
    private static final String PROCPLUGINS_BILLNAME = "plugin_billname";
    private static final String PROCPLUGINS_BILLNUMBER = "plugin_billnumber";
    private static final String PROCPLUGINS_EVNET = "plugin_event";
    private static final String BILLEXCEPTIOOPENTRY = "billexcp";
    private static final String BILLEXCEPTIOOPENTRY_ID = "billexcp_id";
    private static final String BILLEXCEPTIONOPERATION = "billexcp_oper";
    private static final String BILLEXCEPTIONOPERATIONNAME = "billexcp_opername";
    private static final String BILLEXCEPTIONOPERABILLNAME = "billexcp_billname";
    private static final String BILLEXCEPTIONOPERABILLNUMBER = "billexcp_billnumber";
    private static final String ENTITYNUMBER = "entityNumber";
    private static final String ENTITYNAME = "entityName";
    private static final String START = "start";
    private static final String END = "end";
    private static final String TERMINATE = "terminate";
    private static final String BILLTERMINATE = "billterminate";
    private static final String NUMBER = "number";
    private static final String CALCULATEPARTICIPANT = "calculate_participant";
    private static final String CLOSECONDITION = "closecondition";
    private static final String PROPERTY_CLOSE_CONDITION = "closeCondition";
    private static final String SHOWTEXT = "showtext";
    private static final String ADVCLOSECONDITION = "advclosecondition";
    private static final String PERSONRANGE_PROPERTY = "personRange";
    private static final String AFTERAUDITBTN_PROPERTY = "afterAuditbtn";
    private static final String AFTERAUIT_PROPERTY = "afterAudit";
    private static final String AFTERAUDITVALUE_PANEL = "afterauditvalue_panel";
    private static final String PERSONRANGE_MODEL = "personrange";
    private static final String AFTERAUDITBTN_MODEL = "afterauditbtn";
    private static final String AUDITOR_MODEL = "auditor";
    private static final String KEYAUDITOR_MODEL = "keyauditor";
    private static final String AFTERAUDIT_PANEL = "afteraudit_panel";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(CLOSECONDITION);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit procExcp = (TextEdit)this.getControl(SHOWVALUE_EXTITF);
        procExcp.addButtonClickListener((ClickListener)this);
        TextEdit billExpOp = (TextEdit)this.getControl(BILLEXCEPTIONOPERATIONNAME);
        billExpOp.addButtonClickListener((ClickListener)this);
        TextEdit billExpBill = (TextEdit)this.getControl(BILLEXCEPTIONOPERABILLNAME);
        billExpBill.addButtonClickListener((ClickListener)this);
        TextEdit flowPluginBill = (TextEdit)this.getControl(PROCPLUGINS_BILLNAME);
        flowPluginBill.addButtonClickListener((ClickListener)this);
        this.addClickListeners(new String[]{CLOSECONDITION});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject properties = this.getCellProperties();
        this.initPluginEntry(properties);
        this.initBillExeptionEntry();
        this.initFlowPluginEntry();
        this.initCloseCondition(properties);
        this.initAfterAudit(properties);
    }

    private void initAfterAudit(JSONObject properties) {
        if ("WorkflowModel".equals(this.modelType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{AFTERAUDIT_PANEL});
            JSONObject afterAudit = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, AFTERAUIT_PROPERTY);
            if (afterAudit == null || afterAudit.isEmpty() || !afterAudit.containsKey((Object)AFTERAUDITBTN_PROPERTY)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{AFTERAUDITVALUE_PANEL});
                return;
            }
            Boolean afterAuditbtn = afterAudit.getBooleanValue(AFTERAUDITBTN_PROPERTY);
            if (afterAuditbtn.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{AFTERAUDITVALUE_PANEL});
                String personRange = afterAudit.getString(PERSONRANGE_PROPERTY);
                this.getView().setVisible(Boolean.valueOf(AUDITOR_MODEL.equals(personRange)), new String[]{KEYAUDITOR_MODEL});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{AFTERAUDITVALUE_PANEL});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{AFTERAUDIT_PANEL});
        }
    }

    private void initCloseCondition(JSONObject properties) {
        if ("WorkflowModel".equals(this.modelType) || WfConfigurationUtil.isHideUnUseControls()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ADVCLOSECONDITION});
            return;
        }
        JSONObject closeCondition = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, PROPERTY_CLOSE_CONDITION);
        if (closeCondition != null && !closeCondition.isEmpty()) {
            this.getModel().setValue(CLOSECONDITION, (Object)ConditionalRuleUtil.getShowText(closeCondition));
        }
    }

    private void initFlowPluginEntry() {
        if ("WorkflowModel".equals(this.modelType)) {
            EntryGrid entry = (EntryGrid)this.getControl(PROCPLUGINS);
            entry.setColumnProperty(PROCPLUGINS_BILLNAME, "vi", (Object)false);
        } else {
            ComboEdit comboEdit = (ComboEdit)this.getControl(PROCPLUGINS_EVNET);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(5);
            ComboItem comboItem1 = new ComboItem();
            comboItem1.setId(START);
            comboItem1.setValue(START);
            comboItem1.setCaption(new LocaleString(WFMultiLangConstants.getProcInstStratName()));
            comboItems.add(comboItem1);
            ComboItem comboItem2 = new ComboItem();
            comboItem2.setId(END);
            comboItem2.setValue(END);
            comboItem2.setCaption(new LocaleString(WFMultiLangConstants.getProcInstCompleteName()));
            comboItems.add(comboItem2);
            ComboItem comboItem3 = new ComboItem();
            comboItem3.setId(TERMINATE);
            comboItem3.setValue(TERMINATE);
            comboItem3.setCaption(new LocaleString(WFMultiLangConstants.getProcInstAbanName()));
            comboItems.add(comboItem3);
            ComboItem comboItem4 = new ComboItem();
            comboItem4.setId(BILLTERMINATE);
            comboItem4.setValue(BILLTERMINATE);
            comboItem4.setCaption(new LocaleString(WFMultiLangConstants.getBillProcInstCompleteName()));
            comboItems.add(comboItem4);
            ComboItem comboItem5 = new ComboItem();
            comboItem5.setId(CALCULATEPARTICIPANT);
            comboItem5.setValue(CALCULATEPARTICIPANT);
            comboItem5.setCaption(new LocaleString(WFMultiLangConstants.getCulcParticipant()));
            comboItems.add(comboItem5);
            comboEdit.setComboItems(comboItems);
        }
    }

    private void initBillExeptionEntry() {
        if ("WorkflowModel".equals(this.modelType)) {
            EntryGrid entry = (EntryGrid)this.getControl(BILLEXCEPTIOOPENTRY);
            entry.setColumnProperty(BILLEXCEPTIONOPERABILLNAME, "vi", (Object)false);
            ComboEdit comboEdit = (ComboEdit)this.getControl("billexcp_procaction");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
            ComboItem comboItem1 = new ComboItem();
            comboItem1.setId(TERMINATE);
            comboItem1.setValue(TERMINATE);
            comboItem1.setCaption(new LocaleString(WFMultiLangConstants.getProcessAbandonMsg()));
            comboItems.add(comboItem1);
            ComboItem comboItem2 = new ComboItem();
            comboItem2.setId("processdelete");
            comboItem2.setValue("processdelete");
            comboItem2.setCaption(new LocaleString(WFMultiLangConstants.getProcessDeleteMsg()));
            comboItems.add(comboItem2);
            comboEdit.setComboItems(comboItems);
        } else {
            ComboEdit comboEdit = (ComboEdit)this.getControl("billexcp_procaction");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
            ComboItem comboItem = new ComboItem();
            comboItem.setId("procinstiddelete");
            comboItem.setValue("procinstiddelete");
            comboItem.setCaption(new LocaleString(WFMultiLangConstants.getProcessInstanceDeleteMsg()));
            comboItems.add(comboItem);
            ComboItem comboItem1 = new ComboItem();
            comboItem1.setId("billdelete");
            comboItem1.setValue("billdelete");
            comboItem1.setCaption(new LocaleString(WFMultiLangConstants.getBillDeleteMsg()));
            comboItems.add(comboItem1);
            comboEdit.setComboItems(comboItems);
        }
    }

    private void initPluginEntry(JSONObject properties) {
        Object value = DesignerModelUtil.getProperty((Map<String, Object>)properties, "executionListeners");
        if (value instanceof JSONArray) {
            this.initEntryGridValue((EntryGrid)this.getControl(PROCPLUGINS), (JSONArray)value);
        } else {
            this.getModel().deleteEntryData(PROCPLUGINS);
        }
        value = DesignerModelUtil.getProperty((Map<String, Object>)properties, "billExceptionOp");
        if (value instanceof JSONArray) {
            this.initEntryGridValue((EntryGrid)this.getControl(BILLEXCEPTIOOPENTRY), (JSONArray)value);
        } else {
            this.getModel().deleteEntryData(BILLEXCEPTIOOPENTRY);
        }
    }

    @Override
    protected void setGridPropertyValue(String gridKey) {
        if (PROCPLUGINS.equals(gridKey)) {
            this.setProperty("executionListeners", this.getEntryGridValue((EntryGrid)this.getControl(gridKey)));
        } else if (BILLEXCEPTIOOPENTRY.equals(gridKey)) {
            this.setProperty("billExceptionOp", this.getEntryGridValue((EntryGrid)this.getControl(gridKey)));
        } else {
            super.setGridPropertyValue(gridKey);
        }
    }

    @Override
    protected Object getEntryFieldShowValue(String property, Object value) {
        if ("implementation".equals(property)) {
            return ExternalInterfaceUtil.getFormattedShowValue((String)((String)value));
        }
        return super.getEntryFieldShowValue(property, value);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "sv_plugin_implementation": {
                this.openProcExcpExtItf();
                break;
            }
            case "billexcp_opername": {
                this.selectOperation(BILLEXCEPTIOOPENTRY, BILLEXCEPTIONOPERATION, BILLEXCEPTIONOPERABILLNUMBER);
                break;
            }
            case "billexcp_billname": {
                this.selectBill(BILLEXCEPTIONOPERABILLNAME);
                break;
            }
            case "plugin_billname": {
                this.selectBill(PROCPLUGINS_BILLNAME);
                break;
            }
            case "closecondition": {
                DesignerPluginUtil.openConditionalRule(this.getView(), (IFormPlugin)this, this.getCellProperties(), this.getModelJsonString(), this.itemId, ConditionalRuleType.closeProcess, PROPERTY_CLOSE_CONDITION, CLOSECONDITION);
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void selectBill(String key) {
        if (!"BizFlowModel".equals(this.modelType)) {
            return;
        }
        HashMap<String, String> bills = new HashMap<String, String>();
        if (PROCPLUGINS_BILLNAME.equals(key)) {
            String event = (String)this.getModel().getValue(PROCPLUGINS_EVNET);
            if (START.equals(event) || END.equals(event) || TERMINATE.equals(event) || CALCULATEPARTICIPANT.equals(event)) {
                this.getBillFromStartItem(bills);
            } else if (BILLTERMINATE.equals(event)) {
                this.getBillFromAllNode(bills);
            }
            if (bills.isEmpty()) {
                return;
            }
        } else {
            this.getBillFromAllNode(bills);
        }
        FormShowParameter parameter = this.getShowParameter(key, "wf_billabort_billconfig");
        parameter.setCustomParam("bills", (Object)SerializationUtils.toJsonString(bills));
        if (BILLEXCEPTIONOPERABILLNAME.equals(key)) {
            parameter.setCustomParam("selectedValue", this.getModel().getValue(BILLEXCEPTIONOPERABILLNUMBER));
        } else {
            parameter.setCustomParam("selectedValue", this.getModel().getValue(PROCPLUGINS_BILLNUMBER));
        }
        parameter.setCaption(WFMultiLangConstants.getFlowBillInfo());
        this.getView().showForm(parameter);
    }

    private void getBillFromAllNode(Map<String, String> bills) {
        GraphCell graphCell = this.getGraphCell();
        List childShapes = graphCell.getChildShapes();
        for (GraphCell childShape : childShapes) {
            Map properties = childShape.getProperties();
            String entityNumber = (String)DesignerModelUtil.getProperty(properties, ENTITYNUMBER);
            String entityName = (String)DesignerModelUtil.getProperty(properties, ENTITYNAME);
            if (!WfUtils.isNotEmpty((String)entityNumber) || !WfUtils.isNotEmpty((String)entityName) || bills.get(entityNumber) != null) continue;
            bills.put(entityNumber, entityName);
        }
    }

    private void getBillFromStartItem(Map<String, String> bills) {
        JSONObject flowProperties = this.getCellProperties();
        JSONArray startItems = (JSONArray)DesignerModelUtil.getProperty((Map<String, Object>)flowProperties, "startItems");
        if (startItems != null && !startItems.isEmpty()) {
            for (int i = 0; i < startItems.size(); ++i) {
                JSONObject startItem = (JSONObject)startItems.get(i);
                if (!startItem.getBoolean("allowstart").booleanValue()) continue;
                String entityNumber = startItem.getString("entitynumber");
                String entityName = startItem.getString("entityname");
                if (!WfUtils.isNotEmpty((String)entityNumber) || !WfUtils.isNotEmpty((String)entityName) || bills.get(entityNumber) != null) continue;
                bills.put(entityNumber, entityName);
            }
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null || newValue instanceof String && WfUtils.isEmpty((String)((String)newValue))) {
            switch (propName) {
                case "sv_plugin_implementation": {
                    this.getModel().setValue(PROCPLUGINS_EXTITF, null, rowIndex);
                    break;
                }
                case "closecondition": {
                    this.closeConditionChanged(newValue);
                    break;
                }
                case "billexcp_billname": {
                    this.getModel().setValue(BILLEXCEPTIONOPERABILLNUMBER, (Object)"", rowIndex);
                    this.getModel().setValue(BILLEXCEPTIONOPERATIONNAME, (Object)"", rowIndex);
                    break;
                }
                case "billexcp_opername": {
                    this.getModel().setValue(BILLEXCEPTIONOPERATION, (Object)"", rowIndex);
                    break;
                }
                case "plugin_billname": {
                    this.getModel().setValue(PROCPLUGINS_BILLNUMBER, (Object)"", rowIndex);
                    break;
                }
                default: {
                    super.propertyChanged(propName, newValue, oldValue, rowIndex);
                    break;
                }
            }
        } else if (PROCPLUGINS_EVNET.equals(propName)) {
            this.clearBillAndOperateInBizFlow(propName, newValue, oldValue, rowIndex);
        } else if (PROCPLUGINS_BILLNUMBER.equals(propName)) {
            this.clearOperateInBizFlow(propName, newValue, oldValue, rowIndex);
        } else if (KEYAUDITOR_MODEL.equals(propName)) {
            MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)newValue;
            ArrayList<Long> idList = new ArrayList<Long>(collection.size());
            for (DynamicObject id : collection) {
                DynamicObject basedataObj = id.getDynamicObject("fbasedataid");
                Long basedataId = (Long)basedataObj.getPkValue();
                idList.add(basedataId);
            }
            this.setProperty(propName, idList);
        } else if (AFTERAUDITBTN_MODEL.equals(propName)) {
            this.getView().setVisible((Boolean)newValue, new String[]{AFTERAUDITVALUE_PANEL});
            this.setProperty(propName, newValue);
            String personRange = (String)this.getModel().getValue(PERSONRANGE_PROPERTY);
            this.getView().setVisible(Boolean.valueOf(AUDITOR_MODEL.equals(personRange)), new String[]{KEYAUDITOR_MODEL});
        } else if (PERSONRANGE_MODEL.equals(propName)) {
            this.getModel().setValue(propName, newValue);
            this.setProperty(propName, newValue);
            this.getView().setVisible(Boolean.valueOf(AUDITOR_MODEL.equals(newValue)), new String[]{KEYAUDITOR_MODEL});
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    private void closeConditionChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty(CLOSECONDITION, null);
        }
    }

    private void clearOperateInBizFlow(String propName, Object newValue, Object oldValue, int rowIndex) {
        String extitfType;
        if ("BizFlowModel".equals(this.modelType) && "operation".equals(extitfType = (String)this.getModel().getValue(PROCPLUGINS_EXTITF_TYPE))) {
            this.getModel().setValue(PROCPLUGINS_EXTITF_TYPE, (Object)"", rowIndex);
            this.getModel().setValue(SHOWVALUE_EXTITF, (Object)"", rowIndex);
            this.getModel().setValue(PROCPLUGINS_EXTITF, (Object)"", rowIndex);
        }
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
    }

    private void clearBillAndOperateInBizFlow(String propName, Object newValue, Object oldValue, int rowIndex) {
        if ("BizFlowModel".equals(this.modelType)) {
            this.getModel().setValue(PROCPLUGINS_BILLNAME, (Object)"", rowIndex);
            String extitfType = (String)this.getModel().getValue(PROCPLUGINS_EXTITF_TYPE);
            if ("operation".equals(extitfType)) {
                this.getModel().setValue(PROCPLUGINS_EXTITF_TYPE, (Object)"", rowIndex);
                this.getModel().setValue(SHOWVALUE_EXTITF, (Object)"", rowIndex);
                this.getModel().setValue(PROCPLUGINS_EXTITF, (Object)"", rowIndex);
            }
        } else if (CALCULATEPARTICIPANT.equals(newValue)) {
            this.getModel().setValue(PROCPLUGINS_EXTITF_TYPE, (Object)"", rowIndex);
            this.getModel().setValue(SHOWVALUE_EXTITF, (Object)"", rowIndex);
            this.getModel().setValue(PROCPLUGINS_EXTITF, (Object)"", rowIndex);
        }
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
    }

    private void openProcExcpExtItf() {
        JSONObject properties = this.getCellProperties();
        String entityId = null;
        if ("BizFlowModel".equals(this.modelType)) {
            String billNumber = (String)this.getModel().getValue(PROCPLUGINS_BILLNUMBER);
            if (WfUtils.isEmpty((String)billNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"WorkflowProcessControlPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            entityId = MetadataDao.getIdByNumber((String)billNumber, (MetaCategory)MetaCategory.Form);
        } else {
            entityId = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, ENTRABILLID);
        }
        if (WfUtils.isEmpty((String)entityId)) {
            this.getView().showTipNotification(WFMultiLangConstants.getBillNotExistTip());
            return;
        }
        EntryGrid grid = (EntryGrid)this.getControl(PROCPLUGINS);
        String value = (String)this.getModel().getValue(PROCPLUGINS_EXTITF, grid.getEntryState().getFocusRow());
        int index = grid.getEntryState().getFocusRow();
        String event = (String)this.getModel().getValue(PROCPLUGINS_EVNET, index);
        String types = null;
        types = CALCULATEPARTICIPANT.equals(event) ? ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"}) : ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script", "operation"});
        DesignerPluginUtil.openExternalInterface(this.getView(), (IFormPlugin)this, types, entityId, value, this.isOperationSingle(event));
    }

    private boolean isOperationSingle(String event) {
        if (event == null) {
            return false;
        }
        switch (event) {
            case "start": 
            case "end": 
            case "terminate": {
                return true;
            }
        }
        return false;
    }

    private void selectOperation(String entryKey, String billOperateKey, String billNumberKey) {
        DynamicObject obj;
        JSONObject properties = this.getCellProperties();
        EntryGrid grid = (EntryGrid)this.getControl(entryKey);
        int index = grid.getEntryState().getFocusRow();
        String curOp = null;
        if (index > -1 && (obj = this.getModel().getEntryRowEntity(entryKey, index)) != null && obj.get(billOperateKey) != null) {
            try {
                String val = (String)obj.get(billOperateKey);
                if (WfUtils.isNotEmpty((String)val)) {
                    curOp = val;
                }
            }
            catch (Exception e) {
                this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        String entityId = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, ENTRABILLID);
        FormShowParameter parameter = this.getShowParameter(billOperateKey, "wf_formoperation");
        parameter.setShowTitle(true);
        Map params = parameter.getCustomParams();
        HashMap context = new HashMap();
        HashMap<String, String> nodeProperties = new HashMap<String, String>();
        if ("BizFlowModel".equals(this.modelType)) {
            String formKey = (String)this.getModel().getValue(billNumberKey);
            if (WfUtils.isEmpty((String)formKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"WorkflowProcessControlPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            nodeProperties.put("formKey", formKey);
        } else {
            nodeProperties.put("entityId", entityId);
        }
        context.put("nodeProperties", nodeProperties);
        params.put("context", context);
        params.put("selchexkbox", Boolean.FALSE);
        if (curOp != null) {
            params.put("selectValues", curOp);
        }
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "externalInterface": {
                this.updateExternalInterface(returnData);
                break;
            }
            case "billexcp_oper": {
                this.updateOperation(returnData);
                break;
            }
            case "closecondition": {
                this.setCloseCondition((Map)returnData);
                break;
            }
            case "billexcp_billname": {
                this.updateBillName(returnData);
                break;
            }
            case "plugin_billname": {
                this.updatePluginBillName(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setCloseCondition(Map<String, Object> evtData) {
        if (evtData.isEmpty()) {
            this.getModel().setValue(CLOSECONDITION, null);
            this.setProperty(CLOSECONDITION, null);
            return;
        }
        this.getModel().setValue(CLOSECONDITION, (Object)DesignerPluginUtil.getLocaleValue(evtData.get(SHOWTEXT)));
        this.setProperty(CLOSECONDITION, evtData);
    }

    private void updatePluginBillName(Object returnData) {
        EntryGrid grid = (EntryGrid)this.getControl(PROCPLUGINS);
        int index = grid.getEntryState().getFocusRow();
        if (index > -1 && returnData != null) {
            Map ret = (Map)returnData;
            this.getModel().setValue(PROCPLUGINS_BILLNUMBER, ret.get(ENTITYNUMBER), index);
            this.getModel().setValue(PROCPLUGINS_BILLNAME, (Object)((String)ret.get(ENTITYNAME) + "(" + (String)ret.get(ENTITYNUMBER) + ")"), index);
        }
    }

    private void updateBillName(Object returnData) {
        EntryGrid grid = (EntryGrid)this.getControl(BILLEXCEPTIOOPENTRY);
        int index = grid.getEntryState().getFocusRow();
        if (index > -1 && returnData != null) {
            Map ret = (Map)returnData;
            this.getModel().setValue(BILLEXCEPTIONOPERABILLNUMBER, ret.get(ENTITYNUMBER), index);
            this.getModel().setValue(BILLEXCEPTIONOPERABILLNAME, (Object)((String)ret.get(ENTITYNAME) + "(" + (String)ret.get(ENTITYNUMBER) + ")"), index);
        }
    }

    private void updateExternalInterface(Object returnData) {
        if (WfUtils.isNotEmptyString((Object)returnData)) {
            EntryGrid grid = (EntryGrid)this.getControl(PROCPLUGINS);
            int rowIndex = grid.getSelectRows()[0];
            this.getModel().setValue(PROCPLUGINS_EXTITF, returnData, rowIndex);
            this.getModel().setValue(PROCPLUGINS_EXTITF_TYPE, (Object)ExternalInterfaceUtil.getExtItfType((String)returnData.toString()), rowIndex);
        }
    }

    private void updateOperation(Object returnDate) {
        EntryGrid grid = (EntryGrid)this.getControl(BILLEXCEPTIOOPENTRY);
        int index = grid.getEntryState().getFocusRow();
        if (index > -1 && returnDate != null) {
            Map t = (Map)returnDate;
            this.getModel().setValue(BILLEXCEPTIONOPERATION, t.get(NUMBER), index);
            this.getModel().setValue(BILLEXCEPTIONOPERATIONNAME, (Object)(t.get("name") + "(" + t.get(NUMBER) + ")"), index);
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryIdKey = null;
        String field = null;
        String name = e.getEntryProp().getName();
        RowDataEntity data = e.getRowDataEntities()[0];
        switch (name) {
            case "plugin": {
                entryIdKey = PROCPLUGINS_ID;
                field = "executionListeners";
                break;
            }
            case "billexcp": {
                entryIdKey = BILLEXCEPTIOOPENTRY_ID;
                field = "billExceptionOp";
            }
        }
        if (entryIdKey != null) {
            String id = data.getDataEntity().getString(entryIdKey);
            if (WfUtils.isEmpty((String)id)) {
                id = BpmnDiffUtil.getListElementId((String)field);
            }
            data.getDataEntity().set(entryIdKey, (Object)id);
        }
        super.afterAddRow(e);
    }
}

