/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.plugin.model.StencilProperty;
import kd.bos.workflow.design.util.ConditionalRuleUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;

public class WorkflowProcessPropConfPlugin
extends AbstractWorkflowConfigurePlugin
implements TabSelectListener,
BeforeF7SelectListener {
    private final String ENTRABILLNAME = "entrabillname";
    private final String STARTCONDITION = "startupcondrule";
    private final String PANEL_STARTUPCOND = "startupcond_panel";
    private final String ORGUNITID = "orgunitid";
    private final String TAB_PROCESS_CONTROL = "processcontrol_tab";
    private final String TAB_PROCESS_VARIABLE = "processvariable_tab";
    private final String PANEL_PROCESS_CONTROL = "processcontrol_panel";
    private final String PANEL_PROCESS_VARIABLE = "processvariable_panel";
    private final String KEY_PROCESS_CONTROL = "process_control";
    private final String KEY_PROCESS_VARIABLE = "process_variable";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty("startupcondrule");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        TextEdit entraBillName = (TextEdit)this.getControl("entrabillname");
        entraBillName.addButtonClickListener((ClickListener)this);
        this.addStartConditionListener();
    }

    protected void addStartConditionListener() {
        TextEdit startCondition = (TextEdit)this.getControl("startupcondrule");
        startCondition.addButtonClickListener((ClickListener)this);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("orgunitid");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        try {
            this.beginInit();
            if (!this.isModelInitialized()) {
                this.log.debug("The model has not been initialized!");
                return;
            }
            super.afterCreateNewData(e);
            JSONObject properties = this.getCellProperties();
            this.initStartUpCondition(properties);
            if ("false".equals(this.getIdeViewPageCacheData("isDefaultScheme"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"businessid"});
            }
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WorkflowProcessPropConfPlugin.class);
        }
    }

    @Override
    protected void initPropertyValue(StencilProperty property, Control control, JSONObject properties, String propName, List<Object> updateProperties, Map<String, Object> isvPropsConfig) {
        if ("orgunitid".equals(control.getKey())) {
            this.initOrgUnit(properties);
        } else {
            super.initPropertyValue(property, control, properties, propName, updateProperties, isvPropsConfig);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("false".equals(this.getIdeViewPageCacheData("isDefaultScheme"))) {
            return;
        }
        Object orgUnitId = this.getModel().getValue("orgunitid");
        if (orgUnitId instanceof DynamicObject) {
            DynamicObject org = (DynamicObject)orgUnitId;
            long userId = Long.parseLong(RequestContext.get().getUserId());
            if (!WfAdminUtil.canDoOperation((Long)userId, (Long)((Long)org.getPkValue()))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"orgunitid"});
            }
        }
    }

    protected void initOrgUnit(JSONObject properties) {
        Long prop = properties.getLong("orgUnitId");
        if (WfUtils.isEmpty((Long)prop)) {
            return;
        }
        if (QueryServiceHelper.exists((String)"bos_org", (Object)prop)) {
            this.getModel().setValue("orgunitid", (Object)prop);
        } else {
            this.log.debug(String.format("org %s not exist.", prop));
        }
    }

    protected void initStartUpCondition(JSONObject properties) {
        JSONObject conditionRule = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, "startupcondrule");
        this.getModel().setValue("startupcondrule", (Object)ConditionalRuleUtil.getShowText(conditionRule));
    }

    private void openEntityList() {
        DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, "entrabillname");
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "entrabillname": {
                this.openEntityList();
                break;
            }
            case "startupcondrule": {
                DesignerPluginUtil.openConditionalRule(this.getView(), (IFormPlugin)this, this.getCellProperties(), this.getModelJsonString(), this.itemId, ConditionalRuleType.processStartUp, "startupcondrule", "condition");
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "startupcondrule": {
                this.startConditionChanged(newValue);
                break;
            }
            case "orgunitid": {
                this.orgUnitChanged(propName, newValue, oldValue);
                break;
            }
            case "entrabillname": {
                this.entraBillNameChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "businessid": {
                this.businessIdChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void businessIdChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        String result = WfUtils.validateBusinessId((String)newValue.toString());
        if (StringUtils.isNotBlank((CharSequence)result)) {
            this.getModel().beginInit();
            this.getModel().setValue(propName, oldValue);
            this.getModel().endInit();
            this.getView().showTipNotification(result);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    private void entraBillNameChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.getModel().beginInit();
            this.getModel().setValue(propName, oldValue);
            this.getModel().endInit();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u7684\u5c5e\u6027\u914d\u7f6e\u754c\u9762\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"WorkflowProcessPropConfPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    private void startConditionChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty("startupcondrule", null);
        }
    }

    private void orgUnitChanged(String propName, Object newValue, Object oldValue) {
        if (newValue == null) {
            this.getModel().setValue("orgunitid", oldValue);
            return;
        }
        if (newValue instanceof DynamicObject) {
            DynamicObject org = (DynamicObject)newValue;
            this.setProperty(propName, org.getPkValue());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "entrabillname": {
                this.updateEntryBill(returnData);
                break;
            }
            case "condition": {
                this.updateConditionalRule(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void updateConditionalRule(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.getModel().setValue("startupcondrule", (Object)DesignerPluginUtil.getLocaleValue(data.get("showtext")));
            if (data.size() == 0) {
                this.setProperty("startupcondrule", null);
            } else {
                this.setProperty("startupcondrule", data);
            }
        }
    }

    private void updateEntryBill(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            Object id = data.get("id");
            Object name = data.get("name");
            Object number = data.get("number");
            this.getModel().setValue("entrabillname", name);
            this.setProperties("entraBill", number, "entraBillId", id);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String key;
        switch (key = evt.getTabKey()) {
            case "processcontrol_tab": {
                this.loadProcessControlPage();
                break;
            }
            case "processvariable_tab": {
                this.loadProcessVariablePage();
                break;
            }
        }
    }

    private void loadProcessVariablePage() {
        String pageId = this.getPageCache().get("process_variable");
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_process_variable", "processvariable_panel");
            this.getPageCache().put("process_variable", pageId);
        }
    }

    private void loadProcessControlPage() {
        String pageId = this.getPageCache().get("process_control");
        if (pageId == null) {
            pageId = this.showFormInTabContainer("wf_process_control", "processcontrol_panel");
            this.getPageCache().put("process_control", pageId);
        }
    }

    @Override
    protected Object getInitPropValue(JSONObject properties, String propName) {
        if ("processMode".equalsIgnoreCase(propName)) {
            if (properties.getJSONObject("control") != null) {
                String obj = properties.getJSONObject("control").getString(propName);
                this.deleteProperty("control");
                return obj;
            }
            return super.getInitPropValue(properties, propName);
        }
        if ("businessId".equals(propName)) {
            return this.fillBusinessId(properties, propName);
        }
        return super.getInitPropValue(properties, propName);
    }

    private String fillBusinessId(JSONObject properties, String propName) {
        Object businessId = super.getInitPropValue(properties, propName);
        String number = properties.getString("process_id");
        if (StringUtils.isBlank((Object)businessId)) {
            if ("designer".equals(this.getScene())) {
                QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)number)};
                List models = this.getRepositoryService().findEntitiesByFilters("wf_model", filters);
                if (!models.isEmpty()) {
                    businessId = ((ModelEntity)models.get(0)).getBusinessId();
                }
            } else {
                QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)number)};
                List procDefs = this.getRepositoryService().findEntitiesByFilters("wf_processdefinition", filters);
                if (!procDefs.isEmpty()) {
                    businessId = ((ProcessDefinitionEntity)procDefs.get(0)).getBusinessId();
                }
            }
        }
        return StringUtils.isBlank((Object)businessId) ? number : String.valueOf(businessId);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove("process_control");
        this.getPageCache().remove("process_variable");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if ("orgunitid".equals(fieldKey)) {
            String billNumber = this.getCellProperties().getString("entraBill");
            if (WfUtils.isEmpty((String)billNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5355\u636e\u201d\uff0c\u518d\u9009\u62e9\u201c\u6240\u5c5e\u7ec4\u7ec7\u201d\u3002", (String)"WorkflowProcessPropConfPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                evt.setCancel(true);
            } else {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)billNumber);
                String mainOrgPropName = dt.getMainOrg();
                if (WfUtils.isNotEmpty((String)mainOrgPropName)) {
                    MainOrgProp orgProp = (MainOrgProp)dt.getProperty(mainOrgPropName);
                    evt.getFormShowParameter().setCustomParam("orgFuncId", (Object)orgProp.getOrgFunc());
                }
            }
        }
    }
}

