/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.dynamicpartial.DynamicModelPartial;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.plugin.WorkflowDesignerIDEPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class WorkflowProcessVariablePlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String VARIABLES = "variables";
    private static final String DEFAULT_VAR_VALUE = "variables_defaultvalue";
    private static final String VARIABLE_NAME = "variables_name";
    private static final String VARIABLES_DESCRIPTION = "variables_description";
    private static final String VARIABLE_ID = "variables_id";
    private static final String VAR_TYPE = "variables_type";
    private static final String VAR_VALUETYPE = "variables_valuetype";
    private static final String VARIABLE_GROUP_REALVALUE = "variables_grouprealvalue";
    private static final String BIZAPPLIER = "bizApplier";
    private static final String GROUPBY = "taskGroupBy";
    private static final String BILLNAME = "billname";
    private static final String WF_PROCESS_INNERVARIABLE = "wf_process_innervariable";
    private static final String WF_TOHANDLE_GROUPBY = "wf_tohandle_groupby";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit varDefVal = (TextEdit)this.getControl(DEFAULT_VAR_VALUE);
        varDefVal.addButtonClickListener((ClickListener)this);
        TextEdit variableName = (TextEdit)this.getControl(VARIABLE_NAME);
        variableName.addButtonClickListener((ClickListener)this);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "variables_defaultvalue": {
                this.openValueExpression();
                break;
            }
            case "variables_name": {
                this.showVariableName(WF_PROCESS_INNERVARIABLE, key);
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void openValueExpression() {
        JSONObject properties = this.getCellProperties();
        String variableName = (String)this.getModel().getValue(VARIABLE_NAME);
        FormShowParameter parameter = GROUPBY.equals(variableName) ? this.getShowParameter(GROUPBY, WF_TOHANDLE_GROUPBY) : this.getShowParameter("valueExpression", "wf_valueexpression");
        Object defaultVal = this.getModel().getValue(DEFAULT_VAR_VALUE, ((EntryGrid)this.getControl(VARIABLES)).getEntryState().getFocusRow());
        parameter.setCustomParam("entityNumber", DesignerModelUtil.getProperty((Map<String, Object>)properties, "entraBill"));
        parameter.setCustomParam(BILLNAME, DesignerModelUtil.getProperty((Map<String, Object>)properties, "entraBillName"));
        parameter.setCustomParam("isVal", (Object)Boolean.TRUE);
        if (BIZAPPLIER.equals(variableName)) {
            parameter.setCustomParam("filter", (Object)"F7");
        }
        String expression = null;
        if (WfUtils.isNotEmptyString((Object)defaultVal)) {
            expression = defaultVal.toString();
            if (expression.startsWith("${") && expression.matches("\\$\\{.+\\}")) {
                expression = expression.replaceAll("\\$|\\{|\\}", "");
                parameter.setCustomParam("expression", (Object)expression);
            } else if (GROUPBY.equals(variableName)) {
                parameter.setCustomParam("expression", this.getModel().getValue(VARIABLE_GROUP_REALVALUE, ((EntryGrid)this.getControl(VARIABLES)).getEntryState().getFocusRow()));
            } else {
                parameter.setCustomParam("tip", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u503c\u4e0d\u662f\u8868\u8fbe\u5f0f\uff0c\u8868\u8fbe\u5f0f\u9875\u9762\u5c06\u663e\u793a\u9ed8\u8ba4\u503c\u3002", (String)"WorkflowProcessVariablePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        }
        this.getView().showForm(parameter);
    }

    private void showVariableName(String formId, String controlName) {
        if ("WorkflowModel".equals(this.modelType)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId(formId);
            parameter.setCaption(ResManager.loadKDString((String)"\u6d41\u7a0b\u5185\u7f6e\u53d8\u91cf", (String)"WorkflowProcessVariablePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            String variableName = (String)this.getModel().getValue(VARIABLE_NAME);
            parameter.setCustomParam("params", (Object)variableName);
            parameter.setCustomParam("modelType", (Object)this.modelType);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, controlName));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u7f3a\u5c11\u5185\u7f6e\u53d8\u91cf\u3002", (String)"WorkflowProcessVariablePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        String tip = null;
        if (VARIABLE_NAME.equals(propName) && (tip = this.validateVariable((String)oldValue)) != null) {
            this.getModel().setValue(propName, oldValue, rowIndex);
            this.getView().showTipNotification(tip, Integer.valueOf(6000));
        } else if (VARIABLE_NAME.equals(propName) && newValue.equals(GROUPBY)) {
            this.getModel().setValue(DEFAULT_VAR_VALUE, (Object)"", rowIndex);
            this.getModel().setValue(VARIABLE_GROUP_REALVALUE, (Object)"", rowIndex);
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        } else if (DEFAULT_VAR_VALUE.equals(propName)) {
            this.variableDefaultValueChanged(propName, newValue, oldValue, rowIndex);
        } else {
            super.propertyChanged(propName, newValue, oldValue, rowIndex);
        }
    }

    private void variableDefaultValueChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
        if ("hr_scheme".equals(this.getModel().getValue(VARIABLE_NAME, rowIndex))) {
            this.hrSchemeVariableChanged();
        }
    }

    private void hrSchemeVariableChanged() {
        IFormView ideView = this.getIdeFormView();
        FormViewPluginProxy proxy = (FormViewPluginProxy)ideView.getService(FormViewPluginProxy.class);
        WorkflowDesignerIDEPlugin idePlugin = (WorkflowDesignerIDEPlugin)proxy.getPlugin(WorkflowDesignerIDEPlugin.class.getName());
        if (idePlugin != null) {
            idePlugin.refreshStencilsPanel();
            this.getView().sendFormAction(ideView);
        }
    }

    private String validateVariable(String variable) {
        String modelJson = this.getModelJsonString();
        try {
            BpmnModel bpmnModel = DesignerModelUtil.getBpmnModel(modelJson);
            Map partialMap = bpmnModel.getMainProcess().getDynamicModelPartial();
            List partials = (List)partialMap.get("condition");
            ConditionalRuleEntity condition = null;
            BaseElement elt = null;
            String seqTip = ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c%1s\u8282\u70b9\u548c%2s\u8282\u70b9\u95f4\u7684%3s\u7ebf\u5df2\u5f15\u7528\u6b64\u53d8\u91cf\u3002", (String)"WorkflowProcessVariablePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            String nodeTip = ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c%1s\u8282\u70b9\u548c%2s\u8282\u70b9\u95f4\u7684%3s\u7ebf\u5df2\u5f15\u7528\u6b64\u53d8\u91cf\u3002", (String)"WorkflowProcessVariablePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            for (DynamicModelPartial partial : partials) {
                elt = partial.getFlowElement();
                condition = (ConditionalRuleEntity)partial.getPartial();
                for (ConditionalEntity item : condition.getEntryentity()) {
                    if (!item.getParamnumber().equals(variable)) continue;
                    return String.format(elt instanceof SequenceFlow ? seqTip : nodeTip, elt.getName(), elt.getNumber(), ConditionalRuleType.getTypeName((String)condition.getType()));
                }
            }
        }
        catch (Exception e) {
            this.log.error(String.format("\u53d8\u91cf\u6821\u9a8c\u51fa\u9519--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01 %s", e.getMessage()));
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        if (evt.getReturnData() == null) {
            return;
        }
        switch (actionId = evt.getActionId()) {
            case "valueExpression": {
                this.updateVariableDefaultVal(evt.getReturnData());
                break;
            }
            case "variables_name": {
                this.updateVariableName((Map)evt.getReturnData());
                break;
            }
            case "taskGroupBy": {
                this.updateGroupByDefValue(evt.getReturnData());
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void updateGroupByDefValue(Object returnData) {
        Map data = (Map)returnData;
        EntryGrid grid = (EntryGrid)this.getControl(VARIABLES);
        int rowIndex = grid.getSelectRows()[0];
        this.getModel().setValue(DEFAULT_VAR_VALUE, data.get("showinfo"));
        this.getModel().setValue(VARIABLE_GROUP_REALVALUE, (Object)SerializationUtils.toJsonString((Object)data), rowIndex);
    }

    private void updateVariableDefaultVal(Object returnData) {
        Map data;
        if (returnData instanceof Map && WfUtils.isNotEmpty((String)((String)(data = (Map)returnData).get("prop")))) {
            String expression = (String)data.get("expression");
            EntryGrid grid = (EntryGrid)this.getControl(VARIABLES);
            int rowIndex = grid.getSelectRows()[0];
            this.getModel().setValue(DEFAULT_VAR_VALUE, (Object)String.format("${%s}", expression), rowIndex);
            Map propMap = (Map)SerializationUtils.fromJsonString((String)((String)data.get("prop")), Map.class);
            String valueType = propMap.get("valuetype").toString().toLowerCase();
            if ("string,date,number,boolean".contains(valueType)) {
                this.getModel().setValue(VAR_TYPE, (Object)valueType, rowIndex);
            } else if (((Boolean)propMap.get("hasquotes")).booleanValue()) {
                this.getModel().setValue(VAR_TYPE, (Object)"string", rowIndex);
            } else {
                this.getModel().setValue(VAR_TYPE, (Object)"number", rowIndex);
            }
        }
    }

    private void updateVariableName(Map<String, String> variables) {
        int focusRow = this.getEntryEntityFocusRow(VARIABLES);
        if (variables != null && variables.size() > 0) {
            String variablesId = variables.get("variablesId");
            String variablesName = variables.get("variablesName");
            this.getModel().setValue(VARIABLE_NAME, (Object)variablesId, focusRow);
            this.getModel().setValue(VARIABLES_DESCRIPTION, (Object)variablesName, focusRow);
            ComboEdit edit = (ComboEdit)this.getView().getControl(VAR_TYPE);
            if (GROUPBY.equals(variablesId)) {
                edit.setEnable("", Boolean.FALSE.booleanValue(), focusRow);
                this.getModel().setValue(VAR_TYPE, (Object)"string", focusRow);
            } else {
                edit.setEnable("", Boolean.TRUE.booleanValue(), focusRow);
            }
        } else {
            this.getModel().setValue(VARIABLE_NAME, null, focusRow);
            this.getModel().setValue(VARIABLES_DESCRIPTION, null, focusRow);
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (VARIABLES.equals(name)) {
            RowDataEntity data = e.getRowDataEntities()[0];
            String id = data.getDataEntity().getString(VARIABLE_ID);
            if (WfUtils.isEmpty((String)id)) {
                id = BpmnDiffUtil.getListElementId((String)VARIABLES);
            }
            data.getDataEntity().set(VARIABLE_ID, (Object)id);
        }
        super.afterAddRow(e);
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        List variables;
        int[] indexes = e.getRowIndexs();
        String name = e.getEntryProp().getName();
        boolean isHrScheme = false;
        if (VARIABLES.equals(name) && (variables = (List)BpmnModelUtil.getProperty((Map)this.getCellProperties(), (String)String.format("%s.%s", "variableGroup", VARIABLES))) != null && !variables.isEmpty() && indexes.length > 0) {
            Map variable = (Map)variables.get(indexes[0]);
            isHrScheme = "hr_scheme".equals(variable.get("name"));
        }
        super.afterDeleteRow(e);
        if (isHrScheme) {
            this.hrSchemeVariableChanged();
        }
    }
}

