/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowResetApproverPlugin
extends AbstractWorkflowPlugin {
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String ORIGINALAPPROVER = "originalapprover";
    private static final String APPROVER = "approver";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_CONFIRM});
        this.showUsersAddCustomParam();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Boolean isSelectedRows = (Boolean)this.getView().getFormShowParameter().getCustomParam("isSelectedRows");
        if (!isSelectedRows.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5de5\u4f5c\u6d41\u89d2\u8272\uff0c\u8be5\u64cd\u4f5c\u4f1a\u5c06\u6240\u6709\u5de5\u4f5c\u6d41\u89d2\u8272\u4e2d\u5305\u542b\u7684\u201c\u539f\u5ba1\u6279\u4eba\u201d\u66ff\u6362\u4e3a\u8bbe\u7f6e\u540e\u7684\u5ba1\u6279\u4eba\u3002", (String)"WorkflowResetApproverPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private void showUsersAddCustomParam() {
        BasedataEdit approver = (BasedataEdit)this.getControl(APPROVER);
        approver.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
        BasedataEdit originalApprover = (BasedataEdit)this.getControl(ORIGINALAPPROVER);
        originalApprover.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        switch (ctl.getKey()) {
            case "btn_cancel": {
                this.getView().close();
                break;
            }
            case "btn_confirm": {
                this.confirm();
                break;
            }
        }
    }

    private void confirm() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entrance = (String)formShowParameter.getCustomParam("entrance");
        List rowIds = (List)formShowParameter.getCustomParam("rowIds");
        Boolean isSelectedRows = (Boolean)formShowParameter.getCustomParam("isSelectedRows");
        if ("wf_role".equals(entrance) && !PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_role", (String)"/AGOO46A0IE8")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5de5\u4f5c\u6d41\u89d2\u8272\u201d\u7684\u201c\u91cd\u65b0\u8bbe\u7f6e\u5ba1\u6279\u4eba\u201d\u6743\u9650\u3002", (String)"WorkflowRoleListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject originalApprover = (DynamicObject)this.getModel().getValue(ORIGINALAPPROVER);
        if (originalApprover == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u539f\u5ba1\u6279\u4eba\u201d\u3002", (String)"WorkflowResetApproverPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject approver = (DynamicObject)this.getModel().getValue(APPROVER);
        if (approver == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9 \u201c\u5ba1\u6279\u4eba\u8bbe\u7f6e\u4e3a\u201d\u3002", (String)"WorkflowResetApproverPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long originalApproverId = (Long)originalApprover.getPkValue();
        String originalApproverName = originalApprover.getString("name");
        Long approverId = (Long)approver.getPkValue();
        String approverName = approver.getString("name");
        if (originalApproverId.equals(approverId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u4eba\u672a\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WorkflowResetApproverPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String result = this.resetApprover(originalApprover, approver, rowIds, isSelectedRows);
        this.addLog(originalApproverName, approverName);
        this.getView().returnDataToParent((Object)result);
        this.getView().close();
    }

    private void addLog(String originalApproverName, String approverName) {
        WfUtils.addOpLog((String)"wf_resetapprover", (String)"resetApprover", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91cd\u65b0\u8bbe\u7f6e\u5ba1\u6279\u4eba", "WorkflowResetApproverPlugin_4", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5c06\u5de5\u4f5c\u6d41\u89d2\u8272\u4e2d\u6240\u6709\u539f\u5ba1\u6279\u4eba\u4e3a[%1s]\u7684\u8bb0\u5f55\u91cd\u65b0\u8bbe\u7f6e\u5ba1\u6279\u4eba\u4e3a\uff1a[%2s]", "WorkflowResetApproverPlugin_5", "bos-wf-formplugin"), (Object[])new Object[]{originalApproverName, approverName});
    }

    private String resetApprover(DynamicObject originalApprover, DynamicObject approver, List<Long> rowIds, Boolean isSelectedRows) {
        return this.getRepositoryService().resetApprover(originalApprover, approver, rowIds, isSelectedRows);
    }
}

