/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfRoleDimensionUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.RoleDimension;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntity;

public class WorkflowRoleDimensionPlugin
extends AbstractWorkflowPlugin
implements BeforeF7SelectListener {
    private static final String BASEDATAFIELD = "basedatafield";
    private static final String ENTRYENTITY = "entryentity";
    private static final String INDEX = "index";
    private static final String ORGFIELD = "orgfield";
    private static final String WFDIMENSIONSLIST = "dimensions";
    private static final String ISORGFIELDENABLE = "isOrgFieldEnable";
    private static final String HELPURL = "https://vip.kingdee.com/article/315071101351055360?productLineId=29&isKnowledge=2";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btncancel", "btnok", "preview", "help"});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "operationcolumnap"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit formmetaBasedata = (BasedataEdit)this.getControl(BASEDATAFIELD);
        formmetaBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        if (Lang.zh_CN == RequestContext.get().getLang()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap31"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap3"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap31"});
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String dimensions = (String)fsp.getCustomParam(WFDIMENSIONSLIST);
        Boolean isCopy = Boolean.FALSE;
        String copyParam = (String)fsp.getCustomParam("iscopy");
        isCopy = WfUtils.isEmpty((String)copyParam) ? isCopy : Boolean.valueOf(copyParam);
        Boolean isUsed = Boolean.FALSE;
        Object roleId = this.getView().getFormShowParameter().getCustomParam("roleid");
        List entities = this.getManagementService().getBaseDataRefEntities("workflowRole", (Long)roleId);
        Set<Object> usedDimensionList = new HashSet(4);
        if (WfUtils.isNotEmptyForCollection((Collection)entities)) {
            isUsed = Boolean.TRUE;
            usedDimensionList = this.getUsedDimensionSet((Long)roleId);
        }
        if (!isCopy.booleanValue() && isUsed.booleanValue() && usedDimensionList.contains("tmp_wf_role_business")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ORGFIELD});
        }
        if (WfUtils.isEmpty((String)dimensions)) {
            return;
        }
        Map dimensionInfos = WfRoleDimensionUtil.getDimensionInfos((String)dimensions);
        this.getModel().setValue(ORGFIELD, (Object)((Boolean)Optional.ofNullable(dimensionInfos.get(ISORGFIELDENABLE)).orElseGet(() -> Boolean.TRUE)));
        List rdList = new ArrayList(1);
        if (WfUtils.isNotEmptyForMap((Map)dimensionInfos)) {
            rdList = (List)dimensionInfos.get(WFDIMENSIONSLIST);
        }
        if (!rdList.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, rdList.size());
        }
        int i = 0;
        ArrayList<String> list = new ArrayList<String>(rdList.size());
        for (RoleDimension rd : rdList) {
            list.add(rd.getEntityNumber());
        }
        DynamicObject[] objList = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"name, number", (QFilter[])new QFilter[]{new QFilter("number", "in", list)});
        HashMap<String, DynamicObject> objMap = new HashMap<String, DynamicObject>(objList.length);
        for (DynamicObject obj : objList) {
            objMap.put(obj.getString("number"), obj);
        }
        StringBuilder delNumber = new StringBuilder();
        for (RoleDimension rd : rdList) {
            String entityNumber = rd.getEntityNumber();
            this.getModel().setValue(BASEDATAFIELD, objMap.get(entityNumber), i);
            this.getModel().setValue(INDEX, (Object)rd.getIndex(), i);
            if (objMap.containsKey(entityNumber)) {
                if (!isCopy.booleanValue() && isUsed.booleanValue() && usedDimensionList.contains(rd.getEntityNumber())) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{BASEDATAFIELD});
                    this.getModel().setValue("candelete", (Object)Boolean.FALSE, i);
                }
            } else {
                delNumber = delNumber.append(entityNumber).append("\u3001");
            }
            ++i;
        }
        if (delNumber.length() != 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"number\u4e3a\u201c%s\u201d\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u7ef4\u5ea6\u8bbe\u7f6e\u3002", (String)"WorkflowRoleDimensionPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), delNumber.substring(0, delNumber.length() - 1)));
        }
    }

    private Set<String> getUsedDimensionSet(Long roleId) {
        HashSet<String> usedDimensionSet = new HashSet<String>(4);
        List participantModels = this.getRepositoryService().findEntitiesByFilters("wf_participantmodel", new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
        for (ParticipantModelEntity model : participantModels) {
            String field = model.getDimensionField();
            if (WfUtils.isNotEmpty((String)field)) {
                Map infoMap = (Map)SerializationUtils.fromJsonString((String)field, Map.class);
                usedDimensionSet.addAll(infoMap.keySet());
            }
            if (!WfUtils.isNotEmpty((String)model.getBusinessOrgField())) continue;
            usedDimensionSet.add("tmp_wf_role_business");
        }
        return usedDimensionSet;
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "add": {
                this.addDimension();
                break;
            }
            case "remove": {
                this.removeDimension();
                break;
            }
        }
    }

    private void removeDimension() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (selectRows.length > 0) {
            int index = selectRows[0];
            if (((Boolean)this.getModel().getValue("candelete", index)).booleanValue()) {
                this.getModel().deleteEntryRows(ENTRYENTITY, selectRows);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u4f7f\u7528\u89d2\u8272\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u539f\u6709\u7ef4\u5ea6\u3002", (String)"WorkflowRoleDimensionPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }

    private void addDimension() {
        int size = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (size == 4) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb8\u589e\u52a04\u4e2a\u7b5b\u9009\u7ef4\u5ea6\u3002", (String)"WorkflowRoleDimensionPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            int index = this.getModel().createNewEntryRow(ENTRYENTITY);
            int i = index + 1;
            this.getModel().setValue(INDEX, (Object)("dimension" + i), index);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int size = this.getModel().getEntryRowCount(ENTRYENTITY);
        for (int i = 0; i < size; ++i) {
            int index = i + 1;
            this.getModel().setValue(INDEX, (Object)("dimension" + index), i);
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if ("btnok".equals(key)) {
            HashMap<String, Object> dimensionInfo = new HashMap<String, Object>(2);
            Boolean orgFieldEnable = (Boolean)this.getModel().getValue(ORGFIELD);
            dimensionInfo.put(ISORGFIELDENABLE, orgFieldEnable);
            int size = this.getModel().getEntryRowCount(ENTRYENTITY);
            ArrayList<RoleDimension> list = new ArrayList<RoleDimension>(size);
            for (int i = 0; i < size; ++i) {
                DynamicObject obj = (DynamicObject)this.getModel().getValue(BASEDATAFIELD, i);
                if (WfUtils.isNullObject((Object)obj)) continue;
                String index = (String)this.getModel().getValue(INDEX, i);
                RoleDimension rd = new RoleDimension(obj.getString("number"), index);
                list.add(rd);
            }
            if (!orgFieldEnable.booleanValue() && list.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8bbe\u7f6e\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"WorkflowRoleDimensionPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            dimensionInfo.put(WFDIMENSIONSLIST, SerializationUtils.toJsonString(list));
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(dimensionInfo));
            this.getView().close();
        } else if ("preview".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("wf_roledimensionpreview");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        } else if ("help".equals(key)) {
            this.getView().openUrl(HELPURL);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        HashSet<Object> removeId = new HashSet<Object>(4);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject basedatafield = (DynamicObject)this.getModel().getValue(BASEDATAFIELD, i);
            if (WfUtils.isNullObject((Object)basedatafield)) continue;
            removeId.add(basedatafield.get("id"));
        }
        ArrayList<QFilter> qFilter = new ArrayList<QFilter>(1);
        qFilter.add(new QFilter("id", "not in", removeId));
        beforeF7SelectEvent.setCustomQFilters(qFilter);
        FormShowParameter param = beforeF7SelectEvent.getFormShowParameter();
        param.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"WorkflowRoleDimensionPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
    }
}

