/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowRoleImportPlugin
extends BatchImportPlugin {
    private static final String ORG = "org";
    private static final String INCLUDADMINSUB = "includadminsub";
    private static final String PARAM = "param";
    private static final String ISADMINORG = "isAdminOrg";

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        if (WfUtils.isNotEmptyForCollection(billdatas)) {
            Set<String> allNeedUpdateOrgNumbers = this.allNeedUpdateOrgNumbers(billdatas);
            HashMap adminOrgMap = new HashMap(allNeedUpdateOrgNumbers.size());
            if (!allNeedUpdateOrgNumbers.isEmpty()) {
                List orgNumLists = Lists.partition(new ArrayList<String>(allNeedUpdateOrgNumbers), (int)500);
                orgNumLists.forEach(orgNumList -> {
                    try (DataSet ds = QueryServiceHelper.queryDataSet((String)"WorkflowRoleImportPlugin_getOrg", (String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("fisadministrative", "=", (Object)Boolean.TRUE).and(new QFilter("number", "in", orgNumList))}, (String)"id");){
                        while (ds.hasNext()) {
                            Row data = ds.next();
                            adminOrgMap.put(data.getString("number"), Boolean.TRUE);
                        }
                    }
                });
            }
            billdatas.forEach(importData -> {
                JSONArray roleentrys;
                JSONObject roleData = importData.getData();
                if (roleData != null && (roleentrys = roleData.getJSONArray("roleentry")) != null && !roleentrys.isEmpty()) {
                    String roleType = roleData.getString("roletype");
                    roleentrys.stream().filter(Objects::nonNull).forEach(roleentryObj -> {
                        JSONObject roleentry = (JSONObject)roleentryObj;
                        if (roleentry.get((Object)ORG) == null || WfUtils.isEmptyString((Object)roleentry.getJSONObject(ORG).getString("number"))) {
                            return;
                        }
                        if ("approvalposition".equals(roleType) && WfUtils.isEmpty((String)roleentry.getString("alternatetype"))) {
                            roleentry.put("alternatetype", (Object)"designatedPerson");
                        }
                        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
                        if (WfUtils.isEmptyString((Object)roleentry.get((Object)INCLUDADMINSUB))) {
                            boolean includadminsub = adminOrgMap.get(roleentry.getJSONObject(ORG).getString("number")) != null;
                            roleentry.put(INCLUDADMINSUB, (Object)String.valueOf(includadminsub));
                            params.put(ISADMINORG, includadminsub);
                        } else if (roleentry.getBoolean(INCLUDADMINSUB).booleanValue()) {
                            params.put(ISADMINORG, roleentry.getBoolean(INCLUDADMINSUB));
                        } else if (!roleentry.getBoolean(INCLUDADMINSUB).booleanValue()) {
                            params.put(ISADMINORG, adminOrgMap.get(roleentry.getJSONObject(ORG).getString("number")) != null);
                        }
                        roleentry.put(PARAM, (Object)SerializationUtils.toJsonString(params));
                    });
                }
            });
        }
    }

    private Set<String> allNeedUpdateOrgNumbers(List<ImportBillData> billdatas) {
        HashSet<String> orgIds = new HashSet<String>(billdatas.size());
        for (ImportBillData importData : billdatas) {
            JSONArray roleentrys;
            JSONObject roleData = importData.getData();
            if (roleData == null || (roleentrys = roleData.getJSONArray("roleentry")) == null || roleentrys.isEmpty()) continue;
            for (Object roleentryObj : roleentrys) {
                JSONObject roleentry;
                if (roleentryObj == null || (roleentry = (JSONObject)roleentryObj).get((Object)ORG) == null || !WfUtils.isNotEmptyString((Object)roleentry.getJSONObject(ORG).getString("number")) || !WfUtils.isEmptyString((Object)roleentry.get((Object)INCLUDADMINSUB)) && roleentry.getBoolean(INCLUDADMINSUB).booleanValue()) continue;
                orgIds.add(roleentry.getJSONObject(ORG).getString("number"));
            }
        }
        return orgIds;
    }
}

