/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bec.engine.utils.BatchStandardTipsTitleBuilder;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.Delete;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.Copy;
import kd.bos.form.operate.listop.ExportList;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowListPlugin;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.persistence.entity.basedata.BaseDataRefRecordEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;

public class WorkflowRoleListPlugin
extends AbstractWorkflowListPlugin {
    private static final String RESETAPPROVER = "resetapprover";
    private static final String QUERY = "query";
    private static final String ROLE = "role";
    private static final String PERSONNELVALIDITY = "personnelvalidity";
    private static final String BARITEMNEW = "baritemnew";
    private static final String BARITEMDELETE = "baritemdelete";
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private static final String BEUSED = "beused";
    private static final String APPROVALPOSITION = "approvalposition";
    private static final String ITEMNEWPOSITION = "itemnewposition";
    private static final String ROLETYPE = "roletype";
    private static final String WF_POSITIONROLE = "wf_positionrole";
    public static final String FUNCTION_TYPE = "functiontype";
    public static final String ORG = "org";
    public static final String FULLNAME = "fullname";
    private static final String BOS_ORG_STRUCTURE = "bos_org_structure";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{PERSONNELVALIDITY, QUERY, BEUSED, ITEMNEWPOSITION});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        WfAdminUtil.addWfOrgFilter((SetFilterEvent)e, (String)"wf_role");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        boolean isOpenFromNonRoleList = this.isOpenFromNonRoleList();
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            if (!isOpenFromNonRoleList) continue;
            listColumn.setHyperlink(false);
        }
    }

    private boolean isOpenFromNonRoleList() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean openFromNonRoleList = (Boolean)customParams.get("openFromNonRoleList");
        return openFromNonRoleList != null && openFromNonRoleList != false;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "resetapprover": {
                this.resetAuditor();
                break;
            }
            case "personnelvalidity": {
                this.personValidation();
                break;
            }
            case "query": {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_role", (String)"47150e89000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                BaseChangeLogsUtil.queryLog(this.getView(), ROLE);
                break;
            }
            case "beused": {
                this.queryBeUsed();
                break;
            }
            case "exportoldversion": {
                this.log.info("wf_role:view" + this.getView().getPageId());
                WfCacheHelper.putWorkflowRoleOldExport((String)String.valueOf(RequestContext.get().getCurrUserId()));
                break;
            }
        }
    }

    private void openPositionRole(Long pkId, OperationStatus operate) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(WF_POSITIONROLE);
        Optional.ofNullable(pkId).ifPresent(x -> parameter.setPkId((Object)pkId));
        parameter.getCustomParams().put(ROLETYPE, APPROVALPOSITION);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setStatus(operate == null ? OperationStatus.VIEW : operate);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void queryBeUsed() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() != 1) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(rows.size());
            return;
        }
        ListFilterParameter filterParameter = new ListFilterParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        QFilter vFilter = new QFilter("value", "in", rows.get(0).getPrimaryKeyValue());
        QFilter tFilter = new QFilter("type", "=", (Object)"workflowRole");
        qFilters.add(vFilter);
        qFilters.add(tFilter);
        filterParameter.setQFilters(qFilters);
        ListShowParameter parameter = new ListShowParameter();
        parameter.setListFilterParameter(filterParameter);
        parameter.setBillFormId("wf_basedatarefrecord");
        parameter.setCaption(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272\u5f15\u7528\u8bb0\u5f55", (String)"WorkflowRoleListPlugin_19", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void personValidation() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_role", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() < 1) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        JSONArray errorMessages = new JSONArray();
        HashMap<Long, String> failedResult = new HashMap<Long, String>();
        for (int i = 0; i < rows.size(); ++i) {
            Long pkValues = (Long)rows.get(i).getPrimaryKeyValue();
            QFilter f1 = new QFilter("id", "in", (Object)pkValues);
            QFilter[] filters = new QFilter[]{f1};
            List rolesjournalizing = this.getRepositoryService().findEntitiesByFilters("wf_role", filters);
            if (WfUtils.isEmptyForCollection((Collection)rolesjournalizing)) {
                JSONObject errorMessage = new JSONObject();
                errorMessage.put("number", (Object)rows.get(i).getNumber());
                errorMessage.put("name", (Object)rows.get(i).getName());
                errorMessage.put("information", (Object)ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"WorkflowRoleListPlugin_26", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                errorMessages.add((Object)errorMessage);
                String failTips = ResManager.loadKDString((String)"\u7f16\u7801\uff1a{0} \u540d\u79f0\uff1a{1}", (String)"WorkflowRoleListPlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[]{rows.get(i).getNumber(), rows.get(i).getName()});
                failedResult.put(pkValues, failTips);
                continue;
            }
            String roleType = ((RoleEntity)rolesjournalizing.get(0)).getRoleType();
            DynamicObjectCollection roles = ((RoleEntity)rolesjournalizing.get(0)).getRoleEntry();
            for (int j = 0; j < roles.size(); ++j) {
                String failTips;
                DynamicObject roleentry = (DynamicObject)roles.get(j);
                DynamicObject orgEntirety = (DynamicObject)roleentry.get(ORG);
                DynamicObject userEntirety = (DynamicObject)roleentry.get("user");
                DynamicObject positionEntirety = (DynamicObject)roleentry.get(APPROVALPOSITION);
                if (orgEntirety == null || userEntirety == null && positionEntirety == null) {
                    JSONObject errorMessage = new JSONObject();
                    errorMessage.put("number", (Object)rows.get(i).getNumber());
                    errorMessage.put("name", (Object)rows.get(i).getName());
                    StringBuilder info = new StringBuilder();
                    info.append(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u6570\u636e\u7f3a\u5931\u3002", (String)"WorkflowRoleListPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), j + 1));
                    if (orgEntirety == null) {
                        info.append(ResManager.loadKDString((String)"(\u5ba1\u6279\u7ec4\u7ec7\u7684\u503c\u4e3a\u7a7a)", (String)"WorkflowRoleListPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    }
                    if (userEntirety == null && "user".equals(roleType)) {
                        info.append(ResManager.loadKDString((String)"(\u5ba1\u6279\u4eba\u5458\u7684\u503c\u4e3a\u7a7a)", (String)"WorkflowRoleListPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    }
                    if (positionEntirety == null && APPROVALPOSITION.equals(roleType)) {
                        info.append(ResManager.loadKDString((String)"(\u5ba1\u6279\u5c97\u4f4d\u7684\u503c\u4e3a\u7a7a)", (String)"WorkflowRoleListPlugin_22", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    }
                    errorMessage.put("information", (Object)info.toString());
                    errorMessages.add((Object)errorMessage);
                    failTips = ResManager.loadKDString((String)"\u7f16\u7801\uff1a{0} \u540d\u79f0\uff1a{1}", (String)"WorkflowRoleListPlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[]{rows.get(i).getNumber(), rows.get(i).getName()});
                    failedResult.put(pkValues, failTips);
                    continue;
                }
                String result = this.checkUserOrPosition(orgEntirety, userEntirety, positionEntirety, roleType);
                if (!StringUtils.isNotBlank((CharSequence)result)) continue;
                JSONObject errorMessage = new JSONObject();
                errorMessage.put("number", (Object)rows.get(i).getNumber());
                errorMessage.put("name", (Object)rows.get(i).getName());
                errorMessage.put("information", (Object)result);
                errorMessages.add((Object)errorMessage);
                failTips = ResManager.loadKDString((String)"\u7f16\u7801\uff1a{0} \u540d\u79f0\uff1a{1}", (String)"WorkflowRoleListPlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[]{rows.get(i).getNumber(), rows.get(i).getName()});
                failedResult.put(pkValues, failTips);
            }
        }
        if (errorMessages.size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6240\u9009\u5de5\u4f5c\u6d41\u89d2\u8272\u4e2d\u7684\u4eba\u5458\u5747\u6709\u6548\u3002", (String)"WorkflowRoleListPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            String handleName = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272\u6821\u9a8c", (String)"WorkflowRoleListPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            ArrayList failList = new ArrayList(failedResult.values());
            String body = StandardTips.batchOptionMsgContent(failList);
            String title = new BatchStandardTipsTitleBuilder().setFailCount(failList.size()).setSuccessCount(rows.size() - failList.size()).setHandleName(handleName).setTotal(rows.size()).build();
            StandardTips.view((IFormView)this.getView()).batchOptionMsg(title, body, this.buildDetailedInformationParam(errorMessages));
        }
    }

    private FormShowParameter buildDetailedInformationParam(JSONArray errorMessages) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("errorMessages", (Object)errorMessages.toJSONString());
        parameter.setFormId("wf_roleverificationinform");
        return parameter;
    }

    private String checkUserOrPosition(DynamicObject orgEntirety, DynamicObject userEntirety, DynamicObject positionEntirety, String roleType) {
        Object orgName = Optional.ofNullable(orgEntirety.get("name")).orElseGet(() -> "");
        if (APPROVALPOSITION.equals(roleType)) {
            if (positionEntirety == null) {
                return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0\u4e3a\u201c%1s\u201d\u7684\u5c97\u4f4d\u201c%2s\u201d\u65e0\u6548", (String)"WorkflowRoleListPlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]), orgName, "");
            }
            Object positionName = positionEntirety.get("name");
            if (!positionEntirety.getBoolean("enable")) {
                return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0\u4e3a\u201c%1s\u201d\u7684\u5c97\u4f4d\u201c%2s\u201d\u65e0\u6548", (String)"WorkflowRoleListPlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]), orgName, positionName);
            }
            HashSet<Long> positionIds = new HashSet<Long>(1);
            positionIds.add(positionEntirety.getLong("id"));
            Map peopleUnderPosition = UserServiceHelper.getPeopleUnderPosition(positionIds);
            boolean hasEnableUser = false;
            block0: for (Set userSet : peopleUnderPosition.values()) {
                for (DynamicObject user : userSet) {
                    if (!user.getBoolean("enable")) continue;
                    hasEnableUser = true;
                    break block0;
                }
            }
            if (!hasEnableUser) {
                return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0\u4e3a\u201c%1s\u201d\u5c97\u4f4d\u540d\u79f0\u4e3a\u201c%2s\u201d\u7684\u4eba\u5458\u65e0\u6548", (String)"WorkflowRoleListPlugin_24", (String)"bos-wf-formplugin", (Object[])new Object[0]), orgName, positionName);
            }
        } else {
            if (userEntirety == null) {
                return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0\u4e3a\u201c%1s\u201d\u59d3\u540d\u4e3a\u201c%2s\u201d\u7684\u4eba\u5458\u65e0\u6548", (String)"WorkflowRoleListPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), orgName, "");
            }
            Object userName = userEntirety.get("name");
            if (!userEntirety.getBoolean("enable")) {
                return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0\u4e3a\u201c%1s\u201d\u59d3\u540d\u4e3a\u201c%2s\u201d\u7684\u4eba\u5458\u65e0\u6548", (String)"WorkflowRoleListPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), orgName, userName);
            }
        }
        return null;
    }

    private void resetAuditor() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_role", (String)"/AGOO46A0IE8")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5de5\u4f5c\u6d41\u89d2\u8272\u201d\u7684\u201c\u91cd\u65b0\u8bbe\u7f6e\u5ba1\u6279\u4eba\u201d\u6743\u9650\u3002", (String)"WorkflowRoleListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_resetapprover");
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (CollectionUtil.isNotEmpty((Collection)rows)) {
            List rowIds = rows.stream().map(r -> r.getPrimaryKeyValue()).map(r -> Long.valueOf(r.toString())).collect(Collectors.toList());
            parameter.setCustomParam("rowIds", rowIds);
            parameter.setCustomParam("isSelectedRows", (Object)true);
        } else {
            parameter.setCustomParam("isSelectedRows", (Object)false);
        }
        parameter.setCustomParam("entrance", (Object)"wf_role");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RESETAPPROVER));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (RESETAPPROVER.equals(e.getActionId()) && returnData instanceof String) {
            String result = (String)returnData;
            if (!WfUtils.isEmpty((String)result) && result.equals("OK")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u8bbe\u7f6e\u5ba1\u6279\u4eba\u6210\u529f\u3002", (String)"WorkflowRoleListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                IListView listView = (IListView)this.getView();
                listView.refresh();
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u8bbe\u7f6e\u5ba1\u6279\u4eba\u5931\u8d25\u3002", (String)"WorkflowRoleListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof Delete && args.getOperationResult().isSuccess()) {
            BaseChangeLogsUtil.addChangeLog(this.getView(), args.getSource(), ROLE);
        } else if (args.getSource() instanceof ExportList) {
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            for (ListSelectedRow selectedRow : selectedRows) {
                Long pkid = (Long)selectedRow.getPrimaryKeyValue();
                ILocaleString detail = WfUtils.getPromptWordLocaleString((String)"\u628a\u5de5\u4f5c\u6d41\u89d2\u8272\uff1a%1s(%2s)\u5bfc\u51fa", (String)"WorkflowRoleListPlugin_20", (String)"bos-wf-formplugin");
                for (Lang lang : WfUtils.getSupportLangs()) {
                    detail.setItem(lang.toString(), (Object)String.format((String)detail.getItem(lang.toString()), selectedRow.getName(), selectedRow.getNumber()));
                }
                String modifier = RequestContext.get().getUserId();
                ILocaleString title = WfUtils.getPromptWordLocaleString((String)"\u5bfc\u51fa\u5de5\u4f5c\u6d41\u89d2\u8272", (String)"WorkflowRoleListPlugin_21", (String)"bos-wf-formplugin");
                BaseChangeLogsUtil.addLog(pkid, ROLE, "exportlist", title, detail, modifier);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long roleId;
        DynamicObject dynObj;
        ListSelectedRowCollection rows;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete) {
            BaseChangeLogsUtil.putBaseArrayCache(this.getView(), "wf_role");
            ListSelectedRowCollection rows2 = ((IListView)this.getView()).getSelectedRows();
            if (WfUtils.isNotEmptyForCollection((Collection)rows2)) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (ListSelectedRow row : rows2) {
                    ids.add((Long)row.getPrimaryKeyValue());
                }
                if (WfConfigurationUtil.isFilterDataByOrg() && this.checkDeleteData(ids)) {
                    args.setCancel(true);
                    return;
                }
            }
            StringBuilder refTip = new StringBuilder();
            for (int i = 0; i < rows2.size(); ++i) {
                Long roleId2 = (Long)rows2.get(i).getPrimaryKeyValue();
                List entities = this.getManagementService().getBaseDataRefEntities("workflowRole", roleId2);
                if (!WfUtils.isNotEmptyForCollection((Collection)entities)) continue;
                args.setCancel(true);
                RoleEntity roleEntity = (RoleEntity)this.getRepositoryService().findEntityById(roleId2, "wf_role", "name");
                if (roleEntity == null) continue;
                String roleName = roleEntity.getName();
                StringBuilder tip = new StringBuilder();
                tip.append(roleName).append(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u6570\u636e\u5df2\u88ab\u5f15\u7528\u3002", (String)"WorkflowRoleListPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5b58\u5728\u8be5\u5f15\u7528\u7684\u6d41\u7a0b\uff1a", (String)"WorkflowRoleListPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                HashSet<String> procNums = new HashSet<String>(16);
                for (BaseDataRefRecordEntity entity : entities) {
                    String procNum = entity.getProcnum();
                    if (!procNums.contains(procNum)) {
                        tip.append(entity.getProcnum()).append("\uff1b");
                    }
                    procNums.add(procNum);
                }
                refTip.append((CharSequence)tip).append("\n");
            }
            if (refTip.length() > 0) {
                this.getView().showTipNotification(refTip.toString(), Integer.valueOf(8000));
            }
        } else if (args.getSource() instanceof Copy && WfUtils.isNotEmptyForCollection((Collection)(rows = ((IListView)this.getView()).getSelectedRows())) && rows.size() == 1 && APPROVALPOSITION.equals((dynObj = BusinessDataServiceHelper.loadSingle((Object)(roleId = (Long)rows.get(0).getPrimaryKeyValue()), (String)"wf_role", (String)ROLETYPE)).getString(ROLETYPE))) {
            ((Copy)args.getSource()).setViewBillFormId(WF_POSITIONROLE);
        }
    }

    public void afterCreateNewData(EventObject e) {
        PluginUtil.setControlInvisible(this.getView(), "roleexit");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (WfAdminUtil.controlBtnByAdmin((Long)userId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BARITEMNEW, BARITEMDELETE, RESETAPPROVER, IMPORT, EXPORT});
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_role", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5de5\u4f5c\u6d41\u89d2\u8272\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"WorkflowRoleListPlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String fieldName = args.getFieldName();
        if ("number".equalsIgnoreCase(fieldName)) {
            String parentFormId;
            BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            Long pk = (Long)event.getCurrentRow().getPrimaryKeyValue();
            DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"wf_role", (String)ROLETYPE);
            String string = parentFormId = this.getView().getFormShowParameter() != null ? this.getView().getFormShowParameter().getParentFormId() : null;
            if (APPROVALPOSITION.equals(dynObj.getString(ROLETYPE)) && !StringUtils.equals((CharSequence)parentFormId, (CharSequence)"wf_conditionrule_update")) {
                this.openPositionRole(pk, OperationStatus.EDIT);
                args.setCancel(true);
            }
            return;
        }
        super.billListHyperLinkClick(args);
    }

    private boolean checkDeleteData(List<Long> ids) {
        boolean ret = false;
        List roleList = this.getRepositoryService().findEntitiesByFilters("wf_role", new QFilter[]{new QFilter("id", "in", ids)});
        StringBuilder numbers = new StringBuilder();
        if (WfUtils.isNotEmptyForCollection((Collection)roleList)) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            for (RoleEntity role : roleList) {
                Long orgUnitId = role.getOrgUnit();
                if (WfAdminUtil.canDoOperation((Long)userId, (Long)orgUnitId)) continue;
                numbers.append(",").append(role.getNumber());
                ret = true;
            }
        }
        if (ret) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7f16\u7801\u201c%s\u201d\u7684\u201c\u6240\u5c5e\u7ec4\u7ec7\u201d\u7684\u7ba1\u8f96\u6743\u9650\u3002", (String)"WorkflowRoleListPlugin_17", (String)"bos-wf-formplugin", (Object[])new Object[0]), numbers.substring(1)));
        }
        return ret;
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] values;
        boolean isExportOldData = WfUtils.isNotEmpty((String)WfCacheHelper.getWorkflowRoleOldExport((String)String.valueOf(RequestContext.get().getCurrUserId())));
        this.log.info(String.format("wf_role:view\uff1a%s; key value is ", this.getView().getPageId(), this.getPageCache().get("currentOperationKey")));
        for (DynamicObject value : values = e.getQueryValues()) {
            Map<String, String> fullNameMap;
            DynamicObjectCollection collection;
            String roledimension;
            if (isExportOldData && WfUtils.isNotEmpty((String)(roledimension = value.getString("roledimension"))) && roledimension.contains("dimensions")) {
                Map dimensionInfos = (Map)SerializationUtils.fromJsonString((String)roledimension, Map.class);
                value.set("roledimension", dimensionInfos.get("dimensions"));
            }
            if ((collection = value.getDynamicObjectCollection("roleentry")).isEmpty()) continue;
            if (!(((DynamicObject)collection.get(0)).containsProperty(ORG) && ((DynamicObject)collection.get(0)).containsProperty(FULLNAME) && ((DynamicObject)collection.get(0)).containsProperty(FUNCTION_TYPE))) {
                return;
            }
            ArrayList<Long> functionTypeList = new ArrayList<Long>();
            ArrayList<Long> orgIdList = new ArrayList<Long>();
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject org;
                DynamicObject row = (DynamicObject)collection.get(i);
                Long functionType = 1L;
                if (WfUtils.isNotEmpty((Long)row.getLong(FUNCTION_TYPE))) {
                    functionType = row.getLong(FUNCTION_TYPE);
                }
                if ((org = (DynamicObject)row.get(ORG)) == null) {
                    orgIdList.add(null);
                    functionTypeList.add(1L);
                    continue;
                }
                functionType = this.getFunctionType(row, functionType, i);
                Long orgId = (Long)org.getPkValue();
                orgIdList.add(orgId);
                functionTypeList.add(functionType);
            }
            if (functionTypeList.isEmpty() || orgIdList.isEmpty() || (fullNameMap = this.batchGetFullName(functionTypeList, orgIdList)) == null) continue;
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject row = (DynamicObject)collection.get(i);
                if (orgIdList.get(i) == null) {
                    row.set(FULLNAME, (Object)"");
                    continue;
                }
                String fullName = fullNameMap.get(functionTypeList.get(i) + "_" + orgIdList.get(i));
                row.set(FULLNAME, (Object)fullName);
            }
        }
        if (isExportOldData) {
            WfCacheHelper.removeWorkflowRoleOldExport((String)String.valueOf(RequestContext.get().getCurrUserId()));
        }
    }

    private Long getFunctionType(DynamicObject row, Long functionType, int index) {
        if (functionType == 0L) {
            functionType = 1L;
        }
        return functionType;
    }

    private Map<String, String> batchGetFullName(List<Long> functionTypeList, List<Long> orgIdList) {
        QFilter filter1 = new QFilter("view", "in", functionTypeList.stream().distinct().collect(Collectors.toList()));
        QFilter filter2 = new QFilter(ORG, "in", orgIdList.stream().distinct().collect(Collectors.toList()));
        HashMap<String, String> fullnameMap = null;
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)"fullname,view,org", (QFilter[])new QFilter[]{filter1, filter2});
        if (collection != null && !collection.isEmpty()) {
            fullnameMap = new HashMap<String, String>(collection.size());
            DynamicObject orgStructure = null;
            for (int i = 0; i < collection.size(); ++i) {
                orgStructure = (DynamicObject)collection.get(i);
                fullnameMap.put(orgStructure.getLong("view") + "_" + orgStructure.getLong(ORG), orgStructure.getString(FULLNAME));
            }
        }
        return fullnameMap;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (ITEMNEWPOSITION.equalsIgnoreCase(itemKey)) {
            this.openPositionRole(null, OperationStatus.ADDNEW);
            evt.setCancel(true);
        }
        super.beforeItemClick(evt);
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc source = (ColumnDesc)e.getSource();
        if (ROLETYPE.equals(source.getKey()) && StringUtils.isBlank((Object)e.getFormatValue())) {
            e.setFormatValue((Object)"user");
        }
        super.packageData(e);
    }
}

