/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.LongProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.plugin.CustomBasedataFilterEvent;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.design.util.IBaseChangeLogCallBack;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfRoleDimensionUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.RoleDimension;
import kd.bos.workflow.engine.impl.cmd.task.BasedataFormListType;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;
import kd.bos.workflow.management.plugin.WfCustomReportRelationUtil;
import kd.bos.workflow.monitor.plugin.WorkflowUserUtil;

public class WorkflowRolePlugin
extends AbstractWorkflowPlugin
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    public static final String FORM_ID = "wf_role";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String ORGUNIT = "orgunit";
    public static final String MANAGER = "manager";
    public static final String ENTITYTYPE = "entitytype";
    public static final String ENTITYVALUE = "entityvalue";
    public static final String ROLETYPE = "roletype";
    public static final String FORM_ORG = "bos_org";
    public static final String FULLNAME = "fullname";
    public static final String FUNCTION_TYPE = "functiontype";
    public static final String ITEM_ADD = "item_add";
    public static final String ITEM_DELETE = "item_delete";
    public static final String GRID_ROLEENTRY = "roleentry";
    public static final String ORG = "org";
    public static final String USER = "user";
    public static final String ALTERNATETYPE = "alternatetype";
    public static final String ALTERNATETYPE_ITEM_SUPERIOR = "superior";
    public static final String ALTERNATETYPE_ITEM_DESIGNATEDPERSON = "designatedPerson";
    public static final String ALTERNATEUSER = "alternateuser";
    public static final String USERPOSITION = "userposition";
    private static final String APPROVALPOSITION = "approvalposition";
    private static final String ROLE = "role";
    private static final String BOS_ORG_STRUCTURE = "bos_org_structure";
    private static final String ORGF7SELVIEWTREETYPE = "orgF7SelViewTreeType";
    private static final String ROLEDIMENSION = "roledimension";
    private static final String SETTING = "setting";
    private static final String DIMENSION = "dimension";
    private static final String DIMENSION1 = "dimension1";
    private static final String DIMENSION2 = "dimension2";
    private static final String DIMENSION3 = "dimension3";
    private static final String DIMENSION4 = "dimension4";
    private static final String NUMBERDIMENSION = "numberdimension";
    private static final String SHOWVALUEDIMENSION = "showvaluedimension";
    private static final String MULILANGDIMENSION = "mulilangdimension";
    private static final String SHOWVALUEDIMENSION1 = "showvaluedimension1";
    private static final String SHOWVALUEDIMENSION2 = "showvaluedimension2";
    private static final String SHOWVALUEDIMENSION3 = "showvaluedimension3";
    private static final String SHOWVALUEDIMENSION4 = "showvaluedimension4";
    private static final String ISFIRSTOPEN = "isfirstopen";
    private static final String ISCOPY = "iscopy";
    private static final String WFDIMENSIONSLIST = "dimensions";
    private static final String INCLUDADMINSUB = "includadminsub";
    private static final String PARAM = "param";
    private static final String ISADMINORG = "isAdminOrg";
    private static final Map<String, String> orgFullNames = new HashMap<String, String>();

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"advcontoolbarap", "toolbarap"});
        this.addManagerEnableParam();
        this.addOrgUnitParam(ORGUNIT);
        this.addApprovalUserIdParam();
        this.addOrgUnitParam(ORG);
        WorkflowUserUtil.showUsersAddCustomParam(this.getView(), new String[]{MANAGER, USER, ALTERNATEUSER});
        if (WfUtils.isEmpty((String)this.getPageCache().get(ISFIRSTOPEN))) {
            RoleEntity obj;
            BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
            Object pkId = parameter.getPkId();
            if (WfUtils.isNullObject((Object)pkId)) {
                this.getPageCache().put(ISFIRSTOPEN, Boolean.FALSE.toString());
                this.getView().setVisible(Boolean.FALSE, new String[]{SHOWVALUEDIMENSION1, SHOWVALUEDIMENSION2, SHOWVALUEDIMENSION3, SHOWVALUEDIMENSION4});
                return;
            }
            if (BillOperationStatus.ADDNEW.equals((Object)parameter.getBillStatus())) {
                this.getPageCache().put(ISCOPY, Boolean.TRUE.toString());
            }
            if (!WfUtils.isNullObject((Object)(obj = (RoleEntity)this.getRepositoryService().findEntityById(Long.valueOf(String.valueOf(pkId)), FORM_ID, ROLEDIMENSION)))) {
                String roleDimension = obj.getRoleDimension();
                if (WfUtils.isNotEmptyString((Object)roleDimension)) {
                    Map dimensionInfos = WfRoleDimensionUtil.getDimensionInfos((String)roleDimension);
                    Boolean isOrgFieldEnable = (Boolean)Optional.ofNullable(dimensionInfos.get("isOrgFieldEnable")).orElseGet(() -> Boolean.TRUE);
                    this.getView().setVisible(isOrgFieldEnable, new String[]{ORG, FULLNAME, INCLUDADMINSUB});
                    List rd = (List)dimensionInfos.get(WFDIMENSIONSLIST);
                    this.initDimension(rd);
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{SHOWVALUEDIMENSION1, SHOWVALUEDIMENSION2, SHOWVALUEDIMENSION3, SHOWVALUEDIMENSION4});
                }
            }
            this.getPageCache().put(ISFIRSTOPEN, Boolean.FALSE.toString());
        }
        EntryGrid entry = (EntryGrid)this.getView().getControl(GRID_ROLEENTRY);
        entry.addDataBindListener((EntryGridBindDataListener)this);
    }

    private void addManagerEnableParam() {
        BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (OperationStatus.EDIT.equals((Object)parameter.getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{MANAGER});
        }
    }

    private void addOrgUnitParam(final String key) {
        BasedataEdit bizUnitF7 = (BasedataEdit)this.getControl(key);
        bizUnitF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCustomParam("showAdminOrgViewType", (Object)Boolean.TRUE);
            if (ORG.equals(key)) {
                Long customRootOrgId;
                CustomBasedataFilterEvent cbevent = this.getCustomBasedataFilter(FORM_ORG);
                QFilter customFilter = cbevent.getCustomBasedataFilter();
                if (customFilter != null) {
                    listShowParameter.getListFilterParameter().getQFilters().add(customFilter);
                }
                if (WfUtils.isNotEmpty((Long)(customRootOrgId = cbevent.getCustomRootOrgId()))) {
                    listShowParameter.setCustomParam("initRootOrgId", (Object)customRootOrgId);
                }
                int focusRow = this.getEntryEntityFocusRow(GRID_ROLEENTRY);
                DynamicObject userDynamicObject = (DynamicObject)this.getModel().getValue(ORG, focusRow);
                if (userDynamicObject == null) {
                    return;
                }
                Long orgId = userDynamicObject.getLong("id");
                listShowParameter.setSelectedRow((Object)orgId);
            }
        });
        bizUnitF7.addAfterF7SelectListener(new AfterF7SelectListener(){

            public void afterF7Select(AfterF7SelectEvent arg0) {
                int index = WorkflowRolePlugin.this.getEntryEntityFocusRow(WorkflowRolePlugin.GRID_ROLEENTRY);
                if (index == -1) {
                    return;
                }
                String type = WorkflowRolePlugin.this.getPageCache().get(WorkflowRolePlugin.ORGF7SELVIEWTREETYPE);
                if (WorkflowRolePlugin.ORG.equals(key)) {
                    ListSelectedRowCollection listSelectedRowCollection = arg0.getListSelectedRowCollection();
                    WorkflowRolePlugin.this.initOrgFullNameToPageCache(type, listSelectedRowCollection);
                    int size = index + listSelectedRowCollection.size();
                    if (type == null) {
                        WorkflowRolePlugin.this.logger.debug("type cannot be null, if we meeting ,then analysis it");
                    }
                    for (int j = index; j < size; ++j) {
                        if (type != null) {
                            WorkflowRolePlugin.this.getModel().setValue(WorkflowRolePlugin.FUNCTION_TYPE, (Object)type, j);
                            WorkflowRolePlugin.this.updateFfullNameByOne(j);
                            continue;
                        }
                        WorkflowRolePlugin.this.updateInfoToEntry(j);
                    }
                    FieldEdit fieldEdit = (FieldEdit)WorkflowRolePlugin.this.getControl(WorkflowRolePlugin.ALTERNATEUSER);
                    DynamicObjectCollection roleEntitys = WorkflowRolePlugin.this.getModel().getEntryEntity(WorkflowRolePlugin.GRID_ROLEENTRY);
                    if (roleEntitys != null && !roleEntitys.isEmpty()) {
                        for (int i = 0; i < roleEntitys.size(); ++i) {
                            String alternateType = ((DynamicObject)roleEntitys.get(i)).getString(WorkflowRolePlugin.ALTERNATETYPE);
                            if (!WorkflowRolePlugin.ALTERNATETYPE_ITEM_SUPERIOR.equals(alternateType)) continue;
                            fieldEdit.setEnable(WorkflowRolePlugin.ALTERNATEUSER, false, i);
                        }
                    }
                }
                WorkflowRolePlugin.this.getPageCache().remove(WorkflowRolePlugin.ORGF7SELVIEWTREETYPE);
            }
        });
    }

    private CustomBasedataFilterEvent getCustomBasedataFilter(String number) {
        CustomBasedataFilterEvent args = new CustomBasedataFilterEvent(this.getView(), null, null, number);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireCustomEvent((CustomEventArgs)args);
        return args;
    }

    private void addApprovalUserIdParam() {
        BasedataEdit bosUserF7 = (BasedataEdit)this.getControl(USER);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Long customRootOrgId;
            CustomBasedataFilterEvent cbevent;
            QFilter customFilter;
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            int focusRow = this.getEntryEntityFocusRow(GRID_ROLEENTRY);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(USER, focusRow);
            if (dynamicObject != null) {
                listShowParameter.setSelectedRow(dynamicObject.getPkValue());
            }
            if ((customFilter = (cbevent = this.getCustomBasedataFilter("bos_user")).getCustomBasedataFilter()) != null) {
                listShowParameter.getListFilterParameter().getQFilters().add(customFilter);
            }
            if (WfUtils.isNotEmpty((Long)(customRootOrgId = cbevent.getCustomRootOrgId()))) {
                listShowParameter.setCustomParam("initRootOrgId", (Object)customRootOrgId);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        model.setValue(MANAGER, (Object)RequestContext.get().getUserId());
        if (!WfConfigurationUtil.isRepairWorkflowRoleIncludeAdminSubComplete()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{INCLUDADMINSUB});
        }
        model.setDataChanged(Boolean.FALSE.booleanValue());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "item_add": {
                Long customRootOrgId;
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true, (int)0);
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                listFilterParameter.setFilter(qFilter);
                parameter.setListFilterParameter(listFilterParameter);
                parameter.setCustomParam("externalUserType", (Object)"all");
                CustomBasedataFilterEvent cbevent = this.getCustomBasedataFilter("bos_user");
                QFilter customFilter = cbevent.getCustomBasedataFilter();
                if (customFilter != null) {
                    parameter.getListFilterParameter().getQFilters().add(customFilter);
                }
                if (WfUtils.isNotEmpty((Long)(customRootOrgId = cbevent.getCustomRootOrgId()))) {
                    parameter.setCustomParam("initRootOrgId", (Object)customRootOrgId);
                }
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORM_ID));
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "item_delete": {
                EntryGrid grid = (EntryGrid)this.getControl(GRID_ROLEENTRY);
                int[] selectRows = grid.getEntryState().getSelectedRows();
                StandardTips view = StandardTips.view((IFormView)this.getView());
                if (selectRows.length > 0) {
                    this.getModel().deleteEntryRows(GRID_ROLEENTRY, selectRows);
                    break;
                }
                view.notSelectRow();
                break;
            }
            case "setting": {
                this.openDimension();
                break;
            }
        }
    }

    private void openDimension() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_roledimension");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(WFDIMENSIONSLIST, this.getModel().getValue(ROLEDIMENSION));
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        parameter.setCustomParam("roleid", baseShowParameter.getPkId());
        parameter.setCustomParam(ISCOPY, (Object)this.getPageCache().get(ISCOPY));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimensionCallback"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (FORM_ID.equalsIgnoreCase(evt.getActionId())) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)evt.getReturnData();
            if (lsrc == null || lsrc.isEmpty()) {
                return;
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_user");
            DynamicObject[] dos = null;
            ArrayList<Long> selectedIds = new ArrayList<Long>();
            for (ListSelectedRow row : lsrc) {
                selectedIds.add((Long)row.getPrimaryKeyValue());
            }
            Map map = BusinessDataServiceHelper.loadFromCache((Object[])selectedIds.toArray(), (DynamicObjectType)type);
            if (map == null || map.size() == 0) {
                return;
            }
            if (map.size() != selectedIds.size()) {
                DynamicObject[] newDos = new DynamicObject[selectedIds.size()];
                for (int i = 0; i < selectedIds.size(); ++i) {
                    newDos[i] = (DynamicObject)map.get(selectedIds.get(i));
                }
                dos = newDos;
            } else {
                dos = map.values().toArray(new DynamicObject[0]);
            }
            IDataModel model = this.getModel();
            int oldRowCount = model.getEntryRowCount(GRID_ROLEENTRY);
            model.batchCreateNewEntryRow(GRID_ROLEENTRY, dos.length);
            EntryGrid grid = (EntryGrid)this.getControl(GRID_ROLEENTRY);
            ArrayList<Long> pkValueList = new ArrayList<Long>(dos.length);
            for (int i = 0; i < dos.length; ++i) {
                DynamicObject structure;
                grid.getEntryState().setFocusRow(oldRowCount + i);
                model.setValue(USER, dos[i].get("id"), oldRowCount + i);
                DynamicObjectCollection doc = (DynamicObjectCollection)dos[i].get("entryentity");
                Long orgId = null;
                Long pkValue = null;
                String fullname = null;
                for (DynamicObject d : doc) {
                    Object osFullname;
                    if (d.getBoolean("ispartjob")) continue;
                    orgId = (Long)d.get("dpt.id");
                    DynamicObject os = (DynamicObject)d.get("orgstructure");
                    if (os != null) {
                        pkValue = (Long)os.getPkValue();
                    }
                    if ((osFullname = d.get("orgstructure.fullname")) == null) continue;
                    fullname = osFullname.toString();
                }
                if (pkValue == null && WfUtils.isNotEmpty(orgId) && (structure = QueryServiceHelper.queryOne((String)"bos_adminorg_structure", (String)"id,fullname", (QFilter[])new QFilter[]{new QFilter(ORG, "=", (Object)orgId)})) != null) {
                    pkValue = structure.getLong("id");
                    fullname = structure.getString(FULLNAME);
                }
                pkValueList.add(pkValue);
                model.setValue(ORG, (Object)orgId, oldRowCount + i);
                model.setValue(FULLNAME, fullname, oldRowCount + i);
                if (!WfConfigurationUtil.wfRoleAlternateTypeNullValue()) {
                    model.setValue(ALTERNATETYPE, (Object)ALTERNATETYPE_ITEM_SUPERIOR, oldRowCount + i);
                } else {
                    model.setValue(ALTERNATETYPE, null, oldRowCount + i);
                }
                FieldEdit fieldEdit = (FieldEdit)this.getControl(ALTERNATEUSER);
                fieldEdit.setEnable(ALTERNATEUSER, false, oldRowCount + i);
            }
            HashMap<Long, Long> pkValueToViewIdMap = new HashMap<Long, Long>();
            DynamicObject[] orgs = BusinessDataServiceHelper.load((Object[])pkValueList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)BOS_ORG_STRUCTURE));
            if (orgs != null && orgs.length > 0) {
                int i;
                for (i = 0; i < orgs.length; ++i) {
                    Long functionType = Long.valueOf(orgs[i].get("view.id").toString());
                    pkValueToViewIdMap.put((Long)orgs[i].get("id"), functionType);
                }
                i = 0;
                for (Long pKValue : pkValueList) {
                    Long functionType = (Long)pkValueToViewIdMap.get(pKValue);
                    model.setValue(FUNCTION_TYPE, (Object)functionType, oldRowCount + i++);
                }
            }
            grid.clearEntryState();
        } else if ("dimensionCallback".equalsIgnoreCase(evt.getActionId())) {
            Object data = evt.getReturnData();
            if (WfUtils.isNotEmptyString((Object)data)) {
                Map dimensionInfos = WfRoleDimensionUtil.getDimensionInfos((String)((String)data));
                Boolean isOrgFieldEnable = (Boolean)Optional.ofNullable(dimensionInfos.get("isOrgFieldEnable")).orElseGet(() -> Boolean.TRUE);
                this.getView().setVisible(isOrgFieldEnable, new String[]{ORG, FULLNAME, INCLUDADMINSUB});
                this.getView().setVisible(Boolean.valueOf(isOrgFieldEnable != false && WfConfigurationUtil.isRepairWorkflowRoleIncludeAdminSubComplete()), new String[]{INCLUDADMINSUB});
                List rdList = (List)dimensionInfos.get(WFDIMENSIONSLIST);
                if (!WfUtils.isNullObject((Object)rdList)) {
                    this.dimensionSettingCloseCallBack(rdList);
                }
                this.getModel().setValue(ROLEDIMENSION, data);
            }
        } else if ("dimensionclosecallback1".equalsIgnoreCase(evt.getActionId()) || "dimensionclosecallback2".equalsIgnoreCase(evt.getActionId()) || "dimensionclosecallback3".equalsIgnoreCase(evt.getActionId()) || "dimensionclosecallback4".equalsIgnoreCase(evt.getActionId())) {
            char dimensionIndex = evt.getActionId().charAt(evt.getActionId().length() - 1);
            String dimensionId = DIMENSION + dimensionIndex;
            String numberDimension = NUMBERDIMENSION + dimensionIndex;
            String showvaluedimension = SHOWVALUEDIMENSION + dimensionIndex;
            String mulilangdimension = MULILANGDIMENSION + dimensionIndex;
            this.dimensionValueCloseCallback(evt, dimensionId, numberDimension, showvaluedimension, mulilangdimension);
        }
    }

    private void dimensionValueCloseCallback(ClosedCallBackEvent evt, String dimension, String numberDimension, String showvaluedimension, String mulilangdimension) {
        if (WfUtils.isNotEmptyString((Object)evt.getReturnData())) {
            int index = this.getEntryEntityFocusRow(GRID_ROLEENTRY);
            ListSelectedRowCollection collection = (ListSelectedRowCollection)evt.getReturnData();
            if (!collection.isEmpty()) {
                Object mulilangDimensionValue;
                ListSelectedRow row = collection.get(0);
                this.getModel().setValue(dimension, row.getPrimaryKeyValue(), index);
                this.getModel().setValue(numberDimension, (Object)row.getNumber(), index);
                this.getModel().setValue(showvaluedimension, (Object)row.getName(), index);
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)this.getPageCache().get(dimension));
                BasedataEntityType basedataEntityTaype = (BasedataEntityType)obj.getDataEntityType();
                String nameProperty = basedataEntityTaype.getNameProperty();
                try {
                    mulilangDimensionValue = obj.get(nameProperty) instanceof ILocaleString ? obj.getLocaleString(nameProperty) : (obj.get(nameProperty) instanceof String ? new LocaleString((String)obj.get(nameProperty)) : new LocaleString(obj.get(nameProperty) == null ? "" : obj.get(nameProperty).toString()));
                }
                catch (Exception e) {
                    this.logger.error("field type parse is error.");
                    mulilangDimensionValue = new LocaleString();
                }
                this.getModel().setValue(mulilangdimension, mulilangDimensionValue, index);
            }
        }
    }

    private void initDimension(List<RoleDimension> rd) {
        EntryGrid entry = (EntryGrid)this.getControl(GRID_ROLEENTRY);
        int i = 0;
        StringBuilder delNumber = new StringBuilder();
        for (RoleDimension di : rd) {
            String index = di.getIndex();
            char dimensionIndex = index.charAt(index.length() - 1);
            this.getView().setVisible(Boolean.TRUE, new String[]{SHOWVALUEDIMENSION + dimensionIndex});
            ++i;
            DynamicObject dynObject = WfRoleDimensionUtil.getObjectType((String)di.getEntityNumber());
            if (WfUtils.isNullObject((Object)dynObject)) {
                entry.setColumnProperty(SHOWVALUEDIMENSION + dimensionIndex, "header", (Object)new LocaleString(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%s\u88ab\u5220\u9664", (String)"WorkflowRolePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), Character.valueOf(dimensionIndex))));
                delNumber = delNumber.append(di.getEntityNumber()).append("\u3001");
                continue;
            }
            DynamicObjectType type = dynObject.getDynamicObjectType();
            String entityId = di.getEntityNumber();
            entry.setColumnProperty(SHOWVALUEDIMENSION + dimensionIndex, "header", (Object)type.getDisplayName());
            this.getPageCache().put(index, entityId);
        }
        if (delNumber.length() != 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"number\u4e3a\u201c%s\u201d\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u7ef4\u5ea6\u8bbe\u7f6e\u3002", (String)"WorkflowRolePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), delNumber.substring(0, delNumber.length() - 1)));
        }
        while (i < 4) {
            int index = i + 1;
            this.getView().setVisible(Boolean.FALSE, new String[]{SHOWVALUEDIMENSION + index});
            ++i;
        }
    }

    private void dimensionSettingCloseCallBack(List<RoleDimension> rd) {
        List<Map<String, Map<String, Object>>> temp = this.getDimensionsTempValue();
        this.initDimension(rd);
        this.moveDimension(temp, rd);
    }

    private void moveDimension(List<Map<String, Map<String, Object>>> temp, List<RoleDimension> rd) {
        int i = 0;
        int index = 1;
        for (Map<String, Map<String, Object>> data : temp) {
            for (RoleDimension di : rd) {
                char dimensionIndex = di.getIndex().charAt(di.getIndex().length() - 1);
                if (!data.containsKey(di.getEntityNumber())) continue;
                Map<String, Object> dimensionMap = data.get(di.getEntityNumber());
                this.getModel().setValue(DIMENSION + dimensionIndex, dimensionMap.get(DIMENSION), i);
                this.getModel().setValue(SHOWVALUEDIMENSION + dimensionIndex, dimensionMap.get(SHOWVALUEDIMENSION), i);
                this.getModel().setValue(NUMBERDIMENSION + dimensionIndex, dimensionMap.get(NUMBERDIMENSION), i);
                this.getModel().setValue(MULILANGDIMENSION + dimensionIndex, dimensionMap.get(MULILANGDIMENSION), i);
                ++index;
            }
            while (index <= 4) {
                this.getModel().setValue(DIMENSION + index, null, i);
                this.getModel().setValue(SHOWVALUEDIMENSION + index, null, i);
                this.getModel().setValue(NUMBERDIMENSION + index, null, i);
                this.getModel().setValue(MULILANGDIMENSION + index, null, i);
                ++index;
            }
            index = 1;
            ++i;
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryDown(e);
        this.addMoveFlagToCache();
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryUp(e);
        this.addMoveFlagToCache();
    }

    private void addMoveFlagToCache() {
        if (this.getPageCache().get("moveFlag") != null) {
            return;
        }
        this.getPageCache().put("moveFlag", "true");
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        super.propertyChanged(pca);
        String prop = pca.getProperty().getName();
        FieldEdit fieldEdit = (FieldEdit)this.getControl(ALTERNATEUSER);
        switch (prop) {
            case "alternatetype": {
                ChangeData[] changeData = pca.getChangeSet();
                if (changeData == null || changeData.length == 0) {
                    return;
                }
                if (ALTERNATETYPE_ITEM_SUPERIOR.equals(changeData[0].getNewValue())) {
                    int rowIndex = this.getModel().getEntryCurrentRowIndex(GRID_ROLEENTRY);
                    this.getModel().setValue(ALTERNATEUSER, null, rowIndex);
                    fieldEdit.setEnable(ALTERNATEUSER, false, changeData[0].getRowIndex());
                    break;
                }
                if (ALTERNATETYPE_ITEM_DESIGNATEDPERSON.equals(changeData[0].getNewValue())) {
                    fieldEdit.setEnable(ALTERNATEUSER, true, changeData[0].getRowIndex());
                    break;
                }
                if (!StringUtils.isBlank((Object)changeData[0].getNewValue())) break;
                int rowIndex = this.getModel().getEntryCurrentRowIndex(GRID_ROLEENTRY);
                this.getModel().setValue(ALTERNATEUSER, null, rowIndex);
                fieldEdit.setEnable(ALTERNATEUSER, false, changeData[0].getRowIndex());
                break;
            }
            case "user": {
                DynamicObjectCollection roleEntitys = this.getModel().getEntryEntity(GRID_ROLEENTRY);
                if (roleEntitys != null && !roleEntitys.isEmpty()) {
                    for (int i = 0; i < roleEntitys.size(); ++i) {
                        String alternateType = ((DynamicObject)roleEntitys.get(i)).getString(ALTERNATETYPE);
                        if (!ALTERNATETYPE_ITEM_SUPERIOR.equals(alternateType)) continue;
                        fieldEdit.setEnable(ALTERNATEUSER, false, i);
                    }
                }
                this.getModel().setValue(USERPOSITION, null, this.getEntryEntityFocusRow(GRID_ROLEENTRY));
                break;
            }
            case "showvaluedimension1": 
            case "showvaluedimension2": 
            case "showvaluedimension3": 
            case "showvaluedimension4": {
                char dimensionIndex = prop.charAt(prop.length() - 1);
                int roleIndex = this.getEntryEntityFocusRow(GRID_ROLEENTRY);
                if (!WfUtils.isEmptyString((Object)pca.getChangeSet()[0].getNewValue()) || roleIndex < 0) break;
                this.getModel().setValue(DIMENSION + dimensionIndex, null, roleIndex);
                this.getModel().setValue(NUMBERDIMENSION + dimensionIndex, null, roleIndex);
                this.getModel().setValue(MULILANGDIMENSION + dimensionIndex, null, roleIndex);
                break;
            }
            case "org": {
                ChangeData[] datas = pca.getChangeSet();
                if (datas.length != 1) break;
                this.updateInfoToEntry(datas[0].getRowIndex());
                break;
            }
        }
    }

    private void initOrgFullNameToPageCache(String functionType, ListSelectedRowCollection listSelectedRowCollection) {
        DynamicObject[] orgStructures;
        DynamicObjectCollection roleEntitys = this.getModel().getEntryEntity(GRID_ROLEENTRY);
        if (listSelectedRowCollection == null || listSelectedRowCollection.isEmpty() || WfUtils.isEmptyString((Object)functionType)) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(listSelectedRowCollection.size());
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            Long orgId = (Long)listSelectedRow.getPrimaryKeyValue();
            String orgFullName = orgFullNames.get(String.format("%s_*_%s", functionType, orgId));
            if (WfUtils.isNotEmpty((String)orgFullName)) continue;
            orgIds.add(orgId);
        }
        if (orgIds.isEmpty()) {
            return;
        }
        QFilter qFilter1 = new QFilter("view", "=", (Object)Long.valueOf(functionType));
        QFilter qFilter2 = new QFilter(ORG, "in", orgIds);
        QFilter[] qFilter = new QFilter[]{qFilter1, qFilter2};
        for (DynamicObject orgStructure : orgStructures = BusinessDataServiceHelper.load((String)BOS_ORG_STRUCTURE, (String)"view,org,fullname", (QFilter[])qFilter)) {
            long orgId = orgStructure.getLong("org_id");
            String orgFullName = orgStructure.getString(FULLNAME);
            orgFullName = WfUtils.isEmpty((String)orgFullName) ? "null" : orgFullName;
            orgFullNames.put(String.format("%s_*_%s", functionType, orgId), orgFullName);
        }
    }

    private List<Map<String, Map<String, Object>>> getDimensionsTempValue() {
        List rd = new ArrayList(4);
        String oldRoleDimension = (String)this.getModel().getValue(ROLEDIMENSION);
        if (WfUtils.isNotEmpty((String)oldRoleDimension)) {
            Map dimensionInfos = WfRoleDimensionUtil.getDimensionInfos((String)oldRoleDimension);
            rd = (List)dimensionInfos.get(WFDIMENSIONSLIST);
        }
        ArrayList<Map<String, Map<String, Object>>> temp = new ArrayList<Map<String, Map<String, Object>>>(4);
        int size = this.getModel().getEntryRowCount(GRID_ROLEENTRY);
        for (int i = 0; i < size; ++i) {
            HashMap tempMap = new HashMap(4);
            for (RoleDimension di : rd) {
                char dimensionIndex = di.getIndex().charAt(di.getIndex().length() - 1);
                HashMap<String, Object> dimensionMap = new HashMap<String, Object>(4);
                dimensionMap.put(DIMENSION, this.getModel().getValue(DIMENSION + dimensionIndex, i));
                dimensionMap.put(SHOWVALUEDIMENSION, this.getModel().getValue(SHOWVALUEDIMENSION + dimensionIndex, i));
                dimensionMap.put(NUMBERDIMENSION, this.getModel().getValue(NUMBERDIMENSION + dimensionIndex, i));
                dimensionMap.put(MULILANGDIMENSION, this.getModel().getValue(MULILANGDIMENSION + dimensionIndex, i));
                tempMap.put(di.getEntityNumber(), dimensionMap);
            }
            temp.add(tempMap);
        }
        return temp;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object orgId;
        Object orgObj;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && null != (orgObj = this.getModel().getValue(ORGUNIT)) && !this.canDoOperation((Long)(orgId = ((DynamicObject)orgObj).getPkValue()))) {
            args.cancel = true;
            this.getView().showErrorNotification(WFMultiLangConstants.getNotAdminForOperation());
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if (evt.getSource() instanceof Save && evt.getOperationResult().isSuccess()) {
            QFilter tFilter;
            QFilter vFilter;
            Boolean isCopy;
            String baseFormId = evt.getOperationResult().getSuccessPkIds().get(0).toString();
            if (StringUtils.isNotBlank((CharSequence)this.getView().getPageCache().get("roleId"))) {
                ((BaseShowParameter)this.getView().getFormShowParameter()).setPkId((Object)Long.valueOf(this.getView().getPageCache().get("roleId")));
            }
            BaseChangeLogsUtil.addBaseLog(this.getView(), ROLE, FORM_ID, baseFormId, new IBaseChangeLogCallBack(){

                @Override
                public JSONArray getModelArray() {
                    return WorkflowRolePlugin.this.getViewModelArray();
                }
            });
            if (StringUtils.isBlank((Object)((BaseShowParameter)this.getView().getFormShowParameter()).getPkId()) && StringUtils.isNotBlank((Object)this.getModel().getValue("id"))) {
                this.getView().getPageCache().put("roleId", String.valueOf(this.getModel().getValue("id")));
            }
            String newRoleDimension = (String)this.getModel().getValue(ROLEDIMENSION);
            ((IPageCache)this.getView().getService(IPageCache.class)).put(ROLEDIMENSION, newRoleDimension);
            BaseShowParameter parameter = (BaseShowParameter)this.getView().getFormShowParameter();
            Boolean bl = isCopy = WfUtils.isEmpty((String)this.getPageCache().get(ISCOPY)) ? Boolean.FALSE : Boolean.valueOf(this.getPageCache().get(ISCOPY));
            if (!WfUtils.isNullObject((Object)parameter.getPkId()) && !isCopy.booleanValue() && QueryServiceHelper.exists((String)"wf_basedatarefrecord", (QFilter[])new QFilter[]{vFilter = new QFilter("value", "in", parameter.getPkId()), tFilter = new QFilter("type", "=", (Object)"workflowRole")})) {
                ListFilterParameter filterParameter = new ListFilterParameter();
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
                qFilters.add(vFilter);
                qFilters.add(tFilter);
                filterParameter.setQFilters(qFilters);
                ListShowParameter lsp = new ListShowParameter();
                lsp.setCaption(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272\u5f15\u7528\u8bb0\u5f55", (String)"WorkflowRolePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                lsp.setBillFormId("wf_basedatarefrecord");
                lsp.getOpenStyle().setShowType(ShowType.Modal);
                lsp.setListFilterParameter(filterParameter);
                lsp.setFormId("wf_basedatarefrecordmodal");
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    public void afterBindData(EventObject e) {
        Object orgUnit;
        super.afterBindData(e);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (WfAdminUtil.controlBtnByAdmin((Long)userId)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_save"});
        }
        if ((orgUnit = this.getModel().getValue(ORGUNIT)) instanceof DynamicObject) {
            DynamicObject org = (DynamicObject)orgUnit;
            if (!WfAdminUtil.canDoOperation((Long)userId, (Long)((Long)org.getPkValue()))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{ORGUNIT});
            }
        }
        if (WfUtils.isNullObject((Object)this.getModel().getValue(MANAGER))) {
            this.getModel().setValue(MANAGER, (Object)RequestContext.get().getUserId());
        }
        Boolean dimensionSetPermission = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"a479ec06000000ac", (String)FORM_ID, (String)"26UV+S4A=VRY");
        this.getView().setVisible(dimensionSetPermission, new String[]{SETTING});
        int count = this.getModel().getEntryRowCount(GRID_ROLEENTRY);
        for (int i = 0; i < count; ++i) {
            for (int j = 1; j <= 4; ++j) {
                if (!WfUtils.isNotEmptyString((Object)this.getModel().getValue(MULILANGDIMENSION + j, i))) continue;
                OrmLocaleValue o = (OrmLocaleValue)this.getModel().getValue(MULILANGDIMENSION + j, i);
                this.getModel().setValue(SHOWVALUEDIMENSION + j, (Object)o.getLocaleValue(), i);
            }
        }
        String oldRoleDimension = (String)this.getModel().getValue(ROLEDIMENSION);
        ((IPageCache)this.getView().getService(IPageCache.class)).put(ROLEDIMENSION, oldRoleDimension);
        BaseChangeLogsUtil.putBaseModelCache(this.getView(), ROLE, new IBaseChangeLogCallBack(){

            @Override
            public JSONArray getModelArray() {
                return WorkflowRolePlugin.this.getViewModelArray();
            }
        });
        this.refreshSystemDimension();
        this.setFullNameToUserList();
        this.getModel().setDataChanged(false);
    }

    private void refreshSystemDimension() {
        String oldRoleDimension = (String)this.getModel().getValue(ROLEDIMENSION);
        if (WfUtils.isNotEmpty((String)oldRoleDimension)) {
            Map dimensionInfos = WfRoleDimensionUtil.getDimensionInfos((String)oldRoleDimension);
            List rdList = (List)dimensionInfos.get(WFDIMENSIONSLIST);
            for (RoleDimension rd : rdList) {
                this.refreshSingleDimension(rd);
            }
        }
    }

    private void refreshSingleDimension(RoleDimension rd) {
        int count = this.getModel().getEntryRowCount(GRID_ROLEENTRY);
        String index = rd.getIndex();
        char dimensionIndex = index.charAt(index.length() - 1);
        HashMap<Object, List<Integer>> numberMapDimension = new HashMap<Object, List<Integer>>(count);
        HashMap<Object, List<Integer>> idMapDimension = new HashMap<Object, List<Integer>>(count);
        for (int i = 0; i < count; ++i) {
            Object idDimension = this.getModel().getValue(DIMENSION + dimensionIndex, i);
            if (WfUtils.isNotEmptyString((Object)idDimension) && !"0".equals(idDimension)) {
                List<Integer> indexList = idMapDimension.containsKey(idDimension) ? (List)idMapDimension.get(idDimension) : new ArrayList(1);
                indexList.add(i);
                idMapDimension.put(idDimension, indexList);
                continue;
            }
            Object numberDimension = this.getModel().getValue(NUMBERDIMENSION + dimensionIndex, i);
            if (WfUtils.isNotEmptyString((Object)numberDimension)) {
                List<Integer> indexList = numberMapDimension.containsKey(numberDimension) ? (List)numberMapDimension.get(numberDimension) : new ArrayList(1);
                indexList.add(i);
                numberMapDimension.put(numberDimension, indexList);
                continue;
            }
            this.getModel().setValue(DIMENSION + dimensionIndex, null, i);
            this.getModel().setValue(NUMBERDIMENSION + dimensionIndex, null, i);
            this.getModel().setValue(MULILANGDIMENSION + dimensionIndex, null, i);
            this.getModel().setValue(SHOWVALUEDIMENSION + dimensionIndex, null, i);
        }
        this.refreshSingleDimensionValue(rd, numberMapDimension, idMapDimension);
    }

    private void refreshSingleDimensionValue(RoleDimension rd, Map<Object, List<Integer>> numberMapDimension, Map<Object, List<Integer>> idMapDimension) {
        if (numberMapDimension.isEmpty() && idMapDimension.isEmpty()) {
            return;
        }
        String entityNumber = rd.getEntityNumber();
        String index = rd.getIndex();
        char dimensionIndex = index.charAt(index.length() - 1);
        DynamicObject dynObject = WfRoleDimensionUtil.getObjectType((String)entityNumber);
        int count = this.getModel().getEntryRowCount(GRID_ROLEENTRY);
        if (WfUtils.isNullObject((Object)dynObject)) {
            for (int i = 0; i < count; ++i) {
                this.getModel().setValue(DIMENSION + dimensionIndex, null, i);
                this.getModel().setValue(NUMBERDIMENSION + dimensionIndex, null, i);
                this.getModel().setValue(MULILANGDIMENSION + dimensionIndex, null, i);
                this.getModel().setValue(SHOWVALUEDIMENSION + dimensionIndex, null, i);
            }
        } else {
            DynamicObject[] dimensionDymObject;
            BasedataEntityType basedataEntityTaype = (BasedataEntityType)dynObject.getDataEntityType();
            String numberProperty = basedataEntityTaype.getNumberProperty();
            String nameProperty = basedataEntityTaype.getNameProperty();
            QFilter qFilter = null;
            if (!idMapDimension.isEmpty()) {
                Set<Object> keySet = idMapDimension.keySet();
                if (basedataEntityTaype.getPrimaryKey() instanceof LongProp) {
                    HashSet<Long> idSet = new HashSet<Long>(keySet.size());
                    for (Object key : keySet) {
                        idSet.add(Long.valueOf(key.toString()));
                    }
                    qFilter = new QFilter("id", "in", idSet);
                } else {
                    qFilter = new QFilter("id", "in", keySet);
                }
            }
            if (!numberMapDimension.isEmpty()) {
                if (qFilter == null) {
                    qFilter = new QFilter(numberProperty, "in", numberMapDimension.keySet());
                } else {
                    qFilter.or(new QFilter(numberProperty, "in", numberMapDimension.keySet()));
                }
            }
            ArrayList<Integer> valueList = new ArrayList<Integer>(count);
            for (DynamicObject obj : dimensionDymObject = BusinessDataServiceHelper.load((String)entityNumber, (String)String.format("%s,%s", numberProperty, nameProperty), (QFilter[])new QFilter[]{qFilter})) {
                Object pkValue = obj.getPkValue();
                Object number = obj.get(numberProperty);
                Object name = obj.get(nameProperty) instanceof ILocaleString ? obj.getLocaleString(nameProperty) : (obj.get(nameProperty) instanceof String ? new LocaleString((String)obj.get(nameProperty)) : new LocaleString(obj.get(nameProperty) == null ? "" : obj.get(nameProperty).toString()));
                List<Object> list = new ArrayList();
                if (idMapDimension.containsKey(pkValue.toString())) {
                    list = idMapDimension.get(pkValue.toString());
                } else if (numberMapDimension.containsKey(number)) {
                    list = numberMapDimension.get(number);
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    this.getModel().setValue(DIMENSION + dimensionIndex, pkValue, i);
                    this.getModel().setValue(NUMBERDIMENSION + dimensionIndex, number, i);
                    this.getModel().setValue(MULILANGDIMENSION + dimensionIndex, name, i);
                    this.getModel().setValue(SHOWVALUEDIMENSION + dimensionIndex, (Object)name.getLocaleValue(), i);
                    valueList.add(i);
                }
            }
            for (int i = 0; i < count; ++i) {
                if (valueList.contains(i)) continue;
                this.getModel().setValue(DIMENSION + dimensionIndex, null, i);
                this.getModel().setValue(NUMBERDIMENSION + dimensionIndex, null, i);
                this.getModel().setValue(MULILANGDIMENSION + dimensionIndex, null, i);
                this.getModel().setValue(SHOWVALUEDIMENSION + dimensionIndex, null, i);
            }
        }
    }

    private void setFullNameToUserList() {
        Map<String, String> fullNameMap;
        IDataModel model = this.getModel();
        DynamicObjectCollection entities = model.getEntryEntity(GRID_ROLEENTRY);
        ArrayList<Long> functionTypeList = new ArrayList<Long>();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (int i = 0; i < entities.size(); ++i) {
            DynamicObject row = (DynamicObject)entities.get(i);
            Long functionType = Long.valueOf(row.get(FUNCTION_TYPE).toString());
            DynamicObject org = (DynamicObject)row.get(ORG);
            if (org == null) {
                orgIdList.add(null);
                functionTypeList.add(1L);
                continue;
            }
            functionType = this.getFunctionType(row, functionType, i);
            Long orgId = (Long)org.getPkValue();
            orgIdList.add(orgId);
            functionTypeList.add(functionType);
        }
        if (!functionTypeList.isEmpty() && !orgIdList.isEmpty() && (fullNameMap = this.batchGetFullName(functionTypeList, orgIdList)) != null) {
            for (int i = 0; i < entities.size(); ++i) {
                if (orgIdList.get(i) == null) {
                    this.getModel().setValue(FULLNAME, (Object)"", i);
                    continue;
                }
                String fullName = fullNameMap.get(functionTypeList.get(i) + "_" + orgIdList.get(i));
                this.getModel().setValue(FULLNAME, (Object)fullName, i);
            }
        }
    }

    private void updateFfullNameByOne(int index) {
        DynamicObject row = this.getModel().getEntryRowEntity(GRID_ROLEENTRY, index);
        this.updateInfoToEntry(row, index);
    }

    private void updateInfoToEntry(int index) {
        DynamicObject row = this.getModel().getEntryRowEntity(GRID_ROLEENTRY, index);
        DynamicObject org = (DynamicObject)row.get(ORG);
        if (org == null) {
            return;
        }
        Long tmpFunctionType = Long.valueOf("01");
        Long orgId = (Long)org.getPkValue();
        QFilter filter = new QFilter("view", "=", (Object)Long.valueOf("01")).and(new QFilter(ORG, "=", (Object)orgId));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)FULLNAME, (QFilter[])new QFilter[]{filter});
        if (collection == null || collection.isEmpty()) {
            filter = new QFilter("view", "=", (Object)Long.valueOf("15")).and(new QFilter(ORG, "=", (Object)orgId));
            collection = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)FULLNAME, (QFilter[])new QFilter[]{filter});
            tmpFunctionType = Long.valueOf("15");
        }
        if (this.getModel().getValue(FUNCTION_TYPE, index) == null || (Long)this.getModel().getValue(FUNCTION_TYPE, index) == 0L) {
            this.getModel().setValue(FUNCTION_TYPE, (Object)tmpFunctionType, index);
        }
        HashMap<String, Boolean> params = WfUtils.isNotEmptyString((Object)this.getModel().getValue(PARAM, index)) ? (Map)SerializationUtils.fromJsonString((String)((String)this.getModel().getValue(PARAM, index)), Map.class) : new HashMap<String, Boolean>(1);
        FieldEdit fieldEdit = (FieldEdit)this.getControl(INCLUDADMINSUB);
        if (!Long.valueOf("01").equals(tmpFunctionType)) {
            this.getModel().setValue(INCLUDADMINSUB, (Object)Boolean.FALSE, index);
            fieldEdit.setEnable(INCLUDADMINSUB, Boolean.FALSE.booleanValue(), index);
            params.put(ISADMINORG, Boolean.FALSE);
        } else {
            this.getModel().setValue(INCLUDADMINSUB, (Object)Boolean.TRUE, index);
            fieldEdit.setEnable(INCLUDADMINSUB, Boolean.TRUE.booleanValue(), index);
            params.put(ISADMINORG, Boolean.TRUE);
        }
        this.getModel().setValue(PARAM, (Object)SerializationUtils.toJsonString(params), index);
        String fullname = ((DynamicObject)collection.get(0)).getString(FULLNAME);
        this.getModel().setValue(FULLNAME, (Object)fullname, index);
    }

    private void updateInfoToEntry(DynamicObject row, int index) {
        Long functionType = (Long)row.get(FUNCTION_TYPE);
        DynamicObject org = (DynamicObject)row.get(ORG);
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        functionType = this.getFunctionType(row, functionType, index);
        String fullname = this.getFfullname(functionType, orgId);
        this.getModel().setValue(FULLNAME, (Object)fullname, index);
    }

    private Long getFunctionType(DynamicObject row, Long functionType, int index) {
        if (functionType == 0L) {
            functionType = 1L;
            this.getModel().setValue(FUNCTION_TYPE, (Object)functionType, index);
            row.set(FUNCTION_TYPE, (Object)functionType);
        }
        return functionType;
    }

    private String getFfullname(Long functionType, long orgId) {
        String orgFullName = orgFullNames.get(String.format("%s_*_%s", functionType, orgId));
        if (WfUtils.isNotEmpty((String)orgFullName)) {
            return "null".equals(orgFullName) ? "" : orgFullName;
        }
        QFilter qFilter1 = new QFilter("view", "=", (Object)functionType);
        QFilter qFilter2 = new QFilter(ORG, "=", (Object)orgId);
        QFilter[] qFilter = new QFilter[]{qFilter1, qFilter2};
        DynamicObject orgStructure = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_ORG_STRUCTURE, (String)FULLNAME, (QFilter[])qFilter);
        orgFullName = orgStructure != null ? orgStructure.getString(FULLNAME) : "";
        orgFullNames.put(String.format("%s_*_%s", functionType, orgId), orgFullName);
        return orgFullName;
    }

    private Map<String, String> batchGetFullName(List<Long> functionTypeList, List<Long> orgIdList) {
        QFilter filter1 = new QFilter("view", "in", functionTypeList.stream().distinct().collect(Collectors.toList()));
        QFilter filter2 = new QFilter(ORG, "in", orgIdList.stream().distinct().collect(Collectors.toList()));
        HashMap<String, String> fullnameMap = null;
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BOS_ORG_STRUCTURE, (String)"fullname,view,org", (QFilter[])new QFilter[]{filter1, filter2});
        if (collection != null && !collection.isEmpty()) {
            fullnameMap = new HashMap<String, String>(collection.size());
            DynamicObject orgStructure = null;
            for (int i = 0; i < collection.size(); ++i) {
                orgStructure = (DynamicObject)collection.get(i);
                fullnameMap.put(orgStructure.getLong("view") + "_" + orgStructure.getLong(ORG), orgStructure.getString(FULLNAME));
            }
        }
        return fullnameMap;
    }

    private JSONArray getViewModelArray() {
        JSONArray arr = new JSONArray();
        String roleType = (String)Optional.ofNullable(this.getModel().getValue(ROLETYPE)).orElseGet(() -> USER);
        DynamicObjectCollection collection = this.getModel().getEntryEntity(GRID_ROLEENTRY);
        for (DynamicObject dynamicObject : collection) {
            JSONObject roleEntry = new JSONObject();
            roleEntry.put("id", dynamicObject.getPkValue());
            roleEntry.put("roleType", (Object)roleType);
            DynamicObject org = dynamicObject.getDynamicObject(ORG);
            if (org != null) {
                String orgName = org.getLocaleString(NAME).getLocaleValue();
                orgName = orgName == null ? org.getLocaleString(NAME).toString() : orgName;
                roleEntry.put(ORG, (Object)orgName);
            }
            DynamicObject obj = APPROVALPOSITION.equals(roleType) ? dynamicObject.getDynamicObject(APPROVALPOSITION) : dynamicObject.getDynamicObject(USER);
            Optional.ofNullable(obj).ifPresent(x -> {
                ILocaleString objName = x.getLocaleString(NAME);
                String name = WfUtils.isEmpty((ILocaleString)objName) ? "" : objName.toString();
                roleEntry.put(roleType, (Object)name);
            });
            roleEntry.put("type", (Object)dynamicObject.getString(ALTERNATETYPE));
            DynamicObject alternateuser = dynamicObject.getDynamicObject(ALTERNATEUSER);
            roleEntry.put(ALTERNATEUSER, (Object)(alternateuser != null ? alternateuser.getLocaleString(NAME).getLocaleValue() : ""));
            DynamicObject userPosition = dynamicObject.getDynamicObject(USERPOSITION);
            roleEntry.put(USERPOSITION, (Object)(userPosition != null ? userPosition.getLocaleString("position").getLocaleValue() : ""));
            if (!WfConfigurationUtil.closeDimensionRecord()) {
                ILocaleString mulilangdimension1 = dynamicObject.getLocaleString("mulilangdimension1");
                if (!WfUtils.isNullObject((Object)mulilangdimension1)) {
                    roleEntry.put(DIMENSION1, (Object)mulilangdimension1);
                } else {
                    roleEntry.put(DIMENSION1, null);
                }
                ILocaleString mulilangdimension2 = dynamicObject.getLocaleString("mulilangdimension2");
                if (!WfUtils.isNullObject((Object)mulilangdimension2)) {
                    roleEntry.put(DIMENSION2, (Object)mulilangdimension2);
                } else {
                    roleEntry.put(DIMENSION2, null);
                }
                ILocaleString mulilangdimension3 = dynamicObject.getLocaleString("mulilangdimension3");
                if (!WfUtils.isNullObject((Object)mulilangdimension3)) {
                    roleEntry.put(DIMENSION3, (Object)mulilangdimension3);
                } else {
                    roleEntry.put(DIMENSION3, null);
                }
                ILocaleString mulilangdimension4 = dynamicObject.getLocaleString("mulilangdimension4");
                if (!WfUtils.isNullObject((Object)mulilangdimension4)) {
                    roleEntry.put(DIMENSION4, (Object)mulilangdimension4);
                } else {
                    roleEntry.put(DIMENSION4, null);
                }
            }
            roleEntry.put(INCLUDADMINSUB, (Object)dynamicObject.getBoolean(INCLUDADMINSUB));
            arr.add((Object)roleEntry);
        }
        return arr;
    }

    private int getEntryEntityFocusRow(String entryEntityName) {
        EntryGrid grid = (EntryGrid)this.getControl(entryEntityName);
        return grid.getEntryState().getFocusRow();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "showvaluedimension1": 
            case "showvaluedimension2": 
            case "showvaluedimension3": 
            case "showvaluedimension4": {
                char dimensionIndex = key.charAt(key.length() - 1);
                String number = this.getPageCache().get(DIMENSION + dimensionIndex);
                if (WfUtils.isNotEmpty((String)number)) {
                    this.openDimensionSelection(number, "dimensionclosecallback" + dimensionIndex);
                    break;
                }
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%s\u201d\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u7ef4\u5ea6\u8bbe\u7f6e\u3002", (String)"WorkflowRolePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), Character.valueOf(dimensionIndex)));
                break;
            }
        }
    }

    private void openDimensionSelection(String number, String closeCallbackNumber) {
        QFilter customFilter;
        Boolean isMultiSelect = Boolean.FALSE;
        ListShowParameter showParameter = null;
        CustomBasedataFilterEvent cbevent = this.getCustomBasedataFilter(number);
        Long customRootOrgId = cbevent.getCustomRootOrgId();
        if ("bos_user".equals(number)) {
            showParameter = WfCustomReportRelationUtil.createShowListForm(number, isMultiSelect, BasedataFormListType.BOS_USERTREELISTF7.getNumber());
            if (WfUtils.isNotEmpty((Long)customRootOrgId)) {
                showParameter.setCustomParam("initRootOrgId", (Object)customRootOrgId);
            }
        } else if (FORM_ORG.equals(number)) {
            showParameter = WfCustomReportRelationUtil.createShowListForm(number, isMultiSelect, BasedataFormListType.BOS_ADMINORGLISTF7.getNumber());
            if (WfUtils.isNotEmpty((Long)customRootOrgId)) {
                showParameter.setCustomParam("initRootOrgId", (Object)customRootOrgId);
            }
        } else {
            showParameter = WfCustomReportRelationUtil.createShowListForm(number, isMultiSelect, BasedataFormListType.BOS_LISTF7.getNumber());
        }
        if ((customFilter = cbevent.getCustomBasedataFilter()) != null) {
            showParameter.getListFilterParameter().getQFilters().add(customFilter);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, closeCallbackNumber);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SHOWVALUEDIMENSION1, SHOWVALUEDIMENSION2, SHOWVALUEDIMENSION3, SHOWVALUEDIMENSION4});
        BasedataEdit userPositionBasedata = (BasedataEdit)this.getControl(USERPOSITION);
        userPositionBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        userPositionBasedata.addBasedataFuzzySearchListener(event -> {
            List queryData = event.getQueryData();
            if (CollectionUtils.isEmpty((Collection)queryData)) {
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(queryData.size());
            for (Object detail : queryData) {
                List detailItems = (List)detail;
                ids.add(Long.valueOf(detailItems.get(0).toString()));
            }
            QFilter idFilter = new QFilter("id", "in", ids);
            QFilter[] filters = new QFilter[]{idFilter};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"biz.bos_userposition.queryDataSet", (String)"bos_userposition", (String)"id,org.name org,position", (QFilter[])filters, (String)"id asc");){
                queryData.clear();
                for (Row positionObj : dataSet) {
                    ArrayList<String> detailItems = new ArrayList<String>(3);
                    detailItems.add(positionObj.getString("id"));
                    String position = positionObj.getString("position");
                    detailItems.add(position);
                    String orgName = positionObj.getString(ORG);
                    if (StringUtils.isNotBlank((CharSequence)position) && StringUtils.isNotBlank((CharSequence)orgName)) {
                        position = position + "/" + orgName;
                    }
                    detailItems.add(position);
                    queryData.add(detailItems);
                }
            }
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        int focusRow = this.getEntryEntityFocusRow(GRID_ROLEENTRY);
        DynamicObject userDynamicObject = (DynamicObject)this.getModel().getValue(USER, focusRow);
        if (userDynamicObject == null) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u672a\u9009\u62e9\u4eba\u5458\uff0c\u65e0\u6cd5\u9009\u62e9\u804c\u4f4d\u3002", (String)"WorkflowRolePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), focusRow + 1));
            return;
        }
        ArrayList<QFilter> qFilter = new ArrayList<QFilter>();
        Long userId = userDynamicObject.getLong("id");
        qFilter.add(new QFilter("user.id", "=", (Object)userId));
        beforeF7SelectEvent.setCustomQFilters(qFilter);
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List dataList = e.getSourceDataList();
        for (Map sourceData : dataList) {
            if (!sourceData.containsKey(ROLEDIMENSION) || !sourceData.containsKey(GRID_ROLEENTRY)) continue;
            this.refreshSingleRoleImportData(sourceData);
        }
    }

    private void refreshSingleRoleImportData(Map<String, Object> sourceData) {
        String roleDimension = sourceData.get(ROLEDIMENSION).toString();
        if (WfUtils.isNotEmpty((String)roleDimension)) {
            Map dimensionInfos = WfRoleDimensionUtil.getDimensionInfos((String)roleDimension);
            List rdList = (List)dimensionInfos.get(WFDIMENSIONSLIST);
            for (RoleDimension rd : rdList) {
                this.refreshSingleDimensionImportData(rd, sourceData);
            }
        }
    }

    private void refreshSingleDimensionImportData(RoleDimension rd, Map<String, Object> sourceData) {
        JSONArray roleentry = (JSONArray)sourceData.get(GRID_ROLEENTRY);
        int count = roleentry.size();
        String index = rd.getIndex();
        char dimensionIndex = index.charAt(index.length() - 1);
        HashMap<String, List<Integer>> numberMap = new HashMap<String, List<Integer>>();
        for (int i = 0; i < count; ++i) {
            JSONObject roleObj;
            Object role = roleentry.get(i);
            if (!WfUtils.isJSONObject((Object)role) || !(roleObj = JSONObject.parseObject((String)role.toString())).containsKey((Object)(NUMBERDIMENSION + dimensionIndex))) continue;
            String numberDimension = roleObj.getString(NUMBERDIMENSION + dimensionIndex);
            if (WfUtils.isNotEmptyString((Object)numberDimension)) {
                List<Integer> indexList = numberMap.containsKey(numberDimension) ? (List)numberMap.get(numberDimension) : new ArrayList(1);
                indexList.add(i);
                numberMap.put(numberDimension, indexList);
                continue;
            }
            roleObj.put(DIMENSION + dimensionIndex, null);
            roleObj.put(MULILANGDIMENSION + dimensionIndex, null);
        }
        this.refreshSingleDimensionValueImportData(rd, numberMap, roleentry);
    }

    private void refreshSingleDimensionValueImportData(RoleDimension rd, Map<String, List<Integer>> numberMap, JSONArray roleentry) {
        if (numberMap.isEmpty()) {
            return;
        }
        String entityNumber = rd.getEntityNumber();
        String index = rd.getIndex();
        char dimensionIndex = index.charAt(index.length() - 1);
        DynamicObject dynObject = WfRoleDimensionUtil.getObjectType((String)entityNumber);
        if (WfUtils.isNullObject((Object)dynObject)) {
            for (List<Integer> value : numberMap.values()) {
                for (int i : value) {
                    JSONObject jsonObj = JSONObject.parseObject((String)roleentry.get(i).toString());
                    jsonObj.put(DIMENSION + dimensionIndex, null);
                    jsonObj.put(NUMBERDIMENSION + dimensionIndex, null);
                    jsonObj.put(MULILANGDIMENSION + dimensionIndex, null);
                    roleentry.set(i, (Object)jsonObj);
                }
            }
        } else {
            BasedataEntityType basedataEntityTaype = (BasedataEntityType)dynObject.getDataEntityType();
            String numberProperty = basedataEntityTaype.getNumberProperty();
            String nameProperty = basedataEntityTaype.getNameProperty();
            QFilter qFilter = new QFilter(numberProperty, "in", numberMap.keySet());
            DynamicObject[] dimensionDymObject = BusinessDataServiceHelper.load((String)entityNumber, (String)String.format("%s,%s", numberProperty, nameProperty), (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject obj : dimensionDymObject) {
                Object pkValue = obj.getPkValue();
                Object number = obj.get(numberProperty);
                Object name = obj.get(nameProperty) instanceof ILocaleString ? obj.getLocaleString(nameProperty) : (obj.get(nameProperty) instanceof String ? new LocaleString((String)obj.get(nameProperty)) : new LocaleString(obj.get(nameProperty) == null ? "" : obj.get(nameProperty).toString()));
                if (!numberMap.containsKey(number)) continue;
                List<Integer> list = numberMap.get(number);
                for (int i : list) {
                    JSONObject jsonObj = JSONObject.parseObject((String)roleentry.get(i).toString());
                    jsonObj.put(DIMENSION + dimensionIndex, pkValue);
                    jsonObj.put(NUMBERDIMENSION + dimensionIndex, number);
                    jsonObj.put(MULILANGDIMENSION + dimensionIndex, name);
                    roleentry.set(i, (Object)jsonObj);
                }
                numberMap.remove(number);
            }
            for (List list : numberMap.values()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    JSONObject jsonObj = JSONObject.parseObject((String)roleentry.get(i).toString());
                    jsonObj.put(DIMENSION + dimensionIndex, null);
                    jsonObj.put(NUMBERDIMENSION + dimensionIndex, null);
                    jsonObj.put(MULILANGDIMENSION + dimensionIndex, null);
                    roleentry.set(i, (Object)jsonObj);
                }
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject role;
        String roleDimension;
        Long id = (Long)e.getSourceData().get("id");
        if (QueryServiceHelper.exists((String)FORM_ID, (Object)id) && WfUtils.isNotEmpty((String)(roleDimension = (role = BusinessDataServiceHelper.loadSingle((Object)id, (String)FORM_ID, (String)ROLEDIMENSION)).getString(ROLEDIMENSION)))) {
            Map dimensionInfos = WfRoleDimensionUtil.getDimensionInfos((String)roleDimension);
            List rdList = (List)dimensionInfos.get(WFDIMENSIONSLIST);
            HashSet<String> entitySet = new HashSet<String>(rdList.size());
            for (RoleDimension dimension : rdList) {
                entitySet.add(dimension.getEntityNumber());
            }
            String importDimension = (String)this.getModel().getValue(ROLEDIMENSION);
            Map importDimensionInfos = WfRoleDimensionUtil.getDimensionInfos((String)importDimension);
            List importList = (List)importDimensionInfos.get(WFDIMENSIONSLIST);
            for (RoleDimension dimension : importList) {
                entitySet.remove(dimension.getEntityNumber());
            }
            if (!entitySet.isEmpty()) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u5bfc\u5165\u5de5\u4f5c\u6d41\u89d2\u8272\u4e0d\u5141\u8bb8\u5220\u9664\u5df2\u6709\u7ef4\u5ea6\u3002", (String)"WorkflowRolePlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List rows = e.getRows();
        if (WfUtils.isNotEmptyForCollection((Collection)rows)) {
            boolean repairWorkflowRoleIncludeAdminSubComplete = WfConfigurationUtil.isRepairWorkflowRoleIncludeAdminSubComplete();
            rows.forEach(row -> {
                DynamicObject obj = row.getDataEntity();
                if (repairWorkflowRoleIncludeAdminSubComplete) {
                    HashMap params;
                    Map map = params = WfUtils.isNotEmptyString((Object)obj.getString(PARAM)) ? (Map)SerializationUtils.fromJsonString((String)obj.getString(PARAM), Map.class) : new HashMap(1);
                    if (params.get(ISADMINORG) == null || !((Boolean)params.get(ISADMINORG)).booleanValue()) {
                        FieldEdit fieldEdit = (FieldEdit)this.getControl(INCLUDADMINSUB);
                        fieldEdit.setEnable(INCLUDADMINSUB, Boolean.FALSE.booleanValue(), row.getRowIndex());
                    }
                }
                if (WfUtils.isEmpty((String)obj.getString(ALTERNATETYPE))) {
                    FieldEdit fieldEdit = (FieldEdit)this.getControl(ALTERNATEUSER);
                    fieldEdit.setEnable(ALTERNATEUSER, Boolean.FALSE.booleanValue(), row.getRowIndex());
                }
            });
        }
    }
}

