/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.designer.property.alias.IPropertyConverter;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.property.alias.AliasConverterFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.deployer.VersionUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;

public class WorkflowSelectSubProcessPlugin
extends AbstractWorkflowPlugin
implements RowClickEventListener {
    private static final String ENTRY_ENTITY = "entryentity";

    @Override
    public void initialize() {
        this.addClickListeners(new String[]{"confirm", "cancel"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.returnDataToParent();
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "cancel": {
                this.getView().close();
                break;
            }
            case "confirm": {
                this.returnDataToParent();
            }
        }
        super.click(evt);
    }

    private void returnDataToParent() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY);
        int rowIndex = grid.getEntryState().getFocusRow();
        if (rowIndex >= 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            IDataModel model = this.getModel();
            Long processId = Long.valueOf(String.valueOf(model.getValue("processid", rowIndex)));
            param.put("id", processId);
            param.put("name", model.getValue("name", rowIndex));
            param.put("number", model.getValue("number", rowIndex));
            ProcessDefinitionEntity entity = (ProcessDefinitionEntity)this.getRepositoryService().findEntityById(processId, "wf_processdefinition");
            IPropertyConverter convert = AliasConverterFactory.create("wf_formoperation");
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("entityId", entity.getEntraBillId());
            convert.setContext(context, null);
            this.getView().returnDataToParent(param);
            this.getView().close();
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map context = (Map)this.getView().getFormShowParameter().getCustomParam("context");
        String processType = (String)this.getView().getFormShowParameter().getCustomParam("processType");
        if (context != null) {
            Map properties = (Map)context.get("processProperties");
            String processNumber = properties.get("process_id").toString();
            String entraBillId = properties.get("entraBillId").toString();
            Object selected = properties.get("selected");
            QFilter[] filters = new QFilter[]{new QFilter("key", "!=", (Object)processNumber), new QFilter("entrabillid", "=", (Object)entraBillId), new QFilter("enable", "=", (Object)"enable"), new QFilter("type", "=", (Object)ProcessType.AuditFlow.name()), "BizFlow".equals(processType) ? new QFilter("primarysubprocess", "!=", (Object)"sub") : new QFilter("primarysubprocess", "!=", (Object)"main")};
            List entities = this.getRepositoryService().findSubProcDefsByFilters(filters);
            HashSet<String> numbers = new HashSet<String>(entities.size());
            Iterator iter = entities.iterator();
            while (iter.hasNext()) {
                String key = ((ProcessDefinitionEntity)iter.next()).getKey();
                if (numbers.contains(key)) {
                    iter.remove();
                    continue;
                }
                numbers.add(key);
            }
            if (!entities.isEmpty()) {
                IDataModel model = this.getModel();
                int size = entities.size();
                int selectedIndex = -1;
                int[] indexes = model.batchCreateNewEntryRow(ENTRY_ENTITY, size);
                ProcessDefinitionEntity entity = null;
                int index = 0;
                for (int i = 0; i < size; ++i) {
                    entity = (ProcessDefinitionEntity)entities.get(i);
                    index = indexes[i];
                    Long id = entity.getId();
                    if (String.valueOf(id).equals(String.valueOf(selected))) {
                        selectedIndex = i;
                    }
                    model.setValue("processid", (Object)id, index);
                    model.setValue("number", (Object)entity.getKey(), index);
                    model.setValue("name", (Object)entity.getName(), index);
                    OrmLocaleValue obj = (OrmLocaleValue)entity.getDescription();
                    if (WfUtils.isNotEmpty((String)obj.getLocaleValue())) {
                        model.setValue("description", (Object)entity.getDescription(), index);
                    }
                    model.setValue("entrybill", (Object)entity.getEntraBill(), index);
                    model.setValue("type", (Object)entity.getType(), index);
                    model.setValue("org", AliasConverterFactory.create("bos_org").convert((Object)entity.getOrgUnitId()), index);
                    model.setValue("version", (Object)VersionUtils.getPrevVersion((String)entity.getVersion()), index);
                }
                if (selectedIndex > -1) {
                    this.getPageCache().put("selected", String.valueOf(selectedIndex));
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        String selected = this.getPageCache().get("selected");
        if (WfUtils.isNotEmpty((String)selected)) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            grid.selectRows(Integer.parseInt(selected));
            this.getPageCache().remove("selected");
        }
    }
}

