/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.bpmn.graph.model.GraphItem;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.EventSupportTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.util.ConditionalRuleUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.billconv.BillConvertHelper;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class WorkflowSequenceFlowConfigurePlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String CTRL_CONDITIONALRULE = "conditionalrule";
    private static final String CONDITIONALRULE = "conditionalrule";
    private static final String DEFAULTFLOW = "defaultflow";
    private static final String BILLCONV_PANEL = "flexbotp";
    private static final String BILLCONV_MODE = "conversionmode";
    private static final String BILLCONV_TYPE = "conversiontype";
    private static final String BILLCONV_METHOD = "conversionmethod";
    private static final String BILLCONV_TIME = "conversiontime";
    private static final String TASKCLOSERULE = "taskcloserule";
    private static final String SHOWTEXT = "showtext";
    private static final String AFTEROPERATION = "afteroperation";
    private static final String FORMATSHOWVALUE = "%s\\n%s";
    private static final String ENABLE = "enable";
    private static final String RELATIONTYPE = "relationtype";
    private static final String TARGETBILLRAGE = "targetbillrage";
    private static final String BILLRELATIONSHIPMODEL = "billRelationshipModel";
    private static final String FLEXPLUGIN = "flexplugin";
    private static final String PLUGIN = "plugin";
    private static final String BILLRELARELATIONPANEL = "billrelarelationpanel";
    private static final String EXPRESSIONPLAN = "expressionplan";
    private static final String OTHERPLAN = "otherplan";
    private static final String EXPRESSION = "expression";
    private static final String PARAMETER = "parameter";
    public static final String DRAWPARAMETER = "drawParameter";
    public static final String DATAAGGREGATIONCTRPANEL = "dataaggregationctr";
    public static final String ENABLEAGGREGATION = "enableaggregation";
    public static final String AGGREGATIONPLUGINFLEX = "aggregationpluginflex";
    public static final String AGGREGATIONTYPE = "aggregationtype";
    public static final String EXECUTIONAGGREGATE = "executionAggregate";
    public static final String PLUGINAGGREGATE = "pluginAggregate";
    public static final String RADIO_BOTPTARGETBILLS = "botptargetbills";
    public static final String RADIO_QUERYBOTPTARGETBILLS = "querybotptargetbills";
    public static final String RADIO_FINDBYEXPRESSION = "findbyexpression";
    public static final String RADIO_FINDBYPLUGIN = "findbyplugin";
    private static final String ENABLETARGETBILLSFILTER = "enabletargetbillsfilter";
    private static final String TARGETBILLSFILTERFLEX = "targetbillsfilterflex";
    private static final String TARGETBILLSFILTERPANEL = "targetbillsfilterpanel";
    private static final String TARGETBILLSFILTERCONFIG = "targetbillsfilterconfig";
    private static final String TARGETBILLSFILTERCONDITION = "targetBillsFilterCondition";
    private static final String FILTERCONDITIONSHOWTEXT = "filterConditionShowText";
    public static final String AGGREGATIONPLUGIN = "aggregationplugin";
    private static final String GENERATETARGETFLEX = "generatetargetflex";
    private static final String ENABLEGENERATETARGET = "enablegeneratetarget";

    @Override
    public void initialize() {
        super.initialize();
        this.addExclusiveProperty("conditionalrule");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{RELATIONTYPE});
        this.addClickListeners(new String[]{"conditionalrule", TASKCLOSERULE, PLUGIN, EXPRESSION, PARAMETER, ENABLEAGGREGATION, TARGETBILLSFILTERCONFIG, AGGREGATIONPLUGIN, ENABLETARGETBILLSFILTER});
    }

    @Override
    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if ("conditionalrule".equals(key) && !((Boolean)this.getModel().getValue(DEFAULTFLOW)).booleanValue()) {
            JSONObject properties = this.getCellProperties();
            String modelJson = this.getModelJsonString();
            this.getView().getFormShowParameter().setCustomParam("isDefaultScheme", (Object)this.getIdeViewPageCacheData("isDefaultScheme"));
            this.getView().getFormShowParameter().setCustomParam("schemeId", (Object)this.getIdeViewPageCacheData("schemeId"));
            DesignerPluginUtil.openConditionalRule(this.getView(), (IFormPlugin)this, properties, modelJson, this.itemId, ConditionalRuleType.sequenceFlow, "conditionalrule", "condition");
        } else if (TASKCLOSERULE.equals(key)) {
            DesignerPluginUtil.openConditionalRule(this.getView(), (IFormPlugin)this, this.getCellProperties(), this.getModelJsonString(), this.itemId, ConditionalRuleType.taskCloseRule, "billRelationshipModel.taskCloseRule", TASKCLOSERULE);
        } else if (PLUGIN.equals(key)) {
            this.openPluginPage("");
        } else if (EXPRESSION.equals(key)) {
            this.openExpression();
        } else if (PARAMETER.equals(key)) {
            this.openParameter();
        } else if (TARGETBILLSFILTERCONFIG.equals(key)) {
            this.openTargetBillsFilterConfig();
        } else if (AGGREGATIONPLUGIN.equals(key)) {
            this.openPluginPage(AGGREGATIONPLUGIN);
        } else {
            super.click(evt);
        }
    }

    private void openTargetBillsFilterConfig() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String modelJson = this.getModelJsonString();
        BpmnModel bpmnModel = null;
        try {
            bpmnModel = DesignerModelUtil.getBpmnModel(modelJson);
        }
        catch (Exception e) {
            this.logger.error("get BpmnModel from json failed! " + WfUtils.getExceptionStacktrace((Throwable)e));
            return;
        }
        if (bpmnModel != null && ProcessType.BizFlow.name().equals(bpmnModel.getMainProcess().getProcessType()) && WfUtils.isNotEmpty((String)this.itemId) && bpmnModel.getFlowElement(this.itemId) instanceof SequenceFlow) {
            String entityNumber = this.getTargetEntityNumber(bpmnModel.getMainProcess(), (SequenceFlow)bpmnModel.getFlowElement(this.itemId));
            if (WfUtils.isEmpty((String)entityNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u68c0\u67e5\u76ee\u6807\u8282\u70b9\u662f\u5426\u914d\u7f6e\u5355\u636e\u5b9e\u4f53\u3002", (String)"WorkflowSequenceFlowConfigurePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            params.put("entityNumber", entityNumber);
        }
        JSONObject properties = this.getCellProperties();
        JSONObject targetBillsFilterCondition = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, TARGETBILLSFILTERCONDITION);
        params.put(TARGETBILLSFILTERCONDITION, targetBillsFilterCondition);
        this.showForm(TARGETBILLSFILTERCONFIG, "bpm_targetbills_filter", params);
    }

    private String getTargetEntityNumber(Process process, SequenceFlow sequenceFlow) {
        if (process != null && sequenceFlow != null) {
            FlowElement targetElement = process.getFlowElement(sequenceFlow.getTargetRef());
            if (targetElement instanceof BillTask) {
                return ((BillTask)targetElement).getEntityNumber();
            }
            if (targetElement instanceof UserTask) {
                return ((UserTask)targetElement).getEntityNumber();
            }
            if (targetElement instanceof CallActivity) {
                return ((CallActivity)targetElement).getEntityNumber();
            }
            if (targetElement instanceof AutoTask) {
                String entityId = ((AutoTask)targetElement).getEntityId();
                return MetadataDao.getNumberById((String)entityId);
            }
            if (targetElement instanceof EventSupportTask) {
                String entityId = ((EventSupportTask)targetElement).getEntityId();
                return MetadataDao.getNumberById((String)entityId);
            }
        }
        return "";
    }

    private void openParameter() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject properties = this.getCellProperties();
        JSONObject billRelationInfo = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, BILLRELATIONSHIPMODEL);
        params.put(DRAWPARAMETER, billRelationInfo.get((Object)DRAWPARAMETER));
        this.showForm(DRAWPARAMETER, "bpm_drawparameter", params);
    }

    protected void openExpression() {
        String modelJson = this.getModelJsonString();
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("bpmnModel", modelJson);
        content.put("ruleType", ConditionalRuleType.sequenceFlow);
        content.put(EXPRESSION, this.getModel().getValue(EXPRESSION));
        this.showForm("openExpression", "wf_valueexpression", content);
    }

    private void openPluginPage(String actionId) {
        try {
            GraphCell targetCell;
            String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"});
            JSONObject properties = this.getCellProperties();
            String value = null;
            if (AGGREGATIONPLUGIN.equals(actionId)) {
                value = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "aggregationPlugin");
            } else {
                JSONObject relation = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, BILLRELATIONSHIPMODEL);
                if (relation != null) {
                    value = relation.getString(PLUGIN);
                }
            }
            String entityId = null;
            GraphItem target = this.getGraphCell().getTarget();
            if (target != null && (targetCell = this.getGraphCell(target.getResourceId())) != null) {
                Map targetProperties = targetCell.getProperties();
                entityId = "AutoTask".equals(targetCell.getStencil().getId()) ? (String)BpmnModelUtil.getProperty((Map)targetProperties, (String)"service.entityId") : (String)targetProperties.get("entityId");
            }
            if (WfUtils.isEmpty(entityId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u51fa\u73b0\u7ebf-\u5355\u636e\u8282\u70b9-\u76ee\u6807\u5355\u636e", (String)"WorkflowSequenceFlowConfigurePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (WfUtils.isNotEmpty((String)actionId)) {
                DesignerPluginUtil.openExternalInterface(this.getView(), (IFormPlugin)this, types, entityId, value, false, actionId);
            } else {
                DesignerPluginUtil.openExternalInterface(this.getView(), (IFormPlugin)this, types, entityId, value);
            }
        }
        catch (Exception e) {
            this.log.error(String.format("\u521d\u59cb\u5916\u90e8\u63a5\u53e3\u76f8\u5173\u4fe1\u606f\u51fa\u9519--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("BizFlowModel".equals(this.modelType)) {
            this.setConversionModeComboItems();
        }
    }

    private void setConversionModeComboItems() {
        String stencilId;
        GraphCell targetCell;
        ComboEdit conversionMode = (ComboEdit)this.getControl(BILLCONV_MODE);
        ComboItem comboItem1 = new ComboItem();
        comboItem1.setValue("auto");
        comboItem1.setCaption(new LocaleString(WFMultiLangConstants.getAutoConvert()));
        ComboItem comboItem2 = new ComboItem();
        comboItem2.setValue("manualpush");
        comboItem2.setCaption(new LocaleString(WFMultiLangConstants.getManualPush()));
        GraphItem target = this.getGraphCell().getTarget();
        if (target != null && (targetCell = this.getGraphCell(target.getResourceId())) != null && ("AutoTask".equals(stencilId = targetCell.getStencil().getId()) || "UserTask".equals(stencilId))) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(1);
            items.add(comboItem1);
            conversionMode.setComboItems(items);
            return;
        }
        if (WfConfigurationUtil.isHideUnUseControls()) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
            items.add(comboItem1);
            items.add(comboItem2);
            conversionMode.setComboItems(items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCreateNewData(EventObject e) {
        try {
            this.beginInit();
            super.afterCreateNewData(e);
            JSONObject properties = this.getCellProperties();
            if ("BizFlowModel".equals(this.modelType)) {
                this.correctSequenceFlowProperties(properties);
                this.getView().setVisible(Boolean.TRUE, new String[]{BILLRELARELATIONPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{TARGETBILLSFILTERPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{DATAAGGREGATIONCTRPANEL});
                boolean enableAggregation = (Boolean)DesignerModelUtil.getProperty((Map<String, Object>)properties, "enableAggregation");
                String aggregationPlugin = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "aggregationPlugin");
                if (WfUtils.isNotEmpty((String)aggregationPlugin)) {
                    JSONObject aggregationPluginData = (JSONObject)JSONObject.parse((String)aggregationPlugin);
                    this.getModel().setValue(AGGREGATIONPLUGIN, aggregationPluginData.get((Object)"value"));
                }
                String aggregationType = (String)DesignerModelUtil.getProperty((Map<String, Object>)properties, "aggregationType");
                this.getView().setVisible(Boolean.valueOf(PLUGINAGGREGATE.equals(aggregationType)), new String[]{AGGREGATIONPLUGIN});
                this.getView().setVisible(Boolean.valueOf(enableAggregation), new String[]{AGGREGATIONPLUGINFLEX});
                boolean enableTargetBillsFilter = (Boolean)DesignerModelUtil.getProperty((Map<String, Object>)properties, ENABLETARGETBILLSFILTER);
                JSONObject targetBillsFilterCondition = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, TARGETBILLSFILTERCONDITION);
                if (targetBillsFilterCondition != null) {
                    this.getModel().setValue(TARGETBILLSFILTERCONFIG, (Object)targetBillsFilterCondition.getString(FILTERCONDITIONSHOWTEXT));
                }
                this.getView().setVisible(Boolean.valueOf(enableTargetBillsFilter), new String[]{TARGETBILLSFILTERFLEX});
                this.initBillRelationType(properties);
            }
            JSONObject conditionRule = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, "conditionalrule");
            this.getModel().setValue("conditionalrule", (Object)ConditionalRuleUtil.getShowText(conditionRule));
            Boolean isDefaultFlow = (Boolean)this.getModel().getValue(DEFAULTFLOW);
            this.getView().setEnable(Boolean.valueOf(!Boolean.TRUE.equals(isDefaultFlow)), new String[]{"conditionalrule"});
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WorkflowSequenceFlowConfigurePlugin.class);
        }
    }

    private void correctSequenceFlowProperties(JSONObject properties) {
        GraphItem target = this.getGraphCell().getTarget();
        if (target == null) {
            return;
        }
        GraphCell targetCell = this.getGraphCell(target.getResourceId());
        if (targetCell == null) {
            return;
        }
        String stencilId = targetCell.getStencil().getId();
        if (BpmnJsonConverterUtil.incomingFlowDisableBillRelationAdv((String)stencilId)) {
            JSONObject billRelationInfo = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, BILLRELATIONSHIPMODEL);
            if (billRelationInfo != null) {
                billRelationInfo.put("relationType", (Object)"sameWithPreNode");
            }
            properties.put("enableAggregation", (Object)false);
            properties.put("enableTargetBillsFilter", (Object)false);
            if (properties.containsKey((Object)TARGETBILLSFILTERCONDITION)) {
                properties.put(TARGETBILLSFILTERCONDITION, null);
            }
        }
    }

    private void initBillRelationType(JSONObject properties) {
        JSONObject billRelationInfo = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, BILLRELATIONSHIPMODEL);
        this.initRelationTypeCombo();
        if (this.enableBillRelationAdv()) {
            if (billRelationInfo != null) {
                String relationType = billRelationInfo.getString("relationType");
                this.getModel().setValue(RELATIONTYPE, (Object)relationType);
                if ("findByPlugin".equals(relationType)) {
                    String plugin = billRelationInfo.getString(PLUGIN);
                    if (WfUtils.isNotEmpty((String)plugin)) {
                        JSONObject data = (JSONObject)JSONObject.parse((String)plugin);
                        this.getModel().setValue(PLUGIN, (Object)data.getString("value"));
                    }
                    this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPLUGIN});
                    this.getView().setVisible(Boolean.FALSE, new String[]{BILLCONV_PANEL});
                    this.getView().setVisible(Boolean.FALSE, new String[]{EXPRESSIONPLAN});
                } else if ("queryBotpTargetBills".equals(relationType)) {
                    String rage = billRelationInfo.getString(TARGETBILLRAGE);
                    if (WfUtils.isNotEmpty((String)rage)) {
                        this.getModel().setValue(TARGETBILLRAGE, (Object)rage.split("\\,"));
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPLUGIN});
                    this.getView().setVisible(Boolean.FALSE, new String[]{BILLCONV_PANEL});
                    this.getView().setVisible(Boolean.FALSE, new String[]{EXPRESSIONPLAN});
                } else if ("botpTargetBills".equals(relationType)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPLUGIN});
                    this.getView().setVisible(Boolean.TRUE, new String[]{BILLCONV_PANEL});
                    this.getView().setVisible(Boolean.FALSE, new String[]{EXPRESSIONPLAN});
                    this.initBillConverter(billRelationInfo);
                } else if ("findByExpression".equals(relationType)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPLUGIN});
                    this.getView().setVisible(Boolean.TRUE, new String[]{EXPRESSIONPLAN});
                    this.getView().setVisible(Boolean.FALSE, new String[]{BILLCONV_PANEL});
                } else {
                    this.getModel().setValue(RELATIONTYPE, (Object)"sameWithPreNode");
                    this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPLUGIN});
                    this.getView().setVisible(Boolean.FALSE, new String[]{BILLCONV_PANEL});
                    this.getView().setVisible(Boolean.FALSE, new String[]{EXPRESSIONPLAN});
                    this.getView().setVisible(Boolean.FALSE, new String[]{DATAAGGREGATIONCTRPANEL});
                    this.getView().setVisible(Boolean.FALSE, new String[]{TARGETBILLSFILTERPANEL});
                }
            } else {
                this.getModel().setValue(RELATIONTYPE, (Object)"sameWithPreNode");
                this.getView().setVisible(Boolean.FALSE, new String[]{DATAAGGREGATIONCTRPANEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPLUGIN});
                this.getView().setVisible(Boolean.FALSE, new String[]{BILLCONV_PANEL});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPLUGIN});
            this.getView().setVisible(Boolean.FALSE, new String[]{EXPRESSIONPLAN});
            this.getView().setVisible(Boolean.FALSE, new String[]{BILLCONV_PANEL});
            if (billRelationInfo != null) {
                String relationType = billRelationInfo.getString("relationType");
                this.getModel().setValue(RELATIONTYPE, (Object)relationType);
                if ("findByExpression".equals(relationType)) {
                    this.getModel().setValue(EXPRESSION, (Object)billRelationInfo.getString(EXPRESSION));
                    this.getView().setVisible(Boolean.TRUE, new String[]{EXPRESSIONPLAN});
                } else if ("findByPlugin".equals(relationType)) {
                    String plugin = billRelationInfo.getString(PLUGIN);
                    if (WfUtils.isNotEmpty((String)plugin)) {
                        JSONObject data = (JSONObject)JSONObject.parse((String)plugin);
                        this.getModel().setValue(PLUGIN, (Object)data.getString("value"));
                    }
                    this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPLUGIN});
                }
                this.getView().setVisible(Boolean.valueOf(!"sameWithPreNode".equals(relationType)), new String[]{DATAAGGREGATIONCTRPANEL});
                this.getView().setVisible(Boolean.valueOf(!"sameWithPreNode".equals(relationType)), new String[]{TARGETBILLSFILTERPANEL});
            } else {
                this.getModel().setValue(RELATIONTYPE, (Object)"sameWithPreNode");
            }
        }
    }

    private boolean enableBillRelationAdv() {
        String stencilId;
        GraphItem target = this.getGraphCell().getTarget();
        if (target == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{OTHERPLAN});
            return false;
        }
        GraphCell targetCell = this.getGraphCell(target.getResourceId());
        if (targetCell == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{OTHERPLAN});
            return false;
        }
        switch (stencilId = targetCell.getStencil().getId()) {
            case "CallActivity": {
                this.getView().setVisible(Boolean.FALSE, new String[]{OTHERPLAN});
                return false;
            }
        }
        if (!("BillTask".equals(stencilId) || "AutoTask".equals(stencilId) || "UserTask".equals(stencilId))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BILLRELARELATIONPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{TARGETBILLSFILTERPANEL});
        }
        return true;
    }

    private void initBillConverter(JSONObject billConvInfo) {
        if (billConvInfo == null) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BILLCONV_PANEL});
        String convType = billConvInfo.getString("conversionType");
        ComboEdit billConvMethod = (ComboEdit)this.getView().getControl(BILLCONV_METHOD);
        List<ComboItem> modleItems = this.initConversionMethod();
        billConvMethod.setComboItems(modleItems);
        this.getModel().setValue(AFTEROPERATION, billConvInfo.get((Object)AFTEROPERATION));
        String conversionMode = (String)billConvInfo.get((Object)"conversionMode");
        boolean isView = "auto".equals(conversionMode);
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{BILLCONV_METHOD});
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{AFTEROPERATION});
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{DATAAGGREGATIONCTRPANEL});
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{TARGETBILLSFILTERPANEL});
        this.getModel().setValue(PARAMETER, billConvInfo.get((Object)DRAWPARAMETER));
        this.setVisiableParameter(conversionMode);
        this.getModel().setValue(BILLCONV_MODE, (Object)conversionMode);
        this.getModel().setValue(BILLCONV_TYPE, (Object)convType);
        this.getModel().setValue(BILLCONV_METHOD, billConvInfo.get((Object)"conversionMethod"));
        this.getModel().setValue(BILLCONV_TIME, billConvInfo.get((Object)"conversionTime"));
        Object taskCloseRule = DesignerModelUtil.getProperty((Map<String, Object>)billConvInfo, "taskCloseRule");
        if (taskCloseRule instanceof JSONObject) {
            this.getModel().setValue(TASKCLOSERULE, (Object)ConditionalRuleUtil.getShowText((JSONObject)taskCloseRule));
        }
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{GENERATETARGETFLEX});
        boolean enableGenerateTarget = (Boolean)DesignerModelUtil.getProperty((Map<String, Object>)this.getCellProperties(), ENABLEGENERATETARGET);
        this.getModel().setValue(ENABLEGENERATETARGET, (Object)enableGenerateTarget);
    }

    private void setVisiableParameter(String conversionMode) {
        if ("manualdraw".equals(conversionMode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PARAMETER});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{PARAMETER});
        }
    }

    private List<ComboItem> initConversionMethod() {
        ArrayList<ComboItem> modleItems = new ArrayList<ComboItem>();
        String sourceEntityNumber = "";
        String targetEntityNumber = "";
        GraphCell sequenceFlowCell = this.getGraphCell();
        GraphItem targetItem = sequenceFlowCell.getTarget();
        if (targetItem != null && this.getGraphCell(targetItem.getResourceId()) != null) {
            GraphCell targetCell = this.getGraphCell(targetItem.getResourceId());
            if ("BillTask".equals(targetCell.getStencil().getId())) {
                sourceEntityNumber = (String)targetCell.getProperties().get("sourceEntityNumber");
                targetEntityNumber = (String)targetCell.getProperties().get("entityNumber");
            } else {
                sourceEntityNumber = this.getSourceEntityNumber(sequenceFlowCell);
                targetEntityNumber = this.getTargetEntityNumber(targetCell);
            }
        }
        modleItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d", (String)"WorkflowSequenceFlowConfigurePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0])), "automatch"));
        if (WfUtils.isNotEmpty((String)sourceEntityNumber) && WfUtils.isNotEmpty((String)targetEntityNumber)) {
            Map rules = BillConvertHelper.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
            for (Map.Entry entry : rules.entrySet()) {
                modleItems.add(new ComboItem((LocaleString)entry.getValue(), (String)entry.getKey()));
            }
        }
        return modleItems;
    }

    private String getSourceEntityNumber(GraphCell sequenceFlowCell) {
        if (sequenceFlowCell == null || !"SequenceFlow".equals(sequenceFlowCell.getStencil().getId())) {
            return "";
        }
        List children = this.getGraphModel().getRootCell().getChildShapes();
        HashMap ingoingRecordMap = new HashMap(children.size());
        for (GraphCell cell : children) {
            List outgoing = cell.getOutgoing();
            if (!WfUtils.isNotEmptyForCollection((Collection)outgoing)) continue;
            outgoing.forEach(item -> {
                String key = item.getResourceId();
                List<String> ingoing = ingoingRecordMap.get(key) == null ? new ArrayList() : (List)ingoingRecordMap.get(key);
                ingoing.add(cell.getResourceId());
                ingoingRecordMap.putIfAbsent(key, ingoing);
            });
        }
        if (WfUtils.isEmptyForMap(ingoingRecordMap)) {
            return "";
        }
        String lastResourceId = sequenceFlowCell.getResourceId();
        while (WfUtils.isNotEmpty((String)lastResourceId)) {
            List ingoingResourceIds = (List)ingoingRecordMap.get(lastResourceId);
            if (WfUtils.isEmptyForCollection((Collection)ingoingResourceIds) || ingoingResourceIds.size() > 1) {
                return "";
            }
            String sourceResourceId = (String)ingoingResourceIds.get(0);
            GraphCell sourceCell = this.getGraphCell(sourceResourceId);
            if (sourceCell == null) {
                return "";
            }
            String stencilId = sourceCell.getStencil().getId();
            Map properties = sourceCell.getProperties();
            if ("UserTask".equals(stencilId) || "BillTask".equals(stencilId) || "NotifyTask".equals(stencilId) || "WaitTask".equals(stencilId) || "InclusiveGateway".equals(stencilId) || "CallActivity".equals(stencilId) || "RPATask".equals(stencilId)) {
                return (String)BpmnModelUtil.getProperty((Map)properties, (String)"entityNumber");
            }
            if ("AutoTask".equals(stencilId)) {
                String entityId = (String)BpmnModelUtil.getProperty((Map)properties, (String)"service.entityId");
                return MetadataDao.getNumberById((String)entityId);
            }
            if ("BroadcastTask".equals(stencilId)) {
                String entityId = (String)BpmnModelUtil.getProperty((Map)properties, (String)"entityId");
                return MetadataDao.getNumberById((String)entityId);
            }
            lastResourceId = sourceResourceId;
        }
        return "";
    }

    private String getTargetEntityNumber(GraphCell targetCell) {
        if (targetCell != null) {
            String stencilId = targetCell.getStencil().getId();
            Map properties = targetCell.getProperties();
            if ("UserTask".equals(stencilId)) {
                return (String)BpmnModelUtil.getProperty((Map)properties, (String)"entityNumber");
            }
            if ("AutoTask".equals(stencilId)) {
                String entityId = (String)BpmnModelUtil.getProperty((Map)properties, (String)"service.entityId");
                return MetadataDao.getNumberById((String)entityId);
            }
        }
        return "";
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if ("condition".equals(actionId)) {
            this.updateConditionalRule(returnData);
        } else if (TASKCLOSERULE.equals(actionId)) {
            this.updateTaskCloseRule(returnData);
        } else if ("openExpression".equals(actionId)) {
            Map m = (Map)returnData;
            if (m != null) {
                this.getModel().setValue(EXPRESSION, m.get(EXPRESSION));
            }
        } else if ("externalInterface".equals(actionId)) {
            this.updatePlugin(returnData);
        } else if (DRAWPARAMETER.equals(actionId)) {
            this.updateDrawParameter(returnData);
        } else if (TARGETBILLSFILTERCONFIG.equals(actionId)) {
            if (returnData == null) {
                return;
            }
            if ("".equals(returnData)) {
                this.setProperty(TARGETBILLSFILTERCONDITION, null);
                this.getModel().setValue(TARGETBILLSFILTERCONFIG, null);
            } else if (returnData instanceof JSONObject) {
                this.setProperty(TARGETBILLSFILTERCONDITION, returnData);
                this.getModel().setValue(TARGETBILLSFILTERCONFIG, ((JSONObject)returnData).get((Object)FILTERCONDITIONSHOWTEXT));
            }
        } else if (AGGREGATIONPLUGIN.equals(actionId)) {
            this.setProperty("aggregationPlugin", returnData);
            JSONObject data = (JSONObject)JSONObject.parse((String)((String)returnData));
            if (data != null) {
                Object val = data.get((Object)"value");
                if (val instanceof String) {
                    this.getModel().setValue(AGGREGATIONPLUGIN, val);
                } else if (val != null) {
                    this.getModel().setValue(AGGREGATIONPLUGIN, (Object)ExternalInterfaceUtil.castObjectToJSON((Object)val));
                }
            }
        }
    }

    private void updateDrawParameter(Object returnData) {
        if (returnData != null) {
            if (returnData == "") {
                returnData = null;
            }
            this.setProperties(DRAWPARAMETER, returnData);
            this.getModel().setValue(PARAMETER, returnData);
        }
    }

    private void updatePlugin(Object returnData) {
        if (returnData != null) {
            this.setProperty(PLUGIN, returnData);
            JSONObject data = (JSONObject)JSONObject.parse((String)((String)returnData));
            Object val = data.get((Object)"value");
            if (val instanceof String) {
                this.getModel().setValue(PLUGIN, val);
            } else if (val != null) {
                this.getModel().setValue(PLUGIN, (Object)ExternalInterfaceUtil.castObjectToJSON((Object)val));
            }
        }
    }

    private void updateTaskCloseRule(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            if (data.isEmpty()) {
                this.getModel().setValue(TASKCLOSERULE, null);
                this.setProperty(TASKCLOSERULE, null);
                return;
            }
            Object value = data.get(SHOWTEXT);
            String showText = DesignerPluginUtil.getLocaleValue(value);
            this.getModel().setValue(TASKCLOSERULE, (Object)showText);
            this.setProperty(TASKCLOSERULE, data);
        }
    }

    private void updateConditionalRule(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            if (data.isEmpty()) {
                this.getModel().setValue("conditionalrule", null);
                this.setProperty("conditionalrule", null);
                return;
            }
            Object value = data.get(SHOWTEXT);
            String showText = DesignerPluginUtil.getLocaleValue(value);
            this.getModel().setValue("conditionalrule", (Object)showText);
            this.setProperty("conditionalrule", data);
            if (WfUtils.isEmptyString((Object)this.getModel().getValue("name"))) {
                this.setProperty("name", showText);
                this.getModel().setValue("name", (Object)showText);
            }
        }
    }

    @Override
    protected void propertyChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        switch (propName) {
            case "defaultflow": {
                this.defaultFlowChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "conversionmode": {
                this.changeConversionMode(propName, newValue);
                break;
            }
            case "conditionalrule": {
                this.conditionalRuleChanged(newValue);
                break;
            }
            case "targetbillrage": {
                if (newValue instanceof DynamicObjectCollection) {
                    DynamicObjectCollection tmp = (DynamicObjectCollection)newValue;
                    StringBuilder sb = new StringBuilder();
                    for (DynamicObject obj : tmp) {
                        obj = (DynamicObject)obj.get("fbasedataid");
                        sb.append(obj.getPkValue()).append(',');
                    }
                    if (sb.length() > 0) {
                        this.setProperty(TARGETBILLRAGE, sb.substring(0, sb.length() - 1));
                        break;
                    }
                    this.setProperty(TARGETBILLRAGE, "");
                    break;
                }
                this.setProperty(TARGETBILLRAGE, "");
                break;
            }
            case "relationtype": {
                this.updateRelationTypeChange(propName, newValue);
                break;
            }
            case "taskcloserule": {
                if (newValue != null && !"".equals(newValue.toString().trim())) break;
                this.setProperty(TASKCLOSERULE, null);
                break;
            }
            case "enableaggregation": {
                this.getView().setVisible((Boolean)newValue, new String[]{AGGREGATIONPLUGINFLEX});
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "plugin": 
            case "aggregationplugin": {
                if (!WfUtils.isEmptyString((Object)newValue)) break;
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "targetbillsfilterconfig": {
                if (!WfUtils.isEmptyString((Object)newValue)) break;
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                this.setProperty(TARGETBILLSFILTERCONDITION, null);
                break;
            }
            case "aggregationtype": {
                this.getView().setVisible(Boolean.valueOf(PLUGINAGGREGATE.equals(newValue)), new String[]{AGGREGATIONPLUGIN});
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            case "parameter": {
                this.updateDrawParameter(newValue);
                break;
            }
            case "enabletargetbillsfilter": {
                this.getView().setVisible((Boolean)newValue, new String[]{TARGETBILLSFILTERFLEX});
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
                break;
            }
            default: {
                super.propertyChanged(propName, newValue, oldValue, rowIndex);
            }
        }
    }

    private void updateRelationTypeChange(String propName, Object newValue) {
        this.getView().setVisible(Boolean.valueOf(!"sameWithPreNode".equals(newValue)), new String[]{DATAAGGREGATIONCTRPANEL});
        this.getView().setVisible(Boolean.valueOf(!"botpTargetBills".equals(newValue)), new String[]{TARGETBILLSFILTERPANEL});
        if ("botpTargetBills".equals(newValue)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BILLCONV_PANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPLUGIN});
            this.getView().setVisible(Boolean.FALSE, new String[]{EXPRESSIONPLAN});
            boolean isauto = "auto".equals(this.getModel().getValue(BILLCONV_MODE));
            this.getView().setVisible(Boolean.valueOf(isauto), new String[]{DATAAGGREGATIONCTRPANEL});
            this.getView().setVisible(Boolean.valueOf(isauto), new String[]{TARGETBILLSFILTERPANEL});
            this.getView().setVisible(Boolean.valueOf(isauto), new String[]{BILLCONV_METHOD});
            this.getView().setVisible(Boolean.valueOf(isauto), new String[]{AFTEROPERATION});
            if ("0".equals(this.getModel().getValue(BILLCONV_METHOD))) {
                this.getModel().setValue(BILLCONV_METHOD, (Object)"automatch");
            }
            JSONObject properties = this.getCellProperties();
            JSONObject billRelationInfo = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, BILLRELATIONSHIPMODEL);
            this.initBillConverter(billRelationInfo);
            this.getView().setVisible(Boolean.valueOf("manualdraw".equals(this.getModel().getValue(BILLCONV_MODE))), new String[]{PARAMETER});
            this.setProperty(ENABLE, Boolean.FALSE);
        } else if ("findByPlugin".equals(newValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BILLCONV_PANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{EXPRESSIONPLAN});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPLUGIN});
            this.getView().setVisible(Boolean.FALSE, new String[]{GENERATETARGETFLEX});
            this.setProperty(ENABLE, Boolean.TRUE);
        } else if ("queryBotpTargetBills".equals(newValue)) {
            this.setProperty(ENABLE, Boolean.TRUE);
            this.getView().setVisible(Boolean.FALSE, new String[]{BILLCONV_PANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPLUGIN});
            this.getView().setVisible(Boolean.FALSE, new String[]{EXPRESSIONPLAN});
            this.getView().setVisible(Boolean.FALSE, new String[]{GENERATETARGETFLEX});
        } else if ("findByExpression".equals(newValue)) {
            this.setProperty(ENABLE, Boolean.FALSE);
            this.getView().setVisible(Boolean.FALSE, new String[]{BILLCONV_PANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPLUGIN});
            this.getView().setVisible(Boolean.TRUE, new String[]{EXPRESSIONPLAN});
            this.getView().setVisible(Boolean.FALSE, new String[]{GENERATETARGETFLEX});
        } else {
            this.setProperty(ENABLE, Boolean.FALSE);
            this.getView().setVisible(Boolean.FALSE, new String[]{BILLCONV_PANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{EXPRESSIONPLAN});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPLUGIN});
            this.getView().setVisible(Boolean.FALSE, new String[]{TARGETBILLSFILTERPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{GENERATETARGETFLEX});
        }
        this.setProperty(propName, newValue);
    }

    private void changeConversionMode(String propName, Object newValue) {
        boolean isView = "auto".equals(newValue);
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{BILLCONV_METHOD});
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{AFTEROPERATION});
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{DATAAGGREGATIONCTRPANEL});
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{TARGETBILLSFILTERPANEL});
        this.getView().setVisible(Boolean.valueOf(isView), new String[]{GENERATETARGETFLEX});
        if ("0".equals(this.getModel().getValue(BILLCONV_METHOD))) {
            this.getModel().setValue(BILLCONV_METHOD, (Object)"automatch");
        }
        this.setVisiableParameter(newValue.toString());
        this.setProperty(propName, newValue);
    }

    private void conditionalRuleChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.setProperty("conditionalrule", null);
        }
    }

    private void defaultFlowChanged(String propName, Object newValue, Object oldValue, int rowIndex) {
        if (((Boolean)newValue).booleanValue()) {
            this.getModel().setValue("conditionalrule", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"conditionalrule"});
            this.deleteProperty("conditionalrule");
            if (WfUtils.isEmptyString((Object)this.getModel().getValue("name"))) {
                this.setProperty("name", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"WorkflowSequenceFlowConfigurePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("name", (Object)ResManager.loadKDString((String)"\u5176\u4ed6", (String)"WorkflowSequenceFlowConfigurePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"conditionalrule"});
        }
        super.propertyChanged(propName, newValue, oldValue, rowIndex);
    }

    @Override
    protected void updateCellNameForPage(String name, Object value) {
        if (BILLCONV_MODE.equals(name) || "name".equals(name) || BILLCONV_METHOD.equals(name) || RELATIONTYPE.equals(name)) {
            if (!"name".equals(name)) {
                value = this.getModel().getValue("name");
            }
            String showValue = this.getFormatShowValue((String)value);
            super.updateCellNameForPage("name", showValue);
        }
    }

    private String getFormatShowValue(String value) {
        JSONObject properties = this.getCellProperties();
        JSONObject billConvInfo = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, BILLRELATIONSHIPMODEL);
        if (billConvInfo != null && "botpTargetBills".equals(billConvInfo.getString("relationType"))) {
            String conversionMode = (String)this.getModel().getValue(BILLCONV_MODE);
            if ("manualpush".equals(conversionMode)) {
                value = WfUtils.isNotEmpty((String)value) ? String.format(FORMATSHOWVALUE, value, WFMultiLangConstants.getManualPush()) : WFMultiLangConstants.getManualPush();
            } else if ("manualdraw".equals(conversionMode)) {
                value = WfUtils.isNotEmpty((String)value) ? String.format(FORMATSHOWVALUE, value, WFMultiLangConstants.getManualDraw()) : WFMultiLangConstants.getManualDraw();
            } else if ("auto".equals(conversionMode)) {
                value = WfUtils.isNotEmpty((String)value) ? String.format(FORMATSHOWVALUE, value, WFMultiLangConstants.getAutoConvert()) : WFMultiLangConstants.getAutoConvert();
            }
        }
        return value;
    }

    private void initRelationTypeCombo() {
        GraphItem target = this.getGraphCell().getTarget();
        if (target == null) {
            this.logger.warn("target is empty");
            return;
        }
        GraphCell targetCell = this.getGraphCell(target.getResourceId());
        if (targetCell == null) {
            this.logger.warn("targetCell is empty");
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        ComboItem comboItem1 = new ComboItem();
        comboItem1.setValue("sameWithPreNode");
        comboItem1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e0e\u6e90\u5355\u76f8\u540c", (String)"WorkflowSequenceFlowConfigurePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        items.add(comboItem1);
        String stencilId = targetCell.getStencil().getId();
        if (!"CallActivity".equalsIgnoreCase(stencilId)) {
            ComboItem comboItem2 = new ComboItem();
            comboItem2.setValue("botpTargetBills");
            comboItem2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u901a\u8fc7BOTP\u8f6c\u6362\u670d\u52a1\u751f\u6210\u76ee\u6807\u5355", (String)"WorkflowSequenceFlowConfigurePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            items.add(comboItem2);
        }
        ComboItem comboItem3 = new ComboItem();
        comboItem3.setValue("queryBotpTargetBills");
        comboItem3.setCaption(new LocaleString(ResManager.loadKDString((String)"\u901a\u8fc7\u81ea\u5b9a\u4e49\u5355\u636e\u5173\u7cfb\u83b7\u53d6\u76ee\u6807\u5355", (String)"WorkflowSequenceFlowConfigurePlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        items.add(comboItem3);
        ComboItem comboItem4 = new ComboItem();
        comboItem4.setValue("findByExpression");
        comboItem4.setCaption(new LocaleString(ResManager.loadKDString((String)"\u901a\u8fc7\u8868\u8fbe\u5f0f\u83b7\u53d6\u76ee\u6807\u5355", (String)"WorkflowSequenceFlowConfigurePlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        items.add(comboItem4);
        ComboItem comboItem5 = new ComboItem();
        comboItem5.setValue("findByPlugin");
        comboItem5.setCaption(new LocaleString(ResManager.loadKDString((String)"\u901a\u8fc7\u63d2\u4ef6\u83b7\u53d6\u76ee\u6807\u5355", (String)"WorkflowSequenceFlowConfigurePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        items.add(comboItem5);
        ComboEdit combEditDown = (ComboEdit)this.getControl(RELATIONTYPE);
        combEditDown.setComboItems(items);
    }
}

