/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowTargetBillsFilterConditionPlugin
extends AbstractFormPlugin {
    private static final String TARGETBILLSFILTERCONDITION = "targetBillsFilterCondition";
    private static final String ENTITYNUMBER = "entityNumber";
    private static final String TARGETENTITYNUMBER = "targetEntityNumber";
    private static final String FILTERCONDITIONJSON = "filterConditionJson";
    private static final String FILTERCONDITIONSHOWTEXT = "filterConditionShowText";
    private static final String TARGETENTITY = "targetentity";
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        JSONObject targetBillsFilterCondition;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityNumber = (String)parameter.getCustomParam(ENTITYNUMBER);
        this.getModel().setValue(TARGETENTITY, (Object)entityNumber);
        this.getPageCache().put(ENTITYNUMBER, entityNumber);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        filterGrid.setEntityNumber(entityNumber);
        Object targetBillsFilterObj = parameter.getCustomParam(TARGETBILLSFILTERCONDITION);
        JSONObject jSONObject = targetBillsFilterCondition = targetBillsFilterObj instanceof JSONObject ? (JSONObject)targetBillsFilterObj : null;
        if (targetBillsFilterCondition != null) {
            String targetEntityNumber = targetBillsFilterCondition.getString(TARGETENTITYNUMBER);
            if (StringUtils.equals((CharSequence)entityNumber, (CharSequence)targetEntityNumber)) {
                String filterConditionJson = targetBillsFilterCondition.getString(FILTERCONDITIONJSON);
                this.getPageCache().put(FILTERCONDITIONJSON, filterConditionJson);
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u539f\u6709\u8fc7\u6ee4\u6761\u4ef6\u5b9e\u4f53\u201c%1$s\u201d\u4e0e\u73b0\u76ee\u6807\u8282\u70b9\u5b9e\u4f53\u201c%2$s\u201d\u4e0d\u4e00\u81f4\uff0c\u5df2\u81ea\u52a8\u6e05\u7a7a\u539f\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"WorkflowTargetBillsFilterConditionPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), entityNumber, targetEntityNumber));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String filterConditionJson = this.getPageCache().get(FILTERCONDITIONJSON);
        if (WfUtils.isNotEmpty((String)filterConditionJson)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
            filterGrid.SetValue((FilterCondition)SerializationUtils.fromJsonString((String)filterConditionJson, FilterCondition.class));
            this.getPageCache().remove(FILTERCONDITIONJSON);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            JSONObject returnData = this.getReturnData();
            if (returnData != null) {
                this.getView().returnDataToParent((Object)returnData);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        }
    }

    private JSONObject getReturnData() {
        JSONObject returnData = null;
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        if (WfUtils.isNotEmptyForCollection((Collection)filterCondition.getFilterRow())) {
            returnData = new JSONObject();
            String targetEntityNumber = this.getPageCache().get(ENTITYNUMBER);
            returnData.put(TARGETENTITYNUMBER, (Object)targetEntityNumber);
            returnData.put(FILTERCONDITIONJSON, (Object)SerializationUtils.toJsonString((Object)filterCondition));
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)targetEntityNumber), filterCondition);
            filterBuilder.buildFilter(false);
            returnData.put(FILTERCONDITIONSHOWTEXT, (Object)filterBuilder.getFilterString().replaceAll("\\s+", " ").trim());
        }
        return returnData;
    }
}

